#!/usr/bin/env python3
#Purpose of this script is to get the relative energies of all .log files in a folder


#Importing modules
import sys
import os
import numpy as np
import Molecule_Class_V0pt5 as mol_class
#from importlib.machinery import SourceFileLoader
#mol_class = SourceFileLoader("Molecule_Class_V0","/media/richard/Windows/Users/Richard/Documents/Random_Scripts/Molecule_Class_python/Molecule_Class_V0pt2.py").load_module()


#IMPORTANT GLOBAL CONSTANTS
au_to_output = 2625.5
headings = ['Conformers','E(ZPE) / kJ mol','G / kJ mol', 'E(Non-ZPE) / kJ mol']
num_dp = 2	#Number of decimal places in the energies reported
#TESTING IN IPYTHON
sys.argv.append('/media/richard/Windows/Users/Richard/Documents/Random_Scripts/Molecule_Class_python/test_files/frequency_tests/nosymm/BMIM_1H2O_all_freqs')



#Actual Script code
folder = sys.argv[1]
mol_list = mol_class.create_mol_obj_folder(folder,'.log') #List of molecule objects

#output matrix originally holds:
#1st col = index in mol_list, 2nd col = Energy (incl. zero point correction) 
#3rd col = Energy (incl. gibbs correction), 4th col = Energy (SCF,no corrections)
#These all get converted into relative energies in kJ mol-1 later
output_matrix = np.zeros((len(mol_list),4)) 

counter = 0
for mol in mol_list:	#Populate output_matrix
	output_matrix[counter][:] = counter,mol.e_ZPE,mol.e_gibbs,mol.scf_e
	counter = counter + 1

output_matrix = output_matrix[output_matrix[:,1].argsort()]	#Sort by 2nd column

#Nastilty converting to relative units (kJ mol not hartree)
for col in range(1,output_matrix.shape[1]):
	output_matrix[:,col] = (output_matrix[:,col] - output_matrix[0,col]) * au_to_output


#saving file
with open(os.path.join(folder,'Rel_Energies.txt'),'wt') as f:
	f.write(",".join(headings) + '\n')
	for row in range(0,output_matrix.shape[0]):
		temp_str = ",".join([mol_list[int(output_matrix[row,0])].filename, str(round(output_matrix[row,1],num_dp)), 
				str(round(output_matrix[row,2],num_dp)),str(round(output_matrix[row,3],num_dp)),'\n'])
		f.write(temp_str)

