#!/usr/bin/env python3
#Author: Richard Fogarty
#Email: richard.m.fogarty@gmail.com
#********************************Summary********************************#
#     Code will take a folder name, and output a list of conformers     #
#     with closest frag1-frag2 atomic distances, and the atoms	  #
#     involved from each conformer				      #
#     python3.4 used.						   #
#*********************************Input*********************************#
#     1) folder = Full path to folder. This is the only cmd line
#	argument						       #
#     2) save_on=1 will ccause the .txt file to save (must be modded
#	within the code
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#*********************************Output*******************************#
#	1) If save_on=1 then it will save a Min_Dist_Two_Frags.txt     #
#	   output file in "folder".                                    #
#	2) Will also print a results_matrix to console. Col 1= 	       #
#	   filename. col 2=min distnace between rel. fragments         #
#	   col = identities (atom number + element label) of the two   #
#	   atoms.                                                      #
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#								       #
#******************************Dependencies*****************************#
#    1) Requires Molecule_Class_V0pt1.py				#
#								       #
#								       #
#								       #
#								       #
#*********************************Issues********************************#
#								       #
#								       #
#								       #
#								       #
#								       #
#*********************************History*******************************#
#   11th Jan 2017:Started Coding V1				        #
#   Jul 2017: Made it work on .log/.com aswell. + Updated way Mol_Class #
#	      is imported						#
#***********************************************************************#


#Importing relevant files:
import sys
import os
import numpy as np
import Molecule_Class_V0pt5 as imp_obj_mol_class
#from importlib.machinery import SourceFileLoader
#This imp obj contains all functions in Molecule_Class_V0 as veriables.
#imp_obj_mol_class = SourceFileLoader("Molecule_Class_V0", "/media/richard/Windows/Users/Richard/Documents/Random_Scripts/Molecule_Class_python/Molecule_Class_V0pt1.py").load_module()

#run imp_obj_mol_class.Molecule_Class_V0(fchk_file) to create molecule object






#CONSTANTS FOR TESTING IN IPYTHON
#sys.argv.append(r'/media/richard/Windows/Users/Richard/Documents/Random_Scripts/Molecule_Class_python/test_files')
#sys.argv.append('1-25')	#Atoms for first fragment
#sys.argv.append('26-31')	#Atoms for second fragment
#print(sys.argv)
#folder=sys.argv[1]


#IMPORTANT GLOBAL CONSTANTS GO HERE:
save_on=1





#Mostly Stolen from check_frag_geoms.py
#############Summary########################
#  Checks whether atomic numbering is the same for all .fchk files in a folder
#  Prints messeges to console on the results (either all is fine, or diff number
#  of atoms in some files, or which files differ in atomic numbering
################INPUT:######################
#folder = full path to the folder of interest
################OUTPUT:#####################
#mol_list = list of molecule objects, each entry is for one .fchk file in the folder
def gen_object_list(folder):
	quit_prog=0	#If this variable==1 at any point the program terminates
	#-------------->Create list of molecule objects for all fchk files<---------------
	file_list = [os.path.join(folder,file) for file in os.listdir(folder)   #list of paths to all .fchk files in folder
		      if os.path.isfile(os.path.join(folder,file))      #Only want files
		      and (file.endswith('.fchk') or file.endswith('.log') or file.endswith('.com'))]		       #Only want fchk extension or .log or .com

	mol_list = [imp_obj_mol_class.Molecule_Class_V0(file) for file in file_list]  #Each entry is a molecule object ldo
	numb_atoms = [molecule.geom.shape[0] for molecule in mol_list]	#Number of atoms in first file

	#-------------->Checking Same number of atoms are present in all files (error if not)<------------
	for entry in numb_atoms:
		if numb_atoms[0]!=entry:
			quit_prog = 1
			for molecule in mol_list:
				print('File:',molecule.filename,',Number atoms:',molecule.geom.shape[0])
	if quit_prog==1:
		sys.exit()
	#------------->Checking all atom lists are the same (i.e the same element has the same numbered label in each)<----------------	
	all_atoms = np.stack([molecule.geom[:,0] for molecule in mol_list])     #Each row is a complete list of atomic numbers
	if ((all_atoms - all_atoms[0]==0)).all():       #Subtract 1st row off all rows and see if its zero
		print('Atomic Numbering Appears to Be consistent For All Files')
	else:
		quit_prog=1
		indices = np.transpose(np.nonzero(all_atoms - all_atoms[0]))    #1st column contains indices of rows which disagree with file1 in mol_list
		indices = indices[:,0]  #1st col extracted. Each row is the index of a file(in mol_list) that doesnt agree with the geom of the 1st file
		mismatches = [mol_list[molecule].filename for molecule in range(0,len(mol_list))	#Names of files not matching numbering of reference file
				if np.any(indices==molecule)]
		for entry in mismatches:
			print('File',mol_list[0].filename,'atomic labbeling!=',entry,'\n')
		if quit_prog==1:
			sys.exit()
	return mol_list






#------------------->EXECUTED CODE STARTS HERE<---------------------

folder=sys.argv[1]
print(sys.argv[1])
mol_list = gen_object_list(folder)	#Each entry = Molecule Class object for one file
[x.add_fragment(sys.argv[2]) for x in mol_list]	#Define first fragment
[x.add_fragment(sys.argv[3]) for x in mol_list] #Define second fragment
#row is first indice, column is 2nd. result_matrix[3][0] gets 4rd row/1st col value
#Each row contains results from one file,1st col ([x][0])=filename, 2nd col=min distance between frags(angstrom)
#3rd col = atoms involved (1st frag atom given first)
result_matrix = [ [[],[],[]] for x in range(0,len(mol_list))]
#Populating the result_matrix with all the info i care about
counter = 0	#Track the row for results_matrix
for molecule in mol_list:
	dist,atoms,frag_numb = molecule.min_frag_distance(1,[2])	#first arg=number of 1st frag of interest, second arg is number of 2nd frag of interest. molecule.print_frag_list to see fragment numbers
	elements = (imp_obj_mol_class.atomic_label[molecule.geom[(atoms[0]-1)][0]]  #Converts atomic indices to an element symbol +indice
		   + str(atoms[0]) +  '-' + 
		    imp_obj_mol_class.atomic_label[molecule.geom[atoms[1]-1][0]] + str(atoms[1]))
	result_matrix[counter][0],result_matrix[counter][1],result_matrix[counter][2] = molecule.filename,dist,elements
	counter = counter + 1

[print(i) for i in result_matrix[:]] #<---So far only tested on 1 file at a time

#Create output file "Min_Dist_Two_Frags.txt" in current folder
if save_on==1:
	with open(os.path.join(folder,'Min_Dist_Two_Frags.txt'),'wt') as f:
		[f.write('Frag Number:' + str(a) +'\n') for a in enumerate(mol_list[0].frag_list)]	#Writes the header
		for row in range(0,len(result_matrix)):
			temp_list = result_matrix[row]
			f.write(str(temp_list[0]) + ',' + str(temp_list[1]) + ',' + str(temp_list[2]) + '\n')

#'/media/richard/Windows/Users/Richard/Documents/Random_Scripts/Molecule_Class_python/BMIM_2H2O_freq_w1_BBut_w2_BBut_70_61_178_B3LYP_6311plgdp_gd3bj_GP.fchk'

