classdef TDDFT_Output_Class_V1_2014a <handle & dynamicprops    %Inheriting from handle class allows the methods to modify object properties(lol that this isnt default)
    %Class which stores information on the output of a TD-DFT calculation
    % Each excitation gets its own object, 
    %   Pass a full file path to the .log file to create the overall object
    %   array (TDDFT_Output_Class_V1.all_excitations is the main part of
    %   this object.
    
    
    %HISTORY
    %_2014a version-replaced strip with strtrim so it worked in old matlab.
    %               Doubt this will cause any problems but branched it
    %               anyway. Also uses
    %               TDDFT_Single_Excitation_Class_V1_2014a now
    
    
    properties
        
        e_scf;  %Energy of the ground state in the TD-DFT calc
        multiplicity;   %Ground state multiplicity
        numb_alpha; %Number of alpha electrons
        numb_beta; %Number of beta electrons (Useful to get number of SOMO MO)
        all_excitations;    %nx1 object array,each row is an excitation ordered in terms of energy (or however they come out of g09 .log file)
        
        %INTERMEDIARY VARS. unlikely to be directly useful once code fully
        %run, mainly really for debugging
        excitation_section; %Contains section of file containig excitations (nx1 cell array,each line is a row)
        excitation_array;   %nx1 cell array (n=number of excitations/states in calculation), each contains array w/info on a single excitation
        
    end
    
    methods
        function obj = TDDFT_Output_Class_V1_2014a(filename)      %CONSTRUCTOR
            if nargin>0 %Must do nothing if no args given, otherwise cant initialise object array
                if nargin>1
                    error('Only 1 Input argument required for TDDFT_Output_Class_V1');
                end
                
        %****SECTION 1****%
        %Put file in 1xn cell array(column), each line=1 row
        fobject1=fopen(filename);
        full_file = fileread(filename);
        full_file = strsplit(full_file,'\n')';
        fclose(fobject1);
        
        %***SECTION 2***%
        %Create sub-section with excitations only
        %POSSIBLE BUG: very depednt on the exact format of the .log file
        s_start_term = upper('Excitation energies and oscillator strengths:'); %where excitations section starts
        s_end_term = upper('***************************'); %where excitation section ends
        for i = 1 :size(full_file,1)
            if ~isempty(strfind(upper(full_file{i,1}),s_start_term));
                start_line = i;
                for j=i+1:size(full_file,1)
                    if  ~isempty(strfind(upper(full_file{j,1}),s_end_term));
                        end_line = j-2;
                        break;
                    end
                end
                break;
            end
        end
        
        %Deleting all blank lines + also the crap that follows the 1st
        %excitation + also the "Excited state symmetry could not be
        %determined" line from nosymm
        obj.excitation_section = full_file(start_line:end_line,1);
        i=1;
        while i < size(obj.excitation_section,1) %Remove blank lines
           if strcmp(regexprep(obj.excitation_section{i,1},'\W',''),'') 
               obj.excitation_section(i)=[];
           end
           i = i+1;
        end
        
        i=1;
        while i < size(obj.excitation_section,1) %Remove blank lines
            if ~isempty(strfind(obj.excitation_section{i,1},'Excited state symmetry could not '))
                obj.excitation_section(i)=[];
            end
            i = i+1;
        end
        
        
        
        s_string1 = 'This state for optimization and/or second-order correction';   %These 3 sentences anoyingly appear after the 1st excitation
        s_string2 = 'Total Energy,';
        s_string3 =  'Copying the excited state density for this state';
        for i =1:size(obj.excitation_section,1)
            if ~isempty(strfind(obj.excitation_section{i,1},s_string1));
                if ~isempty(strfind(obj.excitation_section{i+1,1},s_string2)) && ~isempty(strfind(obj.excitation_section{i+2,1},s_string3))
                    %obj.excitation_section(i+2) = [];
                    %obj.excitation_section(i+1) = [];
                    %obj.excitation_section(i) = [];
                    obj.excitation_section(i:i+2)=[];
                end
                break;
            end
        end
        
        %*****SECTION 3*****%
        %Extracting misc. info from the file (e.g multiplicity, number beta
        %electons etc)
                
        %POSSIBLE ERROR: Pretty nasty way of extracting these values
        mult_counter = 0;   %error if mul_counter!=1
        electron_counter = 0;   %error if electron)counter!=1
        energy_counter = 0; %error if energy_counter!=1 (i.e two scf energies found)
        for i=1:size(full_file)
            if ~isempty(strfind(full_file{i},'Multiplicity = '));
                tvar = strsplit(strtrim(full_file{i}));
                obj.multiplicity = str2num(tvar{end});
                mult_counter = mult_counter + 1;
            end
            if ~isempty(strfind(full_file{i},'alpha electrons'));
                 tvar = strsplit(strtrim(full_file{i}));
                 obj.numb_alpha = str2num(tvar{1});
                 obj.numb_beta =  str2num(tvar{4});
                 electron_counter = electron_counter + 1;
            end
            if ~isempty(strfind(full_file{i},'SCF Done'));
                tvar = strsplit(strtrim(full_file{i}));
                for i =1:size(tvar,2)
                    if ~isempty(regexp(tvar{1,i},'\.[\d][\d]', 'once')) ;
                        obj.e_scf = str2num(tvar{1,i});
                    end
                end
                energy_counter = energy_counter + 1;
            end
        end
        
        %Error checks for the tests above (imperfect error tests  but oh
        %well)
        if mult_counter~=1
            error(['Multiplicity wasnt extracted properly, mult_counter=' num2str(mult_counter)]);
        end
        if electron_counter~=1
            error(['Multiplicity wasnt extracted properly, electron_counter=' num2str(electron_counter)]);
        end
        if energy_counter~=1
           error(['Multiplicity wasnt extracted properly, energy_counter=' num2str(energy_counter)]);
        end
        
        
        %*****SECTION 4****%
        %Creating an array where each entry is the full text of a single excitation 
        s_string4 = 'Excited State';    %Delimits the excited states really
        counter = 0;
        for i =1:size(obj.excitation_section,1) %Get number of excitations to pre-allocate a cell array to hold data
           if ~isempty(strfind(obj.excitation_section{i,1},s_string4))
               counter = counter + 1;
           end
        end
        obj.excitation_array = cell(counter,1);%<-------
        %Find where 1st excitation is in file
        for i = 1:size(obj.excitation_section,1)
           if ~isempty(strfind(obj.excitation_section{i,1},s_string4))
                first_excitation_line = i;
                break;
           end
        end
        
        %Actually populate obj.excitation_array
        counter = 1;
        start_pos = first_excitation_line;
        for i = first_excitation_line+1:size(obj.excitation_section,1)
            if ~isempty(strfind(obj.excitation_section{i,1},s_string4))
                end_pos = i-1;
                obj.excitation_array{counter,1} = obj.excitation_section(start_pos:end_pos);
                counter = counter+1;
                start_pos=i;
            end
            if   i==size(obj.excitation_section,1)
                end_pos = i;
                obj.excitation_array{counter,1} = obj.excitation_section(start_pos:end_pos);
            end
            
        end
                
        %*****SECTION 5*****%
        %Creating the object array which holds all excitations
                
        all_excitations(size(obj.excitation_array,1),1) = TDDFT_Single_Excitation_Class_V1_2014a;
        for i=1:size(obj.excitation_array,1)
            all_excitations(i,1) = TDDFT_Single_Excitation_Class_V1_2014a(obj.excitation_array{i,1},obj.multiplicity);
        end
        
        obj.all_excitations = all_excitations;
                
                
            end
        
    end
    
end

end