#!/bin/sh

#Set some variables
US=`whoami`

#create directory 
local_dir=`pwd`

#Output File
freq_file=/$local_dir/data/$1_ETA.log

#Log file 
log_dir=$local_dir/gaussian_output
log_file=$log_dir/$1.log

#Template file
template=/$local_dir/template.log

#Get the file from Wigner
#scp -p $US@wigner:/scratch/${US}/$1.log $log_dir

#actual job
#1. copy first part of the file

awk '{if($0 ~ "Symbolic Z-matrix:"){fstart=1}};
{if(fstart == 0) {print $0}}
' $template>$freq_file   

#2. Charge and Multiplicity 
awk '{if($0 ~ "Multiplicity ="){print $0}}
' $log_file>>$freq_file


#3. Get initial geometry 
awk '{if($0 ~ "Input orientation:") {fstart=1}};
{if(fstart == 1 && $0 ~ "Distance matrix"){fend=1}};
{if(fstart == 1 && fend == 0 && $1 ~ /[0-9]+/ && $2 ~ /[0-9]+/) {print $0}}
' $log_file | sed -e '/Distance matrix (angstroms):/d' >> $freq_file
echo " ">>$freq_file

#4. Get input orientation
awk '{if($0 ~ "Input orientation:") {fstart=1}};
{if(fstart == 1 && $0 ~ "Distance matrix"){fend=1}};
{if(fstart == 1 && fend == 0) {print $0}}
' $log_file | sed -e '/Distance matrix/d' >> $freq_file
echo " ">>$freq_file

#5. Pre-Frequencies
awk '{if($0 ~ "Harmonic frequencies"){fstart=1}};
{if(fstart == 1 && $0 ~ "and normal coordinates:"){fend=1}};
{if (fstart == 1 && fend == 0) {print $0}}
' $template >> $freq_file
echo " and normal coordinates:" >> $freq_file

#6. Frequencies from the output file

awk '{if($0 ~ "Second-Order Coupling Frequencies"){fstart=1}};
{if(fstart == 1 && $1 == "Center" && $2 == "Atomic" && $3 == "Forces"){fend=1}};
{if (fstart == 1 && fend == 0) {print $0}}
' $log_file | sed -e '/Second-Order Coupling Frequencies/d' | sed 's/  Atom  AN      X      Y      Z        X      Y      Z        X      Y      Z/ Atom AN      X      Y      Z        X      Y      Z        X      Y      Z/g' >> $freq_file

#7. End the file

echo " ">>$freq_file
echo "Normal termination of Gaussian DV at Wed Aug 16 14:27:42 2006">>$freq_file

exit

