Module SETTINGS
	implicit none
	Type ATOM
		Character (LEN=3) :: ATOM_TYPE='NIL'
		Real :: ATOM_POSITION(3)
		Real :: MASS
	end Type ATOM
	Type(ATOM) :: CENTER_OF_MASS
	integer :: NUMBER_OF_ATOMS
	Type(ATOM),dimension(:),allocatable :: MOLECULE,LIST_OF_ELEMENTS
end Module SETTINGS

subroutine CENTER()
Use SETTINGS
implicit none
integer :: n,m
	do n=1,NUMBER_OF_ATOMS,1
		do m=1,3,1
			MOLECULE(n)%ATOM_POSITION(m)=MOLECULE(n)%ATOM_POSITION(m)-CENTER_OF_MASS%ATOM_POSITION(m)
		end do
	end do
return
end

subroutine READ_MOLECULE()
Use SETTINGS
implicit none
integer :: n,m,l
real :: current_mass
	open(UNIT=2,file='opt.xyz')
	n=1
	do n=1,NUMBER_OF_ATOMS,1
		read(2,*) MOLECULE(n)%ATOM_TYPE,MOLECULE(n)%ATOM_POSITION(1),MOLECULE(n)%ATOM_POSITION(2),MOLECULE(n)%ATOM_POSITION(3)
		m=1
		do while (MOLECULE(n)%ATOM_TYPE/=LIST_OF_ELEMENTS(m)%ATOM_TYPE)
			m=m+1
		enddo
		current_mass=LIST_OF_ELEMENTS(m)%MASS
		CENTER_OF_MASS%MASS=CENTER_OF_MASS%MASS+current_mass
		do l=1,3,1
			CENTER_OF_MASS%ATOM_POSITION(l)=CENTER_OF_MASS%ATOM_POSITION(l)+current_mass*MOLECULE(n)%ATOM_POSITION(l)
		end do
	end do
	close(UNIT=2)
	do n=1,3,1
		CENTER_OF_MASS%ATOM_POSITION(n)=CENTER_OF_MASS%ATOM_POSITION(n)/real(CENTER_OF_MASS%MASS)
	end do
return
end

subroutine FINALIZE()
Use SETTINGS
implicit none
integer allocstatus
	deallocate(MOLECULE,stat=allocstatus)
	if (allocstatus/=0) then
		write(*,*) 'ERROR: Memory deallocation not successful!'
		write(*,*) 'deallocstatus 0 has value: ',allocstatus
	endif
	deallocate(LIST_OF_ELEMENTS,stat=allocstatus)
	if (allocstatus/=0) then
		write(*,*) 'ERROR: Memory deallocation not successful!'
		write(*,*) 'deallocstatus 0 has value: ',allocstatus
	endif
return
end

subroutine INITIALIZE()
Use SETTINGS
implicit none
integer allocstatus,counter
	open(UNIT=1,file='Element_Table')
	read(1,*) NUMBER_OF_ATOMS
	allocate(MOLECULE(NUMBER_OF_ATOMS),stat=allocstatus)
	if (allocstatus/=0) then
		write(*,*) 'SEVERE ERROR: Memory allocation not successful!'
		write(*,*) 'allocstatus 0 has value: ',allocstatus
	endif
	allocate(LIST_OF_ELEMENTS(NUMBER_OF_ATOMS),stat=allocstatus)
	if (allocstatus/=0) then
		write(*,*) 'SEVERE ERROR: Memory allocation not successful!'
		write(*,*) 'allocstatus 0 has value: ',allocstatus
	endif
	counter=0
	do while (LIST_OF_ELEMENTS(counter)%ATOM_TYPE/='X')
		counter=counter+1
		read(1,*) LIST_OF_ELEMENTS(counter)%ATOM_TYPE,LIST_OF_ELEMENTS(counter)%MASS
	enddo
	close(UNIT=1)
	CENTER_OF_MASS%MASS=0.0
	CENTER_OF_MASS%ATOM_POSITION(1)=0.0
	CENTER_OF_MASS%ATOM_POSITION(2)=0.0
	CENTER_OF_MASS%ATOM_POSITION(3)=0.0
return
end

PROGRAM MOTHERPROGRAM
USE SETTINGS
implicit none
integer :: n
real :: translationskorrektur
	call INITIALIZE()
	call READ_MOLECULE
	call CENTER()
	open(UNIT=3,file='opt.xyz')
	do n=1,NUMBER_OF_ATOMS,1
		write(3,*) MOLECULE(n)%ATOM_TYPE,MOLECULE(n)%ATOM_POSITION
	end do
	write(3,*)
	write(3,*)
	write(3,*) CENTER_OF_MASS%ATOM_POSITION
	close(UNIT=3)
	translationskorrektur=CENTER_OF_MASS%ATOM_POSITION(1)**2+CENTER_OF_MASS%ATOM_POSITION(2)**2+CENTER_OF_MASS%ATOM_POSITION(3)**2
	translationskorrektur=SQRT(translationskorrektur)
	write(*,*) translationskorrektur
	call FINALIZE()
stop
end