classdef AIM_cp_class < handle 
    %AIM_cp_class: Holds information on an AIM critical point
    %   The input is a cell array containing the lines of a .sumviz array
    %   between "CP #" and "-DivStress"
    
    properties
        cp_numb;    %Number the CP is given in file
        co_ords;    %Co-ordinates of the critical point (1x3 matrix w/ x/y/z in that order ldo)
        type; %Description of type of CP (e.g RCP,BCP,NACP)
        deriv_signs; %Listed after Type in the .sumviz, e.g (3,-3),(3,+1)
        rho;    %density value at the critical point
        gradrho;    %Gradient of electron density at the CP
        atoms; %List of atoms involved in the critical point (1xn column cell array, each entry=1 atom). "C2","N7" are examples of format
    end
    
    methods 
        
        function obj = AIM_cp_class(cp_section)
            if nargin>0 %Allowing 0 args means initialisation of object arrays is possible
                
                for i=1:size(cp_section,1)    %Extracting the data
                   temp_cell = strsplit(strtrim(cp_section{i,1}));  %NOTE:CANT USE THIS FOR SEARCHING, since i need the whitespace for " rho"
                   if ~isempty(strfind(cp_section{i,1},'Coords'))
                       obj.co_ords = [str2num(temp_cell{5}),str2num(temp_cell{6}),str2num(temp_cell{7})];
                       obj.cp_numb = str2num(temp_cell{2});
                   elseif ~isempty(strfind(cp_section{i,1},' Rho'))
                       obj.rho = str2num(temp_cell{end});
                   elseif  ~isempty(strfind(cp_section{i,1},'Type'))
                        obj.deriv_signs = temp_cell{3};
                        obj.type = temp_cell{4};
                        obj.atoms = temp_cell(5:end);
                   elseif ~isempty(strfind(cp_section{i,1},'GradRho'))
                        obj.gradrho = [str2num(temp_cell{3}),str2num(temp_cell{4}),str2num(temp_cell{5})];  %Only giving 2 vals currently
                   end
                    
                    
                   
                    
                    
                end
                
                
                
                
            end
        end
        
        
    end
    
end

