function [all_i,individ_gauss] = Gen_Gelius_Spectrum( pathlist,hv,FWHM )

dbstop if error

%%HUGE BUG 
%%HUGE BUG
%%HUGE BUG
%%HUGE BUG
%%HUGE BUG
%If pathnames are too long, it will crash when trying to make figures. best
%way to avoid is to run on a pathlist that isnt toooo far from root. Can
%also just set figsave/savejpeg to 0 and get just .txt output


%UNTITLED Summary of this function goes here
%   Input:
%pathlist = a cell array (1 row) containing list of all folders you want to
%           act on
%hv = the photon energy you want the spectrum calcualted for. set to <0 to
%       do a DoS


%USER CONTROLLED CONSTANTS HERE (none get modified during script run)
%For more graph-related options look in function Plot_Spectra
max_e = 45; %cutoff for orbital BINDING energy (orbitals with higher B.E will be deleted)
min_e = -5;  %cutoff for orbital BINDING energy (orbitals with lower B.E will be deleted)
pford = 1;   %Set to 1 to use certain p AO cross sections in place of higher ang.mom ones (d/f), e.g for C2d/N2f etc.
max_e_plotted = 45; %Maximum energy to calculate a spectral intensity for
min_e_plotted = -2;  %Minimum energy to calculate spectral intensity for (0 is sensible value)
savetext = 1;   %set to  1 to save text files with all data in (calc spectra+all breakdowns)
figsave= 1; %set to 1 to save graphs(.fig format) of all breakdowns/the calculated spectrum
savejpeg = 1; %set to 1 to save graphs (.jpeg format) of all breakdowns/claculated spectra (can have both savefig and savejpeg)
%FWHM = 1; %FWHM of each peak plotted (around each MO energy)
lorentz_fraction = 0.3; % percent lorenztian character in the lineshape. 0=pure lorenztian, 1=pure gaussian 0.5 = 50:50 mix
step_size = 0.01; %distance between each plotted/calculated point in eV
all_contribs_output=1;  %Set to 0 if you dont want the txt file with ALL contributions in it. WILL speed up script A LOT. Suffers from same bug as figsave if file pathnames too deep

    %When given a foldername it returns a list of all MLinpt.txt files present
    function [filelist_path,filelist]=Gen_Filelist(foldername)
        filelist_struct=dir(foldername); %Structure array with info about folders/files in input folder
        counter=1;
        for i=1:size(filelist_struct,1);
            %Only gets files that contain .txt and arent directories
            if filelist_struct(i).isdir~=1 && isempty(strfind(filelist_struct(i).name,'MLinpt.txt'))~=1 
                filelist{counter} = filelist_struct(i).name;
                counter = counter + 1;
            end
        end
        counter=1;
        
        %POSSIBLE ERROR:I'm using the backward slash to create a path
        filelist_path = filelist;
        for i=1:size(filelist_path,2);
            %filelist_path{i} = strcat(foldername,'\',filelist_path{i});
            filelist_path{i} = fullfile(foldername,filelist_path{i});
        end
        
        %Generating fragment names
        for i=1:size(filelist,2)
            filelist{i}=strrep(filelist{i},'_MLinpt.txt','');
        end
    end




    %Extracts all info from input file into variables
    %input:
    %filename = obbviously the full path of file to import
    %max_e = cutoff for orbital BINDING energy (orbitals with higher B.E will be deleted)(OPTIONAL ARGUMENT)
    %min_e = cutoff for orbital BINDING energy (orbitals with lower B.E will be deleted)(OPTIONAL ARGUMENT)
    %output:
    %fragment_labels = list of fragment labels (1 label per position) used to extract x_sections later (e.g S3D N2D) 
    %energies = N x 1 column matrix containing all orbital BINDING energies 
    %intensities = N x M matrix, N=number of MOs, M=number of fragments (NOT including TDOS) and same as length of fragment_labels output
    %m_factor = factor to multiply a fragments contribution by (in case calc. system stoichiometry doesnt match experimental)
    function [fragment_labels,energies,intensities,m_factor]=Import_File(filename,max_e,min_e)
        
        inp_file = fileread(filename);
        inp_file = strsplit(inp_file,'\n');	%String list/cell array containing lines of input file
        m_factor = str2num ( strrep(inp_file{1},'# M_FACTOR=','') );
        fragment_labels = strsplit(inp_file{2},',');
        fragment_labels = fragment_labels(3:end);	%All fragment labels,NOT TDOS and energies though
        numb_cols = size(fragment_labels,2) + 1; %Columns in data matrix, 1 more than frag_labels as it includes energy
        data_array = zeros(size(inp_file,2)-3,numb_cols); 
        
        %POSSIBLE ERROR:inp_file has empty column@end, hence the -1 in loop. May cause problems somehow.
        %Putting energies+intensities into 1 grid (data_array-not TDOS column tho)
        for i=3:size(inp_file,2)-1
            temp_list = strsplit(inp_file{i},',');
            counter=1;
            for j=1:size(temp_list,2)
                if j~=2		%Gets rid of the TDOS column
                    data_array(i-2,counter) = str2num(temp_list{j});
                    counter=counter+1;
                end
            end
        end
        
        %Converting energies to binding energies and removing energies
        %above/below threshold
        %POSSIBLE ERROR:code assumes highest value=1st entry (as it should be but..)
        data_array(:,1) = data_array(:,1)*-1;
        e_upper=1;	%index of highest energy MO we want
        e_lower=size(data_array,1);
        for i=1:size(data_array,1)
            if data_array(i,1) > max_e
                e_upper = i +1;
            end
            if data_array(size(data_array,1)-i+1,1) < min_e
                e_lower = size(data_array,1)-i;
            end
        end
        energies = data_array(e_upper:e_lower,1);
        intensities = data_array(e_upper:e_lower,2:end);
        
        
    end


    %Takes a cell array (row vector) of labels (labels_list input) and returns a row of the
    %corresponding cross-sections (x_sections output).
    %Input: labels_list= cell array of labels (S3D,S3P,N2S etc.)
    %       hv=The photon energy you want (
    %       High_Ang_Arg = number (1 to use p x-sections for certain higher ang.
    %       mom orbitals (e.g C2f) if there not otherwise available (see
    %       Get_X_Section.m)
    %Output:%x_sections=row vector of x_sections, each corresponds to the
    %                   same position entry in input labels_list
    %       %hv_used = the photon energy ACTUALLY used to gen spectra
    function [x_sections,hv_used] = Gen_X_Sections(labels_list,hv,High_Ang_Arg)
        x_sections=zeros(1,size(labels_list,2));
        hv_used = zeros(1,size(labels_list,2));
        for i=1:size(labels_list,2)
            [x_sections(1,i),hv_used(1,i)]= Get_X_Section(strcat(labels_list{i},''),hv,High_Ang_Arg); %strcat gets rid of space at end of cell reference 
            if hv_used(1,i) ~= hv_used(1,1)
                error('Not all fragments have the same hv value')
            end
        end
            hv_used=hv_used(1,1);
    end

    
    %Input:
    %all_e = column matrix, each column=energies of one fragment. each row=1 MO energy of that fragment
    %all_i = intensities already weighted by cross section,rows must match energies of all_e. each n columns corresponds to 1 fragment
    %frag_list = row vector containing. Each row contains number of components (columns in all_i) in each fragment in order listed in all_e and all_i. 
    %fragment_names = row vector with names of fragments (e.g Anion,Cation), 1 per column, in same order as frag_list
    %Output:
    %spectral_matrix = 2 column matrix with energies in 1st column and intensities in 2nd column. Easy to generate full spectrum from
    %fragment_matrix -1st column is energies, 2nd col=frag 1 intensities, 3rd col =2 frag 2 intensities etc. Same frag order as frag_list/names
    %all_contribs_matrix = 1st col is energy, each subsequent col. corresponds to a sub-fragment (e.g S3s on frag 3) intensities
    function [spectral_matrix,fragment_matrix,all_contribs_matrix] = Generate_Matrices(all_e,all_i,frag_list,fragment_names)
        %Initialise all matrices
        spectral_matrix = zeros(size(all_e,2)*size(all_e,1),2);
        %IMPORTANT fragment_matrix Holds all energies (col 1) and all intensities(rest of
        %col). Fragments are stacked vertically. so first n rows may be
        %fragment 1, then next m rows are fragment two. 
        fragment_matrix = NaN(size(all_e,2)*size(all_e,1),size(frag_list,2)+1); %1st col=energies,2nd col=frag1(in frag_list/names),3rd col=frag2 (in frag lists/names) etc.
        merged_matrix = NaN(size(all_e,2)*size(all_e,1),1+max(frag_list)) ;       
        all_contribs_matrix =  NaN(size(all_e,2)*size(all_e,1),size(all_i,2)+1);
        
        %Creating spectral_matrix
        %POSSIBLE ERROR:Nasty code,needs a LOT of testing
        counter_e = 1; %Keeps track of which row to start adding energies to in spectral_matrix (and how many to add)
        counter_i = 1; %Keeps track of which cols. of all_i we've already added
        
        
        
        %all_e(isnan(all_e))= -1
        for i=1:size(all_e,2)
            spectral_matrix(counter_e:counter_e+size(all_e,1)-1,1) = all_e(:,i);    %merges energies
            spectral_matrix(counter_e:counter_e+size(all_e,1)-1,2)=nansum(all_i(:,counter_i:counter_i+frag_list(i)-1),2); 
            counter_e = counter_e + size(all_e,1);
            counter_i = counter_i + frag_list(i);
        end
        spectral_matrix=sortrows(spectral_matrix);  %puts all NaN at bottom
        spectral_matrix = spectral_matrix(~any(isnan(spectral_matrix),2),:); %Remove rows which are just NaN.BROKEN.
        

        %CREATING THE ACTUAL MERGED MATRIX (which is a lil more generally
        %useful). IF size all_e=27, then every 27 rows representes a new
        %fragment.
        counter_e = 1; %Keeps track of which row to start adding energies to in spectral_matrix (and how many to add)
        counter_i = 1; %Keeps track of which cols. of all_i we've already added
        for i=1:size(all_e,2)
            curr_i_col = counter_i;
            merged_matrix(counter_e:counter_e+size(all_e,1)-1,1) = all_e(:,i);    %merges energies
            merged_matrix(counter_e:counter_e+size(all_e,1)-1,2:frag_list(i)+1)=(all_i(:,curr_i_col:curr_i_col+frag_list(i)-1)); 
            counter_e = counter_e + size(all_e,1);
            counter_i = counter_i + frag_list(i);
        end
        
        %Sume all the fragment contribs up to get FRAGMENT MATRIX (1st col
        %energy, 2nd col=1st frag in frag_list, 3rd col=2nd frag in
        %frag_list etc.
        counter_fragment_matrix=2; %tracks what column in frag_mat we're on
        fragment_matrix(:,1)=merged_matrix(:,1);
        
        %num_steps each go = size(all_e,1)
        %total_steps = size(merged_matrix,1)/size(all_e,1) =number of fragments
        counter_e=1;
        for j=2:(1+size(frag_list,2))       %(1 per fragment)
        for i=counter_e:(counter_e + size(all_e,1)- 1)
            fragment_matrix(i,j) = nansum(merged_matrix(i,2:end));
        end
                    counter_e=counter_e+size(all_e,1);
        end   

                
        %fragment_matrix=sortrows(fragment_matrix);  %puts all NaN at bottom
        %fragment_matrix = fragment_matrix(~any(isnan(fragment_matrix),2),:); %Remove NaN
        
        
        
        %GENERATING all_contribs_matrix here
        
        counter_e = 1; %Keeps track of which row to start adding energies to in spectral_matrix (and how many to add)
        curr_i_col = 1; %Keeps track of which cols. of all_i we've already added
        for i=1:size(all_e,2)
            all_contribs_matrix(counter_e:counter_e+size(all_e,1)-1,1) = all_e(:,i);    %merges energies
            all_contribs_matrix(counter_e:counter_e+size(all_e,1)-1,curr_i_col+1:curr_i_col+frag_list(i))=(all_i(:,curr_i_col:curr_i_col+frag_list(i)-1)); 
            counter_e = counter_e + size(all_e,1);
            curr_i_col = curr_i_col + frag_list(i);
        end
        
        %Gets rid of all NaN rows from all contribs matrix
        all_contribs_matrix=sortrows(all_contribs_matrix); %puts all NaN at bottom
        first_nan=size(all_contribs_matrix,1);
        for i=1:size(all_contribs_matrix,1)
            if isnan(all_contribs_matrix(i,1))
                first_nan=i-1;      %-1 because splicing is inclusive
                break
            end
        end
        
        all_contribs_matrix=all_contribs_matrix(1:first_nan,:);
        
        %all_contribs_matrix= all_contribs_matrix(~any(isnan(spectral_matrix),2));    %Removes rows with ALL NaN entries
        
        %spectral_matrix=sortrows(spectral_matrix);  %puts all NaN at bottom
        %spectral_matrix = spectral_matrix(~any(isnan(spectral_matrix),2),:); %Remove NaN
        
    end





    %Generates an overall gelius spectrum, and saves any combination of figure/text
    %file/jpeg required.
    %Input:
    %spectral_matrix = row 1 is energies,row 2 is intensities.
    %FWHM = the full-width at half maximum wanted in the caculated spectrum
    %lorenz fraction= between 0 and 1, 1=100% lorenztian lineshape and 0=100% gaussian. 0.5=50:50 mixutre of gassuain/lorenztian
    %min_e_plot = minimum energy at which an intensity will be calculated
    %max_e_plot = maximum energy at which an intenstiy will be calculated
    %step_size
    %base_filename = string containing base name of output files. Info gets appended (e.g hv,FWHM,type of output) to this in the output files
    %
    function [individual_gaussians] = Generate_Overall_Spectrum (spectral_matrix,FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size,base_filename,savetext,figsave,savejpeg)
        %g_prefactor=1/((sqrt(2*pi)*(FWHM/2.3548)));    %Prefactor to normalise a gaussian function (so int. over all space=1)
        %FWHM_factor = ((FWHM/2.35482)^2)*2;  %Used to generate gaussian peak
        %Generate our x values,based on step size/max and min
        %number_points = ceil((max_e_plot-min_e_plot) / step_size);
       % x_axis = [min_e_plot:step_size:(step_size*number_points)]';   %column vector which contains all x_axis values
        
        %Initialising matrices
        %individual_gaussians = zeros(size(x_axis,1),size(spectral_matrix,1));   %Holds all gaussians,1 per column
        %calc_spectrum = zeros(size(x_axis,1),2);   %1st col=x vals,2nd col=intensities of spectrum
        %calc_spectrum(:,1) = x_axis;
        %Putting GL functions around
        
       % for i=1:size(spectral_matrix,1);    %loop once per energy
       %     for j=1:size(x_axis,1);
       %         lorentz=((1/pi)*((0.5*FWHM)/((((x_axis(j)-spectral_matrix(i,1))^2))+((0.5*FWHM)^2)) ))*spectral_matrix(i,2);
       %         gauss=g_prefactor*((exp(-(((x_axis(j))-spectral_matrix(i,1))^2)/FWHM_factor)))*spectral_matrix(i,2);
       %         individual_gaussians (j,i)=((lorentz_fraction*lorentz)+((1-lorentz_fraction)*gauss));
       %     end
      %  end
        %Adds up all contributions to get the spectrum
        %for i=1:size(individual_gaussians,1)
         %   temp_sum = 0;
          %  for j=1:size(individual_gaussians,2)
           %     temp_sum=temp_sum + individual_gaussians(i,j);
            %end
            %calc_spectrum(i,2) = temp_sum;
        %end
        %Replaces all code above which is commented out. calc_spectrum col
        %1=energy,col 2= calculated intensities
        [individual_gaussians,calc_spectrum] = Gen_Gauss_Plot(spectral_matrix(:,1),spectral_matrix(:,2),FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size);
        %Generates the outputs requested
        filename = strcat(base_filename,'_CalcSpectrum');
        if(savetext==1)
            dlmwrite(strcat(base_filename,'.txt'),calc_spectrum);
        end
        if figsave==1
            Plot_Spectra(calc_spectrum,base_filename,{''},savejpeg)
        end
    end





    %Generates the contribution of the fragments (i.e the individual txt
    %files from the folder) to the overall spectrum/DoS.
    %Input is mostly the same as Generate_Overall_Spectrum except:
    %INPUT:
    %fragment_matrix = 1st column is MO energies, next n columns are intensities

    function Generate_Fragment_Spectra (fragment_matrix,fragment_names,FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size,base_filename,savetext,figsave,savejpeg)
        
        %Holds the energies (column 1) and intensities (columns 2-->n)
        %after putting the gaussian functions round each fragment contribution
        number_points = ceil((max_e_plot-min_e_plot) / step_size);
        x_axis = [min_e_plot:step_size:(step_size*number_points)]';   %column vector which contains all x_axis values
        summed_frag_matrix = zeros(size(x_axis,1),size(fragment_matrix,2)-1);
        total_spec = zeros(size(x_axis,1),2);    %holds total spectrum,just for the plotting
        
        
        %Gotta get rid of NaN,zeros are easiest code wise (but WILL SLOW
        %DOWN THE CODE)
        fragment_matrix(isnan(fragment_matrix))= 0 ; %

        %Gets the fragment contribs into a matrix
        for i=2:size(fragment_matrix,2)
            [individual_gaussians,curr_fragment] = Gen_Gauss_Plot(fragment_matrix(:,1),fragment_matrix(:,i),FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size);
            if i==2;
               summed_frag_matrix(:,1) =  curr_fragment(:,1);
            end
            summed_frag_matrix(:,i) = curr_fragment(:,2);
        end
        
        
        
        
        
        
        %Making graphs/saving txt. Each fragment gets individual text file.
        %The plotted graph is with all fragments on 1 graph
        for i=2:size(summed_frag_matrix,2);
            if savetext==1;
                text_name = strcat(fragment_names{i-1},'_',base_filename,'.txt');
                dlmwrite(text_name,[summed_frag_matrix(:,1) summed_frag_matrix(:,i)]);
            end
        end
        
        %Now the plotting part
        if figsave==1
            fig_name = strcat(base_filename,'_','frag_contribs');
            legend_names = ['total spectrum' fragment_names];
            total_spec(:,1) = summed_frag_matrix(:,1);
            for i=1:size(summed_frag_matrix,1);
                total_spec(i,2) = sum( summed_frag_matrix(i,2:end));
            end
            to_plot = [total_spec summed_frag_matrix(:,2:end)]
            
            Plot_Spectra(to_plot,fig_name,legend_names,savejpeg)
        end
        
        end
        
    %Gets the contributions from all sub-fragments to the spectrum. not
    %bothering making plot since theres generally too many lines
    %INPUT:
    %mostly same as previous butL
    %all_contribs_matrix has 1st column=eenergies,2nd->n columns contain intensities from all sub-fragments (anion S3S,cation 3P)
    %frag_list=row matrix, each with number of columns per fragment (e,g [3 4] means two fragments, 1st has 3 sub=fragments, 2nd has 4 sub-fragments)
    %fragment_names = name of each fragment, e.g 'Anion'. Comes from input file names
    %all_labels = list of ALL sub-fragments in cell array ({'S3S','N2P'} etc)
    function Generate_All_Contribs_Spectra(all_contribs_matrix,frag_list,fragment_names,all_labels,FWHM,lorentz_fraction,min_e_plotted,max_e_plotted,step_size,base_filename,savetext)
        
        number_points = ceil((max_e_plotted-min_e_plotted) / step_size);
        x_axis = [min_e_plotted:step_size:(step_size*number_points)]';   %column vector which contains all x_axis values
        all_contribs_final = zeros(size(x_axis,1),size(all_contribs_matrix,2)); %holds the final gaussians for sub-fragments
        output_fname = strcat('ALL_Contribs_',base_filename,'.txt');
        
        %Populates the matrix
        for i=2:size(all_contribs_final,2)
            [individual_gaussians,summed_gaussians] = Gen_Gauss_Plot(all_contribs_matrix(:,1),all_contribs_matrix(:,i),FWHM,lorentz_fraction,min_e_plotted,max_e_plotted,step_size);
            if i==2
               all_contribs_final(:,1) = summed_gaussians(:,1);
               all_contribs_final(:,i) = summed_gaussians(:,2);
            else
               all_contribs_final(:,i) = summed_gaussians(:,2);
            end
        end
        %Defining each header line to be printed to output file
        frag_list_string = strrep(num2str(frag_list(1,:)),'  ',',');  %converts frag_list from row vector to comma delimited string
        header_1 = strcat('#',strjoin(fragment_names,','));
        header_2 = strcat('#Sub fragments in each=,',frag_list_string);
        header_3 = strcat('#Energy(eV),',all_labels);
        total_header = strcat(header_1,'\n',header_2,'\n',header_3,'\n');
        %Writing all data to an output file.
        fobject=fopen(output_fname,'w');
        fprintf(fobject,total_header)
        fclose(fobject);
        dlmwrite(output_fname,all_contribs_final,'-append');
    end
        
    




    %POSSIBLE ERROR : NOT SURE IF THIS CURRENTLY SUPPORTS NaN well
    %INPUT:
    %energies=1column,each row contains an orbital energy
    %intensities=1 column, same size as energies. Each row contains the
    %intenisty to multiple the GL peak (cnetered around energies) by
    %Output
    %individual gaussians is an nxm matrix, with m (column) gaussian functions stored. each n row corresponds to a binding energy
    %
    function [individual_gaussians,summed_gaussians] = Gen_Gauss_Plot(energies,intensities,FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size)
        
        g_prefactor=1/((sqrt(2*pi)*(FWHM/2.3548)));    %Prefactor to normalise a gaussian function (so int. over all space=1)
        FWHM_factor = ((FWHM/2.35482)^2)*2;  %Used to generate gaussian peak
        %Generate our x values,based on step size/max and min
        number_points = ceil((max_e_plot-min_e_plot) / step_size);
        x_axis = [min_e_plot:step_size:(step_size*number_points)]';   %column vector which contains all x_axis values
        
        %Initialising matrices
        individual_gaussians = zeros(size(x_axis,1),size(energies,1));   %Holds all gaussians,1 per column
        summed_gaussians = zeros(size(x_axis,1),2);   %1st col=x vals,2nd col=intensities of spectrum
        summed_gaussians(:,1) = x_axis;
        %Putting GL functions around
        
        for i=1:size(energies,1);    %loop once per energy
            for j=1:size(x_axis,1);
                lorentz=((1/pi)*((0.5*FWHM)/((((x_axis(j)-energies(i,1))^2))+((0.5*FWHM)^2)) ))*intensities(i,1);
                gauss=g_prefactor*((exp(-(((x_axis(j))-energies(i,1))^2)/FWHM_factor)))*intensities(i,1);
                individual_gaussians (j,i)=((lorentz_fraction*lorentz)+((1-lorentz_fraction)*gauss));
            end
        end
        
        test_matrix=summed_gaussians;
        %Adds up all contributions to get the spectrum
        for i=1:size(individual_gaussians,1)
            %for j=1:size(individual_gaussians,2)
                %temp_sum=nansum([temp_sum + individual_gaussians(i,j)]);
                %temp_sum=temp_sum + individual_gaussians(i,j)
            %end
            temp_sum=nansum(individual_gaussians(i,:));
            summed_gaussians(i,2) = temp_sum;
        end
        
    end







    %Plots+saves spectrum
    %Input: 1)to_plot = matrix, 1st col=x vals, col 2:n = lines to plot
    function Plot_Spectra(to_plot,base_filename,legend_names,savejpeg)

        
    max_y = max(max(to_plot(:,2:end))) ; %Highest y value in to_plot
    %all graph options here
    xlim= [min(to_plot(:,1)) max(to_plot(:,1))];
    ylim= [0 max_y+(0.1*max_y)];
    lwidth=2;
    font_size=9;
    font_type='times';
    xlabel='Binding Energy / eV';
    ylabel='Intensity / arb.units';
    
    %figure1 = figure('visible','off'); %Anoyingly saves in "invisible" mode too,
    figure1 = figure;
    axes1= axes('Parent',figure1,'XDir','reverse');
    hold all
    
    for i=2:size(to_plot,2)
       plot(to_plot(:,1),to_plot(:,i),'linewidth',lwidth);
    end
    
    
    set(axes1,'fontsize',font_size);
    set(axes1,'fontname',font_type);
    set(axes1,'xlim',xlim);
    set(axes1,'ylim',ylim);
    set(get(axes1,'xlabel'),'string',xlabel,'fontsize',font_size,'fontname',font_type);
    set(get(axes1,'ylabel'),'string',ylabel,'fontsize',font_size,'fontname',font_type);

    
    if ~strcmp(legend_names{1},'');
        legend_1 = legend(legend_names);
        
    end;
    
    savefig(gcf,strcat(base_filename,'.fig'));
    %savefig(gcf,strcat('cheese','.fig'));

    if savejpeg==1
        saveas(figure1,strcat(base_filename,'.jpeg'));
    end
    close(figure1);
    
    end

















%Likely will need some pre-processing options for diff systems
%(cygwin/bash/mac/windows) due to diff path formats
    function [all_labels] = Main()
  %      if ischar(foldername)   %Converts single filename from string to
  %      list. From before i decided to make this only work on folders
  %          foldername=filename
  %          foldername = strsplit(foldername,'\')
  %          foldername(end)=[]
  %          foldername = strjoin(foldername,'\')
  %          foldername = {foldername}
        
        %ADD SOME ERROR CHECKS HERE(e.g if min_e > max_e give appropriate
        %error msg)
        %NEED TO MAKE COMPATIBLE FOR FRAGMENTS W/DIFFERENT ENERGIES(lotsa
        %array padding to do)
        Script_Dir = pwd;   %So we can return to folder with script in @ end
        pause on
        for folder=1:size(pathlist,2);
        %Creating new folder structure
        cd(pathlist{folder})    %So we save in correct folder
        l_frac=strrep(num2str(lorentz_fraction),'.','pt');
        if hv>0
        dirname=strrep(num2str(hv),'.','pt');
        dirname=strcat(dirname,'eV_',num2str(FWHM),'ev_',l_frac,'l');
        mkdir(dirname)   
        cd(dirname);
        else
            l_frac=strrep(num2str(lorentz_fraction),'.','pt');
            dirname='DoS';
            dirname=strcat(dirname,'_',num2str(FWHM),'ev_',l_frac,'l');
            mkdir(dirname);
            cd(dirname);
        end
        %Initialising variables
        [filelist,fragment_names] = Gen_Filelist(pathlist{folder});   %Gets list of paths for all relevant files in folder(filelist) and also filenames w/ extension removed (fragment_names)
        frag_list = zeros(size(filelist,1),1)   ;%holds number of fragments in each file (1 numb/column)
        all_labels = ''   ;  %str will hold (comma delimted) all fragment labels (S3S,C2P, etc)
        all_e=[] ;   %holds columns of energy from all fragments in folder(1 col/frag)
        all_i=[];    %holds all intensities
        all_m_factors=[]; %holds all m_factors (1 m_factor/column)
        
        %Populates all_labels/all_e/all_i/all_m_factors
        for file=1:size(filelist,2)
            [fragment_labels,energies,intensities,m_factor] = Import_File(filelist{file},max_e,min_e) ; %Imports all useful info from input file (
           %Next bit combines all energies/intensities/m_factors into
           %all_i/all_e
           %(has to pad arrays so all same size)
            if isempty(all_e);
                all_e = energies;
                all_i = intensities * m_factor;
            else
                if size(energies,1) >= size(all_e,1);
                    all_e = padarray(all_e(:,1:end),abs(size(all_e,1)-size(energies,1)),NaN,'post');
                    all_i = padarray(all_i(:,1:end),abs(size(all_i,1)-size(energies,1)),NaN,'post');
                end
                if size(energies,1) <=size(all_e,1);
                    energies = padarray(energies(:,1:end),abs(size(all_e,1)-size(energies,1)),NaN,'post');
                    intensities = padarray(intensities(:,1:end),abs(size(all_i,1)-size(intensities,1)),NaN,'post');
                end
                all_e = [all_e energies];
                all_i = [all_i intensities*m_factor];
                
            end
            %Puts all fragments labels into one long list (1xrow,N columns)
            if isempty(all_labels)
                all_labels=strcat(all_labels,strjoin(fragment_labels,','));
            else
                all_labels=strcat(all_labels,',',strjoin(fragment_labels,','));
            end
 
            all_m_factors(file) = m_factor ;
            frag_list(file) = size(fragment_labels,2);
        end
        
        %This part uses the combined fragment stuff
        %Get x-sections
        if hv>0
            [x_sections,hv_used] = Gen_X_Sections(strsplit(all_labels,','),hv,pford);
            hv_used=strcat(num2str(hv_used),'eV');
            
            %pause on;
            %pause;
        else
            x_sections = ones(1,size(strsplit(all_labels,','),2));
            hv_used = 'DoS';
        end
        %Weights all intensities by cross-section
        for i=1:size(all_i,2)
            all_i(:,i) = all_i(:,i) * x_sections(1,i);
        end
        %Generates a base_filename for all subsequent scripts
%         base_filename=strsplit(pathlist{folder},'\');    %POSSIBLE ERROR:using '\' as delimiter in file path
%         hv_used_str = strrep(hv_used,'.','pt')   ;       %hv used to calc spectra
%         base_filename = strcat(base_filename{end},'_',hv_used_str);
        
        [~,base_filename]=fileparts(pathlist{folder});    
        hv_used_str = strrep(hv_used,'.','pt')   ;       %hv used to calc spectra
        base_filename = strcat(base_filename,'_',hv_used_str);
       
        
        %Generates range of matrices to be used in later functions (see
        %function description for full details)
        [spectral_matrix,fragment_matrix,all_contribs_matrix] = Generate_Matrices(all_e,all_i,frag_list,fragment_names);
        %NOTE:Need to swap to correct folder before running these functions
        
        [individ_gauss] = Generate_Overall_Spectrum (spectral_matrix,FWHM,lorentz_fraction,min_e_plotted,max_e_plotted,step_size,base_filename,savetext,figsave,savejpeg);
        
        %BIT BELOW NEEDS SOME TESTING:  
        Generate_Fragment_Spectra(fragment_matrix,fragment_names,FWHM,lorentz_fraction,min_e_plotted,max_e_plotted,step_size,base_filename,savetext,figsave,savejpeg);
        if all_contribs_output==1
        Generate_All_Contribs_Spectra(all_contribs_matrix,frag_list,fragment_names,all_labels,FWHM,lorentz_fraction,min_e_plotted,max_e_plotted,step_size,base_filename,savetext);
        end
        %POSSIBLE ERROR: NEED TO MAKE SURE NaN supported by gen_gaussians
        %code/gen_all_contribs.
        
        %Modules to generate spectrum broken down in different ways
        %Generate_Overall_Spectrum (spectral_matrix,FWHM,lorentz_fraction,min_e_plot,max_e_plot,step_size,base_filename,hv,savetext,figsave,savejpeg)
        end
        cd(Script_Dir)  %Move back to starting directory
    end

    
tic
[all_labels]=Main();
toc

%PROGRESS:Should have all values extracted/mostly formatted
%Need to:
%SORT OUT GRAPHING FUNCTION
%a) Add more matrix outputs to Generate_Matrices option (spectral_matrix
%current works though,as does fragment_matrix-woohoo)
%b) Put in all the modules (MO breakdown,Total spectrum,fragment
%breakdowns)

end


%CURRENT BIG BUG:
%savas function has been crashiing my matlab for just 1 of the folders (where NPOTHING is wrong with the graph plotted/the filename)



