      subroutine valence_attr
      use grid_module
      use orbitals_module
      use basins_module
      implicit none
      integer i,j,k,irw,ix,iy,iz,npyz,neighb(6)
      integer nborder,iborder
      integer ixa,iya,iza,indy
      integer*2 count
      integer low_limit,limit2,seed
      integer npx,npy,npz,n_neighb(6)
      integer nchange,vpoint,vcircle
      integer new_attr
      integer l1
      real thresh,oldf
      double precision eps
      double precision xp,yp,zp
c     double precision origin(3), edge(3),step(3)
      double precision pi,dist,an
      character*1 molecule(40)
      character*40 filebas, fileelf, dumname
      logical func_type
      common /files/ molecule,fileelf,filebas
      common/ftype/func_type
      common/valence/thresh,low_limit
      common/random/seed
      equivalence (molecule(1),dumname)
      vpoint=2
      vcircle=3
      pi=dacos(-1.0d0)
      count=0
      new_attr=0
      eps=1.0d-5
      origin(1)=xmin
      origin(2)=ymin
      origin(3)=zmin
      edge(1)=xmax-origin(1)
      edge(2)=ymax-origin(2)
      edge(3)=zmax-origin(3)
      npx=np(1)-1
      npy=np(2)-1
      npz=np(3)-1
      if(npx.eq.0) then
         step(1)=0.0d0
      else
         step(1)=edge(1)/npx
      endif
      if(npy.eq.0) then
         step(2)=0.0d0
      else
         step(2)=edge(2)/npy
      endif
      if(npz.eq.0) then
         step(3)=0.0d0
      else
         step(3)=edge(3)/npz
      endif
      npts=np(1)*np(2)*np(3)
      npyz=np(2)*np(3)
      nchange=0
      do i=1,attract_label
         call fill_bas(i)
      enddo
      i=indx(1)
      if(attract_code(i).eq.0) then
         ix=(i-1)/npyz
         iy=(i-1-ix*npyz)/np(3)
         iz=i-1-ix*npyz-iy*np(3)
         xp=origin(1)+ix*step(1)
         yp=origin(2)+iy*step(2)
         zp=origin(3)+iz*step(3)
         irw=0
         dist=1.0d3
         do k=1,natoms
            an=(xp-xat(k))**2+(yp-yat(k))**2+(zp-zat(k))**2
            if(an.lt.dist) then
               irw=k
               dist=an
            endif
         enddo
         call attractors(xp,yp,zp,irw,0,vpoint,vcircle) 
         ixa=nint((xp-origin(1))/step(1))
         iya=nint((yp-origin(2))/step(2))
         iza=nint((zp-origin(3))/step(3))
         indy=1+iza+np(3)*(iya+np(2)*ixa)
         if(attract_code(indy).eq.0) then
            attract_code(i)=1
            call fill_bas(1)
         endif
      endif
      nborder=0
      oldf=elf(indx(1))
      l1=low_limit/10
      limit2=2
      do while (elf(indx(limit2)).ge.0.25e0)
         limit2=limit2+1
      enddo
      do j=2,limit2
        i=indx(j)
        ix=(i-1)/npyz
        iy=(i-1-ix*npyz)/np(3)
        iz=i-1-ix*npyz-iy*np(3)
        call neighbor(i,neighb)
        call neighcls(neighb,n_neighb,iborder)
*
*       iborder=0 new attractor
*
        if(iborder.eq.0) then
           if(attract_code(i).eq.0) then
              xp=origin(1)+ix*step(1)
              yp=origin(2)+iy*step(2)
              zp=origin(3)+iz*step(3)
              irw=0
              dist=1.0d3
              do k=1,natoms
                 an=(xp-xat(k))**2+(yp-yat(k))**2+(zp-zat(k))**2
                 if(an.lt.dist) then
                    irw=k
                    dist=an
                 endif
              enddo
              call attractors(xp,yp,zp,irw,0,vpoint,vcircle)
              ixa=nint((xp-origin(1))/step(1))
              iya=nint((yp-origin(2))/step(2))
              iza=nint((zp-origin(3))/step(3))
              indy=1+iza+np(3)*(iya+np(2)*ixa)
              if(attract_code(indy).eq.0) then
                 attract_code(i)=1
                 call fill_bas(attract_label)
              endif
           endif
        endif
*
*       iborder=1 regular wandering point
*
        if(iborder.ge.1) then
           attract_code(i)=n_neighb(1)
        endif
      enddo
      return
      end
