      subroutine symmat(iop)
      implicit none
      double precision trans(3,3)
      double precision xc, yc, zc
      integer sym(3,3,3)
      integer iop,i,j
      character*3 name_op(3), names(22)
      common /mat/xc,yc,zc,trans,sym,name_op
      data names/'INV','PLX','PLY','PLZ','PXY','PYX','PXZ','PZX',
     .           'PYZ','PZY','C2X','C2Y','C2Z','C4X','C4Y','C4Z',
     .           'S4X','S4Y','S4Z','CTX','CTY','CTZ'/
      do i=1,3
         do j=1,3
            sym(iop,i,j)=0
         enddo
         trans(iop,i)=0.0d0
      enddo
*
*     inversion
*
      if(name_op(iop).eq.names(1)) then
         sym(iop,1,1)=-1   
         sym(iop,2,2)=-1   
         sym(iop,3,3)=-1   
         trans(iop,1)=2.0d0*xc
         trans(iop,2)=2.0d0*yc
         trans(iop,3)=2.0d0*zc
*
*     mirror plane x=xc
*
      else if(name_op(iop).eq.names(2)) then
         sym(iop,1,1)=-1   
         sym(iop,2,2)=1   
         sym(iop,3,3)=1   
         trans(iop,1)=2.0d0*xc
*
*     mirror plane y=yc
*
      else if(name_op(iop).eq.names(3)) then
         sym(iop,1,1)=1   
         sym(iop,2,2)=-1   
         sym(iop,3,3)=1   
         trans(iop,2)=2.0d0*yc
*
*     mirror plane z=zc
*
      else if(name_op(iop).eq.names(4)) then
         sym(iop,1,1)=1   
         sym(iop,2,2)=1   
         sym(iop,3,3)=-1   
         trans(iop,3)=2.0d0*zc
      else if(name_op(iop).eq.names(5)) then
*
*     dihedral plane x=y
*
         sym(iop,1,2)=1
         sym(iop,2,1)=1
         sym(iop,3,3)=1
         trans(iop,1)=xc
         trans(iop,2)=yc
      else if(name_op(iop).eq.names(6)) then
*
*     dihedral plane x=-y
*
         sym(iop,1,2)=-1
         sym(iop,2,1)=-1
         sym(iop,3,3)=1
         trans(iop,1)=xc
         trans(iop,2)=yc
      else if(name_op(iop).eq.names(7)) then
*
*     dihedral plane x=z
*
         sym(iop,1,3)=1
         sym(iop,3,1)=1
         sym(iop,2,2)=1
         trans(iop,1)=xc
         trans(iop,3)=zc
      else if(name_op(iop).eq.names(8)) then
*
*     dihedral plane x=-y
*
         sym(iop,1,3)=-1
         sym(iop,3,1)=-1
         sym(iop,2,2)=1
         trans(iop,1)=xc
         trans(iop,3)=zc
      else if(name_op(iop).eq.names(9)) then
*
*     dihedral plane y=z
*
         sym(iop,2,3)=1
         sym(iop,3,2)=1
         sym(iop,1,1)=1
         trans(iop,2)=yc
         trans(iop,3)=zc
      else if(name_op(iop).eq.names(10)) then
*
*     dihedral plane y=-z
*
         sym(iop,2,3)=-1
         sym(iop,3,2)=-1
         sym(iop,1,1)=1
         trans(iop,2)=yc
         trans(iop,3)=zc
      else if(name_op(iop).eq.names(11)) then
*
*     C2 axis parallel to x
*
         sym(iop,1,1)=1
         sym(iop,2,2)=-1
         sym(iop,3,3)=-1
         trans(iop,2)=2.0d0*yc
         trans(iop,3)=2.0d0*zc
      else if(name_op(iop).eq.names(12)) then
*
*     C2 axis parallel to y
*
         sym(iop,1,1)=-1
         sym(iop,2,2)=1
         sym(iop,3,3)=-1
         trans(iop,1)=2.0d0*xc
         trans(iop,3)=2.0d0*zc
      else if(name_op(iop).eq.names(13)) then
*
*     C2 axis parallel to z
*
         sym(iop,1,1)=-1
         sym(iop,2,2)=-1
         sym(iop,3,3)=1
         trans(iop,1)=2.0d0*xc
         trans(iop,2)=2.0d0*yc
      else if(name_op(iop).eq.names(14)) then
*
*     C4 axis parallel to x
*
         sym(iop,1,1)=1
         sym(iop,2,3)=-1
         sym(iop,3,2)=1
         trans(iop,2)=yc+zc
         trans(iop,3)=zc-yc
      else if(name_op(iop).eq.names(15)) then
*
*     C4 axis parallel to y
*
         sym(iop,1,3)=-1
         sym(iop,2,2)=1
         sym(iop,3,1)=1
         trans(iop,1)=xc+zc
         trans(iop,3)=zc-xc
      else if(name_op(iop).eq.names(16)) then
*
*     C4 axis parallel to z
*
         sym(iop,1,2)=-1
         sym(iop,2,1)=1
         sym(iop,3,3)=1
         trans(iop,1)=xc+yc
         trans(iop,2)=yc-xc
*
*     S4 axis parallel to x
*
         sym(iop,1,1)=-1
         sym(iop,2,3)=-1
         sym(iop,3,2)=1
         trans(iop,1)=2.0d0*xc
         trans(iop,2)=yc+zc
         trans(iop,3)=zc-yc
      else if(name_op(iop).eq.names(15)) then
*
*     S4 axis parallel to y
*
         sym(iop,1,3)=-1
         sym(iop,2,2)=-1
         sym(iop,3,1)=1
         trans(iop,1)=xc+zc
         trans(iop,1)=2.0d0*yc
         trans(iop,3)=zc-xc
      else if(name_op(iop).eq.names(16)) then
*
*     S4 axis parallel to z
*
         sym(iop,1,2)=-1
         sym(iop,2,1)=1
         sym(iop,3,3)=-1
         trans(iop,1)=xc+yc
         trans(iop,2)=yc-xc
         trans(iop,1)=2.0d0*zc
      else if(name_op(iop).eq.names(20)) then
*
*     C4 axis parallel to x and translation of zc along x
*
         sym(iop,1,1)=1
         sym(iop,2,3)=-1
         sym(iop,3,2)=1
         trans(iop,1)=xc
         trans(iop,2)=yc+zc
         trans(iop,3)=zc-yc
      else if(name_op(iop).eq.names(21)) then
*
*     C4 axis parallel to y and translation of zc along y
*
         sym(iop,1,3)=-1
         sym(iop,2,2)=1
         sym(iop,3,1)=1
         trans(iop,1)=xc+zc
         trans(iop,2)=yc
         trans(iop,3)=zc-xc
      else if(name_op(iop).eq.names(22)) then
*
*     C4 axis parallel to z and translation of zc along z
*

         sym(iop,1,2)=-1
         sym(iop,2,1)=1
         sym(iop,3,3)=1
         trans(iop,1)=xc+yc
         trans(iop,2)=yc-xc
         trans(iop,3)=zc
      endif
      return
      end
