      program sbf_to_am
      use grid_module
      use orbitals_module
      use basins_module
*
*      create AmiraMesh  file from sbf
*
      character filein*40, file_type*3,dumname*40
      character*40 filegam,fileelf,filebas
      character*1 molecule(40),blank
      logical rho_and_elf
      common /files/ molecule,filein,filegam,fileelf,filebas,rho_and_elf
      common /type/ file_type
      equivalence (molecule(1),dumname)
      data blank/' '/
      write(*,*) ' input sbf file name '
      read(*,'(a)') fileelf
      call read_sbf
      call write_am
      end
      subroutine write_am
      use grid_module
      use orbitals_module
      use basins_module
      integer i
      character filein*40, file_type*3,dumname*40
      character*40 filegam,fileelf,filebas
      character*1 molecule(40),blank
      logical rho_and_elf
      common /files/ molecule,filein,filegam,fileelf,filebas,rho_and_elf
      common /type/ file_type
      equivalence (molecule(1),dumname)
      data blank/' '/
      dumname=fileelf
      i=1
      do while (molecule(i).ne.blank)
         i=i+1
      enddo
      molecule(i-3)='a'
      molecule(i-2)='m'
      molecule(i-1)=blank
      open(unit=1,file=dumname,status='unknown')
      write(1,'("#AmiraMesh ASCII 1.0")')
      write(1,'("define Lattice",3i4)') np(3),np(2),np(1)
      write(1,'("Parameters {")')
      write(1,'(''     CoordType "uniform",'')')
      write(1,'("      BoundingBox ",6f10.4)')
     .             zmin,zmax,ymin,ymax,xmin,xmax
      write(1,'("}")')
      if(file_type.eq.'elf') then
         write(1,'("Lattice { float ScalarField } = @1")')
         write(1,'("@1")')
      else if(file_type.eq.'lap') then
         write(1,'("Lattice { float ScalarField } = @1")')
         write(1,'("@1")')
      else if(file_type.eq.'rho') then
         write(1,'("Lattice { float ScalarField } = @1")')
         write(1,'("@1")')
      else if (file_type.eq.'bas') then
         write(1,'("Lattice { short ScalarField } = @1")')
         write(1,'("@1")')
      else if (file_type.eq.'syn') then
         write(1,'("Lattice { short ScalarField } = @1")')
         write(1,'("@1")')
      endif
      npts=np(1)*np(2)*np(3)
      if(file_type.eq.'elf') then
         write(1,'(13f6.3)') (elf(i),i=1,npts)
      else if (file_type.eq.'rho') then
         write(1,'(6e12.3)') (elf(i),i=1,npts)
      else if (file_type.eq.'lap') then
         write(1,'(6e12.3)') (elf(i),i=1,npts)
      else if (file_type.eq.'bas') then
         write(1,'(40i2)') (attract_code(i),i=1,npts)
      else if (file_type.eq.'syn') then
         write(1,'(40i2)') (attract_code(i),i=1,npts)
      endif
      close(unit=1)
      return
      end  
