      subroutine read_sbf
      use grid_module
      use orbitals_module
      use basins_module
      implicit none
      integer i,npx,npy,npz
      integer, dimension (:,:), allocatable :: index_basin,tab
      double precision, dimension (:), allocatable :: volume
      logical if_file,rho_and_elf
      character filein*40, file_type*3,dunname*40,filegam*40
      character filebas*40,fileelf*40
      character*1 molecule(40),blank
      common /files/ molecule,filein,filegam,fileelf,filebas,rho_and_elf
      common /type/ file_type
      equivalence (molecule(1),dunname)
      data blank/' '/
      allocate(volume(maxbasin))
      allocate(index_basin(maxbasin,5),tab(maxbasin,5))
      inquire(file=fileelf,exist=if_file)
      if(.not.if_file) then
        write(*,'(2x,"requested file does not exist:",a40)') filein
        stop
      endif
      dunname=fileelf
      i=1
      do while (molecule(i).ne.blank)
         i=i+1
      enddo
      file_type=molecule(i-7)//molecule(i-6)//molecule(i-5)
      open(unit=1,file=fileelf,status='unknown',form='unformatted')
         read(1) np
         read(1) xmin,xmax,ymin,ymax,zmin,zmax
         npts=np(1)*np(2)*np(3)
         allocate(elf(npts),attract_code(npts),indx(npts))
      if((file_type.eq.'elf').or.(file_type.eq.'rho').or.
     .                           (file_type.eq.'lap')) then
         read(1)(elf(i),i=1,npts)
      else if(file_type.eq.'bas') then
         read(1) natoms,attract_label
         do i=1,natoms
            read(1) nat(i),atom_name(i),xat(i),yat(i),zat(i)
         enddo
         do i=1,attract_label
            read(1) index_basin(i,1),name_basin(i),volume(i),x(i),y(i),
     .              z(i)
         enddo
         read(1)(attract_code(i),i=1,npts)
      else if(file_type.eq.'syn') then
         read(1)(attract_code(i),i=1,npts)
      endif
      close(unit=1)
      deallocate(volume,index_basin,tab)
      return
      end
