#!/apps/python/3.4.2//bin/python3

#This is the first script run while tuning a RSH functional. It sets up the initial .com files (neutral/pl1) and writes initial data to
# the .out file. (e.g what parameters are used)
#INPUT ARGUMENTS:

import sys

#TESTING - WILL BE REMOVED AFTER TESTING (and made into system args)#
#filename = r'/Users/rf614/Work/Random_Coding/tune_RSH_testing/test_files/H2O_SPE_6311plgdp_GP_B3LYP_builtin.com'
#xc_funct = 'CAM-B3LYP'
#P5_val = 0.81
#mu_range = 0.33
#alpha_val = 0.19
#beta_val = 0.81
#mu_lower = 0.20 #lower bound on the mu(range sep) var
#mu_upper = 0.30#upper bound on the mu(range sep) var
#es_mult = 2 #Multiplicity of ionised species,only relevant if start config is closed shell but still.....
#TESTING - WILL BE REMOVED AFTER TESTING (and made into system args)#


#EXTRACTING THE CMD LINE ARGUMENTS:
#./init_OTRSH.py "r'/Users/rf614/Work/Random_Coding/tune_RSH_testing/test_files/H2O_SPE_6311plgdp_GP_B3LYP_builtin.com'" CAM-B3LYP 0.81 0.33 0.19 0.81 0.20 0.30 2
filename,xc_funct,P5_val,alpha_val,beta_val,mu_lower,mu_upper,es_mult = [sys.argv[x] for x in range(1,len(sys.argv))]
P5_val,alpha_val,beta_val,mu_lower,mu_upper,es_mult = float(P5_val),float(alpha_val),float(beta_val),float(mu_lower),float(mu_upper),int(es_mult)
print('filename =',filename,',xc_funct=',xc_funct,',P5_val=',P5_val,
	',alpha_val=',alpha_val,',beta_val=',beta_val,',mu_lower=',mu_lower,',mu_upper=',mu_upper,',es_mult=',es_mult)
#Print cmd line arguments as a test









#Summary (write_RSH)
#Code writes the IOps needed to define the RSH based on input arguments (which are in the format of the 2004 CAM-B3LYP paper)
#INPUT:
#1) filename = string,full path to the file to add these instructions to. Should be a g09 input file but missing the functional.
#2) xc_funct = string,combintation of DFT xchange and correlation functionals to use. e.g 'BLYP'. String gets written directly on route section of .com file.
#3) P5_val = float,Decimal value (0-->1) of the P5 parameter in the general DFT expansion on g09 website. This is the coefficient for non local correlation (e.g its 0.81 for B3LYP)
#4) mu_range = float,The parameter determining the behavior of the range seperation function, i.e a in erf(a.r)/r_{1.2}. Also see original CAM-B3LYP paper for formulae. I THINK THIS is in bohr^-1, but not sure.
#5) alpha_val = float,Paramter (between 0 and 1) controlling HF exchange at short range essentially. value of 1 means full HF everywhere, value of 0 means no HF xchange at short range.
#6) beta_val = float,Parameter (between 0 and 1) controlling HF exchange at long range essentially. If alpha+Beta = 1 then HF exchange will be used at r=inf. 
#7) new_filename = the filename of the ouptut fil
#NOTE: Advised that alpha+beta = 1, for correct asymptotic behavior.
def write_RSH(filename,xc_funct,P5_val,mu_range,alpha_val,beta_val,new_filename):
	#****SECTION 1****#
	#Getting all the correct IOp commands in individual strings 
	p1_p2_com = 'IOp(3/76=1000010000)'
	p3_p4_com = 'IOp(3/77=1000010000)'
	p5_p6_com = 'IOp(3/78=' + format(round(P5_val*10000),'05.0f') + '10000)'
	beta_com = 'IOp(3/119=' + format(round(beta_val*10000),'05.0f') + '00000) IOp(3/120=' + format(round(beta_val*10000),'05.0f') +'00000)'
	alpha_com  = 'IOp(3/130=' + format(round(alpha_val*10000),'05.0f') + ') IOp(3/131=' + format(round(alpha_val*10000),'05.0f') + ')'
	mu_com = 'IOp(3/107=' + format(round(mu_range*10000),'05.0f') + '00000) IOp(3/108=' + format(round(mu_range*10000),'05.0f') + '00000)'	
	all_coms = xc_funct + ' ' + p1_p2_com + ' ' + p3_p4_com + ' ' + p5_p6_com + ' ' + alpha_com + ' ' + beta_com + ' ' + mu_com	
	#Creating the modified input file
	with open(filename,'r') as f:
		inp_file=[line.replace('#','# ' + all_coms) for line in f]	#Each line of input file is an entry in the list. Also replaced route section of input file
	with open(new_filename,'w') as f:
		f.write(''.join(inp_file))

#Modifies the charge and multiplicity for the ionised calculation. filename full path to the file to modify
def mod_es_input(filename,es_mult):
	with open(filename,'r') as f: #Sorting out the multiplicity
		inp_file=[line for line in f]
	route_line = 0
	blanks=0
	for line in range(len(inp_file)):
		if inp_file[line].find('#')!=-1:
			route_line = route_line + 1
		if inp_file[line].strip() == '': 	#Looking for the 2nd blank line after #
			blanks = blanks + 1
		if route_line == 1 and blanks==2:
			inp_file[line+1] = str(int(inp_file[line+1].strip().replace(' ',',').split(',')[0])+1) + ',' + str(es_mult) + '\n'
			break
	with open(filename,'w') as f:
		f.write("".join(inp_file))
	











#----------------------->EXECUTED CODE STARTS HERE<-------------------

#****Section 0**** Any error checks i feel like running
if mu_lower == mu_upper:
	print('ERROR mu_lower==mu_upper')
	sys.exit()
if mu_upper < mu_lower:
	mu_upper,mu_lower = mu_lower,mu_upper

#****SECTION 1**** Creating the initial .com files from base file
#Creating the two new files (with modified functional + new multiplicity/charge for excited state)
write_RSH(filename,xc_funct,P5_val,mu_lower,alpha_val,beta_val,filename.replace('.com','_gsstate_mulow.com')) #ground state calc (low mu)
write_RSH(filename,xc_funct,P5_val,mu_lower,alpha_val,beta_val,filename.replace('.com','_ionstate_mulow.com')) #ionised state calc (low mu) 
write_RSH(filename,xc_funct,P5_val,mu_upper,alpha_val,beta_val,filename.replace('.com','_gsstate_muhigh.com')) #ground state calc (high mu)
write_RSH(filename,xc_funct,P5_val,mu_upper,alpha_val,beta_val,filename.replace('.com','_ionstate_muhigh.com')) #ionised state calc (high mu)

#Replacing the multiplicity/charge in the new file
mod_es_input(filename.replace('.com','_ionstate_mulow.com'),es_mult)
mod_es_input(filename.replace('.com','_ionstate_muhigh.com'),es_mult)



#****SECTION 2****
#Creating the .out file and writing the initial parameters to it. Also creating the .calc file
init_param_list = ",".join(['xc_funct','P5_val','alpha_val','beta_val','ionised_multiplicity'])
init_param_list = init_param_list + '\n' + ",".join([xc_funct,str(P5_val),str(alpha_val),str(beta_val),str(es_mult)])	
table_string = ",".join(['mu_val','ftype','E_neutral(au)','E_ion(au)','HOMO E (neutral,au)','Ionisation Potential(au)','IP-E_HOMO (au)'])
file_string = 'Filename = ' + filename + '\n' + init_param_list + '\n' 'OPTIMISATION BEGIN' + '\n' + table_string + '\n' + str(mu_lower) + ',low' + '\n' + str(mu_upper) + ',high' + '\n'

with open(filename.replace('.com','_OTRSH.out'),'w') as f:
	f.write(file_string)

with open(filename.replace('.com','_OTRSH.calc'),'w') as f:
	f.write('curr_grad_step=0')		


