#! /usr/bin/env python


#Purpose of this script is to merge two files from
#The Format_Multiwfn_Output script into one, which is still
#in the correct format for the matlab script. This will be neccesary
#when there is a "fragment" (e.g NTf2) which has too many elements
#for one multiwfn commands file to handle.
#Input
#1) Path to first file you want to merge, will use this as the name of output file(Must have MLinpt.txt extension)
#2) Path to Second file you want to merge (Must have MLinpt.txt extension)
#Output
#1) Merged file, name is same as 1st input file 

import sys
import string


#Returns string list for each file
def Import_Fragment(Fname):
	fobject = open(Fname,'r')
	String_List = fobject.read()
	fobject.close()
	String_List = String_List.split('\n')
	return String_List


def Main():
	#Inp_File1 ="DOS_line_1_MLinp.txt"
	#Inp_File2 ="DOS_line_2_Empty_Frags_MLinp.txt"
	
	Inp_File1 = sys.argv[1]
	Inp_File2 = sys.argv[2]

	Fragment1 = Import_Fragment(Inp_File1)	#Gets String_List
	Fragment2 = Import_Fragment(Inp_File2)

	New_File_String = ""	#String which will contain new file data

	#Testing same number of rows is in both (Terminates if not)
	if len(Fragment1) != len(Fragment2):
		Error_Message = "Merge_Fragment_Files Could not merge " + Inp_File1 +" and "+ Inp_File2
		Error_Message = Error_Message + "\n len(file1) = " + str(len(Fragment1)) + "while len(file2) = " + str(len(Fragment2))
		sys.exit(Error_Message)	

	#Deleting TDOS column and Energy column off second file
	line_num = 0
	for line in Fragment2:
		tstring = line.split(',')	
		Fragment2[line_num] = ','.join(tstring[2:])
		line_num +=1

        #Combining the two
	for i in range(0,len(Fragment1)):
		New_File_String = New_File_String + (Fragment1[i] + "," + Fragment2[i] + "\n")	

	#get 1 extra line in the file,this deletes the extra line
	temp_string=New_File_String.split('\n')
	temp_string=temp_string[0:-1]	#POSSIBLE ERROR-I HAVE NO IDEA WHY THIS IS NECCESARY
	New_File_String = '\n'.join(temp_string)	
	#print New_File_String	

	#Saving to file
	#Output_Name = Inp_File1.replace("MLinp.txt","mMLinp.txt")
	Output_Name = Inp_File1.replace("MLinpt.txt","MLinpt.txt")	#better since it allows iteration
	fobject = open(Output_Name,"w")
	fobject.write(New_File_String)
	fobject.close()
	

Main()



