function [ X_Section hv_used ] = Get_X_Section( Label,hv,High_Ang_Arg )

dbstop if error

%Takes a label (e.g 3S) and photon energy and returns a cross section
    %Cross sections come from a library (the folder location is defined by 
    %Lib_Path variable). The hv used is determined by picking the value
    %closest to a known cross section (e.g hv=401.12 will likely return 
    %hv used of 400 eV). The High_Ang_Arg is used to use p cross sections
    %for polarisation functions for elements in which cross sections have
    %not been calculated (e.g using the C2p cross sections for C2d

%Label - 'S3S' or 'C2D' or 'N2P' or 'Bi3S, basically the element label
%        followed by the shell, followed by the sub-shell
%hv - Photon energy you want the X-Section at. Will use the closest number
%      available
%High_Ang_Arg - Set to 1 to replace D+ angular momentum orbitals (e.g F/G) 
%               with P orbitals X-Section (Used for elements like carbon
%               where no d cross-sections have been calculated). OPTIONAL
%               ARGUMENT (default val=0)

%NOTE:the cross-sections i use in my library are from:
%https://vuo.elettra.eu/services/elements/WebElements.html
%Which gets them from:
%This periodic table interface was developed to easily acces the calculated atomic cross sections for photoionization
%and the related asymmetry parameters. The data are taken from: J.J. Yeh, Atomic Calculation of Photoionization Cross-Sections
%and Asymmetry Parameters, Gordon and Breach Science Publishers, Langhorne, PE (USA), 1993 and from J.J. Yeh and I.Lindau,
%Atomic Data and Nuclear Data Tables, 32, 1-155 (1985). The data shown here are those calculated in the dipole length approximation.

%IMPORTANT GLOBAL VARIABLES HERE
Lib_Path='C:\Users\Richard\Documents\X_Section_Library'  %Folder in which your X_Section library is located
if nargin()==2 ; %Set default value for the optional argument
    High_Ang_Arg=0
end
replacement_orb='P'; %If High_Ang_Arg = 1 this determines what x-section you use for d+ orbitals
    
%repl_orb = type of basis function you want to replace with.
%P=replace with p=type,%S=replace with s type
    function [Label] = Replace_High_Ang_Mom(Label,repl_orb)
        switch Label
            case {'B2D','B2F','B2G'}
                Label = strcat('B2',repl_orb);
            case {'C2D','C2F','C2G'}
                Label = strcat('C2',repl_orb);
             case {'C2D','C2F','C2G'}
                Label = strcat('C2',repl_orb);
            case {'N2D','N2F','N2G'}
                Label = strcat('N2',repl_orb);
            case {'O2D','O2F','O2G'}
                Label = strcat('O2',repl_orb);
            case {'F2D','F2F','F2G'}
                Label = strcat('F2',repl_orb);
            case {'P3D','P3F','P3G'}
                Label = strcat('P3',repl_orb);
            case {'S3D','S3F','S3G'}
                Label = strcat('S3',repl_orb);
            case {'CL3D','CL3F','CL3G'}
                Label = strcat('CL3',repl_orb);
        end
    end


%When given folder(Path var) and filename (w/o the .txt extension) imports
%the cross-sections file into a 2 column matrix (col 1 =hv,col 2=
%X_Section)
    function [X_Sections] = Import_Lib_File(Path,Filename)
      %  Full_Path = strcat(Path,'\',Filename,'.txt');
        Full_Path = fullfile(Path,[Filename,'.txt']);
        X_Sections = dlmread(Full_Path);
    end


    function Main()
        if High_Ang_Arg==1
            Label = Replace_High_Ang_Mom(Label,replacement_orb);
        end
        X_Sections = Import_Lib_File(Lib_Path,Label);
        [val loc]=min(abs(X_Sections(:,1)-hv))  %Finds index of closest hv to the val passed to the function
        X_Section = X_Sections(loc,2);
        hv_used = X_Sections(loc,1);
    end


Main()















end

