/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Reader;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.Eval;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Frame;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.StyleManager;
import org.jmol.viewer.TempManager;
import org.jmol.viewer.TransformManager;

public class Viewer
extends JmolViewer {
    Component awtComponent;
    ColorManager colorManager;
    PropertyManager propertyManager;
    StatusManager statusManager;
    TransformManager transformManager;
    SelectionManager selectionManager;
    MouseManager mouseManager;
    FileManager fileManager;
    ModelManager modelManager;
    RepaintManager repaintManager;
    StyleManager styleManager;
    TempManager tempManager;
    PickingManager pickingManager;
    Eval eval;
    Graphics3D g3d;
    JmolAdapter modelAdapter;
    String strJavaVendor;
    String strJavaVersion;
    String strOSName;
    Hashtable appletInfo;
    String htmlName = "";
    boolean jvm11orGreater = false;
    boolean jvm12orGreater = false;
    boolean jvm14orGreater = false;
    final Hashtable imageCache = new Hashtable();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    public static final int MAXIMUM_ZOOM = 200;
    public static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    final Rectangle rectClip = new Rectangle();
    boolean enableFullSceneAntialiasing = false;
    char inlineNewlineChar = (char)124;
    int motionEventNumber;
    boolean wasInMotion = false;
    int iscript = 0;
    String defaultLoadScript = "";
    int hoverAtomIndex = -1;
    boolean rasmolHydrogenSetting = true;
    boolean rasmolHeteroSetting = true;
    boolean debugScript = false;
    boolean rangeSelected = false;
    boolean windowCenteredFlag = true;
    boolean adjustCameraFlag = true;
    boolean allowCameraMoveFlag = true;
    float solventProbeRadius = 1.2f;
    boolean solventOn = false;
    boolean testFlag1;
    boolean testFlag2;
    boolean testFlag3;
    boolean testFlag4;
    private int axesMode = 0;
    private boolean displayCellParameters = true;
    boolean selectionHaloEnabled = false;
    private boolean bondSelectionModeOr;
    boolean chainCaseSensitive = false;
    boolean ribbonBorder = false;
    boolean hideNameInPopup = false;
    boolean greyscaleRendering;
    boolean labelsFrontFlag;
    boolean disablePopupMenu;
    final AtomIterator nullAtomIterator = new NullAtomIterator();
    final BondIterator nullBondIterator = new NullBondIterator();
    boolean measureAllModels = false;
    boolean isTainted = true;
    int pickingSpinRate = 10;
    Point3f ptDefaultLattice = new Point3f();

    Viewer(Component awtComponent, JmolAdapter modelAdapter) {
        this.awtComponent = awtComponent;
        this.modelAdapter = modelAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        Logger.info("(C) 2006 Jmol Development\nJmol Version " + this.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName);
        Logger.info(this.htmlName + " jvm11orGreater=" + this.jvm11orGreater + "\njvm12orGreater=" + this.jvm12orGreater + "\njvm14orGreater=" + this.jvm14orGreater);
        this.g3d = new Graphics3D(awtComponent);
        this.statusManager = new StatusManager(this);
        this.colorManager = new ColorManager(this, this.g3d);
        this.transformManager = new TransformManager(this);
        this.selectionManager = new SelectionManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(awtComponent, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(awtComponent, this) : new MouseManager10(awtComponent, this));
        this.fileManager = new FileManager(this, modelAdapter);
        this.repaintManager = new RepaintManager(this);
        this.modelManager = new ModelManager(this, modelAdapter);
        this.styleManager = new StyleManager(this);
        this.propertyManager = new PropertyManager(this);
        this.tempManager = new TempManager(this);
        this.pickingManager = new PickingManager(this);
    }

    public static JmolViewer allocateViewer(Component awtComponent, JmolAdapter modelAdapter) {
        return new Viewer(awtComponent, modelAdapter);
    }

    public Component getAwtComponent() {
        return this.awtComponent;
    }

    public boolean handleOldJvm10Event(Event e) {
        return this.mouseManager.handleOldJvm10Event(e);
    }

    public void homePosition() {
        this.setCenter(null);
        this.transformManager.homePosition();
        if (this.modelManager.modelsHaveSymmetry()) {
            this.styleManager.setCrystallographicDefaults();
        }
        this.refresh(1, "Viewer:homePosition()");
    }

    void flushCachedImages() {
        this.imageCache.clear();
        this.colorManager.flushCachedColors();
    }

    Hashtable getAppletInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        info.put("htmlName", this.htmlName);
        info.put("version", "10.x.28 (branch bob200603/11.0 beta)");
        info.put("date", JmolConstants.date);
        info.put("javaVendor", this.strJavaVendor);
        info.put("javaVersion", this.strJavaVersion);
        info.put("operatingSystem", this.strOSName);
        return info;
    }

    int getShapeVisibilityFlag(int shapeID) {
        return 2 << shapeID;
    }

    String getJmolVersion() {
        return "10.x.28 (branch bob200603/11.0 beta)  " + JmolConstants.date;
    }

    void move(Vector3f dRot, int dZoom, Vector3f dTrans, int dSlab, float floatSecondsTotal, int fps) {
        this.transformManager.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
    }

    public void moveTo(float floatSecondsTotal, Point3f pt, float degrees, int zoom, int xTrans, int yTrans) {
        this.transformManager.moveTo(floatSecondsTotal, pt, degrees, zoom, xTrans, yTrans);
    }

    String getMoveToText(float timespan) {
        return this.transformManager.getMoveToText(timespan);
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.transformManager.rotateXYBy(xDelta, yDelta);
        this.refresh(1, "Viewer:rotateXYBy()");
    }

    void rotateZBy(int zDelta) {
        this.transformManager.rotateZBy(zDelta);
        this.refresh(1, "Viewer:rotateZBy()");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
    }

    public void rotateToX(float angleRadians) {
        this.transformManager.rotateToX(angleRadians);
    }

    public void rotateToY(float angleRadians) {
        this.transformManager.rotateToY(angleRadians);
    }

    public void rotateToZ(float angleRadians) {
        this.transformManager.rotateToZ(angleRadians);
    }

    public void rotateToX(int angleDegrees) {
        this.rotateToX((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateToY(int angleDegrees) {
        this.rotateToY((float)angleDegrees * ((float)Math.PI / 180));
    }

    void rotateToZ(int angleDegrees) {
        this.rotateToZ((float)angleDegrees * ((float)Math.PI / 180));
    }

    void rotateXRadians(float angleRadians) {
        this.transformManager.rotateXRadians(angleRadians);
        this.refresh(1, "Viewer:rotateXRadians()");
    }

    void rotateYRadians(float angleRadians) {
        this.transformManager.rotateYRadians(angleRadians);
        this.refresh(1, "Viewer:rotateYRadians()");
    }

    void rotateZRadians(float angleRadians) {
        this.transformManager.rotateZRadians(angleRadians);
        this.refresh(1, "Viewer:rotateZRadians()");
    }

    void rotateXDegrees(float angleDegrees) {
        this.rotateXRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotateYDegrees(float angleDegrees) {
        this.rotateYRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotateZDegrees(float angleDegrees) {
        this.rotateZRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotate(AxisAngle4f axisAngle) {
        this.transformManager.rotateAxisAngle(axisAngle);
    }

    void rotateTo(float xAxis, float yAxis, float zAxis, float degrees) {
        this.transformManager.rotateTo(xAxis, yAxis, zAxis, degrees);
    }

    void rotateTo(AxisAngle4f axisAngle) {
        this.transformManager.rotateTo(axisAngle);
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.transformManager.translateXYBy(xDelta, yDelta);
        this.refresh(1, "Viewer:translateXYBy()");
    }

    void translateToXPercent(float percent) {
        this.transformManager.translateToXPercent(percent);
        this.refresh(1, "Viewer:translateToXPercent()");
    }

    void translateToYPercent(float percent) {
        this.transformManager.translateToYPercent(percent);
        this.refresh(1, "Viewer:translateToYPercent()");
    }

    void translateToZPercent(float percent) {
        this.transformManager.translateToZPercent(percent);
        this.refresh(1, "Viewer:translateToZPercent()");
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    void translateByXPercent(float percent) {
        this.translateToXPercent(this.getTranslationXPercent() + percent);
    }

    void translateByYPercent(float percent) {
        this.translateToYPercent(this.getTranslationYPercent() + percent);
    }

    void translateByZPercent(float percent) {
        this.translateToZPercent(this.getTranslationZPercent() + percent);
    }

    void translateCenterTo(int x, int y) {
        this.transformManager.translateCenterTo(x, y);
    }

    void zoomBy(int pixels) {
        this.transformManager.zoomBy(pixels);
        this.refresh(1, "Viewer:zoomBy()");
    }

    public int getZoomPercent() {
        return this.transformManager.zoomPercent;
    }

    int getZoomPercentSetting() {
        return this.transformManager.zoomPercentSetting;
    }

    void zoomToPercent(int percent) {
        this.transformManager.zoomToPercent(percent);
        this.refresh(1, "Viewer:zoomToPercent()");
    }

    void zoomByPercent(int percent) {
        this.transformManager.zoomByPercent(percent);
        this.refresh(1, "Viewer:zoomByPercent()");
    }

    void setZoomEnabled(boolean zoomEnabled) {
        this.transformManager.setZoomEnabled(zoomEnabled);
        this.refresh(1, "Viewer:setZoomEnabled()");
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    int getSlabPercentSetting() {
        return this.transformManager.slabPercentSetting;
    }

    void slabByPixels(int pixels) {
        this.transformManager.slabByPercentagePoints(pixels);
        this.refresh(0, "Viewer:slabByPixels()");
    }

    void depthByPixels(int pixels) {
        this.transformManager.depthByPercentagePoints(pixels);
        this.refresh(0, "Viewer:depthByPixels()");
    }

    void slabDepthByPixels(int pixels) {
        this.transformManager.slabDepthByPercentagePoints(pixels);
        this.refresh(0, "Viewer:slabDepthByPixels()");
    }

    void slabToPercent(int percentSlab) {
        this.transformManager.slabToPercent(percentSlab);
        this.refresh(0, "Viewer:slabToPercent()");
    }

    void depthToPercent(int percentDepth) {
        this.transformManager.depthToPercent(percentDepth);
        this.refresh(0, "Viewer:depthToPercent()");
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.transformManager.setSlabEnabled(slabEnabled);
        this.refresh(0, "Viewer:setSlabEnabled()");
    }

    void setModeSlab(int modeSlab) {
        this.transformManager.setModeSlab(modeSlab);
        this.refresh(0, "Viewer:setModeSlab()");
    }

    int getModeSlab() {
        return this.transformManager.modeSlab;
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
    }

    Point3i transformPoint(Point3f pointAngstroms) {
        return this.transformManager.transformPoint(pointAngstroms);
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        return this.transformManager.transformPoint(pointAngstroms, vibrationVector);
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, vibrationVector, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3f pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoints(Point3f[] pointsAngstroms, Point3i[] pointsScreens) {
        this.transformManager.transformPoints(pointsAngstroms.length, pointsAngstroms, pointsScreens);
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.transformManager.transformVector(vectorAngstroms, vectorTransformed);
    }

    float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        return this.transformManager.scaleToScreen(z, sizeAngstroms);
    }

    short scaleToScreen(int z, int milliAngstroms) {
        return this.transformManager.scaleToScreen(z, milliAngstroms);
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.transformManager.scaleToPerspective(z, sizeAngstroms);
    }

    void scaleFitToScreen() {
        this.transformManager.scaleFitToScreen();
    }

    boolean areAxesTainted() {
        boolean TF = this.axesAreTainted;
        this.axesAreTainted = false;
        return TF;
    }

    void setCrystallographicDefaults() {
        this.styleManager.setCrystallographicDefaults();
    }

    void checkCameraDistance() {
        if (!this.allowCameraMove()) {
            return;
        }
        if (this.transformManager.getIncreaseRotationRadius()) {
            this.modelManager.increaseRotationRadius(this.transformManager.getRotationRadiusIncrease());
        }
    }

    public void setScreenDimension(Dimension dim) {
        int height = dim.height;
        int width = dim.width;
        if (this.getStereoMode() == 1) {
            width = (width + 1) / 2;
        }
        if (this.dimScreen.width == width && this.dimScreen.height == height) {
            return;
        }
        this.dimScreen.width = width;
        this.dimScreen.height = height;
        this.transformManager.setScreenDimension(width, height);
        this.transformManager.scaleFitToScreen();
        this.g3d.setWindowSize(width, height, this.enableFullSceneAntialiasing);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    void setRectClip(Rectangle clip) {
        if (clip == null) {
            this.rectClip.y = 0;
            this.rectClip.x = 0;
            this.rectClip.setSize(this.dimScreen);
        } else {
            this.rectClip.setBounds(clip);
            if (this.rectClip.x < 0) {
                this.rectClip.x = 0;
            }
            if (this.rectClip.y < 0) {
                this.rectClip.y = 0;
            }
            if (this.rectClip.x + this.rectClip.width > this.dimScreen.width) {
                this.rectClip.width = this.dimScreen.width - this.rectClip.x;
            }
            if (this.rectClip.y + this.rectClip.height > this.dimScreen.height) {
                this.rectClip.height = this.dimScreen.height - this.rectClip.y;
            }
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.transformManager.setScaleAngstromsPerInch(angstromsPerInch);
    }

    void setSlabAndDepthValues(int slabValue, int depthValue) {
        this.g3d.setSlabAndDepthValues(slabValue, depthValue);
    }

    public void setVibrationPeriod(float period) {
        this.transformManager.setVibrationPeriod(period);
    }

    void setVibrationT(float t) {
        this.transformManager.setVibrationT(t);
    }

    float getVibrationRadians() {
        return this.transformManager.vibrationRadians;
    }

    void setSpinX(int value) {
        this.transformManager.setSpinX(value);
    }

    float getSpinX() {
        return this.transformManager.spinX;
    }

    void setSpinY(int value) {
        this.transformManager.setSpinY(value);
    }

    float getSpinY() {
        return this.transformManager.spinY;
    }

    void setSpinZ(int value) {
        this.transformManager.setSpinZ(value);
    }

    float getSpinZ() {
        return this.transformManager.spinZ;
    }

    void setSpinFps(int value) {
        this.transformManager.setSpinFps(value);
    }

    float getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean spinOn) {
        this.transformManager.setSpinOn(spinOn);
    }

    boolean getSpinOn() {
        return this.transformManager.spinOn;
    }

    String getOrientationText() {
        return this.transformManager.getOrientationText();
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        this.transformManager.getAxisAngle(axisAngle);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void setRotation(Matrix3f matrixRotation) {
        this.transformManager.setRotation(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        this.transformManager.getRotation(matrixRotation);
    }

    void setDefaultColors(String colorScheme) {
        this.colorManager.setDefaultColors(colorScheme);
    }

    public void setSelectionArgb(int argb) {
        this.colorManager.setSelectionArgb(argb);
        this.refresh(0, "Viewer:setSelectionArgb()");
    }

    int getColixArgb(short colix) {
        return this.g3d.getColixArgb(colix);
    }

    short getColixSelection() {
        return this.colorManager.getColixSelection();
    }

    void setRubberbandArgb(int argb) {
        this.colorManager.setRubberbandArgb(argb);
    }

    short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int elementNumber, int argb) {
        this.colorManager.setElementArgb(elementNumber, argb);
    }

    float getVectorScale() {
        return this.transformManager.vectorScale;
    }

    public void setVectorScale(float scale) {
        this.transformManager.setVectorScale(scale);
    }

    public void setVibrationScale(float scale) {
        this.transformManager.setVibrationScale(scale);
    }

    float getVibrationScale() {
        return this.transformManager.vibrationScale;
    }

    public void setBackgroundArgb(int argb) {
        this.colorManager.setBackgroundArgb(argb);
        this.refresh(0, "Viewer:setBackgroundArgb()");
    }

    public int getBackgroundArgb() {
        return this.colorManager.argbBackground;
    }

    public void setColorBackground(String colorName) {
        this.colorManager.setColorBackground(colorName);
        this.refresh(0, "Viewer:setColorBackground()");
    }

    short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    int getArgbFromString(String colorName) {
        return Graphics3D.getArgbFromString(colorName);
    }

    void setSpecular(boolean specular) {
        this.colorManager.setSpecular(specular);
    }

    boolean getSpecular() {
        return this.colorManager.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.colorManager.setSpecularPower(specularPower);
    }

    void setAmbientPercent(int ambientPercent) {
        this.colorManager.setAmbientPercent(ambientPercent);
    }

    void setDiffusePercent(int diffusePercent) {
        this.colorManager.setDiffusePercent(diffusePercent);
    }

    void setSpecularPercent(int specularPercent) {
        this.colorManager.setSpecularPercent(specularPercent);
    }

    void setLightsourceZ(float z) {
        this.colorManager.setLightsourceZ(z);
    }

    short getColixAtom(Atom atom) {
        return this.colorManager.getColixAtom(atom);
    }

    short getColixAtomPalette(Atom atom, String palette) {
        return this.colorManager.getColixAtomPalette(atom, palette);
    }

    short getColixHbondType(short order) {
        return this.colorManager.getColixHbondType(order);
    }

    short getColixFromPalette(float val, float rangeMin, float rangeMax, String palette) {
        return this.colorManager.getColixFromPalette(val, rangeMin, rangeMax, palette);
    }

    void removeSelection(int atomIndex) {
        this.selectionManager.removeSelection(atomIndex);
        this.refresh(0, "Viewer:removeSelection()");
    }

    void removeSelection(BitSet set) {
        this.selectionManager.removeSelection(set);
        this.refresh(0, "Viewer:removeSelection()");
    }

    void select(BitSet bs) {
        this.selectionManager.select(bs);
        this.reportSelection("" + this.getSelectionCount() + " atoms selected");
    }

    void addSelection(int atomIndex) {
        this.selectionManager.addSelection(atomIndex);
        this.refresh(0, "Viewer:addSelection()");
    }

    void addSelection(BitSet set) {
        this.selectionManager.addSelection(set);
        this.refresh(0, "Viewer:addSelection()");
    }

    void toggleSelection(int atomIndex) {
        this.selectionManager.toggleSelection(atomIndex);
        this.refresh(0, "Viewer:toggleSelection()");
    }

    void setSelection(int atomIndex) {
        this.selectionManager.setSelection(atomIndex);
        this.refresh(0, "Viewer:setSelection()");
    }

    boolean isSelected(int atomIndex) {
        return this.selectionManager.isSelected(atomIndex);
    }

    void reportSelection(String msg) {
        if (this.selectionHaloEnabled) {
            this.setTainted(true);
        }
        this.scriptStatus(msg);
    }

    boolean hasSelectionHalo(int atomIndex) {
        return this.selectionHaloEnabled && this.selectionManager.isSelected(atomIndex);
    }

    public void selectAll() {
        this.selectionManager.selectAll();
        this.refresh(0, "Viewer:selectAll()");
    }

    public void clearSelection() {
        this.selectionManager.clearSelection();
        this.refresh(0, "Viewer:clearSelection()");
    }

    public void setSelectionSet(BitSet set) {
        this.selectionManager.setSelectionSet(set);
        this.refresh(0, "Viewer:setSelectionSet()");
    }

    void toggleSelectionSet(BitSet set) {
        this.selectionManager.toggleSelectionSet(set);
        this.refresh(0, "Viewer:toggleSelectionSet()");
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    void excludeSelectionSet(BitSet set) {
        this.selectionManager.excludeSelectionSet(set);
    }

    BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public void addSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    public void removeSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    BitSet getAtomBitSet(String atomExpression) {
        return this.selectionManager.getAtomBitSet(atomExpression);
    }

    int firstAtomOf(BitSet bs) {
        return this.modelManager.firstAtomOf(bs);
    }

    Point3f getAtomSetCenter(BitSet bs) {
        return this.modelManager.getAtomSetCenter(bs);
    }

    Vector getAtomBitSetVector(String atomExpression) {
        return this.selectionManager.getAtomBitSetVector(atomExpression);
    }

    public void setModeMouse(int modeMouse) {
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    public void setAppletContext(String htmlName, URL documentBase, URL codeBase, String appletProxy) {
        this.htmlName = htmlName;
        this.fileManager.setAppletContext(documentBase, codeBase, appletProxy);
    }

    Object getInputStreamOrErrorMessageFromName(String name) {
        return this.fileManager.getInputStreamOrErrorMessageFromName(name);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name) {
        return this.fileManager.getUnzippedBufferedReaderOrErrorMessageFromName(name);
    }

    Object getBufferedReaderForString(String string) {
        return this.fileManager.getBufferedReaderForString(string);
    }

    public void openFile(String name) {
        this.openFile(name, null);
    }

    public void openFile(String name, int[] params) {
        this.clear();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFile(name, params);
        long ms = System.currentTimeMillis() - timeBegin;
        this.setStatusFileLoaded(1, name, "", this.modelManager.getModelSetName(), null, null);
        String sp = "";
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sp = sp + "," + params[i];
            }
        }
        Logger.info("openFile(" + name + sp + ")" + ms + " ms");
    }

    public void openFiles(String modelName, String[] names) {
        this.clear();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFiles(modelName, names);
        long ms = System.currentTimeMillis() - timeBegin;
        for (int i = 0; i < names.length; ++i) {
            this.setStatusFileLoaded(1, names[i], "", this.modelManager.getModelSetName(), null, null);
        }
        Logger.info("openFiles(" + names.length + ") " + ms + " ms");
    }

    public void openStringInline(String strModel) {
        this.clear();
        this.fileManager.openStringInline(strModel);
        this.setStatusFileLoaded(1, "string", "", this.modelManager.getModelSetName(), null, this.getOpenFileError());
    }

    public void openStringInline(String strModel, int[] params) {
        this.clear();
        this.fileManager.openStringInline(strModel, params);
        this.setStatusFileLoaded(1, "string", "", this.modelManager.getModelSetName(), null, this.getOpenFileError());
    }

    public String getInlineData() {
        return this.fileManager.inlineData;
    }

    public void loadInline(String strModel) {
        if (strModel == null) {
            return;
        }
        if (this.inlineNewlineChar != '\u0000') {
            int i;
            int len = strModel.length();
            for (i = 0; i < len && strModel.charAt(0) == ' '; ++i) {
            }
            if (i < len && strModel.charAt(i) == this.inlineNewlineChar) {
                strModel = strModel.substring(i + 1);
            }
            strModel = strModel.replace(this.inlineNewlineChar, '\n');
        }
        int[] A = new int[4];
        A[1] = (int)this.ptDefaultLattice.x;
        A[2] = (int)this.ptDefaultLattice.y;
        A[3] = (int)this.ptDefaultLattice.z;
        this.openStringInline(strModel, A);
    }

    public void openDOM(Object DOMNode) {
        this.clear();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openDOM(DOMNode);
        long ms = System.currentTimeMillis() - timeBegin;
        Logger.info("openDOM " + ms + " ms");
        this.setStatusFileLoaded(1, "JSNode", "", this.modelManager.getModelSetName(), null, this.getOpenFileError());
    }

    public void openReader(String fullPathName, String name, Reader reader) {
        this.clear();
        this.fileManager.openReader(fullPathName, name, reader);
        this.getOpenFileError();
    }

    public String getOpenFileError() {
        String errorMsg = this.getOpenFileError1();
        return errorMsg;
    }

    String getOpenFileError1() {
        String fullPathName = this.getFullPathName();
        String fileName = this.fileManager.getFileName();
        Object clientFile = this.fileManager.waitForClientFileOrErrorMessage();
        if (clientFile instanceof String || clientFile == null) {
            String errorMsg = (String)clientFile;
            this.setStatusFileNotLoaded(fullPathName, errorMsg);
            return errorMsg;
        }
        this.openClientFile(fullPathName, fileName, clientFile);
        return null;
    }

    public String getCurrentFileAsString() {
        if (this.getFullPathName() == "string") {
            return this.fileManager.inlineData;
        }
        if (this.getFullPathName() == "JSNode") {
            return "<DOM NODE>";
        }
        String pathName = this.modelManager.getModelSetPathName();
        if (pathName == null) {
            return null;
        }
        return this.fileManager.getFileAsString(pathName);
    }

    public String getFileAsString(String pathName) {
        return this.fileManager.getFileAsString(pathName);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public void openClientFile(String fullPathName, String fileName, Object clientFile) {
        this.setStatusFileLoaded(2, fullPathName, fileName, this.modelManager.getModelSetName(), clientFile, null);
        this.pushHoldRepaint();
        this.modelManager.setClientFile(fullPathName, fileName, clientFile);
        this.homePosition();
        this.selectAll();
        this.setCenter(this.getRotationCenter());
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        if (this.modelManager.hasVibrationVectors()) {
            this.setShapeSize(5, this.styleManager.defaultVectorMad);
        }
        this.setFrankOn(this.styleManager.frankOn);
        this.repaintManager.initializePointers(1);
        this.setDisplayModelIndex(0);
        this.setTainted(true);
        this.popHoldRepaint();
        this.setStatusFileLoaded(3, fullPathName, fileName, this.modelManager.getModelSetName(), clientFile, null);
    }

    void clear() {
        this.repaintManager.clearAnimation();
        this.transformManager.clearVibration();
        this.transformManager.clearSpin();
        this.modelManager.setClientFile(null, null, null);
        this.selectionManager.clearSelection();
        this.clearMeasurements();
        this.setWindowCentered(true);
        this.transformManager.setFixedRotationCenter(new Point3f(0.0f, 0.0f, 0.0f));
        this.setStatusFileLoaded(0, null, null, null, null, null);
        this.refresh(0, "Viewer:clear()");
    }

    public String getModelSetName() {
        return this.modelManager.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getModelSetProperty(String strProp) {
        return this.modelManager.getModelSetProperty(strProp);
    }

    public Object getModelSetAuxiliaryInfo(String strKey) {
        return this.modelManager.getModelSetAuxiliaryInfo(strKey);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelManager.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.modelManager.frame != null;
    }

    void clearBfactorRange() {
        this.modelManager.clearBfactorRange();
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoType, boolean hybridizationCompatible) {
        return this.modelManager.getPrincipalAxes(atomIndex, z, x, lcaoType, hybridizationCompatible);
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        return this.modelManager.getModelAtomBitSet(modelIndex);
    }

    BitSet getModelBitSet(BitSet atomList) {
        return this.modelManager.getModelBitSet(atomList);
    }

    Object getClientFile() {
        return null;
    }

    String getClientAtomStringProperty(Object clientAtomReference, String propertyName) {
        return this.modelManager.getClientAtomStringProperty(clientAtomReference, propertyName);
    }

    JmolAdapter getExportJmolAdapter() {
        return this.modelManager.getExportJmolAdapter();
    }

    public Frame getFrame() {
        return this.modelManager.getFrame();
    }

    public float getRotationRadius() {
        return this.modelManager.getRotationRadius();
    }

    Point3f getRotationCenter() {
        return this.modelManager.getRotationCenter();
    }

    Point3f getRotationCenterDefault() {
        return this.modelManager.getRotationCenterDefault();
    }

    Point3f getBoundBoxCenter() {
        return this.modelManager.getBoundBoxCenter();
    }

    Vector3f getBoundBoxCornerVector() {
        return this.modelManager.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelManager.getBoundBoxInfo();
    }

    int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelManager.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelManager.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelManager.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelManager.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelManager.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int modelIndex) {
        return this.modelManager.getModelNumber(modelIndex);
    }

    public String getModelName(int modelIndex) {
        return this.modelManager.getModelName(modelIndex);
    }

    public Properties getModelProperties(int modelIndex) {
        return this.modelManager.getModelProperties(modelIndex);
    }

    public String getModelProperty(int modelIndex, String propertyName) {
        return this.modelManager.getModelProperty(modelIndex, propertyName);
    }

    public Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.modelManager.getModelAuxiliaryInfo(modelIndex);
    }

    public Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.modelManager.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.modelManager.getModelNumberIndex(modelNumber);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelManager.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        return this.modelManager.modelHasVibrationVectors(modelIndex);
    }

    public int getChainCount() {
        return this.modelManager.getChainCount();
    }

    public int getGroupCount() {
        return this.modelManager.getGroupCount();
    }

    public int getPolymerCount() {
        return this.modelManager.getPolymerCount();
    }

    public int getPolymerCountInModel(int modelIndex) {
        return this.modelManager.getPolymerCountInModel(modelIndex);
    }

    public int getAtomCount() {
        return this.modelManager.getAtomCount();
    }

    public int getBondCount() {
        return this.modelManager.getBondCount();
    }

    boolean frankClicked(int x, int y) {
        return this.modelManager.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        return this.modelManager.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubberBand) {
        return this.modelManager.findAtomsInRectangle(rectRubberBand);
    }

    void convertFractionalCoordinates(Point3f pt) {
        this.modelManager.convertFractionalCoordinates(this.getDisplayModelIndex(), pt);
    }

    Point3f getCenter() {
        return this.modelManager.getRotationCenter();
    }

    void setCenterFromInternalRotation(Point3f center) {
        this.modelManager.setRotationCenterAndRadiusXYZ(center, false);
    }

    void setCenter(Point3f center) {
        if ((center = this.modelManager.setRotationCenterAndRadiusXYZ(center, true)) != null) {
            this.transformManager.setFixedRotationCenter(center);
        }
        this.refresh(0, "Viewer:setCenter()");
    }

    void setCenter(String relativeTo, Point3f pt) {
        Point3f center = this.modelManager.setRotationCenterAndRadiusXYZ(relativeTo, pt);
        this.scaleFitToScreen();
        if (center != null) {
            this.transformManager.setFixedRotationCenter(center);
        }
        this.refresh(0, "Viewer:setCenter(" + relativeTo + ")");
    }

    void setCenterBitSet(BitSet bsCenter, boolean doScale) {
        Point3f center = this.modelManager.setCenterBitSet(bsCenter, doScale);
        this.transformManager.setFixedRotationCenter(center);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    public void setNewRotationCenter(String axisID) {
        Point3f center = this.getDrawObjectCenter(axisID);
        if (center == null) {
            return;
        }
        this.setNewRotationCenter(center);
    }

    public void setNewRotationCenter(Point3f center) {
        this.modelManager.setNewRotationCenter(center, true);
        this.transformManager.setFixedRotationCenter(center);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    void moveRotationCenter(Point3f center) {
        center = this.modelManager.setRotationCenterAndRadiusXYZ(center, false);
        this.transformManager.setFixedRotationCenter(center);
        this.transformManager.setRotationPointXY(center);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection, true);
    }

    public void rebond() {
        this.modelManager.rebond();
        this.refresh(0, "Viewer:rebond()");
    }

    public void setBondTolerance(float bondTolerance) {
        this.modelManager.setBondTolerance(bondTolerance);
        this.refresh(0, "Viewer:setBOndTolerance()");
    }

    public float getBondTolerance() {
        return this.modelManager.bondTolerance;
    }

    public void setMinBondDistance(float minBondDistance) {
        this.modelManager.setMinBondDistance(minBondDistance);
        this.refresh(0, "Viewer:setMinBondDistance()");
    }

    public float getMinBondDistance() {
        return this.modelManager.minBondDistance;
    }

    BitSet getAtomBits(String setType) {
        return this.modelManager.getAtomBits(setType);
    }

    BitSet getAtomBits(String setType, String specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomsWithin(String withinWhat, BitSet bs) {
        return this.modelManager.getAtomsWithin(withinWhat, bs);
    }

    BitSet getAtomsWithin(float distance, BitSet bs) {
        return this.modelManager.getAtomsWithin(distance, bs);
    }

    BitSet getAtomsConnected(float min, float max, BitSet bs) {
        return this.modelManager.getAtomsConnected(min, max, bs);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.modelManager.getAtomIndexFromAtomNumber(atomNumber);
    }

    public BitSet getElementsPresentBitSet() {
        return this.modelManager.getElementsPresentBitSet();
    }

    BitSet getVisibleSet() {
        return this.modelManager.getVisibleSet();
    }

    public BitSet getGroupsPresentBitSet() {
        return this.modelManager.getGroupsPresentBitSet();
    }

    void calcSelectedGroupsCount() {
        this.modelManager.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelManager.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelManager.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelManager.getFileHeader();
    }

    String getPDBHeader() {
        return this.modelManager.getPDBHeader();
    }

    public Hashtable getModelInfo() {
        return this.modelManager.getModelInfo();
    }

    public Hashtable getAuxiliaryInfo() {
        return this.modelManager.getAuxiliaryInfo();
    }

    public Hashtable getShapeInfo() {
        return this.modelManager.getShapeInfo();
    }

    int getShapeIdFromObjectName(String objectName) {
        return this.modelManager.getShapeIdFromObjectName(objectName);
    }

    Vector getAllAtomInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllAtomInfo(bs);
    }

    Vector getAllBondInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllBondInfo(bs);
    }

    Vector getMoleculeInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getMoleculeInfo(bs);
    }

    public Hashtable getAllChainInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllChainInfo(bs);
    }

    public Hashtable getAllPolymerInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllPolymerInfo(bs);
    }

    public Hashtable getAllStateInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllStateInfo(bs);
    }

    public BitSet setConformation() {
        return this.modelManager.setConformation(-1, this.getSelectionSet());
    }

    public BitSet setConformation(int conformationIndex) {
        return this.modelManager.setConformation(this.getDisplayModelIndex(), conformationIndex);
    }

    public void autoHbond() {
        BitSet bs = this.getSelectionSet();
        this.autoHbond(bs, bs);
    }

    public void autoHbond(BitSet bsFrom, BitSet bsTo) {
        this.modelManager.autoHbond(bsFrom, bsTo);
    }

    boolean hbondsAreVisible() {
        return this.modelManager.hbondsAreVisible(this.getDisplayModelIndex());
    }

    public void recalculateStructure(BitSet bsSelected) {
        this.modelManager.recalculateStructure(bsSelected);
    }

    public void clearMeasurements() {
        this.setShapeProperty(6, "clear", null);
        this.refresh(0, "Viewer:clearMeasurements()");
    }

    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(6, "count");
        return count <= 0 ? 0 : count;
    }

    public String getMeasurementStringValue(int i) {
        String str = "" + this.getShapeProperty(6, "stringValue", i);
        return str;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(6, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int i) {
        int[] List2 = (int[])this.getShapeProperty(6, "countPlusIndices", i);
        return List2;
    }

    void setPendingMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "pending", atomCountPlusIndices);
    }

    void defineMeasurement(Vector monitorExpressions, float[] rangeMinMax, boolean isDelete, boolean isAllConnected, boolean isShowHide, boolean isHidden) {
        this.setShapeProperty(6, "setConnected", new Boolean(isAllConnected));
        this.setShapeProperty(6, "setRange", rangeMinMax);
        this.setShapeProperty(6, isDelete ? "deleteVector" : (isShowHide ? (isHidden ? "hideVector" : "showVector") : "defineVector"), monitorExpressions);
        this.setStatusNewDefaultModeMeasurement("scripted", 1, "?");
    }

    public void deleteMeasurement(int i) {
        this.setShapeProperty(6, "delete", new Integer(i));
    }

    void deleteMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "delete", atomCountPlusIndices);
    }

    public void showMeasurement(int[] atomCountPlusIndices, boolean isON) {
        this.setShapeProperty(6, isON ? "show" : "hide", atomCountPlusIndices);
        this.refresh(0, "Viewer:clearMeasurements()");
    }

    public void hideMeasurements(boolean isOFF) {
        this.setShapeProperty(6, "hideAll", new Boolean(isOFF));
        this.refresh(0, "setShowMeasurements()");
    }

    void toggleMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "toggle", atomCountPlusIndices);
    }

    void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    void setAnimationDirection(int direction) {
        this.repaintManager.setAnimationDirection(direction);
    }

    int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.repaintManager.getAnimationInfo();
    }

    public void setAnimationFps(int fps) {
        this.repaintManager.setAnimationFps(fps);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    void setAnimationReplayMode(int replay, float firstFrameDelay, float lastFrameDelay) {
        this.repaintManager.setAnimationReplayMode(replay, firstFrameDelay, lastFrameDelay);
    }

    int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.repaintManager.animationOn;
        if (animationOn == wasAnimating) {
            return;
        }
        this.repaintManager.setAnimationOn(animationOn);
    }

    void resumeAnimation() {
        if (this.repaintManager.animationOn) {
            Logger.debug("animation is ON in resumeAnimation");
            return;
        }
        this.repaintManager.resumeAnimation();
        this.refresh(0, "Viewer:resumeAnimation()");
    }

    void pauseAnimation() {
        if (!this.repaintManager.animationOn || this.repaintManager.animationPaused) {
            return;
        }
        this.repaintManager.pauseAnimation();
        this.refresh(0, "Viewer:pauseAnimation()");
    }

    void setAnimationRange(int modelIndex1, int modelIndex2) {
        this.repaintManager.setAnimationRange(modelIndex1, modelIndex2);
    }

    BitSet getVisibleFramesBitSet() {
        return this.repaintManager.getVisibleFramesBitSet();
    }

    boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh(0, "Viewer:setAnimationNext()");
        }
    }

    void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh(0, "Viewer:setAnimationPrevious()");
        }
    }

    void rewindAnimation() {
        this.repaintManager.rewindAnimation();
        this.refresh(0, "Viewer:rewindAnimation()");
    }

    boolean setDisplayModelIndex(int modelIndex) {
        return this.repaintManager.setDisplayModelIndex(modelIndex);
    }

    public int getDisplayModelIndex() {
        return this.repaintManager.displayModelIndex;
    }

    FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean inMotion) {
        if (this.wasInMotion ^ inMotion) {
            if (inMotion) {
                ++this.motionEventNumber;
            }
            this.repaintManager.setInMotion(inMotion);
            this.wasInMotion = inMotion;
        }
    }

    boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    Image takeSnapshot() {
        return this.repaintManager.takeSnapshot();
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    public void refresh() {
        this.repaintManager.refresh();
    }

    public void refresh(int isOrientationChange, String strWhy) {
        this.repaintManager.refresh();
        this.statusManager.setStatusViewerRefreshed(isOrientationChange, strWhy);
    }

    void requestRepaintAndWait() {
        this.repaintManager.requestRepaintAndWait();
    }

    public void repaintView() {
        this.repaintManager.repaintView();
    }

    public void renderScreenImage(Graphics g, Dimension size, Rectangle clip) {
        this.manageScriptTermination();
        if (this.isTainted) {
            this.setModelVisibility();
            this.modelManager.setModelClickability();
        }
        this.isTainted = false;
        if (size != null) {
            this.setScreenDimension(size);
        }
        int stereoMode = this.getStereoMode();
        switch (stereoMode) {
            case 0: {
                this.setRectClip(clip);
                this.render1(g, this.transformManager.getStereoRotationMatrix(false), false, 0, 0);
                break;
            }
            case 1: {
                this.setRectClip(null);
                this.render1(g, this.transformManager.getStereoRotationMatrix(false), false, 0, 0);
                this.render1(g, this.transformManager.getStereoRotationMatrix(true), false, this.dimScreen.width, 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setRectClip(null);
                this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, this.transformManager.getStereoRotationMatrix(true), false);
                this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
                this.g3d.endRendering();
                this.g3d.snapshotAnaglyphChannelBytes();
                this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, this.transformManager.getStereoRotationMatrix(false), false);
                this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
                this.g3d.endRendering();
                if (stereoMode == 2) {
                    this.g3d.applyCyanAnaglyph();
                } else {
                    this.g3d.applyBlueOrGreenAnaglyph(stereoMode == 3);
                }
                Image img = this.g3d.getScreenImage();
                try {
                    g.drawImage(img, 0, 0, null);
                }
                catch (NullPointerException npe) {
                    Logger.error("Sun!! ... fix graphics your bugs!");
                }
                this.g3d.releaseScreenImage();
            }
        }
        this.repaintView();
    }

    void render1(Graphics g, Matrix3f matrixRotate, boolean antialias, int x, int y) {
        this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, matrixRotate, antialias);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        Image img = this.g3d.getScreenImage();
        try {
            g.drawImage(img, x, y, null);
        }
        catch (NullPointerException npe) {
            Logger.error("Sun!! ... fix graphics your bugs!");
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        boolean antialiasThisFrame = true;
        this.setRectClip(null);
        this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, this.transformManager.getStereoRotationMatrix(false), antialiasThisFrame);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    Eval getEval() {
        if (this.eval == null) {
            this.eval = new Eval(this);
        }
        return this.eval;
    }

    public String evalFile(String strFilename) {
        if (strFilename != null) {
            if (!this.getEval().loadScriptFile(strFilename, false)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalString(String strScript) {
        if (strScript != null) {
            if (!this.getEval().loadScriptString(strScript, false)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalStringQuiet(String strScript) {
        if (strScript != null) {
            if (!this.getEval().loadScriptString(strScript, true)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalStringWait(String strScript) {
        if (strScript == null) {
            return null;
        }
        String statusList = this.statusManager.statusList;
        this.getProperty("String", "jmolStatus", statusList);
        Eval e = new Eval(this);
        if (e.loadScriptString(strScript, false)) {
            e.runEval();
        }
        return (String)this.getProperty("JSON", "jmolStatus", statusList);
    }

    public String script(String script) {
        ++this.iscript;
        String strError = this.evalString(script);
        this.setStatusScriptStarted(this.iscript, script, strError);
        return strError;
    }

    public String scriptCheck(String script) {
        ++this.iscript;
        return this.evalString(script);
    }

    public String scriptWait(String script) {
        ++this.iscript;
        return this.evalStringWait(script);
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        if (this.eval != null) {
            this.eval.haltExecution();
        }
    }

    void setDefaultLoadScript(String script) {
        this.defaultLoadScript = script;
    }

    String getDefaultLoadScript() {
        return this.defaultLoadScript;
    }

    String getStandardLabelFormat() {
        return this.styleManager.getStandardLabelFormat();
    }

    boolean getSsbondsBackbone() {
        return this.styleManager.ssbondsBackbone;
    }

    void setHbondsBackbone(boolean hbondsBackbone) {
        this.styleManager.setHbondsBackbone(hbondsBackbone);
    }

    boolean getHbondsBackbone() {
        return this.styleManager.hbondsBackbone;
    }

    void setHbondsSolid(boolean hbondsSolid) {
        this.styleManager.setHbondsSolid(hbondsSolid);
    }

    boolean getHbondsSolid() {
        return this.styleManager.hbondsSolid;
    }

    public void setMarBond(short marBond) {
        this.styleManager.setMarBond(marBond);
        this.setShapeSize(1, marBond * 2);
    }

    void hoverOn(int atomIndex) {
        if (!(this.eval != null && this.eval.isActive() || atomIndex == this.hoverAtomIndex)) {
            this.loadShape(21);
            this.setShapeProperty(21, "target", new Integer(atomIndex));
            this.hoverAtomIndex = atomIndex;
        }
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(21, "target", null);
            this.hoverAtomIndex = -1;
        }
    }

    void setLabel(String strLabel) {
        if (strLabel != null) {
            this.setShapeSize(4, this.styleManager.pointsLabelFontSize);
        }
        this.setShapeProperty(4, "label", strLabel);
    }

    void togglePickingLabel(int atomIndex) {
        if (atomIndex != -1) {
            this.setShapeSize(4, this.styleManager.pointsLabelFontSize);
            this.modelManager.setShapeProperty(4, "pickingLabel", new Integer(atomIndex), null);
            this.refresh(0, "Viewer:");
        }
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    void setShapeShow(int shapeID, boolean show) {
        this.setShapeSize(shapeID, show ? -1 : 0);
    }

    boolean getShapeShow(int shapeID) {
        return this.getShapeSize(shapeID) != 0;
    }

    void loadShape(int shapeID) {
        this.modelManager.loadShape(shapeID);
    }

    void setShapeSize(int shapeID, int size) {
        this.setShapeSize(shapeID, size, this.selectionManager.bsSelection);
    }

    void setShapeSize(int shapeID, int size, BitSet bsAtoms) {
        this.modelManager.setShapeSize(shapeID, size, bsAtoms);
        this.refresh(0, "Viewer:setShapeSize(" + shapeID + "," + size + ")");
    }

    int getShapeSize(int shapeID) {
        return this.modelManager.getShapeSize(shapeID);
    }

    void setShapeProperty(int shapeID, String propertyName, Object value) {
        this.modelManager.setShapeProperty(shapeID, propertyName, value, this.selectionManager.bsSelection);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapeProperty(int shapeID, String propertyName, int value) {
        this.setShapeProperty(shapeID, propertyName, new Integer(value));
    }

    void setShapePropertyArgb(int shapeID, String propertyName, int argb) {
        this.setShapeProperty(shapeID, propertyName, argb == 0 ? null : new Integer(argb | 0xFF000000));
    }

    void setShapeColorProperty(int shapeType, int argb) {
        this.setShapePropertyArgb(shapeType, "color", argb);
    }

    Object getShapeProperty(int shapeType, String propertyName) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, index);
    }

    int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    int getShapeID(String shapeName) {
        int i = 29;
        while (--i >= 0) {
            if (!JmolConstants.shapeClassBases[i].equals(shapeName)) continue;
            return i;
        }
        String msg = "Unrecognized shape name:" + shapeName;
        Logger.error(msg);
        throw new NullPointerException(msg);
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    void setRasmolHydrogenSetting(boolean b) {
        this.rasmolHydrogenSetting = b;
    }

    boolean getRasmolHydrogenSetting() {
        return this.rasmolHydrogenSetting;
    }

    void setRasmolHeteroSetting(boolean b) {
        this.rasmolHeteroSetting = b;
    }

    boolean getRasmolHeteroSetting() {
        return this.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.debugScript;
    }

    public void setDebugScript(boolean debugScript) {
        this.debugScript = debugScript;
        Logger.setActiveLevel(0, debugScript);
    }

    void atomPicked(int atomIndex, boolean shiftKey, boolean altKey) {
        this.pickingManager.atomPicked(atomIndex, shiftKey, altKey);
    }

    void clearClickCount() {
        this.mouseManager.clearClickCount();
    }

    void setPickingMode(int pickingMode) {
        this.pickingManager.setPickingMode(pickingMode);
    }

    boolean setPickingStyle(String style) {
        return this.pickingManager.setPickingStyle(style);
    }

    public String getAtomInfo(int atomIndex) {
        return this.modelManager.getAtomInfo(atomIndex);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.messageQueue;
    }

    Viewer getViewer() {
        return this;
    }

    void setStatusAtomPicked(int atomIndex, String info) {
        this.statusManager.setStatusAtomPicked(atomIndex, info);
    }

    void setStatusNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.statusManager.setStatusNewPickingModeMeasurement(iatom, strMeasure);
    }

    void setStatusNewDefaultModeMeasurement(String status, int count, String strMeasure) {
        this.statusManager.setStatusNewDefaultModeMeasurement(status, count, strMeasure);
    }

    void setStatusScriptStarted(int iscript, String script, String strError) {
        this.statusManager.setStatusScriptStarted(iscript, script, strError);
    }

    void setStatusUserAction(String info) {
        this.statusManager.setStatusUserAction(info);
    }

    Vector getStatusChanged(String statusNameList) {
        return this.statusManager.getStatusChanged(statusNameList);
    }

    void popupMenu(int x, int y) {
        if (this.disablePopupMenu) {
            return;
        }
        this.statusManager.popupMenu(x, y);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener);
    }

    void setStatusFrameChanged(int frameNo) {
        this.statusManager.setStatusFrameChanged(frameNo);
    }

    void setStatusFileLoaded(int ptLoad, String fullPathName, String fileName, String modelName, Object clientFile, String strError) {
        this.statusManager.setStatusFileLoaded(fullPathName, fileName, modelName, clientFile, strError, ptLoad);
    }

    void setStatusFileNotLoaded(String fullPathName, String errorMsg) {
        this.setStatusFileLoaded(-1, fullPathName, null, null, null, errorMsg);
    }

    private void manageScriptTermination() {
        if (this.eval != null && this.eval.hasTerminationNotification()) {
            String strErrorMessage = this.eval.getErrorMessage();
            int msWalltime = this.eval.getExecutionWalltime();
            this.eval.resetTerminationNotification();
            this.statusManager.setStatusScriptTermination(strErrorMessage, msWalltime);
        }
    }

    public void scriptEcho(String strEcho) {
        this.statusManager.setScriptEcho(strEcho);
    }

    void scriptStatus(String strStatus) {
        this.statusManager.setScriptStatus(strStatus);
    }

    public void showUrl(String urlString) {
        if (urlString.indexOf(":") < 0) {
            String base = this.fileManager.getAppletDocumentBase();
            if (base == "") {
                base = this.fileManager.getFullPathName();
            }
            if (base.indexOf("/") >= 0) {
                base = base.substring(0, base.lastIndexOf("/") + 1);
            } else if (base.indexOf("\\") >= 0) {
                base = base.substring(0, base.lastIndexOf("\\") + 1);
            }
            urlString = base + urlString;
        }
        Logger.info("showUrl:" + urlString);
        this.statusManager.showUrl(urlString);
    }

    void showConsole(boolean showConsole) {
        this.statusManager.showConsole(showConsole);
    }

    public boolean getBooleanProperty(String key) {
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            return this.getPerspectiveDepth();
        }
        if (key.equalsIgnoreCase("showAxes")) {
            return this.getShapeShow(16);
        }
        if (key.equalsIgnoreCase("showBoundBox")) {
            return this.getShapeShow(17);
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            return this.getShapeShow(18);
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            return this.getShowHydrogens();
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            return this.getShowMeasurements();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            return this.getAxesOrientationRasmol();
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            return this.getZeroBasedXyzRasmol();
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            return this.getTestFlag1();
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            return this.getTestFlag2();
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            return this.getTestFlag3();
        }
        if (key.equalsIgnoreCase("testFlag4")) {
            return this.getTestFlag4();
        }
        if (key.equalsIgnoreCase("chainCaseSensitive")) {
            return this.getChainCaseSensitive();
        }
        if (key.equalsIgnoreCase("hideNameInPopup")) {
            return this.getHideNameInPopup();
        }
        if (key.equalsIgnoreCase("autobond")) {
            return this.getAutoBond();
        }
        if (key.equalsIgnoreCase("greyscaleRendering")) {
            return this.getGreyscaleRendering();
        }
        if (key.equalsIgnoreCase("disablePopupMenu")) {
            return this.getDisablePopupMenu();
        }
        if (key.equalsIgnoreCase("labelsFront")) {
            return this.getLabelsFrontFlag();
        }
        Logger.error("viewer.getBooleanProperty(" + key + ") - unrecognized");
        return false;
    }

    public void setBooleanProperty(String key, boolean value) {
        this.refresh(0, "viewer.setBooleanProperty");
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            this.setPerspectiveDepth(value);
            return;
        }
        if (key.equalsIgnoreCase("showAxes")) {
            this.setShapeShow(16, value);
            return;
        }
        if (key.equalsIgnoreCase("showBoundBox")) {
            this.setShapeShow(17, value);
            return;
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            this.setShapeShow(18, value);
            return;
        }
        if (key.equalsIgnoreCase("showSelections")) {
            this.setSelectionHaloEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
            return;
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            this.setShowMeasurements(value);
            return;
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            this.setAxesOrientationRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            this.setZeroBasedXyzRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("windowCentered")) {
            this.setWindowCentered(value);
            return;
        }
        if (key.equalsIgnoreCase("adjustCamera")) {
            this.setAdjustCamera(value);
            return;
        }
        if (key.equalsIgnoreCase("rangeSelected")) {
            this.setRangeSelected(value);
            return;
        }
        if (key.equalsIgnoreCase("cameraMove")) {
            this.setAllowCameraMove(value);
            return;
        }
        if (key.equalsIgnoreCase("axesWindow")) {
            this.setAxesModeMolecular(false);
            return;
        }
        if (key.equalsIgnoreCase("axesMolecular")) {
            this.setAxesModeMolecular(value);
            return;
        }
        if (key.equalsIgnoreCase("axesUnitCell")) {
            this.setAxesModeUnitCell(value);
            return;
        }
        if (key.equalsIgnoreCase("measureAllModels")) {
            this.setMeasureAllModels(value);
            return;
        }
        if (key.equalsIgnoreCase("displayCellParameters")) {
            this.setDisplayCellParameters(value);
            return;
        }
        if (key.equalsIgnoreCase("statusReporting")) {
            this.setAllowStatusReporting(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            this.setTestFlag1(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            this.setTestFlag2(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            this.setTestFlag3(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag4")) {
            this.setTestFlag4(value);
            return;
        }
        if (key.equalsIgnoreCase("chainCaseSensitive")) {
            this.setChainCaseSensitive(value);
            return;
        }
        if (key.equalsIgnoreCase("ribbonBorder")) {
            this.setRibbonBorder(value);
            return;
        }
        if (key.equalsIgnoreCase("hideNameInPopup")) {
            this.setHideNameInPopup(value);
            return;
        }
        if (key.equalsIgnoreCase("autobond")) {
            this.setAutoBond(value);
            return;
        }
        if (key.equalsIgnoreCase("greyscaleRendering")) {
            this.setGreyscaleRendering(value);
            return;
        }
        if (key.equalsIgnoreCase("labelsFront")) {
            this.setLabelsFrontFlag(value);
            return;
        }
        if (key.equalsIgnoreCase("disablePopupMenu")) {
            this.setDisablePopupMenu(value);
            return;
        }
        Logger.error("viewer.setBooleanProperty(" + key + "," + value + ") - unrecognized");
        this.scriptStatus("Script ERROR: unrecognized subcommand: set " + key);
    }

    boolean isRangeSelected() {
        return this.rangeSelected;
    }

    void setRangeSelected(boolean TF) {
        this.rangeSelected = TF;
    }

    boolean isWindowCentered() {
        return this.windowCenteredFlag;
    }

    void setWindowCentered(boolean TF) {
        this.windowCenteredFlag = TF;
    }

    boolean isCameraAdjustable() {
        return this.adjustCameraFlag;
    }

    void setAdjustCamera(boolean TF) {
        this.adjustCameraFlag = TF;
    }

    boolean allowCameraMove() {
        return this.allowCameraMoveFlag;
    }

    void setAllowCameraMove(boolean TF) {
        this.allowCameraMoveFlag = TF;
    }

    void setSolventProbeRadius(float radius) {
        this.solventProbeRadius = radius;
    }

    float getSolventProbeRadius() {
        return this.solventProbeRadius;
    }

    float getCurrentSolventProbeRadius() {
        return this.solventOn ? this.solventProbeRadius : 0.0f;
    }

    void setSolventOn(boolean isOn) {
        this.solventOn = isOn;
    }

    boolean getSolventOn() {
        return this.solventOn;
    }

    void setAllowStatusReporting(boolean TF) {
        this.statusManager.setAllowStatusReporting(TF);
    }

    void setTestFlag1(boolean value) {
        this.testFlag1 = value;
    }

    boolean getTestFlag1() {
        return this.testFlag1;
    }

    void setTestFlag2(boolean value) {
        this.testFlag2 = value;
    }

    boolean getTestFlag2() {
        return this.testFlag2;
    }

    void setTestFlag3(boolean value) {
        this.testFlag3 = value;
    }

    boolean getTestFlag3() {
        return this.testFlag3;
    }

    void setTestFlag4(boolean value) {
        this.testFlag4 = value;
    }

    boolean getTestFlag4() {
        return this.testFlag4;
    }

    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.transformManager.setPerspectiveDepth(perspectiveDepth);
        this.refresh(0, "Viewer:setPerspectiveDepth()");
    }

    public void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.transformManager.setAxesOrientationRasmol(axesOrientationRasmol);
        this.refresh(0, "Viewer:setAxesOrientationRasmol()");
    }

    public boolean getAxesOrientationRasmol() {
        return this.transformManager.axesOrientationRasmol;
    }

    void setAxesModeMolecular(boolean TF) {
        this.axesMode = TF ? 1 : 0;
        this.axesAreTainted = true;
    }

    void setAxesModeUnitCell(boolean TF) {
        this.axesMode = TF ? 2 : 0;
        this.axesAreTainted = true;
    }

    int getAxesMode() {
        return this.axesMode;
    }

    void setDisplayCellParameters(boolean displayCellParameters) {
        this.displayCellParameters = displayCellParameters;
    }

    boolean getDisplayCellParameters() {
        return this.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    void setCameraDepth(float depth) {
        this.transformManager.setCameraDepth(depth);
    }

    float getCameraDepth() {
        return this.transformManager.getCameraDepth();
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        if (this.selectionHaloEnabled != selectionHaloEnabled) {
            this.selectionHaloEnabled = selectionHaloEnabled;
            this.refresh(0, "Viewer:setSelectionHaloEnabled()");
        }
    }

    boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    void setBondSelectionModeOr(boolean bondSelectionModeOr) {
        this.bondSelectionModeOr = bondSelectionModeOr;
        this.refresh(0, "Viewer:setBondSelectionModeOr()");
    }

    boolean getBondSelectionModeOr() {
        return this.bondSelectionModeOr;
    }

    boolean getChainCaseSensitive() {
        return this.chainCaseSensitive;
    }

    void setChainCaseSensitive(boolean chainCaseSensitive) {
        this.chainCaseSensitive = chainCaseSensitive;
    }

    boolean getRibbonBorder() {
        return this.ribbonBorder;
    }

    void setRibbonBorder(boolean borderOn) {
        this.ribbonBorder = borderOn;
    }

    boolean getHideNameInPopup() {
        return this.hideNameInPopup;
    }

    void setHideNameInPopup(boolean hideNameInPopup) {
        this.hideNameInPopup = hideNameInPopup;
    }

    void setSsbondsBackbone(boolean ssbondsBackbone) {
        this.styleManager.setSsbondsBackbone(ssbondsBackbone);
    }

    public void setAutoBond(boolean ab) {
        this.modelManager.setAutoBond(ab);
        this.refresh(0, "Viewer:setAutoBond()");
    }

    public boolean getAutoBond() {
        return this.modelManager.autoBond;
    }

    void setGreyscaleRendering(boolean greyscaleRendering) {
        this.greyscaleRendering = greyscaleRendering;
        this.g3d.setGreyscaleMode(greyscaleRendering);
        this.refresh(0, "Viewer:setGreyscaleRendering()");
    }

    boolean getGreyscaleRendering() {
        return this.greyscaleRendering;
    }

    void setLabelsFrontFlag(boolean labelsFrontFlag) {
        this.labelsFrontFlag = labelsFrontFlag;
    }

    boolean getLabelsFrontFlag() {
        return this.labelsFrontFlag;
    }

    void setDisablePopupMenu(boolean disablePopupMenu) {
        this.disablePopupMenu = disablePopupMenu;
    }

    boolean getDisablePopupMenu() {
        return this.disablePopupMenu;
    }

    public void setPercentVdwAtom(int percentVdwAtom) {
        this.styleManager.setPercentVdwAtom(percentVdwAtom);
        this.setShapeSize(0, -percentVdwAtom);
    }

    public void setFrankOn(boolean frankOn) {
        this.styleManager.setFrankOn(frankOn);
        this.setShapeSize(19, frankOn ? -1 : 0);
    }

    boolean getFrankOn() {
        return this.styleManager.frankOn;
    }

    public int getPercentVdwAtom() {
        return this.styleManager.percentVdwAtom;
    }

    short getMadAtom() {
        return (short)(-this.styleManager.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.styleManager.marBond * 2);
    }

    void setModeMultipleBond(byte modeMultipleBond) {
        this.styleManager.setModeMultipleBond(modeMultipleBond);
        this.refresh(0, "Viewer:setModeMultipleBond()");
    }

    byte getModeMultipleBond() {
        return this.styleManager.modeMultipleBond;
    }

    void setShowMultipleBonds(boolean showMultipleBonds) {
        this.styleManager.setShowMultipleBonds(showMultipleBonds);
        this.refresh(0, "Viewer:setShowMultipleBonds()");
    }

    boolean getShowMultipleBonds() {
        return this.styleManager.showMultipleBonds;
    }

    public void setShowHydrogens(boolean showHydrogens) {
        this.styleManager.setShowHydrogens(showHydrogens);
        this.refresh(0, "Viewer:setShowHydrogens()");
    }

    public boolean getShowHydrogens() {
        return this.styleManager.showHydrogens;
    }

    public void setShowBbcage(boolean showBbcage) {
        this.setShapeShow(17, showBbcage);
    }

    public boolean getShowBbcage() {
        return this.getShapeShow(17);
    }

    public void setShowAxes(boolean showAxes) {
        this.setShapeShow(16, showAxes);
    }

    public boolean getShowAxes() {
        return this.getShapeShow(16);
    }

    public void setShowMeasurements(boolean showMeasurements) {
        this.styleManager.setShowMeasurements(showMeasurements);
        this.refresh(0, "setShowMeasurements()");
    }

    public void setMeasureAllModels(boolean TF) {
        this.measureAllModels = TF;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.measureAllModels;
    }

    public boolean getShowMeasurements() {
        return this.styleManager.showMeasurements;
    }

    void setShowMeasurementLabels(boolean showMeasurementLabels) {
        this.styleManager.setShowMeasurementLabels(showMeasurementLabels);
        this.refresh(0, "Viewer:setShowMeasurementLabels()");
    }

    boolean getShowMeasurementLabels() {
        return this.styleManager.showMeasurementLabels;
    }

    boolean setMeasureDistanceUnits(String units) {
        if (!this.styleManager.setMeasureDistanceUnits(units)) {
            return false;
        }
        this.setShapeProperty(6, "reformatDistances", null);
        return true;
    }

    String getMeasureDistanceUnits() {
        return this.styleManager.measureDistanceUnits;
    }

    public void setJmolDefaults() {
        this.styleManager.setJmolDefaults();
    }

    public void setRasmolDefaults() {
        this.styleManager.setRasmolDefaults();
    }

    void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.styleManager.setZeroBasedXyzRasmol(zeroBasedXyzRasmol);
        this.modelManager.setZeroBased();
    }

    boolean getZeroBasedXyzRasmol() {
        return this.styleManager.zeroBasedXyzRasmol;
    }

    void setLabelFontSize(int points) {
        this.styleManager.setLabelFontSize(points);
        this.refresh(0, "Viewer:setLabelFontSize()");
    }

    void setLabelOffset(int xOffset, int yOffset) {
        this.styleManager.setLabelOffset(xOffset, yOffset);
        this.refresh(0, "Viewer:setLabelOffset()");
    }

    int getLabelOffsetX() {
        return this.styleManager.labelOffsetX;
    }

    int getLabelOffsetY() {
        return this.styleManager.labelOffsetY;
    }

    Point3f[] allocTempPoints(int size) {
        return this.tempManager.allocTempPoints(size);
    }

    void freeTempPoints(Point3f[] tempPoints) {
        this.tempManager.freeTempPoints(tempPoints);
    }

    Point3i[] allocTempScreens(int size) {
        return this.tempManager.allocTempScreens(size);
    }

    void freeTempScreens(Point3i[] tempScreens) {
        this.tempManager.freeTempScreens(tempScreens);
    }

    boolean[] allocTempBooleans(int size) {
        return this.tempManager.allocTempBooleans(size);
    }

    void freeTempBooleans(boolean[] tempBooleans) {
        this.tempManager.freeTempBooleans(tempBooleans);
    }

    Font3D getFont3D(int fontSize) {
        return this.g3d.getFont3D("SansSerif", "Plain", fontSize);
    }

    Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return this.g3d.getFont3D(fontFace, fontStyle, fontSize);
    }

    String getElementSymbol(int i) {
        return this.modelManager.getElementSymbol(i);
    }

    int getElementNumber(int i) {
        return this.modelManager.getElementNumber(i);
    }

    public String getAtomName(int i) {
        return this.modelManager.getAtomName(i);
    }

    public int getAtomNumber(int i) {
        return this.modelManager.getAtomNumber(i);
    }

    float getAtomX(int i) {
        return this.modelManager.getAtomX(i);
    }

    float getAtomY(int i) {
        return this.modelManager.getAtomY(i);
    }

    float getAtomZ(int i) {
        return this.modelManager.getAtomZ(i);
    }

    public Point3f getAtomPoint3f(int i) {
        return this.modelManager.getAtomPoint3f(i);
    }

    public float getAtomRadius(int i) {
        return this.modelManager.getAtomRadius(i);
    }

    public int getAtomArgb(int i) {
        return this.g3d.getColixArgb(this.modelManager.getAtomColix(i));
    }

    String getAtomChain(int i) {
        return this.modelManager.getAtomChain(i);
    }

    public int getAtomModelIndex(int i) {
        return this.modelManager.getAtomModelIndex(i);
    }

    String getAtomSequenceCode(int i) {
        return this.modelManager.getAtomSequenceCode(i);
    }

    public Point3f getBondPoint3f1(int i) {
        return this.modelManager.getBondPoint3f1(i);
    }

    public Point3f getBondPoint3f2(int i) {
        return this.modelManager.getBondPoint3f2(i);
    }

    public float getBondRadius(int i) {
        return this.modelManager.getBondRadius(i);
    }

    public short getBondOrder(int i) {
        return this.modelManager.getBondOrder(i);
    }

    public int getBondArgb1(int i) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix1(i));
    }

    public int getBondModelIndex(int i) {
        return this.modelManager.getBondModelIndex(i);
    }

    public int getBondArgb2(int i) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix2(i));
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        return this.modelManager.getPolymerLeadMidPoints(modelIndex, polymerIndex);
    }

    void setStereoMode(int stereoMode) {
        this.transformManager.setStereoMode(stereoMode);
    }

    int getStereoMode() {
        return this.transformManager.stereoMode;
    }

    float getStereoDegrees() {
        return this.transformManager.stereoDegrees;
    }

    void setStereoDegrees(float degrees) {
        this.transformManager.setStereoDegrees(degrees);
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    String formatDecimal(float value, int decimalDigits) {
        return this.styleManager.formatDecimal(value, decimalDigits);
    }

    public Object getProperty(String returnType, String infoType, String paramInfo) {
        return this.propertyManager.getProperty(returnType, infoType, paramInfo);
    }

    String getModelExtract(String atomExpression) {
        BitSet bs = this.selectionManager.getAtomBitSet(atomExpression);
        return this.fileManager.getFullPathName() + "\nJmol version " + this.getJmolVersion() + "\nEXTRACT: " + atomExpression + "\n" + this.modelManager.getModelExtract(bs);
    }

    String simpleReplace(String str, String strFrom, String strTo) {
        boolean isOnce;
        int fromLength = strFrom.length();
        boolean bl = isOnce = strTo.indexOf(strFrom) >= 0;
        if (str == null || fromLength == 0) {
            return str;
        }
        String stemp = "";
        while (str.indexOf(strFrom) >= 0) {
            int ipt;
            int ipt0 = 0;
            while ((ipt = str.indexOf(strFrom, ipt0)) >= 0) {
                stemp = stemp + str.substring(ipt0, ipt) + strTo;
                ipt0 = ipt + fromLength;
            }
            str = stemp + str.substring(ipt0, str.length());
            if (!isOnce) continue;
            break;
        }
        return str;
    }

    String getHexColorFromIndex(short colix) {
        return this.g3d.getHexColorFromIndex(colix);
    }

    void setModelVisibility() {
        this.modelManager.setModelVisibility();
    }

    void setTainted(boolean TF) {
        this.isTainted = TF;
        this.axesAreTainted = TF;
    }

    public void setSyncDriver(int syncMode) {
        Logger.debug(this.htmlName + " viewer setting sync driver " + syncMode);
        this.statusManager.setSyncDriver(syncMode);
    }

    public int getSyncMode() {
        return this.statusManager.getSyncMode();
    }

    void checkObjectClicked(int x, int y, boolean isShiftDown) {
        this.modelManager.checkObjectClicked(x, y, isShiftDown);
    }

    int cardinalityOf(BitSet bs) {
        int nbitset = 0;
        int i = bs.size();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            ++nbitset;
        }
        return nbitset;
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin) {
        if (rotCenter != null) {
            this.moveRotationCenter(rotCenter);
        }
        this.transformManager.rotateAxisAngleAtCenter(rotCenter, rotAxis, degrees, endDegrees, isSpin);
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float nDegrees, float endDegrees, boolean isSpin) {
        this.transformManager.rotateAboutPointsInternal(point1, point2, nDegrees, endDegrees, false, isSpin);
    }

    void setPickingSpinRate(int rate) {
        if (rate < 1) {
            rate = 1;
        }
        this.pickingSpinRate = rate;
    }

    void startSpinningAxis(int atomIndex1, int atomIndex2, boolean isClockwise) {
        Point3f pt1 = this.modelManager.getAtomPoint3f(atomIndex1);
        Point3f pt2 = this.modelManager.getAtomPoint3f(atomIndex2);
        this.startSpinningAxis(pt1, pt2, isClockwise);
    }

    void startSpinningAxis(Point3f pt1, Point3f pt2, boolean isClockwise) {
        if (this.getSpinOn()) {
            this.setSpinOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(pt1, pt2, this.pickingSpinRate, Float.MAX_VALUE, isClockwise, true);
    }

    Point3f getDrawObjectCenter(String axisID) {
        return this.modelManager.getSpinCenter(axisID, this.repaintManager.displayModelIndex);
    }

    Vector3f getDrawObjectAxis(String axisID) {
        return this.modelManager.getSpinAxis(axisID, this.repaintManager.displayModelIndex);
    }

    Vector3f getModelDipole() {
        return this.modelManager.getModelDipole();
    }

    void getBondDipoles() {
        this.modelManager.getBondDipoles();
    }

    public void setDipoleScale(float scale) {
        this.loadShape(23);
        this.setShapeProperty(23, "dipoleVectorScale", new Float(scale));
    }

    void getAtomIdentityInfo(int atomIndex, Hashtable info) {
        this.modelManager.getAtomIdentityInfo(atomIndex, info);
    }

    void setDefaultLattice(Point3f ptLattice) {
        this.ptDefaultLattice.set(ptLattice);
    }

    Point3f getDefaultLattice() {
        return this.ptDefaultLattice;
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        this.modelManager.setAtomCoord(atomIndex, x, y, z);
    }

    public void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        this.modelManager.setAtomCoordRelative(atomIndex, x, y, z);
    }

    float functionXY(String functionName, int x, int y) {
        return this.statusManager.functionXY(functionName, x, y);
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        return this.modelManager.getAdditionalHydrogens(atomSet);
    }

    static class NullBondIterator
    implements BondIterator {
        NullBondIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public int nextIndex() {
            return -1;
        }

        public Bond next() {
            return null;
        }
    }

    static class NullAtomIterator
    implements AtomIterator {
        NullAtomIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Atom next() {
            return null;
        }

        public void release() {
        }
    }
}

