/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.viewer.BbcageRenderer;
import org.jmol.viewer.Frame;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Uccage;

class UccageRenderer
extends ShapeRenderer {
    NumberFormat nf;
    byte fid;
    final Point3i[] screens = new Point3i[8];
    final Point3f[] verticesT = new Point3f[8];
    Uccage uccage;

    UccageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screens[i] = new Point3i();
            this.verticesT[i] = new Point3f();
        }
    }

    void initRenderer() {
    }

    void render() {
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            return;
        }
        this.uccage = (Uccage)this.shape;
        short colix = this.uccage.colix;
        short mad = this.uccage.mad;
        if (mad == 0) {
            return;
        }
        this.render1(modelIndex, mad, colix);
    }

    void render1(int modelIndex, short mad, short colix) {
        if (!this.frame.someModelsHaveUnitcells) {
            return;
        }
        Frame.CellInfo cellInfo = this.frame.cellInfo[modelIndex];
        if (!cellInfo.hasUnitcell) {
            return;
        }
        if (colix == 0) {
            colix = (short)17;
        }
        int i = 8;
        while (--i >= 0) {
            this.verticesT[i].add(cellInfo.vertices[i], cellInfo.offset);
        }
        BbcageRenderer.render(this.viewer, this.g3d, mad, colix, this.verticesT, this.screens);
        if (!this.viewer.getDisplayCellParameters()) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.fid = this.g3d.getFontFid("Monospaced", 14);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int line = 15;
        int lineheight = 15;
        if (cellInfo.spaceGroup != null) {
            this.g3d.drawString(cellInfo.spaceGroup, colix, 5, line += lineheight, 0);
        }
        this.g3d.drawString("a=" + this.nfformat(cellInfo.a) + "\u00c5", colix, 5, line += lineheight, 0);
        this.g3d.drawString("b=" + this.nfformat(cellInfo.b) + "\u00c5", colix, 5, line += lineheight, 0);
        this.g3d.drawString("c=" + this.nfformat(cellInfo.c) + "\u00c5", colix, 5, line += lineheight, 0);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        this.g3d.drawString("\u03b1=" + this.nfformat(cellInfo.alpha) + "\u00b0", colix, 5, line += lineheight, 0);
        this.g3d.drawString("\u03b2=" + this.nfformat(cellInfo.beta) + "\u00b0", colix, 5, line += lineheight, 0);
        this.g3d.drawString("\u03b3=" + this.nfformat(cellInfo.gamma) + "\u00b0", colix, 5, line += lineheight, 0);
    }

    String nfformat(float x) {
        if (this.nf == null) {
            return "" + x;
        }
        return this.nf.format(x);
    }
}

