/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class TransformManager {
    Viewer viewer;
    static final float twoPI = (float)Math.PI * 2;
    float spinX;
    float spinY = 30.0f;
    float spinZ;
    float spinFps = 30.0f;
    Point3f fixedRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    AxisAngle4f fixedRotationAxis;
    float fixedRotationAngle = 0.0f;
    float fixedRotationAngleFramed = 0.0f;
    boolean haveNotifiedNaN = false;
    boolean haveNotifiedCamera = false;
    boolean isSpinInternal = false;
    boolean isSpinFixed = false;
    AxisAngle4f internalRotationAxis;
    Point3f internalRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    float internalRotationAngle = 0.0f;
    private final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    private final Matrix4f matrixTemp4 = new Matrix4f();
    final AxisAngle4f axisangleT = new AxisAngle4f();
    final Vector3f vectorT = new Vector3f();
    final Vector3f vectorT2 = new Vector3f();
    final Point3f pointT = new Point3f();
    final Point3f pointT2 = new Point3f();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    float xFixedTranslation;
    float yFixedTranslation;
    boolean zoomEnabled = true;
    int zoomPercent = 100;
    int zoomPercentSetting = 100;
    boolean slabEnabled = false;
    int modeSlab;
    int slabPercentSetting = 100;
    int depthPercentSetting = 0;
    private int slabValue;
    private int depthValue;
    boolean perspectiveDepth = true;
    float cameraDepth = 3.0f;
    int cameraDistance = 1000;
    float cameraDistanceFloat = 1000.0f;
    boolean tOversample;
    int width;
    int height;
    int width1;
    int height1;
    int width4;
    int height4;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    final Matrix4f matrixTransform = new Matrix4f();
    private final Point3f point3fVibrationTemp = new Point3f();
    private final Point3f point3fScreenTemp = new Point3f();
    private final Point3i point3iScreenTemp = new Point3i();
    private final Matrix4f matrixTemp = new Matrix4f();
    private final Vector3f vectorTemp = new Vector3f();
    boolean axesOrientationRasmol = false;
    boolean increaseRotationRadius;
    float minimumZ;
    Vector3f perspectiveOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    AxisAngle4f aaMoveTo;
    AxisAngle4f aaStep;
    AxisAngle4f aaTotal;
    Matrix3f matrixStart;
    Matrix3f matrixInverse;
    Matrix3f matrixStep;
    Matrix3f matrixEnd;
    boolean spinOn;
    SpinThread spinThread;
    boolean vibrationOn;
    float vibrationPeriod;
    int vibrationPeriodMs;
    float vibrationAmplitude;
    float vibrationRadians;
    float vectorScale = 1.0f;
    float vibrationScale = 1.0f;
    VibrationThread vibrationThread;
    int stereoMode;
    float stereoDegrees = 5.0f;
    float stereoRadians = 0.08726646f;
    boolean stereoFrame;
    private final Matrix3f matrixStereo = new Matrix3f();

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void homePosition() {
        this.translateCenterTo(0, 0);
        this.matrixRotate.setIdentity();
        this.setZoomEnabled(true);
        this.zoomToPercent(100);
        this.scaleFitToScreen();
    }

    void setFixedRotationCenter(Point3f rotationCenter) {
        this.fixedRotationCenter = new Point3f();
        this.fixedRotationCenter.set(rotationCenter);
    }

    void checkFixedRotationCenter() {
        this.fixedRotationCenter = new Point3f();
        Point3f pt = this.viewer.getRotationCenter();
        if (pt == null) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        } else {
            this.fixedRotationCenter.set(pt);
        }
    }

    void setRotationPointXY(Point3f center) {
        Point3i newCenterScreen = this.transformPoint(center);
        this.translateCenterTo(newCenterScreen.x, newCenterScreen.y);
    }

    float setRotateInternal(Point3f center, Vector3f axis, float degrees) {
        this.checkFixedRotationCenter();
        this.internalRotationCenter.set(center);
        if (this.internalRotationAxis == null) {
            this.internalRotationAxis = new AxisAngle4f();
        }
        float radians = degrees * ((float)Math.PI / 180);
        this.internalRotationAxis.set(axis, radians);
        return radians;
    }

    float setRotateFixed(Point3f center, Vector3f axis, float degrees) {
        if (center != null) {
            this.fixedRotationCenter.set(center);
        }
        if (this.fixedRotationAxis == null) {
            this.fixedRotationAxis = new AxisAngle4f();
        }
        float radians = degrees * ((float)Math.PI / 180);
        this.fixedRotationAxis.set(axis, radians);
        return radians;
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.rotateXRadians((float)yDelta * ((float)Math.PI / 180));
        this.rotateYRadians((float)xDelta * ((float)Math.PI / 180));
    }

    void rotateZBy(int zDelta) {
        this.rotateZRadians((float)Math.PI * (float)zDelta / 180.0f);
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateToX(float angleRadians) {
        this.matrixRotate.rotX(angleRadians);
    }

    void rotateToY(float angleRadians) {
        this.matrixRotate.rotY(angleRadians);
    }

    void rotateToZ(float angleRadians) {
        this.matrixRotate.rotZ(angleRadians);
    }

    synchronized void rotateXRadians(float angleRadians) {
        this.matrixTemp3.rotX(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateYRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotY(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateZRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateAxisAngle(Vector3f rotAxis, int degrees) {
        this.axisangleT.set(rotAxis, (float)degrees * ((float)Math.PI / 180));
        this.rotateAxisAngle(this.axisangleT);
    }

    synchronized void rotateAxisAngle(AxisAngle4f axisAngle) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateTo(float x, float y, float z, float degrees) {
        if ((double)degrees < 0.01 && (double)degrees > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
            this.matrixRotate.set(this.axisangleT);
        }
    }

    void rotateTo(AxisAngle4f axisAngle) {
        if ((double)axisAngle.angle < 0.01 && (double)axisAngle.angle > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.matrixRotate.set(axisAngle);
        }
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin) {
        this.setSpinOn(false);
        if (degrees == 0.0f) {
            return;
        }
        if (rotCenter != null) {
            this.setRotationPointXY(rotCenter);
        }
        float angle = this.setRotateFixed(rotCenter, rotAxis, degrees);
        if (isSpin) {
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.setSpinOn(true, endDegrees);
            return;
        }
        this.rotateAxisAngleRadiansFixed(angle);
    }

    synchronized void rotateAxisAngleRadiansFixed(float angleRadians) {
        this.fixedRotationAngle = angleRadians;
        this.axisangleT.set(this.fixedRotationAxis);
        this.axisangleT.angle = angleRadians;
        this.rotateAxisAngle(this.axisangleT);
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float degrees, float endDegrees, boolean isClockwise, boolean isSpin) {
        this.setSpinOn(false);
        if (degrees == 0.0f) {
            return;
        }
        Vector3f axis = new Vector3f(point1);
        axis.sub(point2);
        if (isClockwise) {
            axis.scale(-1.0f);
        }
        float angle = this.setRotateInternal(point1, axis, degrees);
        if (isSpin) {
            this.isSpinInternal = true;
            this.isSpinFixed = false;
            this.setSpinOn(true, endDegrees);
            return;
        }
        this.rotateAxisAngleRadiansInternal(angle);
    }

    synchronized void rotateAxisAngleRadiansInternal(float radians) {
        this.internalRotationAngle = radians;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform(this.vectorT, this.vectorT2);
        this.axisangleT.set(this.vectorT2, radians);
        this.matrixTemp3.set(this.axisangleT);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
        this.getNewFixedRotationCenter();
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.set(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.set(this.axisangleT);
        this.vectorT.set(this.internalRotationCenter);
        this.pointT2.set(this.fixedRotationCenter);
        this.pointT2.sub(this.vectorT);
        this.matrixTemp4.transform(this.pointT2, this.pointT);
        this.pointT.add(this.vectorT);
        this.fixedRotationCenter.set(this.pointT);
        this.viewer.setCenterFromInternalRotation(this.fixedRotationCenter);
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.xFixedTranslation += (float)xDelta;
        this.yFixedTranslation += (float)yDelta;
    }

    void translateToXPercent(float percent) {
        this.xFixedTranslation = (float)(this.width / 2) + (float)this.width * percent / 100.0f;
    }

    void translateToYPercent(float percent) {
        this.yFixedTranslation = (float)(this.height / 2) + (float)this.height * percent / 100.0f;
    }

    void translateToZPercent(float percent) {
    }

    float getTranslationXPercent() {
        return (this.xFixedTranslation - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.yFixedTranslation - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String info = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            info = info + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            info = info + "translate y " + f + ";";
        }
        return info;
    }

    void translateCenterTo(int x, int y) {
        this.xFixedTranslation = x;
        this.yFixedTranslation = y;
    }

    String getOrientationText() {
        return this.getMoveToText() + "\nOR\n" + this.getRotateZyzText(true);
    }

    Hashtable getOrientationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("moveTo", this.getMoveToText());
        info.put("rotateZYZ", this.getRotateZyzText(false));
        info.put("rotateXYZ", this.getRotateXyzText());
        info.put("transXPercent", new Float(this.getTranslationXPercent()));
        info.put("transYPercent", new Float(this.getTranslationYPercent()));
        info.put("zoom", new Integer(this.zoomPercent));
        return info;
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        axisAngle.set(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    Matrix3f getMatrixRotate() {
        return this.matrixRotate;
    }

    void setRotation(Matrix3f matrixRotation) {
        this.matrixRotate.set(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        matrixRotation.set(this.matrixRotate);
    }

    void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        int deltaPercent = pixels * this.zoomPercentSetting / 50;
        if (deltaPercent == 0) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0 ? -1 : 0);
        }
        int percent = deltaPercent + this.zoomPercentSetting;
        this.zoomToPercent(percent);
    }

    int getZoomPercent() {
        return this.zoomPercent;
    }

    int getZoomPercentSetting() {
        return this.zoomPercentSetting;
    }

    void zoomToPercent(int percentZoom) {
        this.zoomPercentSetting = percentZoom;
        this.calcZoom();
    }

    void zoomByPercent(int percentZoom) {
        int delta = percentZoom * this.zoomPercentSetting / 100;
        if (delta == 0) {
            delta = percentZoom < 0 ? -1 : 1;
        }
        this.zoomPercentSetting += delta;
        this.calcZoom();
    }

    private void calcZoom() {
        if (this.zoomPercentSetting < 5) {
            this.zoomPercentSetting = 5;
        }
        if (this.zoomPercentSetting > 200000) {
            this.zoomPercentSetting = 200000;
        }
        this.zoomPercent = this.zoomEnabled ? this.zoomPercentSetting : 100;
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom * (float)this.zoomPercent / 100.0f;
    }

    void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
            this.calcZoom();
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom = 72.0f / angstromsPerInch;
    }

    boolean getSlabEnabled() {
        return this.slabEnabled;
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int percentage) {
        this.slabPercentSetting += percentage;
        if (this.slabPercentSetting < 1) {
            this.slabPercentSetting = 1;
        } else if (this.slabPercentSetting > 100) {
            this.slabPercentSetting = 100;
        }
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int percentage) {
        this.depthPercentSetting += percentage;
        if (this.depthPercentSetting < 0) {
            this.depthPercentSetting = 0;
        } else if (this.depthPercentSetting > 99) {
            this.depthPercentSetting = 99;
        }
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int percentage) {
        if (percentage > 0) {
            if (this.slabPercentSetting + percentage > 100) {
                percentage = 100 - this.slabPercentSetting;
            }
        } else if (this.depthPercentSetting + percentage < 0) {
            percentage = 0 - this.depthPercentSetting;
        }
        this.slabPercentSetting += percentage;
        this.depthPercentSetting += percentage;
    }

    void slabToPercent(int percentSlab) {
        int n = percentSlab < 1 ? 1 : (this.slabPercentSetting = percentSlab > 100 ? 100 : percentSlab);
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
    }

    void depthToPercent(int percentDepth) {
        int n = percentDepth < 0 ? 0 : (this.depthPercentSetting = percentDepth > 99 ? 99 : percentDepth);
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void setModeSlab(int modeSlab) {
        this.modeSlab = modeSlab;
    }

    int getModeSlab() {
        return this.modeSlab;
    }

    void calcSlabAndDepthValues() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (this.slabEnabled) {
            int radius = (int)(this.viewer.getRotationRadius() * this.scalePixelsPerAngstrom);
            this.slabValue = (100 - this.slabPercentSetting) * 2 * radius / 100 + this.cameraDistance;
            this.depthValue = (100 - this.depthPercentSetting) * 2 * radius / 100 + this.cameraDistance;
        }
    }

    void setPerspectiveDepth(boolean perspectiveDepth) {
        this.perspectiveDepth = perspectiveDepth;
        this.scaleFitToScreen();
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void setCameraDepth(float depth) {
        this.cameraDepth = depth;
        Logger.debug("setCameraDepth: " + depth);
    }

    float getCameraDepth() {
        return this.cameraDepth;
    }

    void setScreenDimension(int width, int height) {
        this.width1 = this.width = width;
        this.width4 = width + width;
        this.height1 = this.height = height;
        this.height4 = height + height;
    }

    void setOversample(boolean tOversample) {
        if (this.tOversample == tOversample) {
            return;
        }
        this.tOversample = tOversample;
        if (tOversample) {
            this.width = this.width4;
            this.height = this.height4;
        } else {
            this.width = this.width1;
            this.height = this.height1;
        }
        this.scaleFitToScreen();
    }

    void scaleFitToScreen() {
        if (this.width == 0 || this.height == 0 || !this.viewer.haveFrame()) {
            return;
        }
        this.xFixedTranslation = this.width / 2;
        this.yFixedTranslation = this.height / 2;
        this.screenPixelCount = this.width;
        if (this.height > this.screenPixelCount) {
            this.screenPixelCount = this.height;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = (float)(this.screenPixelCount / 2) / this.viewer.getRotationRadius();
        if (this.perspectiveDepth) {
            this.cameraDistance = (int)(this.cameraDepth * (float)this.screenPixelCount);
            this.cameraDistanceFloat = this.cameraDistance;
            float scaleFactor = (float)(this.cameraDistance + this.screenPixelCount / 2) / this.cameraDistanceFloat;
            scaleFactor = (float)((double)scaleFactor + 0.02);
            this.scaleDefaultPixelsPerAngstrom *= scaleFactor;
        }
        this.calcZoom();
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        float pixelSize = sizeAngstroms * this.scalePixelsPerAngstrom;
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * (float)this.cameraDistance / (float)z;
        }
        return pixelSize;
    }

    short scaleToScreen(int z, int milliAngstroms) {
        if (milliAngstroms == 0) {
            return 0;
        }
        int pixelSize = (int)((float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * this.cameraDistance / z;
        }
        if (pixelSize == 0) {
            return 1;
        }
        return (short)pixelSize;
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.perspectiveDepth ? sizeAngstroms * (float)this.cameraDistance / (float)z : sizeAngstroms;
    }

    void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.axesOrientationRasmol = axesOrientationRasmol;
    }

    boolean getIncreaseRotationRadius() {
        return this.increaseRotationRadius;
    }

    synchronized void finalizeTransformParameters() {
        this.calcTransformMatrix();
        this.calcSlabAndDepthValues();
        this.viewer.setSlabAndDepthValues(this.slabValue, this.depthValue);
        this.increaseRotationRadius = false;
        this.minimumZ = Float.MAX_VALUE;
        this.haveNotifiedNaN = false;
        this.haveNotifiedCamera = false;
        this.setPerspectiveOffset();
    }

    void setPerspectiveOffset() {
        if (!this.viewer.isWindowCentered()) {
            this.matrixTransform.transform(this.viewer.getRotationCenterDefault(), this.pointT);
            this.matrixTransform.transform(this.viewer.getRotationCenter(), this.pointT2);
            this.perspectiveOffset.sub(this.pointT, this.pointT2);
        }
        this.perspectiveOffset.x = this.xFixedTranslation;
        this.perspectiveOffset.y = this.yFixedTranslation;
        if (!this.viewer.isCameraAdjustable()) {
            this.perspectiveOffset.z = 0.0f;
        }
    }

    float getRotationRadiusIncrease() {
        float backupDistance = (float)this.cameraDistance - this.minimumZ + 1.0f;
        float angstromsIncrease = backupDistance / this.scalePixelsPerAngstrom;
        return angstromsIncrease;
    }

    private synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.vectorTemp.x = 0.0f;
        this.vectorTemp.y = 0.0f;
        this.vectorTemp.z = this.viewer.getRotationRadius() + this.cameraDistanceFloat / this.scalePixelsPerAngstrom;
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        if (this.axesOrientationRasmol) {
            this.matrixTransform.add(this.matrixTemp);
        } else {
            this.matrixTransform.sub(this.matrixTemp);
        }
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        if (!this.axesOrientationRasmol) {
            this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        }
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f unscaled = new Matrix4f();
        unscaled.setIdentity();
        if (this.fixedRotationCenter == null) {
            this.fixedRotationCenter = new Point3f();
            this.fixedRotationCenter.set(this.viewer.getRotationCenter());
        }
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        unscaled.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        unscaled.mul(this.matrixTemp, unscaled);
        return unscaled;
    }

    void transformPoints(int count, Point3f[] angstroms, Point3i[] screens) {
        int i = count;
        while (--i >= 0) {
            screens[i].set(this.transformPoint(angstroms[i]));
        }
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms));
    }

    synchronized Point3i transformPoint(Point3f pointAngstroms) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        return this.adjustedTemporaryScreenPoint(pointAngstroms);
    }

    Point3i adjustedTemporaryScreenPoint(Point3f pointAngstroms) {
        float z = this.point3fScreenTemp.z - this.perspectiveOffset.z;
        if (z < (float)this.cameraDistance) {
            if (Float.isNaN(this.point3fScreenTemp.z)) {
                if (!this.haveNotifiedNaN) {
                    Logger.debug("NaN seen in TransformPoint");
                }
                this.haveNotifiedNaN = true;
                z = 1.0f;
            } else {
                if (!this.spinOn && !this.haveNotifiedCamera) {
                    Logger.debug("need to back up the camera");
                    Logger.debug("point3fScreenTemp.z=" + this.point3fScreenTemp.z + " -> z=" + z);
                    this.haveNotifiedCamera = true;
                }
                this.increaseRotationRadius = true;
                if (z < this.minimumZ) {
                    this.minimumZ = z;
                }
                if (z <= 0.0f) {
                    if (!this.spinOn && !this.haveNotifiedCamera) {
                        Logger.debug("WARNING! DANGER! z <= 0! transformPoint() point=" + pointAngstroms + "  ->  " + this.point3fScreenTemp);
                        this.haveNotifiedCamera = true;
                    }
                    z = 1.0f;
                }
            }
        }
        this.point3fScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / z;
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3fScreenTemp.x += this.perspectiveOffset.x;
        this.point3fScreenTemp.y += this.perspectiveOffset.y;
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.x = (int)this.point3fScreenTemp.x;
        this.point3iScreenTemp.y = (int)this.point3fScreenTemp.y;
        this.point3iScreenTemp.z = (int)this.point3fScreenTemp.z;
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f pointAngstroms, Point3f screen) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        this.adjustedTemporaryScreenPoint(pointAngstroms);
        screen.set(this.point3fScreenTemp);
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        if (!this.vibrationOn || vibrationVector == null) {
            this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        } else {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, vibrationVector, pointAngstroms);
            this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        }
        return this.adjustedTemporaryScreenPoint(pointAngstroms);
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms, vibrationVector));
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.matrixTransform.transform(vectorAngstroms, vectorTransformed);
    }

    void move(Vector3f dRot, int dZoom, Vector3f dTrans, int dSlab, float floatSecondsTotal, int fps) {
        int zoom = this.getZoomPercent();
        int slab = this.getSlabPercentSetting();
        float transX = this.getTranslationXPercent();
        float transY = this.getTranslationYPercent();
        float transZ = this.getTranslationZPercent();
        long timeBegin = System.currentTimeMillis();
        int timePerStep = 1000 / fps;
        int totalSteps = (int)((float)fps * floatSecondsTotal);
        float radiansPerDegreePerStep = (float)Math.PI / 180 / (float)totalSteps;
        float radiansXStep = radiansPerDegreePerStep * dRot.x;
        float radiansYStep = radiansPerDegreePerStep * dRot.y;
        float radiansZStep = radiansPerDegreePerStep * dRot.z;
        this.viewer.setInMotion(true);
        if (totalSteps == 0) {
            totalSteps = 1;
        }
        for (int i = 1; i <= totalSteps; ++i) {
            int timeAllowed;
            int timeSpent;
            if (dRot.x != 0.0f) {
                this.rotateXRadians(radiansXStep);
            }
            if (dRot.y != 0.0f) {
                this.rotateYRadians(radiansYStep);
            }
            if (dRot.z != 0.0f) {
                this.rotateZRadians(radiansZStep);
            }
            if (dZoom != 0) {
                this.zoomToPercent(zoom + dZoom * i / totalSteps);
            }
            if (dTrans.x != 0.0f) {
                this.translateToXPercent(transX + dTrans.x * (float)i / (float)totalSteps);
            }
            if (dTrans.y != 0.0f) {
                this.translateToYPercent(transY + dTrans.y * (float)i / (float)totalSteps);
            }
            if (dTrans.z != 0.0f) {
                this.translateToZPercent(transZ + dTrans.z * (float)i / (float)totalSteps);
            }
            if (dSlab != 0) {
                this.slabToPercent(slab + dSlab * i / totalSteps);
            }
            if ((timeSpent = (int)(System.currentTimeMillis() - timeBegin)) >= (timeAllowed = i * timePerStep)) continue;
            this.viewer.requestRepaintAndWait();
            timeSpent = (int)(System.currentTimeMillis() - timeBegin);
            int timeToSleep = timeAllowed - timeSpent;
            if (timeToSleep <= 0) continue;
            try {
                Thread.sleep(timeToSleep);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.viewer.setInMotion(false);
    }

    void moveTo(float floatSecondsTotal, Point3f pt, float degrees, int zoom, int xTrans, int yTrans) {
        Vector3f axis = new Vector3f(pt);
        if (this.aaMoveTo == null) {
            this.aaMoveTo = new AxisAngle4f();
            this.aaStep = new AxisAngle4f();
            this.aaTotal = new AxisAngle4f();
            this.matrixStart = new Matrix3f();
            this.matrixEnd = new Matrix3f();
            this.matrixStep = new Matrix3f();
            this.matrixInverse = new Matrix3f();
        }
        if (degrees < 0.01f && degrees > -0.01f) {
            this.matrixEnd.setIdentity();
        } else {
            if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
                int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
                if (sleepTime > 0) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                return;
            }
            this.aaMoveTo.set(axis, degrees * (float)Math.PI / 180.0f);
            this.matrixEnd.set(this.aaMoveTo);
        }
        this.getRotation(this.matrixStart);
        this.matrixInverse.invert(this.matrixStart);
        this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
        this.aaTotal.set(this.matrixStep);
        int fps = 30;
        int totalSteps = (int)(floatSecondsTotal * (float)fps);
        this.viewer.setInMotion(true);
        if (totalSteps > 1) {
            this.aaStep.angle /= (float)totalSteps;
            int frameTimeMillis = 1000 / fps;
            long targetTime = System.currentTimeMillis();
            int zoomStart = this.getZoomPercent();
            int zoomDelta = zoom - zoomStart;
            float xTransStart = this.getTranslationXPercent();
            float xTransDelta = (float)xTrans - xTransStart;
            float yTransStart = this.getTranslationYPercent();
            float yTransDelta = (float)yTrans - yTransStart;
            for (int iStep = 1; iStep < totalSteps; ++iStep) {
                this.getRotation(this.matrixStart);
                this.matrixInverse.invert(this.matrixStart);
                this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
                this.aaTotal.set(this.matrixStep);
                this.aaStep.set(this.aaTotal);
                this.aaStep.angle /= (float)(totalSteps - iStep + 1);
                if (this.aaStep.angle == 0.0f) {
                    this.matrixStep.setIdentity();
                } else {
                    this.matrixStep.set(this.aaStep);
                }
                this.matrixStep.mul(this.matrixStart);
                this.zoomToPercent(zoomStart + zoomDelta * iStep / totalSteps);
                this.translateToXPercent(xTransStart + xTransDelta * (float)iStep / (float)totalSteps);
                this.translateToYPercent(yTransStart + yTransDelta * (float)iStep / (float)totalSteps);
                this.setRotation(this.matrixStep);
                if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
                this.viewer.requestRepaintAndWait();
                int sleepTime = (int)(targetTime - System.currentTimeMillis());
                if (sleepTime <= 0) continue;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        } else {
            int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.zoomToPercent(zoom);
        this.translateToXPercent(xTrans);
        this.translateToYPercent(yTrans);
        this.setRotation(this.matrixEnd);
        this.viewer.setInMotion(false);
    }

    String getMoveToText(float timespan) {
        this.axisangleT.set(this.matrixRotate);
        float degrees = this.axisangleT.angle * 57.29578f;
        StringBuffer sb = new StringBuffer();
        sb.append("moveto " + timespan);
        if (degrees < 0.01f) {
            sb.append(" 0 0 1 0");
        } else {
            this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
            this.vectorT.normalize();
            this.vectorT.scale(1000.0f);
            TransformManager.truncate0(sb, this.vectorT.x);
            TransformManager.truncate0(sb, this.vectorT.y);
            TransformManager.truncate0(sb, this.vectorT.z);
            TransformManager.truncate1(sb, degrees);
        }
        int zoom = this.getZoomPercent();
        int tX = (int)this.getTranslationXPercent();
        int tY = (int)this.getTranslationYPercent();
        if (zoom != 100 || tX != 0 || tY != 0) {
            sb.append(" ");
            sb.append(zoom);
            if (tX != 0 || tY != 0) {
                sb.append(" ");
                sb.append(tX);
                sb.append(" ");
                sb.append(tY);
            }
        }
        return "" + sb + ";";
    }

    String getMoveToText() {
        return this.getMoveToText(1.0f);
    }

    String getRotateXyzText() {
        float tY;
        float tX;
        float rZ;
        float rX;
        StringBuffer sb = new StringBuffer();
        float m20 = this.matrixRotate.m20;
        float rY = -((float)Math.asin(m20)) * 57.29578f;
        if (m20 > 0.999f || m20 < -0.999f) {
            rX = -((float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11)) * 57.29578f;
            rZ = 0.0f;
        } else {
            rX = (float)Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29578f;
            rZ = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29578f;
        }
        sb.append("reset");
        if (rX != 0.0f) {
            sb.append("; rotate x");
            TransformManager.truncate1(sb, rX);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ);
        }
        sb.append(";");
        int zoom = this.getZoomPercent();
        if (zoom != 100) {
            sb.append(" zoom ");
            sb.append(zoom);
            sb.append(";");
        }
        if ((tX = this.getTranslationXPercent()) != 0.0f) {
            sb.append(" translate x ");
            sb.append(tX);
            sb.append(";");
        }
        if ((tY = this.getTranslationYPercent()) != 0.0f) {
            sb.append(" translate y ");
            sb.append(tY);
            sb.append(";");
        }
        return "" + sb;
    }

    String getRotateZyzText(boolean iAddComment) {
        int tY;
        int tX;
        int zoom;
        float rZ2;
        float rZ1;
        StringBuffer sb = new StringBuffer();
        float m22 = this.matrixRotate.m22;
        float rY = (float)Math.acos(m22) * 57.29578f;
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            rZ2 = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        if (rZ1 != 0.0f && rY != 0.0f && rZ2 != 0.0f && iAddComment) {
            sb.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sb.append("reset");
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ2);
        }
        if ((zoom = this.getZoomPercent()) != 100) {
            sb.append("; zoom ");
            sb.append(zoom);
        }
        if ((tX = (int)this.getTranslationXPercent()) != 0) {
            sb.append("; translate x ");
            sb.append(tX);
        }
        if ((tY = (int)this.getTranslationYPercent()) != 0) {
            sb.append("; translate y ");
            sb.append(tY);
        }
        sb.append(';');
        return "" + sb;
    }

    static void truncate0(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append(Math.round(val));
    }

    static void truncate1(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append((float)Math.round(val * 10.0f) / 10.0f);
    }

    void setSpinX(float degrees) {
        this.spinX = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinY(float degrees) {
        this.spinY = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinZ(float degrees) {
        this.spinZ = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    void clearSpin() {
        this.setSpinOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    void setSpinOn(boolean spinOn) {
        this.setSpinOn(spinOn, Float.MAX_VALUE);
    }

    void setSpinOn(boolean spinOn, float endDegrees) {
        this.spinOn = spinOn;
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(endDegrees);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationPeriod(float period) {
        if (period <= 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
            this.clearVibration();
        } else {
            this.vibrationPeriod = period;
            this.vibrationPeriodMs = (int)(period * 1000.0f);
            this.setVibrationOn(true);
        }
    }

    void setVibrationT(float t) {
        this.vibrationRadians = t * ((float)Math.PI * 2);
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    void setVectorScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vectorScale = scale;
        }
    }

    void setVibrationScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vibrationScale = scale;
        }
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn || !this.viewer.haveFrame()) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    void clearVibration() {
        this.setVibrationOn(false);
    }

    void setStereoMode(int stereoMode) {
        this.stereoMode = stereoMode;
        this.viewer.setGreyscaleRendering(stereoMode >= 2);
    }

    void setStereoDegrees(float stereoDegrees) {
        this.stereoDegrees = stereoDegrees;
        this.stereoRadians = stereoDegrees * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean stereoFrame) {
        this.stereoFrame = stereoFrame;
        if (stereoFrame) {
            this.matrixTemp3.rotY(this.axesOrientationRasmol ? this.stereoRadians : -this.stereoRadians);
            this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        } else {
            this.matrixStereo.set(this.matrixRotate);
        }
        return this.matrixStereo;
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
        }

        public void run() {
            long startTime;
            long lastRepaintTime = startTime = System.currentTimeMillis();
            try {
                do {
                    long currentTime;
                    int elapsed;
                    int sleepTime;
                    if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    lastRepaintTime = currentTime = System.currentTimeMillis();
                    elapsed = (int)(currentTime - startTime);
                    float t = (float)(elapsed % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(t);
                    TransformManager.this.viewer.refresh(0, "TransformationManager:VibrationThread:run()");
                } while (!this.isInterrupted());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    class SpinThread
    extends Thread
    implements Runnable {
        float endDegrees;
        float nDegrees = 0.0f;

        SpinThread(float endDegrees) {
            this.endDegrees = Math.abs(endDegrees);
        }

        public void run() {
            float myFps = TransformManager.this.spinFps;
            int i = 0;
            long timeBegin = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int targetTime;
                int sleepTime;
                boolean refreshNeeded;
                if (myFps != TransformManager.this.spinFps) {
                    myFps = TransformManager.this.spinFps;
                    i = 0;
                    timeBegin = System.currentTimeMillis();
                }
                if (myFps == 0.0f || !TransformManager.this.spinOn) {
                    TransformManager.this.setSpinOn(false);
                    return;
                }
                boolean bl = refreshNeeded = TransformManager.this.isSpinInternal && TransformManager.this.internalRotationAxis.angle != 0.0f || TransformManager.this.isSpinFixed && TransformManager.this.fixedRotationAxis != null && TransformManager.this.fixedRotationAxis.angle != 0.0f || !TransformManager.this.isSpinFixed && !TransformManager.this.isSpinInternal && TransformManager.this.spinX + TransformManager.this.spinY + TransformManager.this.spinZ != 0.0f;
                int currentTime = (int)(System.currentTimeMillis() - timeBegin);
                if ((sleepTime = (targetTime = (int)((float)(++i * 1000) / myFps)) - currentTime) <= 0) continue;
                if (refreshNeeded && TransformManager.this.spinOn) {
                    float angle = 0.0f;
                    if (TransformManager.this.isSpinInternal || TransformManager.this.isSpinFixed) {
                        angle = (TransformManager.this.isSpinInternal ? TransformManager.this.internalRotationAxis : TransformManager.this.fixedRotationAxis).angle / myFps;
                        if (TransformManager.this.isSpinInternal) {
                            TransformManager.this.rotateAxisAngleRadiansInternal(angle);
                        } else {
                            TransformManager.this.rotateAxisAngleRadiansFixed(angle);
                        }
                        this.nDegrees += Math.abs(angle / ((float)Math.PI * 2) * 360.0f);
                    } else {
                        if (TransformManager.this.spinX != 0.0f) {
                            TransformManager.this.rotateXRadians(TransformManager.this.spinX * ((float)Math.PI / 180) / myFps);
                        }
                        if (TransformManager.this.spinY != 0.0f) {
                            TransformManager.this.rotateYRadians(TransformManager.this.spinY * ((float)Math.PI / 180) / myFps);
                        }
                        if (TransformManager.this.spinZ != 0.0f) {
                            TransformManager.this.rotateZRadians(TransformManager.this.spinZ * ((float)Math.PI / 180) / myFps);
                        }
                    }
                    TransformManager.this.viewer.refresh(1, "TransformationManager:SpinThread:run()");
                    if ((double)this.nDegrees >= (double)this.endDegrees - 1.0E-5) {
                        TransformManager.this.setSpinOn(false);
                    }
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

