/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.DecimalFormat;
import org.jmol.viewer.Viewer;

class StyleManager {
    Viewer viewer;
    int percentVdwAtom = 20;
    short marBond = (short)100;
    byte modeMultipleBond = (byte)2;
    boolean showMultipleBonds = true;
    boolean showAtoms = true;
    boolean showBonds = true;
    boolean showHydrogens = true;
    int defaultVectorMad = 0;
    boolean showVectors = true;
    boolean showMeasurements = true;
    boolean showMeasurementLabels = true;
    String measureDistanceUnits = "nanometers";
    String propertyStyleString = "";
    boolean zeroBasedXyzRasmol = false;
    boolean frankOn;
    boolean ssbondsBackbone;
    boolean hbondsBackbone;
    boolean hbondsSolid;
    int pointsLabelFontSize = 13;
    int labelOffsetX = 4;
    int labelOffsetY = 4;
    static String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    DecimalFormat[] formatters;

    StyleManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setPercentVdwAtom(int percentVdwAtom) {
        this.percentVdwAtom = percentVdwAtom;
    }

    void setMarBond(short marBond) {
        this.marBond = marBond;
    }

    void setModeMultipleBond(byte modeMultipleBond) {
        this.modeMultipleBond = modeMultipleBond;
    }

    void setShowMultipleBonds(boolean showMultipleBonds) {
        this.showMultipleBonds = showMultipleBonds;
    }

    void setShowAtoms(boolean showAtoms) {
        this.showAtoms = showAtoms;
    }

    void setShowBonds(boolean showBonds) {
        this.showBonds = showBonds;
    }

    void setShowHydrogens(boolean showHydrogens) {
        this.showHydrogens = showHydrogens;
    }

    void setDefaultVectorMad(int mad) {
        this.defaultVectorMad = mad;
    }

    void setShowVectors(boolean showVectors) {
        this.showVectors = showVectors;
    }

    void setShowMeasurements(boolean showMeasurements) {
        this.showMeasurements = showMeasurements;
    }

    void setShowMeasurementLabels(boolean showMeasurementLabels) {
        this.showMeasurementLabels = showMeasurementLabels;
    }

    boolean setMeasureDistanceUnits(String units) {
        if (units.equalsIgnoreCase("angstroms")) {
            this.measureDistanceUnits = "angstroms";
        } else if (units.equalsIgnoreCase("nanometers") || units.equalsIgnoreCase("nm")) {
            this.measureDistanceUnits = "nanometers";
        } else if (units.equalsIgnoreCase("picometers") || units.equalsIgnoreCase("pm")) {
            this.measureDistanceUnits = "picometers";
        } else {
            return false;
        }
        return true;
    }

    void setPropertyStyleString(String s) {
        this.propertyStyleString = s;
    }

    void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.zeroBasedXyzRasmol = zeroBasedXyzRasmol;
    }

    void setCommonDefaults() {
        this.viewer.zoomToPercent(100);
        this.viewer.setPercentVdwAtom(20);
        this.viewer.setPerspectiveDepth(true);
        this.viewer.setBondTolerance(0.45f);
        this.viewer.setMinBondDistance(0.4f);
        this.viewer.setMarBond((short)150);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setDefaultColors("jmol");
        this.viewer.setAxesOrientationRasmol(false);
        this.setZeroBasedXyzRasmol(false);
    }

    void setRasmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setDefaultColors("rasmol");
        this.viewer.setAxesOrientationRasmol(true);
        this.setZeroBasedXyzRasmol(true);
        this.viewer.setPercentVdwAtom(0);
        this.viewer.setMarBond((short)1);
    }

    void setFrankOn(boolean frankOn) {
        this.frankOn = frankOn;
    }

    void setSsbondsBackbone(boolean ssbondsBackbone) {
        this.ssbondsBackbone = ssbondsBackbone;
    }

    void setHbondsBackbone(boolean hbondsBackbone) {
        this.hbondsBackbone = hbondsBackbone;
    }

    void setHbondsSolid(boolean hbondsSolid) {
        this.hbondsSolid = hbondsSolid;
    }

    void setLabelFontSize(int points) {
        this.pointsLabelFontSize = points <= 0 ? 13 : points;
    }

    void setLabelOffset(int offsetX, int offsetY) {
        this.labelOffsetX = offsetX;
        this.labelOffsetY = offsetY;
    }

    String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits < 0) {
            return "" + value;
        }
        if (this.formatters == null) {
            this.formatters = new DecimalFormat[formattingStrings.length];
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = this.formatters[decimalDigits]) == null) {
            formatter = this.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        return formatter.format(value);
    }

    String getStandardLabelFormat() {
        int modelCount = this.viewer.getModelCount();
        String strLabel = this.viewer.getChainCount() > modelCount ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= modelCount ? "%e%i" : "[%n]%r.%a");
        if (this.viewer.getModelCount() > 1) {
            strLabel = strLabel + "/%M";
        }
        return strLabel;
    }

    void setCrystallographicDefaults() {
        this.viewer.setShapeSize(16, 200);
        this.viewer.setShapeSize(18, 1);
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setPerspectiveDepth(false);
    }
}

