/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class Sticks
extends Shape {
    final float[] connectDistances = new float[2];
    int connectDistanceCount;
    final BitSet[] connectSets = new BitSet[2];
    int connectSetCount;
    private static final short NULL_BOND_ORDER = -1;
    short connectBondOrder;
    int connectOperation;
    private static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    private static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    private static final int DELETE_BONDS = 0;
    private static final int MODIFY_ONLY = 1;
    private static final int CREATE_ONLY = 2;
    private static final int MODIFY_OR_CREATE = 3;
    private static final int AUTO_BOND = 4;
    private static final String[] connectOperationStrings = new String[]{"delete", "modify", "create", "modifyOrCreate", "auto"};

    Sticks() {
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.setMadBond(mad, (short)3, bsSelected);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.debug(propertyName + " " + value + " " + bsSelected);
        if ("color" == propertyName) {
            short colix;
            this.setColixBond(colix, (colix = Graphics3D.getColix(value)) != 3 ? null : (String)value, (short)3, bsSelected);
            return;
        }
        if ("translucency" == propertyName) {
            this.setTranslucencyBond(value == "translucent", (short)3, bsSelected);
            return;
        }
        if ("resetConnectParameters" == propertyName) {
            this.connectDistanceCount = 0;
            this.connectSetCount = 0;
            this.connectBondOrder = (short)-1;
            this.connectOperation = 3;
            return;
        }
        if ("connectDistance" == propertyName) {
            if (this.connectDistanceCount < this.connectDistances.length) {
                this.connectDistances[this.connectDistanceCount++] = ((Float)value).floatValue();
            } else {
                Logger.error("too many connect distances specified");
            }
            return;
        }
        if ("connectSet" == propertyName) {
            if (this.connectSetCount < this.connectSets.length) {
                this.connectSets[this.connectSetCount++] = (BitSet)value;
            } else {
                Logger.error("too many connect sets specified");
            }
            return;
        }
        if ("connectBondOrder" == propertyName) {
            this.connectBondOrder = this.bondOrderFromString((String)value);
            return;
        }
        if ("connectOperation" == propertyName) {
            this.connectOperation = this.connectOperationFromString((String)value);
            return;
        }
        if ("applyConnectParameters" == propertyName) {
            if (this.connectDistanceCount < 2) {
                if (this.connectDistanceCount == 0) {
                    this.connectDistances[0] = 1.0E8f;
                }
                this.connectDistances[1] = this.connectDistances[0];
                this.connectDistances[0] = 0.1f;
            }
            if (this.connectSetCount < 2) {
                if (this.connectSetCount == 0) {
                    this.connectSets[0] = bsSelected;
                }
                this.connectSets[1] = this.connectSets[0];
                this.connectSets[0] = bsSelected;
            }
            if (this.connectOperation >= 0) {
                this.makeConnections(this.connectDistances[0], this.connectDistances[1], this.connectBondOrder, this.connectOperation, this.connectSets[0], this.connectSets[1]);
            }
            return;
        }
        if ("rasmolCompatibleConnect" == propertyName) {
            this.frame.deleteAllBonds();
            this.frame.autoBond(null, null);
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    void setMadBond(short mad, short bondTypeMask, BitSet bs) {
        BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
        while (iter.hasNext()) {
            iter.next().setMad(mad);
        }
    }

    void setColixBond(short colix, String palette, short bondTypeMask, BitSet bs) {
        if (colix != 3) {
            BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
            while (iter.hasNext()) {
                iter.next().setColix(colix);
            }
        } else {
            Logger.error("setColixBond called with palette:" + palette);
        }
    }

    void setTranslucencyBond(boolean isTranslucent, short bondTypeMask, BitSet bs) {
        BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
        while (iter.hasNext()) {
            iter.next().setTranslucent(isTranslucent);
        }
    }

    void makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB) {
        Logger.debug("makeConnections(" + minDistance + "," + maxDistance + "," + order + "," + connectOperation + "," + bsA + "," + bsB + ")");
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if (connectOperation == 0) {
            this.deleteConnections(minDistance, maxDistance, order, bsA, bsB);
            return;
        }
        if (connectOperation == 4) {
            this.autoBond(order, bsA, bsB);
            return;
        }
        if (order == -1) {
            order = 1;
        }
        float minDistanceSquared = minDistance * minDistance;
        float maxDistanceSquared = maxDistance * maxDistance;
        int iA = atomCount;
        while (--iA >= 0) {
            if (!bsA.get(iA)) continue;
            Atom atomA = atoms[iA];
            Point3f pointA = atomA.point3f;
            int iB = atomCount;
            while (--iB >= 0) {
                float distanceSquared;
                if (iB == iA || !bsB.get(iB)) continue;
                Atom atomB = atoms[iB];
                if (atomA.modelIndex != atomB.modelIndex || atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != 0 && atomB.alternateLocationID != 0) continue;
                Bond bondAB = atomA.getBond(atomB);
                if (1 == connectOperation && bondAB == null || 2 == connectOperation && bondAB != null || (distanceSquared = pointA.distanceSquared(atomB.point3f)) < minDistanceSquared || distanceSquared > maxDistanceSquared) continue;
                if (bondAB != null) {
                    bondAB.setOrder(order);
                    continue;
                }
                this.frame.bondAtoms(atomA, atomB, order);
            }
        }
    }

    void deleteConnections(float minDistance, float maxDistance, short order, BitSet bsA, BitSet bsB) {
        int bondCount = this.frame.bondCount;
        Bond[] bonds = this.frame.bonds;
        BitSet bsDelete = new BitSet();
        float minDistanceSquared = minDistance * minDistance;
        float maxDistanceSquared = maxDistance * maxDistance;
        if (order != -1 && (order & 0x3C0) != 0) {
            order = (short)960;
        }
        int i = bondCount;
        while (--i >= 0) {
            float distanceSquared;
            Bond bond = bonds[i];
            Atom atom1 = bond.atom1;
            Atom atom2 = bond.atom2;
            if ((!bsA.get(atom1.atomIndex) || !bsB.get(atom2.atomIndex)) && (!bsA.get(atom2.atomIndex) || !bsB.get(atom1.atomIndex)) || !bond.atom1.isBonded(bond.atom2) || !((distanceSquared = atom1.point3f.distanceSquared(atom2.point3f)) >= minDistanceSquared) || !(distanceSquared <= maxDistanceSquared) || order != -1 && order != (bond.order & 0xFFFFFFDF) && (order & bond.order & 0x3C0) == 0) continue;
            bsDelete.set(i);
        }
        this.frame.deleteBonds(bsDelete);
    }

    short bondOrderFromString(String bondOrderString) {
        int i = JmolConstants.bondOrderNames.length;
        while (--i >= 0) {
            if (!JmolConstants.bondOrderNames[i].equalsIgnoreCase(bondOrderString)) continue;
            return JmolConstants.bondOrderValues[i];
        }
        return -1;
    }

    int connectOperationFromString(String connectOperationString) {
        int i = connectOperationStrings.length;
        while (--i >= 0 && !connectOperationStrings[i].equalsIgnoreCase(connectOperationString)) {
        }
        return i;
    }

    void autoBond(short order, BitSet bsA, BitSet bsB) {
        if (order == -1) {
            this.frame.autoBond(bsA, bsB);
        } else if (order == 64) {
            this.frame.autoHbond(bsA, bsB);
        } else {
            Logger.warn("Sticks.autoBond() unknown order: " + order);
        }
    }

    void setModelClickability() {
        Bond[] bonds = this.frame.bonds;
        int i = this.frame.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            bond.atom1.clickabilityFlags |= this.myVisibilityFlag;
            bond.atom2.clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

