/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import org.jmol.api.JmolSelectionListener;
import org.jmol.util.Logger;
import org.jmol.viewer.Eval;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class SelectionManager {
    Viewer viewer;
    JmolSelectionListener[] listeners = new JmolSelectionListener[4];
    private final BitSet bsNull = new BitSet();
    final BitSet bsSelection = new BitSet();
    static final int TRUE = 1;
    static final int FALSE = 0;
    static final int UNKNOWN = -1;
    int empty = 1;

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void removeSelection(int atomIndex) {
        this.bsSelection.clear(atomIndex);
        if (this.empty != 1) {
            this.empty = -1;
        }
        this.selectionChanged();
    }

    void removeSelection(BitSet set) {
        this.bsSelection.andNot(set);
        if (this.empty != 1) {
            this.empty = -1;
        }
        this.selectionChanged();
    }

    void addSelection(int atomIndex) {
        if (!this.bsSelection.get(atomIndex)) {
            this.bsSelection.set(atomIndex);
            this.empty = 0;
            this.selectionChanged();
        }
    }

    void addSelection(BitSet set) {
        this.bsSelection.or(set);
        if (this.empty == 1) {
            this.empty = -1;
        }
        this.selectionChanged();
    }

    void toggleSelection(int atomIndex) {
        if (this.bsSelection.get(atomIndex)) {
            this.bsSelection.clear(atomIndex);
        } else {
            this.bsSelection.set(atomIndex);
        }
        this.empty = this.empty == 1 ? 0 : -1;
        this.selectionChanged();
    }

    boolean isSelected(int atomIndex) {
        return this.bsSelection.get(atomIndex);
    }

    boolean isEmpty() {
        if (this.empty != -1) {
            return this.empty == 1;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            this.empty = 0;
            return false;
        }
        this.empty = 1;
        return true;
    }

    void select(BitSet bs) {
        if (bs == null) {
            if (!this.viewer.getRasmolHydrogenSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits("hydrogen"));
            }
            if (!this.viewer.getRasmolHeteroSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits("hetero"));
            }
        } else {
            this.setSelectionSet(bs);
        }
    }

    void selectAll() {
        int count = this.viewer.getAtomCount();
        this.empty = count == 0 ? 1 : 0;
        int i = count;
        while (--i >= 0) {
            this.bsSelection.set(i);
        }
        this.selectionChanged();
    }

    void clearSelection() {
        this.bsSelection.and(this.bsNull);
        this.empty = 1;
        this.selectionChanged();
    }

    void setSelection(int atomIndex) {
        this.bsSelection.and(this.bsNull);
        this.bsSelection.set(atomIndex);
        this.empty = 0;
        this.selectionChanged();
    }

    void setSelectionSet(BitSet set) {
        this.bsSelection.and(this.bsNull);
        if (set != null) {
            this.bsSelection.or(set);
        }
        this.empty = -1;
        this.selectionChanged();
    }

    void toggleSelectionSet(BitSet bs) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0 && (!bs.get(i) || this.bsSelection.get(i))) {
        }
        if (i < 0) {
            i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.bsSelection.clear(i);
            }
            this.empty = -1;
        } else {
            do {
                if (!bs.get(i)) continue;
                this.bsSelection.set(i);
                this.empty = 0;
            } while (--i >= 0);
        }
        this.selectionChanged();
    }

    void invertSelection() {
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.bsSelection.get(i)) {
                this.bsSelection.clear(i);
                continue;
            }
            this.bsSelection.set(i);
            this.empty = 0;
        }
        this.selectionChanged();
    }

    void excludeSelectionSet(BitSet setExclude) {
        if (setExclude == null || this.empty == 1) {
            return;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!setExclude.get(i)) continue;
            this.bsSelection.clear(i);
        }
        this.empty = -1;
        this.selectionChanged();
    }

    int getSelectionCount() {
        if (this.empty == 1) {
            return 0;
        }
        int count = 0;
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i)) continue;
            ++count;
        }
        if (count > 0) {
            this.empty = 0;
        }
        return count;
    }

    void addListener(JmolSelectionListener listener) {
        int len;
        this.removeListener(listener);
        int i = len = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != null) continue;
            this.listeners[i] = listener;
            return;
        }
        this.listeners = (JmolSelectionListener[])Util.doubleLength(this.listeners);
        this.listeners[len] = listener;
    }

    void removeListener(JmolSelectionListener listener) {
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != listener) continue;
            this.listeners[i] = null;
            return;
        }
    }

    private void selectionChanged() {
        int i = this.listeners.length;
        while (--i >= 0) {
            JmolSelectionListener listener = this.listeners[i];
            if (listener == null) continue;
            this.listeners[i].selectionChanged(this.bsSelection);
        }
    }

    BitSet getAtomBitSet(String atomExpression) {
        Eval e = new Eval(this.viewer);
        BitSet bs = new BitSet();
        try {
            bs = e.getAtomBitSet(atomExpression);
        }
        catch (Exception ex) {
            Logger.error("SelectionManager.getAtomBitSet " + atomExpression);
            Logger.error("" + ex);
            return bs;
        }
        return bs;
    }

    Vector getAtomBitSetVector(String atomExpression) {
        Vector<Integer> V = new Vector<Integer>();
        BitSet bs = this.getAtomBitSet(atomExpression);
        int atomCount = this.viewer.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            V.add(new Integer(i));
        }
        return V;
    }
}

