/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.SelectionIndependentShape;
import org.jmol.viewer.Util;

class Polyhedra
extends SelectionIndependentShape {
    static final float DEFAULT_MAXFACTOR = 1.85f;
    static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    static final int EDGES_NONE = 0;
    static final int EDGES_ALL = 1;
    static final int EDGES_FRONT = 2;
    static final int MAX_VERTICES = 90;
    static final int FACE_COUNT_MAX = 87;
    Atom[] otherAtoms = new Atom[90];
    int polyhedronCount;
    Polyhedron[] polyhedrons = new Polyhedron[32];
    float radius;
    int nBonds;
    float faceCenterOffset;
    float maxFactor;
    int drawEdges;
    boolean isCollapsed;
    boolean iHaveCenterBitSet;
    boolean iHaveVertexBitSet;
    BitSet centers;
    BitSet bsVertices;
    short[] normixesT = new short[90];
    byte[] planesT = new byte[270];
    static final Point3f randomPoint = new Point3f(3141.0f, 2718.0f, 1414.0f);
    Vector3f align1 = new Vector3f();
    Vector3f align2 = new Vector3f();
    static float minDistanceForPlanarity = 0.1f;

    Polyhedra() {
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("polyhedra: " + propertyName + " " + value);
        if (propertyName.equalsIgnoreCase("init")) {
            this.faceCenterOffset = 0.25f;
            this.maxFactor = 1.85f;
            this.radius = 0.0f;
            this.nBonds = 0;
            this.bsVertices = null;
            this.centers = null;
            this.iHaveVertexBitSet = false;
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.drawEdges = 0;
        }
        if (propertyName.equalsIgnoreCase("generate")) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.deletePolyhedra();
            this.buildPolyhedra(this.radius == 0.0f);
            return;
        }
        if (propertyName.equalsIgnoreCase("collapsed")) {
            this.isCollapsed = true;
            return;
        }
        if (propertyName.equalsIgnoreCase("solid")) {
            this.isCollapsed = false;
            return;
        }
        if (propertyName.equalsIgnoreCase("nbonds")) {
            this.nBonds = value instanceof Integer ? (Integer)value : 100;
            return;
        }
        if (propertyName.equalsIgnoreCase("centers")) {
            this.centers = (BitSet)value;
            this.iHaveCenterBitSet = true;
        }
        if (propertyName.equalsIgnoreCase("to")) {
            this.bsVertices = (BitSet)value;
        }
        if (propertyName.equalsIgnoreCase("faceCenterOffset")) {
            if (value instanceof Float) {
                this.faceCenterOffset = ((Float)value).floatValue();
            }
            return;
        }
        if (propertyName.equalsIgnoreCase("maxFactor")) {
            if (value instanceof Float) {
                this.maxFactor = ((Float)value).floatValue();
            }
            return;
        }
        if ("bonds" == propertyName) {
            return;
        }
        if ("delete" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == propertyName) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == propertyName) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == propertyName) {
            this.drawEdges = 2;
            return;
        }
        if ("color" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.colix = Graphics3D.getColix(value);
            this.setColix(this.colix, this.colix != 3 ? null : (String)value);
            return;
        }
        if ("translucency" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.colix = Graphics3D.getColix(value);
            this.setTranslucent("translucent" == value);
            return;
        }
        if ("radius" == propertyName) {
            this.radius = ((Float)value).floatValue();
            return;
        }
    }

    void deletePolyhedra() {
        int i;
        int newCount = 0;
        for (i = 0; i < this.polyhedronCount; ++i) {
            Polyhedron p = this.polyhedrons[i];
            if (this.centers.get(p.centralAtom.atomIndex)) continue;
            this.polyhedrons[newCount++] = p;
        }
        for (i = newCount; i < this.polyhedronCount; ++i) {
            this.polyhedrons[i] = null;
        }
        this.polyhedronCount = newCount;
    }

    void setVisible(boolean visible) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !this.centers.get(p.centralAtom.atomIndex)) continue;
            p.visible = visible;
        }
    }

    void setColix(short colix, String palette) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            int atomIndex;
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !this.centers.get(atomIndex = p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = colix != 3 ? colix : this.viewer.getColixAtomPalette(this.frame.getAtomAt(atomIndex), palette);
        }
    }

    void setTranslucent(boolean isTranslucent) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !this.centers.get(p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = Graphics3D.setTranslucent(p.polyhedronColix, isTranslucent);
        }
    }

    void savePolyhedron(Polyhedron p) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])Util.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = p;
    }

    void buildPolyhedra(boolean isBonds) {
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Polyhedron p;
            if (!this.centers.get(i) || (p = isBonds ? this.constructBondsPolyhedron(i) : this.constructRadiusPolyhedron(i)) == null) continue;
            this.savePolyhedron(p);
        }
    }

    Polyhedron constructBondsPolyhedron(int atomIndex) {
        Atom atom = this.frame.getAtomAt(atomIndex);
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return null;
        }
        int bondCount = 0;
        int i = bonds.length;
        while (--i >= 0) {
            Atom otherAtom;
            Bond bond = bonds[i];
            Atom atom2 = otherAtom = bond.atom1 == atom ? bond.atom2 : bond.atom1;
            if (this.bsVertices != null && !this.bsVertices.get(otherAtom.atomIndex)) continue;
            if (bondCount == 90) break;
            this.otherAtoms[bondCount++] = otherAtom;
        }
        if (bondCount < 3 || this.nBonds > 0 && this.nBonds != bondCount) {
            return null;
        }
        return this.validatePolyhedronNew(atom, bondCount, this.otherAtoms);
    }

    Polyhedron constructRadiusPolyhedron(int atomIndex) {
        Atom atom = this.frame.getAtomAt(atomIndex);
        int otherAtomCount = 0;
        AtomIterator withinIterator = this.frame.getWithinModelIterator(atom, this.radius);
        while (withinIterator.hasNext()) {
            Atom other = withinIterator.next();
            if (other == atom || this.bsVertices != null && !this.bsVertices.get(other.atomIndex) || other.alternateLocationID != atom.alternateLocationID && other.alternateLocationID != 0 && atom.alternateLocationID != 0) continue;
            if (otherAtomCount == 90) break;
            this.otherAtoms[otherAtomCount++] = other;
        }
        if (otherAtomCount < 3 || this.nBonds > 0 && this.nBonds != otherAtomCount) {
            return null;
        }
        return this.validatePolyhedronNew(atom, otherAtomCount, this.otherAtoms);
    }

    Polyhedron validatePolyhedronNew(Atom centralAtom, int vertexCount, Atom[] otherAtoms) {
        boolean isOK;
        Vector3f normal = new Vector3f();
        int planeCount = 0;
        int ipt = 0;
        int ptCenter = vertexCount;
        int nPoints = ptCenter + 1;
        float distMax = 0.0f;
        float dAverage = 0.0f;
        Point3f[] points = new Point3f[270];
        points[ptCenter] = centralAtom.point3f;
        otherAtoms[ptCenter] = centralAtom;
        for (int i = 0; i < ptCenter; ++i) {
            points[i] = otherAtoms[i].point3f;
            dAverage += points[ptCenter].distance(points[i]);
        }
        float factor = this.maxFactor;
        BitSet bs = new BitSet(ptCenter);
        boolean bl = isOK = (dAverage /= (float)ptCenter) == 0.0f;
        block1: while (!isOK) {
            int i;
            distMax = dAverage * factor;
            for (i = 0; i < ptCenter; ++i) {
                bs.set(i);
            }
            for (i = 0; i < ptCenter - 2; ++i) {
                for (int j = i + 1; j < ptCenter - 1; ++j) {
                    if (points[i].distance(points[j]) > distMax) continue;
                    for (int k = j + 1; k < ptCenter; ++k) {
                        if (points[i].distance(points[k]) > distMax || points[j].distance(points[k]) > distMax) continue;
                        bs.clear(i);
                        bs.clear(j);
                        bs.clear(k);
                    }
                }
            }
            isOK = true;
            for (i = 0; i < ptCenter; ++i) {
                if (!bs.get(i)) continue;
                isOK = false;
                Logger.debug("Polyhedra maxFactor for " + ptCenter + " atoms increased to " + (factor *= 1.05f) + " in order to include " + otherAtoms[i].getIdentity());
                continue block1;
            }
        }
        String faceCatalog = "";
        String facetCatalog = "";
        for (int i = 0; i < ptCenter - 2; ++i) {
            for (int j = i + 1; j < ptCenter - 1; ++j) {
                for (int k = j + 1; k < ptCenter; ++k) {
                    if (!this.isPlanar(points[i], points[j], points[k], points[ptCenter])) continue;
                    faceCatalog = faceCatalog + this.faceId(i, j, k);
                }
            }
        }
        for (int j = 0; j < ptCenter - 1; ++j) {
            for (int k = j + 1; k < ptCenter; ++k) {
                if (!this.isAligned(points[j], points[k], points[ptCenter])) continue;
                facetCatalog = facetCatalog + this.faceId(j, k, -1);
            }
        }
        Point3f ptRef = new Point3f();
        for (int i = 0; i < ptCenter - 2; ++i) {
            for (int j = i + 1; j < ptCenter - 1; ++j) {
                if (points[i].distance(points[j]) > distMax) continue;
                for (int k = j + 1; k < ptCenter; ++k) {
                    boolean isFaceCentered;
                    if (points[i].distance(points[k]) > distMax || points[j].distance(points[k]) > distMax) continue;
                    if (planeCount >= 87) {
                        Logger.error("Polyhedron error: maximum face(87) -- reduce maxFactor from " + this.maxFactor);
                        return null;
                    }
                    if (nPoints >= 90) {
                        Logger.error("Polyhedron error: maximum vertex count(90) reduce maxFactor from " + this.maxFactor);
                        return null;
                    }
                    boolean bl2 = isFaceCentered = faceCatalog.indexOf(this.faceId(i, j, k)) >= 0;
                    if (isFaceCentered) {
                        this.g3d.getNormalFromCenter(randomPoint, points[i], points[j], points[k], false, normal);
                    } else {
                        this.g3d.getNormalFromCenter(points[ptCenter], points[i], points[j], points[k], true, normal);
                    }
                    normal.scale(this.isCollapsed && !isFaceCentered ? this.faceCenterOffset : 0.001f);
                    int nRef = nPoints;
                    if (this.isCollapsed && !isFaceCentered) {
                        points[nPoints] = new Point3f(points[ptCenter]);
                        points[nPoints].add(normal);
                        otherAtoms[nPoints] = new Atom(points[nPoints]);
                    } else if (isFaceCentered) {
                        ptRef.set(points[ptCenter]);
                        ptRef.sub(normal);
                        nRef = ptCenter;
                    }
                    String facet = this.faceId(i, j, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)i;
                        this.planesT[ipt++] = (byte)j;
                        this.planesT[ipt++] = (byte)nRef;
                        this.g3d.getNormalFromCenter(points[k], points[i], points[j], ptRef, false, normal);
                        this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    facet = this.faceId(i, k, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)i;
                        this.planesT[ipt++] = (byte)nRef;
                        this.planesT[ipt++] = (byte)k;
                        this.g3d.getNormalFromCenter(points[j], points[i], ptRef, points[k], false, normal);
                        this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    facet = this.faceId(j, k, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)nRef;
                        this.planesT[ipt++] = (byte)j;
                        this.planesT[ipt++] = (byte)k;
                        this.g3d.getNormalFromCenter(points[i], ptRef, points[j], points[k], false, normal);
                        short s = this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    if (isFaceCentered) continue;
                    if (this.isCollapsed) {
                        ++nPoints;
                        continue;
                    }
                    this.planesT[ipt++] = (byte)i;
                    this.planesT[ipt++] = (byte)j;
                    this.planesT[ipt++] = (byte)k;
                    this.normixesT[planeCount++] = this.g3d.getNormix(normal);
                }
            }
        }
        return new Polyhedron(centralAtom, ptCenter, nPoints, planeCount, otherAtoms, this.normixesT, this.planesT);
    }

    String faceId(int i, int j, int k) {
        return "" + new Point3i(i, j, k);
    }

    boolean isAligned(Point3f pt1, Point3f pt2, Point3f pt3) {
        this.align1.sub(pt1, pt3);
        this.align2.sub(pt2, pt3);
        float angle = this.align1.angle(this.align2);
        return angle < 0.01f || angle > 3.13f;
    }

    boolean isPlanar(Point3f pt1, Point3f pt2, Point3f pt3, Point3f ptX) {
        Vector3f plane = new Vector3f();
        float w = this.g3d.getPlaneThroughPoints(pt1, pt2, pt3, plane);
        float distanceToPlane = Math.abs(plane.x * ptX.x + plane.y * ptX.y + plane.z * ptX.z + w) / (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
        boolean isPlanar = distanceToPlane < minDistanceForPlanarity;
        return isPlanar;
    }

    void setVisibilityFlags(BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            p.visibilityFlags = p.visible && bs.get(p.centralAtom.modelIndex) ? this.myVisibilityFlag : 0;
        }
    }

    class Polyhedron {
        final Atom centralAtom;
        final Atom[] vertices;
        int ptCenter;
        int nPoints;
        boolean visible;
        final short[] normixes;
        short polyhedronColix;
        byte[] planes;
        int planeCount;
        int visibilityFlags = 0;
        boolean collapsed = false;

        Polyhedron(Atom centralAtom, int ptCenter, int nPoints, int planeCount, Atom[] otherAtoms, short[] normixes, byte[] planes) {
            this.polyhedronColix = Polyhedra.this.colix;
            this.collapsed = Polyhedra.this.isCollapsed;
            this.centralAtom = centralAtom;
            this.ptCenter = ptCenter;
            this.nPoints = nPoints;
            this.vertices = new Atom[nPoints];
            this.visible = true;
            this.normixes = new short[planeCount];
            this.planeCount = planeCount;
            this.planes = new byte[planeCount * 3];
            int i = nPoints;
            while (--i >= 0) {
                this.vertices[i] = otherAtoms[i];
            }
            i = planeCount;
            while (--i >= 0) {
                this.normixes[i] = normixes[i];
            }
            i = planeCount * 3;
            while (--i >= 0) {
                this.planes[i] = planes[i];
            }
        }
    }
}

