/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class PickingManager {
    Viewer viewer;
    int pickingMode = 1;
    int pickingStyle = 0;
    int queuedAtomCount = 0;
    int[] queuedAtomIndexes = new int[4];
    int[] countPlusIndexes = new int[5];

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void atomPicked(int atomIndex, boolean shiftKey, boolean alternateKey) {
        if (atomIndex == -1) {
            if (this.pickingStyle == 2 && !shiftKey && !alternateKey) {
                this.viewer.clearSelection();
                this.reportSelection();
            }
            return;
        }
        Frame frame = this.viewer.getFrame();
        switch (this.pickingMode) {
            case 0: {
                break;
            }
            case 1: {
                this.viewer.setStatusAtomPicked(atomIndex, this.viewer.getAtomInfo(atomIndex));
                break;
            }
            case 2: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) break;
                float distance = frame.getDistance(this.queuedAtomIndexes[0], atomIndex);
                String value = "Distance " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " : " + distance;
                this.viewer.setStatusNewPickingModeMeasurement(2, value);
                break;
            }
            case 4: {
                if (this.queuedAtomCount >= 3) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 3) break;
                float angle = frame.getAngle(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], atomIndex);
                String value = "Angle " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " : " + angle;
                this.viewer.setStatusNewPickingModeMeasurement(3, value);
                break;
            }
            case 5: {
                if (this.queuedAtomCount >= 4) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 4) break;
                float torsion = frame.getTorsion(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], this.queuedAtomIndexes[2], atomIndex);
                String value = "Torsion " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[3]) + " : " + torsion;
                this.viewer.setStatusNewPickingModeMeasurement(4, value);
                break;
            }
            case 3: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) break;
                this.countPlusIndexes[0] = 2;
                this.countPlusIndexes[1] = this.queuedAtomIndexes[0];
                this.countPlusIndexes[2] = this.queuedAtomIndexes[1];
                this.viewer.toggleMeasurement(this.countPlusIndexes);
                break;
            }
            case 6: {
                this.viewer.togglePickingLabel(atomIndex);
                break;
            }
            case 7: {
                BitSet bs = new BitSet();
                bs.set(atomIndex);
                this.viewer.setCenterBitSet(bs, false);
                break;
            }
            case 10: {
                this.applyMouseStyle(atomIndex, shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 11: {
                BitSet bsGroup = frame.getGroupBitSet(atomIndex);
                this.applyMouseStyle(bsGroup, shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 12: {
                BitSet bsChain = frame.getChainBitSet(atomIndex);
                this.applyMouseStyle(bsChain, shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 14: {
                BitSet bsMolecule = frame.getMoleculeBitSet(atomIndex);
                this.applyMouseStyle(bsMolecule, shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 13: {
                if (this.viewer.getSpinOn()) {
                    this.viewer.setSpinOn(false);
                    break;
                }
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                if (this.queuedAtomCount == 1 && this.queuedAtomIndexes[0] == atomIndex) break;
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) {
                    this.viewer.setSpinOn(false);
                    this.viewer.scriptStatus(GT._("pick " + (this.queuedAtomCount == 1 ? "one more" : "two ") + " atoms in order to spin the model around an axis"));
                    break;
                }
                this.viewer.startSpinningAxis(this.queuedAtomIndexes[0], atomIndex, false);
            }
        }
    }

    void applyMouseStyle(int atomIndex, boolean shiftKey, boolean alternateKey) {
        if (this.pickingStyle == 2) {
            if (shiftKey && alternateKey) {
                this.viewer.removeSelection(atomIndex);
            } else if (shiftKey) {
                this.viewer.toggleSelection(atomIndex);
            } else if (alternateKey) {
                this.viewer.addSelection(atomIndex);
            } else {
                this.viewer.setSelection(atomIndex);
            }
        } else if (shiftKey | this.pickingStyle == 0) {
            this.viewer.toggleSelection(atomIndex);
        } else {
            this.viewer.setSelection(atomIndex);
        }
        this.reportSelection();
    }

    void applyMouseStyle(BitSet bs, boolean shiftKey, boolean alternateKey) {
        if (this.pickingStyle == 2) {
            if (shiftKey && alternateKey) {
                this.viewer.removeSelection(bs);
            } else if (shiftKey) {
                this.viewer.toggleSelectionSet(bs);
            } else if (alternateKey) {
                this.viewer.addSelection(bs);
            } else {
                this.viewer.setSelectionSet(bs);
            }
        } else if (shiftKey | this.pickingStyle == 0) {
            this.viewer.toggleSelectionSet(bs);
        } else {
            this.viewer.setSelectionSet(bs);
        }
        this.reportSelection();
    }

    void reportSelection() {
        this.viewer.reportSelection("" + this.viewer.getSelectionCount() + " " + GT._("atoms selected"));
    }

    void setPickingMode(int pickingMode) {
        this.pickingMode = pickingMode;
        this.queuedAtomCount = 0;
        Logger.debug("setPickingMode(" + pickingMode + ":" + JmolConstants.pickingModeNames[pickingMode] + ")");
    }

    boolean setPickingStyle(String style) {
        int pickingStyle = -1;
        int i = JmolConstants.pickingStyleNames.length;
        while (--i >= 0) {
            if (!style.equalsIgnoreCase(JmolConstants.pickingStyleNames[i])) continue;
            pickingStyle = i;
        }
        if (pickingStyle < 0) {
            return false;
        }
        this.pickingStyle = pickingStyle;
        this.queuedAtomCount = 0;
        Logger.debug("setPickingStyle(" + pickingStyle + ":" + JmolConstants.pickingStyleNames[pickingStyle] + ")");
        return true;
    }

    void queueAtom(int atomIndex) {
        this.queuedAtomIndexes[this.queuedAtomCount++] = atomIndex;
        this.viewer.setStatusAtomPicked(atomIndex, "Atom #" + this.queuedAtomCount + ":" + this.viewer.getAtomInfo(atomIndex));
    }
}

