/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;
import org.jmol.smiles.SmilesParser;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Viewer;

class PatternMatcher {
    private int atomCount = 0;
    private Frame frame = null;

    PatternMatcher(Viewer viewer) {
        this.frame = viewer.getFrame();
        this.atomCount = viewer.getAtomCount();
    }

    BitSet getSubstructureSet(String smiles) throws InvalidSmilesException {
        SmilesParser parser = new SmilesParser();
        SmilesMolecule pattern = parser.parseSmiles(smiles);
        return this.getSubstructureSet(pattern);
    }

    BitSet getSubstructureSet(SmilesMolecule pattern) {
        BitSet bsSubstructure = new BitSet();
        this.searchMatch(bsSubstructure, pattern, 0);
        return bsSubstructure;
    }

    private void searchMatch(BitSet bs, SmilesMolecule pattern, int atomNum) {
        int i;
        SmilesAtom patternAtom = pattern.getAtom(atomNum);
        for (i = 0; i < patternAtom.getBondsCount(); ++i) {
            SmilesBond patternBond = patternAtom.getBond(i);
            if (patternBond.getAtom2() != patternAtom) continue;
            int matchingAtom = patternBond.getAtom1().getMatchingAtom();
            Atom atom = this.frame.getAtomAt(matchingAtom);
            Bond[] bonds = atom.getBonds();
            if (bonds != null) {
                for (int j = 0; j < bonds.length; ++j) {
                    if (bonds[j].getAtom1().atomIndex == matchingAtom) {
                        this.searchMatch(bs, pattern, patternAtom, atomNum, bonds[j].getAtom2().atomIndex);
                    }
                    if (bonds[j].getAtom2().atomIndex != matchingAtom) continue;
                    this.searchMatch(bs, pattern, patternAtom, atomNum, bonds[j].getAtom1().atomIndex);
                }
            }
            return;
        }
        for (i = 0; i < this.atomCount; ++i) {
            this.searchMatch(bs, pattern, patternAtom, atomNum, i);
        }
    }

    private void searchMatch(BitSet bs, SmilesMolecule pattern, SmilesAtom patternAtom, int atomNum, int i) {
        for (int j = 0; j < atomNum; ++j) {
            SmilesAtom previousAtom = pattern.getAtom(j);
            if (previousAtom.getMatchingAtom() != i) continue;
            return;
        }
        boolean canMatch = true;
        Atom atom = this.frame.getAtomAt(i);
        if (patternAtom.getSymbol() != "*" && patternAtom.getSymbol() != atom.getElementSymbol()) {
            canMatch = false;
        }
        if (patternAtom.getCharge() != atom.getFormalCharge()) {
            canMatch = false;
        }
        for (int j = 0; j < patternAtom.getBondsCount(); ++j) {
            SmilesBond patternBond = patternAtom.getBond(j);
            if (patternBond.getAtom2() != patternAtom) continue;
            int matchingAtom = patternBond.getAtom1().getMatchingAtom();
            Bond[] bonds = atom.getBonds();
            boolean bondFound = false;
            block9: for (int k = 0; k < bonds.length; ++k) {
                if (bonds[k].getAtom1().atomIndex != matchingAtom && bonds[k].getAtom2().atomIndex != matchingAtom) continue;
                switch (patternBond.getBondType()) {
                    case 4: {
                        if ((bonds[k].getOrder() & 4) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 2: {
                        if ((bonds[k].getOrder() & 2) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if ((bonds[k].getOrder() & 1) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case 3: {
                        if ((bonds[k].getOrder() & 3) == 0) continue block9;
                        bondFound = true;
                        continue block9;
                    }
                    case -1: {
                        bondFound = true;
                    }
                }
            }
            if (bondFound) continue;
            canMatch = false;
        }
        if (canMatch) {
            patternAtom.setMatchingAtom(i);
            if (atomNum + 1 < pattern.getAtomsCount()) {
                this.searchMatch(bs, pattern, atomNum + 1);
            } else {
                for (int k = 0; k < pattern.getAtomsCount(); ++k) {
                    SmilesAtom matching = pattern.getAtom(k);
                    bs.set(matching.getMatchingAtom());
                }
            }
            patternAtom.setMatchingAtom(-1);
        }
    }
}

