/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.NumberFormat;
import org.jmol.viewer.IsosurfaceRenderer;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MolecularOrbital;

class MolecularOrbitalRenderer
extends IsosurfaceRenderer {
    NumberFormat nf;
    byte fid;

    MolecularOrbitalRenderer() {
    }

    void render() {
        MolecularOrbital mo = (MolecularOrbital)this.shape;
        int i = mo.meshCount;
        while (--i >= 0) {
            if (!this.render1(mo.meshes[i])) continue;
            this.renderInfo(mo.meshes[i]);
        }
    }

    void renderInfo(Mesh mesh) {
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.fid = this.g3d.getFontFid("Monospaced", 14);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        short colix = this.viewer.getColixBackgroundContrast();
        this.g3d.setFont(this.fid);
        int line = 15;
        int lineheight = 15;
        if (mesh.title != null) {
            for (int i = 0; i < mesh.title.length; ++i) {
                if (mesh.title[i].length() <= 0) continue;
                this.g3d.drawString(mesh.title[i], colix, 5, line, 0);
                line += lineheight;
            }
        }
    }

    String nfformat(float x) {
        if (this.nf == null) {
            return "" + x;
        }
        return this.nf.format(x);
    }
}

