/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point4f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;

class MolecularOrbital
extends Isosurface {
    String moTranslucency = null;
    Point4f moPlane = null;
    Float moCutoff = new Float(0.05f);
    Float moResolution = null;
    Integer moColorPos = null;
    Integer moColorNeg = null;
    Integer moIndex = null;
    Float moRed = null;
    Float moBlue = null;
    int myColorPt;

    MolecularOrbital() {
    }

    void initShape() {
        super.setProperty("thisID", "mo", null);
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("MolecularOrbital.setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.myColorPt = 0;
            super.setProperty("init", null, null);
            return;
        }
        if ("cutoff" == propertyName) {
            this.moCutoff = (Float)value;
            return;
        }
        if ("resolution" == propertyName) {
            this.moResolution = (Float)value;
            return;
        }
        if ("colorRGB" == propertyName) {
            this.moColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            return;
        }
        if ("plane" == propertyName) {
            this.moPlane = (Point4f)value;
            return;
        }
        if ("translucency" == propertyName) {
            this.moTranslucency = (String)value;
        }
        if ("moData" == propertyName) {
            String strID = "mo_model" + (this.viewer.getDisplayModelIndex() + 1);
            super.setProperty("reset", strID, null);
            if (this.moResolution != null) {
                super.setProperty("resolution", this.moResolution, null);
            }
            if (this.moPlane != null) {
                super.setProperty("plane", this.moPlane, null);
                if (this.moCutoff != null) {
                    super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                    super.setProperty("blue", this.moCutoff, null);
                }
            } else {
                if (this.moCutoff != null) {
                    super.setProperty("cutoff", this.moCutoff, null);
                }
                if (this.moColorNeg != null) {
                    super.setProperty("colorRGB", this.moColorNeg, null);
                }
                if (this.moColorPos != null) {
                    super.setProperty("colorRGB", this.moColorPos, null);
                }
            }
            super.setProperty("moData", value, null);
            if (this.moTranslucency != null) {
                super.setProperty("translucency", this.moTranslucency, null);
            }
            return;
        }
        super.setProperty(propertyName, value, bs);
    }
}

