/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Dipoles;
import org.jmol.viewer.Draw;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.MeshCollection;
import org.jmol.viewer.Model;
import org.jmol.viewer.Polyhedra;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Viewer;

class ModelManager {
    final Viewer viewer;
    final JmolAdapter adapter;
    String fullPathName;
    String fileName;
    String modelSetName;
    boolean haveFile = false;
    Frame frame;
    private final Point3f pointT = new Point3f();
    boolean autoBond = true;
    float bondTolerance = 0.45f;
    float minBondDistance = 0.4f;
    int[] shapeSizes = new int[29];
    Hashtable[] shapeProperties = new Hashtable[29];
    private static final Object NULL_SURROGATE = new Object();
    static final String[] pdbRecords = new String[]{"ATOM  ", "HELIX ", "SHEET ", "TURN  ", "MODEL ", "SCALE", "HETATM", "SEQRES", "DBREF "};

    ModelManager(Viewer viewer, JmolAdapter adapter) {
        this.viewer = viewer;
        this.adapter = adapter;
    }

    void setClientFile(String fullPathName, String fileName, Object clientFile) {
        if (clientFile == null) {
            this.modelSetName = null;
            fileName = null;
            fullPathName = null;
            this.frame = null;
            this.haveFile = false;
        } else {
            this.fullPathName = fullPathName;
            this.fileName = fileName;
            this.modelSetName = this.adapter.getAtomSetCollectionName(clientFile);
            if (this.modelSetName != null) {
                this.modelSetName = this.modelSetName.trim();
                if (this.modelSetName.length() == 0) {
                    this.modelSetName = null;
                }
            }
            if (this.modelSetName == null) {
                this.modelSetName = this.reduceFilename(fileName);
            }
            this.frame = new Frame(this.viewer, this.adapter, clientFile);
            this.haveFile = true;
        }
    }

    String reduceFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        int ichDot = fileName.indexOf(46);
        if (ichDot > 0) {
            fileName = fileName.substring(0, ichDot);
        }
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 20) + " ...";
        }
        return fileName;
    }

    String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return this.adapter.getClientAtomStringProperty(clientAtom, propertyName);
    }

    Frame getFrame() {
        return this.frame;
    }

    JmolAdapter getExportJmolAdapter() {
        return this.frame == null ? null : this.frame.getExportJmolAdapter();
    }

    String getModelSetName() {
        return this.modelSetName;
    }

    String getModelSetFileName() {
        return this.fileName;
    }

    String getModelSetPathName() {
        return this.fullPathName;
    }

    Properties getModelSetProperties() {
        return this.frame == null ? null : this.frame.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.frame == null ? null : this.frame.getModelSetProperty(propertyName);
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.frame == null ? null : this.frame.getModelSetAuxiliaryInfo();
    }

    Object getModelSetAuxiliaryInfo(String keyName) {
        return this.frame == null ? null : this.frame.getModelSetAuxiliaryInfo(keyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.frame == null ? false : this.frame.modelSetHasVibrationVectors();
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        return this.frame == null ? false : this.frame.modelHasVibrationVectors(modelIndex);
    }

    String getModelSetTypeName() {
        return this.frame == null ? null : this.frame.getModelSetTypeName();
    }

    boolean isPDB() {
        return this.frame == null ? false : this.frame.isPDB;
    }

    boolean isPDB(int modelIndex) {
        return this.frame == null ? false : this.frame.mmset.getModel((int)modelIndex).isPDB;
    }

    int getModelCount() {
        return this.frame == null ? 0 : this.frame.getModelCount();
    }

    String getModelInfoAsString() {
        int modelCount = this.getModelCount();
        String str = "model count = " + modelCount + "\nmodelSetHasVibrationVectors:" + this.modelSetHasVibrationVectors();
        Properties props = this.getModelSetProperties();
        str = str.concat(this.listProperties(props));
        for (int i = 0; i < modelCount; ++i) {
            str = str.concat("\n" + i + ":" + this.getModelNumber(i) + ":" + this.getModelName(i) + "\nmodelHasVibrationVectors:" + this.modelHasVibrationVectors(i));
        }
        return str;
    }

    String getSymmetryInfoAsString() {
        if (this.frame == null) {
            return "";
        }
        int modelCount = this.getModelCount();
        String str = "Symmetry Information:";
        for (int i = 0; i < modelCount; ++i) {
            str = str + "\nmodel #" + this.getModelNumber(i) + "; name=" + this.getModelName(i) + "\n" + this.frame.getSymmetryInfoAsString(i);
        }
        return str;
    }

    String getModelName(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelName(modelIndex);
    }

    int getModelNumber(int modelIndex) {
        return this.frame == null ? -1 : this.frame.getModelNumber(modelIndex);
    }

    Properties getModelProperties(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.frame == null ? null : this.frame.getModelProperty(modelIndex, propertyName);
    }

    Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelAuxiliaryInfo(modelIndex);
    }

    Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.frame == null ? null : this.frame.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.frame == null ? -1 : this.frame.getModelNumberIndex(modelNumber);
    }

    boolean hasVibrationVectors() {
        return this.frame.hasVibrationVectors();
    }

    float getRotationRadius() {
        return this.frame == null ? 1.0f : this.frame.getRotationRadius();
    }

    Point3f getSpinCenter(String axisID, int modelIndex) {
        Draw draw = (Draw)this.frame.shapes[28];
        if (draw == null) {
            return null;
        }
        int meshIndex = draw.getIndexFromName(axisID);
        if (meshIndex < 0) {
            return null;
        }
        return draw.meshes[meshIndex].getSpinCenter(modelIndex);
    }

    Vector3f getSpinAxis(String axisID, int modelIndex) {
        Draw draw = (Draw)this.frame.shapes[28];
        if (draw == null) {
            return null;
        }
        int meshIndex = draw.getIndexFromName(axisID);
        if (meshIndex < 0) {
            return null;
        }
        return draw.meshes[meshIndex].getSpinAxis(modelIndex);
    }

    void increaseRotationRadius(float increaseInAngstroms) {
        if (this.frame != null) {
            this.frame.increaseRotationRadius(increaseInAngstroms);
        }
    }

    Point3f getBoundBoxCenter() {
        return this.frame == null ? null : this.frame.getBoundBoxCenter();
    }

    Vector3f getBoundBoxCornerVector() {
        return this.frame == null ? null : this.frame.getBoundBoxCornerVector();
    }

    Point3f getAtomSetCenter(BitSet bs) {
        return this.frame == null ? null : this.frame.getAtomSetCenter(bs);
    }

    int firstAtomOf(BitSet bs) {
        return this.frame == null ? -1 : this.frame.firstAtomOf(bs);
    }

    BitSet getAtomBits(String setType) {
        return this.frame == null ? null : this.frame.getAtomBits(setType);
    }

    BitSet getAtomBits(String setType, String specInfo) {
        return this.frame == null ? null : this.frame.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int specInfo) {
        return this.frame == null ? null : this.frame.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        return this.frame == null ? null : this.frame.getAtomBits(setType, specInfo);
    }

    int getChainCount() {
        return this.frame == null ? 0 : this.frame.getChainCount();
    }

    int getChainCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getChainCountInModel(modelIndex);
    }

    int getGroupCount() {
        return this.frame == null ? 0 : this.frame.getGroupCount();
    }

    int getGroupCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getGroupCountInModel(modelIndex);
    }

    int getPolymerCount() {
        return this.frame == null ? 0 : this.frame.getPolymerCount();
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getPolymerCountInModel(modelIndex);
    }

    int getAtomCount() {
        return this.frame == null ? 0 : this.frame.getAtomCount();
    }

    int getBondCount() {
        return this.frame == null ? 0 : this.frame.getBondCount();
    }

    int getMoleuleCount() {
        return this.frame == null ? 0 : this.frame.getMoleculeCount();
    }

    int getAtomCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getAtomCountInModel(modelIndex);
    }

    int getBondCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getBondCountInModel(modelIndex);
    }

    Point3f getRotationCenter() {
        return this.frame == null ? null : this.frame.getRotationCenter();
    }

    Point3f getRotationCenterDefault() {
        return this.frame == null ? null : this.frame.getRotationCenterDefault();
    }

    Point3f setCenterBitSet(BitSet bsCenter, boolean doScale) {
        if (this.frame == null) {
            return new Point3f(0.0f, 0.0f, 0.0f);
        }
        Point3f center = null;
        if (bsCenter != null) {
            int countSelected = 0;
            center = this.pointT;
            center.set(0.0f, 0.0f, 0.0f);
            int i = this.getAtomCount();
            while (--i >= 0) {
                if (!bsCenter.get(i)) continue;
                ++countSelected;
                center.add(this.frame.getAtomPoint3f(i));
            }
            if (countSelected > 0) {
                center.scale(1.0f / (float)countSelected);
            } else {
                center = null;
            }
        }
        if (center == null) {
            center = this.frame.getRotationCenterDefault();
        }
        this.setNewRotationCenter(center, doScale);
        return center;
    }

    void setNewRotationCenter(Point3f center, boolean doScale) {
        if (this.viewer.isWindowCentered()) {
            this.viewer.translateToXPercent(0.0f);
            this.viewer.translateToYPercent(0.0f);
            this.frame.setRotationCenterAndRadiusXYZ(center, true);
            if (doScale) {
                this.viewer.scaleFitToScreen();
            }
        } else {
            this.viewer.moveRotationCenter(center);
        }
    }

    Point3f setRotationCenterAndRadiusXYZ(Point3f center, boolean andRadius) {
        if (this.frame == null) {
            return null;
        }
        return this.frame.setRotationCenterAndRadiusXYZ(center, andRadius);
    }

    Point3f setRotationCenterAndRadiusXYZ(String relativeTo, Point3f pt) {
        if (this.frame == null) {
            return new Point3f(0.0f, 0.0f, 0.0f);
        }
        return this.frame.setRotationCenterAndRadiusXYZ(relativeTo, pt);
    }

    void rebond() {
        if (this.frame != null) {
            this.frame.rebond();
        }
    }

    void setAutoBond(boolean ab) {
        this.autoBond = ab;
    }

    void setBondTolerance(float bondTolerance) {
        this.bondTolerance = bondTolerance;
    }

    void setMinBondDistance(float minBondDistance) {
        this.minBondDistance = minBondDistance;
    }

    boolean frankClicked(int x, int y) {
        return this.getShapeSize(19) != 0 && this.frame.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        return this.frame == null ? -1 : this.frame.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubber) {
        return this.frame.findAtomsInRectangle(rectRubber);
    }

    void loadShape(int shapeID) {
        if (this.frame != null) {
            this.frame.loadShape(shapeID);
        }
    }

    void setShapeSize(int shapeType, int size, BitSet bsSelected) {
        this.shapeSizes[shapeType] = size;
        if (this.frame != null) {
            this.frame.setShapeSize(shapeType, size, bsSelected);
        }
    }

    int getShapeSize(int shapeType) {
        return this.shapeSizes[shapeType];
    }

    void setShapeProperty(int shapeType, String propertyName, Object value, BitSet bsSelected) {
        Hashtable<String, Object> props = this.shapeProperties[shapeType];
        if (props == null) {
            props = this.shapeProperties[shapeType] = new Hashtable<String, Object>();
        }
        propertyName = propertyName.intern();
        props.put(propertyName, value != null ? value : NULL_SURROGATE);
        if (this.frame != null) {
            this.frame.setShapeProperty(shapeType, propertyName, value, bsSelected);
        }
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        Hashtable props;
        Object value = null;
        if (this.frame != null) {
            value = this.frame.getShapeProperty(shapeType, propertyName, index);
        }
        if (value == null && (props = this.shapeProperties[shapeType]) != null && (value = props.get(propertyName)) == NULL_SURROGATE) {
            value = null;
            return null;
        }
        return value;
    }

    int getShapeIdFromObjectName(String objectName) {
        int i;
        for (i = 24; i < 29; ++i) {
            MeshCollection shape = (MeshCollection)this.frame.shapes[i];
            if (shape == null || shape.getIndexFromName(objectName) < 0) continue;
            return i;
        }
        i = 23;
        Dipoles dipoles = (Dipoles)this.frame.shapes[i];
        if (dipoles != null && dipoles.getIndexFromName(objectName) >= 0) {
            return i;
        }
        return -1;
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.frame == null ? -1 : this.frame.getAtomIndexFromAtomNumber(atomNumber);
    }

    BitSet getElementsPresentBitSet() {
        return this.frame == null ? null : this.frame.getElementsPresentBitSet();
    }

    BitSet getGroupsPresentBitSet() {
        return this.frame == null ? null : this.frame.getGroupsPresentBitSet();
    }

    BitSet getVisibleSet() {
        return this.frame == null ? null : this.frame.getVisibleSet();
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelAtomBitSet(modelIndex);
    }

    BitSet getModelBitSet(BitSet atomList) {
        return this.frame == null ? null : this.frame.getModelBitSet(atomList);
    }

    BitSet getMoleculeBitSet(int modelIndex) {
        return this.frame == null ? null : this.frame.getMoleculeBitSet(modelIndex);
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        if (this.frame != null) {
            this.frame.calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        if (this.frame != null) {
            this.frame.calcSelectedMonomersCount(bsSelected);
        }
    }

    void calcSelectedMoleculesCount(BitSet bsSelected) {
        if (this.frame != null) {
            this.frame.calcSelectedGroupsCount(bsSelected);
        }
    }

    String getAtomInfo(int i) {
        return this.frame.getAtomAt(i).getInfo();
    }

    String getElementSymbol(int i) {
        return this.frame.getAtomAt(i).getElementSymbol();
    }

    int getElementNumber(int i) {
        return this.frame.getAtomAt(i).getElementNumber();
    }

    String getAtomName(int i) {
        return this.frame.getAtomAt(i).getAtomName();
    }

    boolean getAtomVisibility(int i) {
        return this.frame.getAtomAt(i).isVisible();
    }

    int getAtomNumber(int i) {
        return this.frame.getAtomAt(i).getAtomNumber();
    }

    float getAtomX(int i) {
        return this.frame.getAtomAt(i).getAtomX();
    }

    float getAtomY(int i) {
        return this.frame.getAtomAt(i).getAtomY();
    }

    float getAtomZ(int i) {
        return this.frame.getAtomAt(i).getAtomZ();
    }

    Point3f getAtomPoint3f(int i) {
        return this.frame.getAtomAt(i).getPoint3f();
    }

    float getAtomRadius(int i) {
        return this.frame.getAtomAt(i).getRadius();
    }

    short getAtomColix(int i) {
        return this.frame.getAtomAt(i).getColix();
    }

    String getAtomChain(int i) {
        return "" + this.frame.getAtomAt(i).getChainID();
    }

    String getAtomSequenceCode(int i) {
        return this.frame.getAtomAt(i).getSeqcodeString();
    }

    int getAtomModelIndex(int i) {
        return this.frame.getAtomAt(i).getModelIndex();
    }

    Point3f getBondPoint3f1(int i) {
        return this.frame.getBondAt(i).getAtom1().getPoint3f();
    }

    Point3f getBondPoint3f2(int i) {
        return this.frame.getBondAt(i).getAtom2().getPoint3f();
    }

    float getBondRadius(int i) {
        return this.frame.getBondAt(i).getRadius();
    }

    short getBondOrder(int i) {
        return this.frame.getBondAt(i).getOrder();
    }

    float getBondLength(int i) {
        return this.getBondAtom1((int)i).point3f.distance(this.getBondAtom2((int)i).point3f);
    }

    Atom getBondAtom1(int i) {
        return this.frame.getBondAt(i).getAtom1();
    }

    Atom getBondAtom2(int i) {
        return this.frame.getBondAt(i).getAtom2();
    }

    short getBondColix1(int i) {
        return this.frame.getBondAt(i).getColix1();
    }

    short getBondColix2(int i) {
        return this.frame.getBondAt(i).getColix2();
    }

    int getBondModelIndex(int i) {
        Atom atom = this.frame.getBondAt(i).getAtom1();
        if (atom != null) {
            return atom.getModelIndex();
        }
        atom = this.frame.getBondAt(i).getAtom2();
        if (atom != null) {
            return atom.getModelIndex();
        }
        return 0;
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        Polymer polymer = this.frame.getPolymerAt(modelIndex, polymerIndex);
        return polymer.getLeadMidpoints();
    }

    BitSet getAtomsWithin(String withinWhat, BitSet bs) {
        if (this.frame == null) {
            return null;
        }
        if (withinWhat.equals("group")) {
            return this.withinGroup(bs);
        }
        if (withinWhat.equals("chain")) {
            return this.withinChain(bs);
        }
        if (withinWhat.equals("molecule")) {
            return this.withinMolecule(bs);
        }
        if (withinWhat.equals("model")) {
            return this.withinModel(bs);
        }
        return null;
    }

    BitSet withinGroup(BitSet bs) {
        Group groupLast = null;
        BitSet bsResult = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Group group;
            if (!bs.get(i) || (group = (atom = this.frame.getAtomAt(i)).getGroup()) == groupLast) continue;
            group.selectAtoms(bsResult);
            groupLast = group;
        }
        return bsResult;
    }

    BitSet withinChain(BitSet bs) {
        Chain chainLast = null;
        BitSet bsResult = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Chain chain;
            if (!bs.get(i) || (chain = (atom = this.frame.getAtomAt(i)).getChain()) == chainLast) continue;
            chain.selectAtoms(bsResult);
            chainLast = chain;
        }
        return bsResult;
    }

    BitSet withinMolecule(BitSet bs) {
        return this.frame.getMoleculeBitSet(bs);
    }

    BitSet withinModel(BitSet bs) {
        int modelIndexLast = -1;
        BitSet bsResult = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            int modelIndex;
            if (!bs.get(i) || (modelIndex = this.frame.getAtomAt(i).getModelIndex()) == modelIndexLast) continue;
            this.selectModelIndexAtoms(modelIndex, bsResult);
            modelIndexLast = modelIndex;
        }
        return bsResult;
    }

    void selectModelIndexAtoms(int modelIndex, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (frame.getAtomAt(i).getModelIndex() != modelIndex) continue;
            bsResult.set(i);
        }
    }

    BitSet getAtomsWithin(float distance, BitSet bs) {
        BitSet bsResult = new BitSet();
        int i = this.frame.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            Atom atom = this.frame.getAtomAt(i);
            AtomIterator iterWithin = this.frame.getWithinModelIterator(atom, distance);
            while (iterWithin.hasNext()) {
                bsResult.set(iterWithin.next().getAtomIndex());
            }
        }
        return bsResult;
    }

    BitSet getAtomsConnected(float min, float max, BitSet bs) {
        BitSet bsResult = new BitSet();
        int atomCount = this.getAtomCount();
        int[] nBonded = new int[atomCount];
        int bondCount = this.getBondCount();
        for (int ibond = 0; ibond < bondCount; ++ibond) {
            Bond bond = this.frame.bonds[ibond];
            if (bond.order <= 0) continue;
            if (bs.get(bond.atom1.atomIndex)) {
                int n = bond.atom2.atomIndex;
                nBonded[n] = nBonded[n] + 1;
            }
            if (!bs.get(bond.atom2.atomIndex)) continue;
            int n = bond.atom1.atomIndex;
            nBonded[n] = nBonded[n] + 1;
        }
        int i = atomCount;
        while (--i >= 0) {
            if (!((float)nBonded[i] >= min) || !((float)nBonded[i] <= max)) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    String getModelExtract(BitSet bs) {
        int i;
        String str = "";
        int atomCount = this.getAtomCount();
        int bondCount = this.getBondCount();
        int nAtoms = 0;
        int nBonds = 0;
        int[] atomMap = new int[atomCount];
        for (i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            atomMap[i] = ++nAtoms;
            str = str + this.getAtomRecordMOL(i);
        }
        for (i = 0; i < bondCount; ++i) {
            short order;
            if (!bs.get(this.frame.getBondAt((int)i).getAtom1().atomIndex) || !bs.get(this.frame.getBondAt((int)i).getAtom2().atomIndex) || (order = this.getBondOrder(i)) < 1 || order >= 3) continue;
            str = str + this.getBondRecordMOL(i, atomMap);
            ++nBonds;
        }
        if (nAtoms > 999 || nBonds > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        return this.rFill("   ", "" + nAtoms) + this.rFill("   ", "" + nBonds) + "  0  0  0\n" + str;
    }

    String getAtomRecordMOL(int i) {
        return this.rFill("          ", this.safeTruncate(this.getAtomX(i), 10)) + this.rFill("          ", this.safeTruncate(this.getAtomY(i), 10)) + this.rFill("          ", this.safeTruncate(this.getAtomZ(i), 10)) + " " + (this.getElementSymbol(i) + "  ").substring(0, 2) + "\n";
    }

    String getBondRecordMOL(int i, int[] atomMap) {
        Bond b = this.frame.getBondAt(i);
        return this.rFill("   ", "" + atomMap[b.getAtom1().atomIndex]) + this.rFill("   ", "" + atomMap[b.getAtom2().atomIndex]) + "  " + this.getBondOrder(i) + "\n";
    }

    private String rFill(String s1, String s2) {
        return s1.substring(0, s1.length() - s2.length()) + s2;
    }

    private String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    String getPDBHeader() {
        if (!this.frame.isPDB) {
            return "!Not a pdb file!\n" + this.getFileHeader();
        }
        String modelFile = this.viewer.getCurrentFileAsString();
        int ichMin = modelFile.length();
        int i = pdbRecords.length;
        while (--i >= 0) {
            int ichFound = -1;
            String strRecord = pdbRecords[i];
            if (modelFile.startsWith(strRecord)) {
                ichFound = 0;
            } else {
                String strSearch = "\n" + strRecord;
                ichFound = modelFile.indexOf(strSearch);
                if (ichFound >= 0) {
                    ++ichFound;
                }
            }
            if (ichFound < 0 || ichFound >= ichMin) continue;
            ichMin = ichFound;
        }
        return modelFile.substring(0, ichMin);
    }

    String getFileHeader() {
        String info = this.getModelSetProperty("fileHeader");
        if (info == null) {
            info = this.getModelSetName();
        }
        if (info != null) {
            return info;
        }
        if (this.frame.isPDB) {
            return this.getPDBHeader();
        }
        return "no header information found";
    }

    Hashtable getModelInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        if (this.frame == null) {
            return info;
        }
        int modelCount = this.viewer.getModelCount();
        info.put("modelSetName", this.getModelSetName());
        info.put("modelCount", new Integer(modelCount));
        info.put("modelSetHasVibrationVectors", new Boolean(this.viewer.modelSetHasVibrationVectors()));
        Properties props = this.viewer.getModelSetProperties();
        if (props != null) {
            info.put("modelSetProperties", props);
        }
        Vector models = new Vector();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Object> model = new Hashtable<String, Object>();
            model.put("_ipt", new Integer(i));
            model.put("num", new Integer(this.viewer.getModelNumber(i)));
            model.put("name", this.viewer.getModelName(i));
            model.put("vibrationVectors", new Boolean(this.viewer.modelHasVibrationVectors(i)));
            model.put("atomCount", new Integer(this.getAtomCountInModel(i)));
            model.put("bondCount", new Integer(this.getBondCountInModel(i)));
            model.put("groupCount", new Integer(this.getGroupCountInModel(i)));
            model.put("polymerCount", new Integer(this.getPolymerCountInModel(i)));
            model.put("chainCount", new Integer(this.getChainCountInModel(i)));
            props = this.viewer.getModelProperties(i);
            if (props != null) {
                model.put("modelProperties", props);
            }
            models.add(model);
        }
        info.put("models", models);
        return info;
    }

    Hashtable getAuxiliaryInfo() {
        Hashtable info = new Hashtable();
        if (this.frame == null) {
            return info;
        }
        info = this.getModelSetAuxiliaryInfo();
        if (info == null) {
            return info;
        }
        Vector<Hashtable> models = new Vector<Hashtable>();
        int modelCount = this.viewer.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable modelinfo = this.getModelAuxiliaryInfo(i);
            models.add(modelinfo);
        }
        info.put("models", models);
        return info;
    }

    Vector getAllAtomInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        int atomCount = this.viewer.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            V.add(this.getAtomInfoLong(i));
        }
        return V;
    }

    Vector getMoleculeInfo(BitSet bsAtoms) {
        return this.frame.getMoleculeInfo(bsAtoms);
    }

    void getAtomIdentityInfo(int i, Hashtable info) {
        info.put("_ipt", new Integer(i));
        info.put("atomno", new Integer(this.getAtomNumber(i)));
        info.put("info", this.getAtomInfo(i));
        info.put("sym", this.getElementSymbol(i));
    }

    Hashtable getAtomInfoLong(int i) {
        Atom atom = this.frame.getAtomAt(i);
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(i, info);
        info.put("elemno", new Integer(atom.getElementNumber()));
        info.put("x", new Float(this.getAtomX(i)));
        info.put("y", new Float(this.getAtomY(i)));
        info.put("z", new Float(this.getAtomZ(i)));
        if (this.frame.vibrationVectors != null && this.frame.vibrationVectors[i] != null) {
            info.put("vibVector", new Vector3f(this.frame.vibrationVectors[i]));
        }
        info.put("bondCount", new Integer(atom.getCovalentBondCount()));
        info.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        info.put("model", new Integer(atom.getModelTagNumber()));
        info.put("visible", new Boolean(this.getAtomVisibility(i)));
        info.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        info.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        info.put("spacefill", new Integer(atom.madAtom >> 3));
        String strColor = this.viewer.getHexColorFromIndex(atom.colixAtom);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(atom.colixAtom));
        boolean isTranslucent = atom.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", new Boolean(isTranslucent));
        }
        info.put("formalCharge", new Integer(atom.getFormalCharge()));
        info.put("partialCharge", new Float(atom.getPartialCharge()));
        if (this.isPDB(atom.modelIndex)) {
            char ch;
            info.put("resname", atom.getGroup3());
            info.put("resno", atom.getSeqcodeString());
            char chainID = atom.getChainID();
            info.put("name", this.getAtomName(i));
            info.put("chain", chainID == '\u0000' ? "" : "" + chainID);
            info.put("atomID", new Integer(atom.getSpecialAtomID()));
            info.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != 0) {
                info.put("altLocation", new String("" + atom.alternateLocationID));
            }
            if ((ch = atom.getInsertionCode()) != '\u0000') {
                info.put("insertionCode", new String("" + ch));
            }
            info.put("structure", new Integer(atom.getProteinStructureType()));
            info.put("polymerLength", new Integer(atom.getPolymerLength()));
            info.put("occupancy", new Integer(atom.getOccupancy()));
            int temp = atom.getBfactor100();
            info.put("temp", new Integer(temp < 0 ? 0 : temp / 100));
        }
        return info;
    }

    Vector getAllBondInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        int bondCount = this.viewer.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            if (!bs.get(this.frame.getBondAt((int)i).getAtom1().atomIndex) || !bs.get(this.frame.getBondAt((int)i).getAtom2().atomIndex)) continue;
            V.add(this.getBondInfo(i));
        }
        return V;
    }

    Hashtable getBondInfo(int i) {
        Bond bond = this.frame.getBondAt(i);
        Atom atom1 = this.getBondAtom1(i);
        Atom atom2 = this.getBondAtom2(i);
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("_bpt", new Integer(i));
        Hashtable infoA = new Hashtable();
        this.getAtomIdentityInfo(atom1.atomIndex, infoA);
        Hashtable infoB = new Hashtable();
        this.getAtomIdentityInfo(atom2.atomIndex, infoB);
        info.put("atom1", infoA);
        info.put("atom2", infoB);
        info.put("order", new Integer(this.getBondOrder(i)));
        info.put("radius", new Float((double)bond.mad / 2000.0));
        info.put("length_Ang", new Float(this.getBondLength(i)));
        info.put("visible", new Boolean(bond.shapeVisibilityFlags != 0));
        String strColor = this.viewer.getHexColorFromIndex(bond.colix);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(bond.colix));
        boolean isTranslucent = bond.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", new Boolean(isTranslucent));
        }
        return info;
    }

    String listProperties(Properties props) {
        String str = "";
        if (props == null) {
            str = str.concat("\nProperties: null");
        } else {
            Enumeration<?> e = props.propertyNames();
            str = str.concat("\nProperties:");
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                str = str.concat("\n " + propertyName + "=" + props.getProperty(propertyName));
            }
        }
        return str;
    }

    Hashtable listPropertiesAsObject(Properties props) {
        Hashtable<String, String> info = new Hashtable<String, String>();
        if (props == null) {
            return info;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            info.put(propertyName, props.getProperty(propertyName));
        }
        return info;
    }

    Hashtable getAllChainInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        int modelCount = this.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector info = this.getChainInfo(i, bs);
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("chains", info);
            modelVector.add(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    Vector getChainInfo(int modelIndex, BitSet bs) {
        Model model = this.frame.mmset.getModel(modelIndex);
        int nChains = model.getChainCount();
        Vector infoChains = new Vector();
        for (int i = 0; i < nChains; ++i) {
            Chain chain = model.getChain(i);
            Vector infoChain = new Vector();
            int nGroups = chain.getGroupCount();
            Hashtable arrayName = new Hashtable();
            for (int igroup = 0; igroup < nGroups; ++igroup) {
                Group group = chain.getGroup(igroup);
                if (!bs.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> infoGroup = new Hashtable<String, Object>();
                infoGroup.put("groupIndex", new Integer(igroup));
                infoGroup.put("groupID", new Short(group.getGroupID()));
                infoGroup.put("seqCode", group.getSeqcodeString());
                infoGroup.put("_apt1", new Integer(group.firstAtomIndex));
                infoGroup.put("_apt2", new Integer(group.lastAtomIndex));
                infoGroup.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex));
                infoGroup.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex));
                infoGroup.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                infoChain.add(infoGroup);
            }
            if (infoChain.isEmpty()) continue;
            arrayName.put("residues", infoChain);
            infoChains.add(arrayName);
        }
        return infoChains;
    }

    Hashtable getAllPolymerInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        int modelCount = this.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector<Hashtable> info = new Vector<Hashtable>();
            int polymerCount = this.getPolymerCountInModel(i);
            for (int ip = 0; ip < polymerCount; ++ip) {
                Hashtable polyInfo = this.getPolymerInfo(i, ip, bs);
                if (polyInfo.isEmpty()) continue;
                info.add(polyInfo);
            }
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("polymers", info);
            modelVector.add(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    Hashtable getPolymerInfo(int iModel, int iPolymer, BitSet bs) {
        Hashtable returnInfo = new Hashtable();
        Vector<Hashtable> info = new Vector<Hashtable>();
        Polymer polymer = this.frame.mmset.getModel(iModel).getPolymer(iPolymer);
        int monomerCount = polymer.monomerCount;
        for (int i = 0; i < monomerCount; ++i) {
            if (!bs.get(polymer.monomers[i].getLeadAtomIndex())) continue;
            Hashtable monomerInfo = polymer.monomers[i].getMyInfo();
            monomerInfo.put("monomerIndex", new Integer(i));
            info.add(monomerInfo);
        }
        if (info.size() > 0) {
            returnInfo.put("monomers", info);
        }
        return returnInfo;
    }

    Hashtable getAllStateInfo(BitSet bs) {
        Hashtable<String, Cloneable> stateInfo = new Hashtable<String, Cloneable>();
        Vector V = new Vector();
        int atomCount = this.viewer.getAtomCount();
        int colix = -1;
        int lastColix = -1;
        int shapeVisibilityFlags = 0;
        int lastVisibilityFlags = -1;
        short mad = 0;
        short lastMad = -1;
        short defaultMadCode = this.viewer.getMadAtom();
        boolean isFirst = true;
        Hashtable<String, Hashtable> elementInfo = new Hashtable<String, Hashtable>();
        for (int i = 0; i < atomCount; ++i) {
            String value;
            if (!bs.get(i)) continue;
            boolean isChanged = false;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            Atom atom = this.frame.getAtomAt(i);
            String element = this.getElementSymbol(i);
            if (!elementInfo.containsKey(element)) {
                Hashtable<String, String> Htable = new Hashtable<String, String>();
                Htable.put("mad", "" + atom.convertEncodedMad(defaultMadCode));
                elementInfo.put(element, Htable);
            }
            Hashtable thisElementInfo = (Hashtable)elementInfo.get(element);
            String str = "" + atom.madAtom;
            if (!str.equals(value = (String)thisElementInfo.get("mad"))) {
                thisElementInfo.put("mad", str);
                info.put("mad", new Integer(atom.madAtom));
                isChanged = true;
            }
            if (atom.colixAtom >= 0 && !(str = "" + atom.colixAtom).equals(value = (String)thisElementInfo.get("colix"))) {
                thisElementInfo.put("colix", str);
                info.put("colix", new Integer(atom.colixAtom));
                String strColor = this.viewer.getHexColorFromIndex(atom.colixAtom);
                if (strColor != null) {
                    info.put("color", strColor);
                }
                isChanged = true;
            }
            shapeVisibilityFlags = atom.shapeVisibilityFlags;
            if (isFirst || shapeVisibilityFlags != lastVisibilityFlags) {
                info.put("visibilityFlags", new Integer(shapeVisibilityFlags));
            }
            if (!info.isEmpty()) {
                info.put("element", element);
                info.put("_ipt", new Integer(i));
                V.add(info);
            }
            lastVisibilityFlags = shapeVisibilityFlags;
            isFirst = false;
            if (!isChanged) continue;
            elementInfo.put(element, thisElementInfo);
        }
        stateInfo.put("atomState", V);
        isFirst = true;
        V = new Vector();
        int bondCount = this.viewer.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            if (!bs.get(this.frame.getBondAt((int)i).getAtom1().atomIndex) || bs.get(this.frame.getBondAt((int)i).getAtom2().atomIndex)) continue;
            Bond bond = this.frame.getBondAt(i);
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            mad = bond.mad;
            if (isFirst || mad != lastMad) {
                info.put("mad", new Integer(mad));
            }
            colix = bond.colix;
            if (isFirst || colix >= 0 && colix != lastColix) {
                info.put("colix", new Integer(bond.colix));
                String strColor = this.viewer.getHexColorFromIndex(bond.colix);
                if (strColor != null) {
                    info.put("color", strColor);
                }
            }
            if (!info.isEmpty()) {
                info.put("_ipt", new Integer(i));
                V.add(info);
            }
            lastMad = mad;
            lastColix = colix;
            isFirst = false;
        }
        stateInfo.put("bondState", V);
        stateInfo.put("shapeInfo", this.getShapeInfo());
        stateInfo.put("modelInfo", this.getModelInfo());
        stateInfo.put("animationInfo", this.viewer.getAnimationInfo());
        stateInfo.put("polymerInfo", this.getAllPolymerInfo(bs));
        return stateInfo;
    }

    Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> info = new Hashtable<String, Tuple3f>();
        info.put("center", this.getBoundBoxCenter());
        info.put("edge", this.getBoundBoxCornerVector());
        return info;
    }

    void setModelVisibility() {
        if (this.frame == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int displayModelIndex = this.viewer.getDisplayModelIndex();
        boolean isOneFrame = displayModelIndex >= 0;
        boolean showHydrogens = this.viewer.getShowHydrogens();
        int ballVisibilityFlag = this.viewer.getShapeVisibilityFlag(0);
        int haloVisibilityFlag = this.viewer.getShapeVisibilityFlag(29);
        BitSet bs = this.viewer.getVisibleFramesBitSet();
        for (int i = 23; i < 29; ++i) {
            if (this.frame.shapes[i] == null) continue;
            this.frame.shapes[i].setVisibilityFlags(bs);
        }
        Polyhedra p = (Polyhedra)this.frame.shapes[22];
        if (p != null) {
            p.setVisibilityFlags(bs);
        }
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            atom.shapeVisibilityFlags &= 0xFFFFFFFE & ~ballVisibilityFlag & ~haloVisibilityFlag;
            if (atom.madAtom == Short.MIN_VALUE || !showHydrogens && atom.elementNumber == 1 || (isOneFrame || !bs.get(atom.modelIndex)) && atom.modelIndex != displayModelIndex) continue;
            atom.shapeVisibilityFlags |= 1;
            if (atom.madAtom != 0) {
                atom.shapeVisibilityFlags |= ballVisibilityFlag;
            }
            if (!this.viewer.hasSelectionHalo(atom.atomIndex)) continue;
            atom.shapeVisibilityFlags |= haloVisibilityFlag;
        }
    }

    void setModelClickability() {
        if (this.frame == null) {
            return;
        }
        for (int i = 0; i < 29; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    void checkObjectClicked(int x, int y, boolean isShiftDown) {
        if (this.frame == null) {
            return;
        }
        for (int i = 0; i < 29; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            shape.checkObjectClicked(x, y, isShiftDown);
        }
    }

    Hashtable getShapeInfo() {
        Hashtable info = new Hashtable();
        if (this.frame == null) {
            return info;
        }
        for (int i = 0; i < 29; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            String shapeType = JmolConstants.shapeClassBases[i];
            Hashtable<String, Serializable> shapeinfo = new Hashtable<String, Serializable>();
            shapeinfo.put("index", new Integer(i));
            shapeinfo.put("myVisibilityFlag", new Integer(shape.myVisibilityFlag));
            if ("Draw,Dipoles,Isosurface,LcaoOrbital,MolecularOrbital".indexOf(shapeType) >= 0) {
                shapeinfo.put("obj", shape.getShapeDetail());
            }
            info.put(shapeType, shapeinfo);
        }
        if (this.viewer.selectionHaloEnabled) {
            Hashtable<String, Integer> shapeinfo = new Hashtable<String, Integer>();
            shapeinfo.put("index", new Integer(29));
            shapeinfo.put("myVisibilityFlag", new Integer(this.viewer.getShapeVisibilityFlag(29)));
            info.put("halo", shapeinfo);
        }
        return info;
    }

    Point3f getAveragePosition(int atomIndex1, int atomIndex2) {
        return this.frame.getAveragePosition(atomIndex1, atomIndex2);
    }

    Vector3f getAtomVector(int atomIndex1, int atomIndex2) {
        return this.frame.getAtomVector(atomIndex1, atomIndex2);
    }

    Vector3f getModelDipole() {
        return this.frame == null ? null : this.frame.getModelDipole();
    }

    void getBondDipoles() {
        if (this.frame == null) {
            return;
        }
        this.frame.getBondDipoles();
    }

    boolean modelsHaveSymmetry() {
        return this.frame == null ? false : this.frame.someModelsHaveSymmetry;
    }

    void recalculateStructure(BitSet bsSelected) {
        if (this.frame == null) {
            return;
        }
        this.frame.recalculateStructure(bsSelected);
    }

    BitSet setConformation(int modelIndex, BitSet bsConformation) {
        this.frame.setConformation(modelIndex, bsConformation);
        return bsConformation;
    }

    BitSet setConformation(int modelIndex, int conformationIndex) {
        if (this.frame == null) {
            return null;
        }
        int modelCount = this.getModelCount();
        BitSet bsResult = new BitSet();
        int i = modelCount;
        while (--i >= 0) {
            if (i != modelIndex || modelIndex < 0) continue;
            String altLocs = this.frame.getAltLocListInModel(i);
            BitSet bsConformation = this.getModelAtomBitSet(i);
            if (conformationIndex >= 0) {
                int c = this.frame.getAltLocCountInModel(i);
                while (--c >= 0) {
                    if (c == conformationIndex) continue;
                    bsConformation.andNot(this.frame.getSpecAlternate(altLocs.substring(c, c + 1)));
                }
            }
            if (bsConformation.length() <= 0) continue;
            this.frame.setConformation(i, bsConformation);
            bsResult.or(bsConformation);
        }
        return bsResult;
    }

    void autoHbond(BitSet bsFrom, BitSet bsTo) {
        if (this.frame == null) {
            return;
        }
        this.frame.autoHbond(bsFrom, bsTo);
    }

    boolean hbondsAreVisible(int modelIndex) {
        if (this.frame == null) {
            return false;
        }
        int bondCount = this.getBondCount();
        Bond[] bonds = this.frame.bonds;
        int i = bondCount;
        while (--i >= 0) {
            if (modelIndex >= 0 && modelIndex != bonds[i].atom1.modelIndex || !bonds[i].isHydrogen() || bonds[i].mad <= 0) continue;
            return true;
        }
        return false;
    }

    void convertFractionalCoordinates(int modelIndex, Point3f pt) {
        this.frame.convertFractionalCoordinates(modelIndex, pt);
    }

    void clearBfactorRange() {
        if (this.frame == null) {
            return;
        }
        this.frame.clearBfactorRange();
    }

    void setZeroBased() {
        if (this.frame == null) {
            return;
        }
        this.frame.setZeroBased();
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        if (this.frame == null) {
            return;
        }
        this.frame.setAtomCoord(atomIndex, x, y, z);
    }

    void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        if (this.frame == null) {
            return;
        }
        this.frame.setAtomCoordRelative(atomIndex, x, y, z);
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoType, boolean hybridizationCompatible) {
        if (this.frame == null) {
            return false;
        }
        return this.frame.getPrincipalAxes(atomIndex, z, x, lcaoType, hybridizationCompatible);
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        if (this.frame == null) {
            return null;
        }
        return this.frame.getAdditionalHydrogens(atomSet);
    }
}

