/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.Model;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Util;

final class Mmset {
    Frame frame;
    Properties modelSetProperties;
    Hashtable modelSetAuxiliaryInfo;
    private int modelCount = 0;
    private String[] modelNames = new String[1];
    private int[] modelNumbers = new int[1];
    private Properties[] modelProperties = new Properties[1];
    private Hashtable[] modelAuxiliaryInfo = new Hashtable[1];
    private Model[] models = new Model[1];
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];

    Mmset(Frame frame) {
        this.frame = frame;
    }

    void defineStructure(int modelIndex, String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])Util.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(modelIndex, structureType, startChainID, Group.getSeqcode(startSequenceNumber, startInsertionCode), endChainID, Group.getSeqcode(endSequenceNumber, endInsertionCode));
    }

    void calculateStructures() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calculateStructures();
        }
    }

    void recalculateStructure(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].recalculateStructure(bsSelected);
        }
    }

    void setConformation(int modelIndex, BitSet bsConformation) {
        int i = this.modelCount;
        while (--i >= 0) {
            if (i != modelIndex && modelIndex >= 0) continue;
            this.models[i].setConformation(bsConformation);
        }
    }

    void freeze() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].freeze();
        }
        this.propogateSecondaryStructure();
    }

    void setModelSetProperties(Properties modelSetProperties) {
        this.modelSetProperties = modelSetProperties;
    }

    void setModelSetAuxiliaryInfo(Hashtable modelSetAuxiliaryInfo) {
        this.modelSetAuxiliaryInfo = modelSetAuxiliaryInfo;
    }

    Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    String getModelSetProperty(String propertyName) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(propertyName);
    }

    Object getModelSetAuxiliaryInfo(String keyName) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(keyName);
    }

    boolean getModelSetAuxiliaryInfoBoolean(String keyName) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(keyName) && (Boolean)this.modelSetAuxiliaryInfo.get(keyName) != false;
    }

    int getModelSetAuxiliaryInfoInt(String keyName) {
        if (this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(keyName)) {
            return (Integer)this.modelSetAuxiliaryInfo.get(keyName);
        }
        return Integer.MIN_VALUE;
    }

    void setModelCount(int modelCount) {
        if (this.modelCount != 0) {
            throw new NullPointerException();
        }
        this.modelCount = modelCount;
        this.models = (Model[])Util.setLength(this.models, modelCount);
        this.modelNames = Util.setLength(this.modelNames, modelCount);
        this.modelNumbers = Util.setLength(this.modelNumbers, modelCount);
        this.modelProperties = (Properties[])Util.setLength(this.modelProperties, modelCount);
        this.modelAuxiliaryInfo = (Hashtable[])Util.setLength(this.modelAuxiliaryInfo, modelCount);
    }

    int setSymmetryAtomInfo(int modelIndex, int atomIndex, int atomCount) {
        this.models[modelIndex].preSymmetryAtomIndex = atomIndex;
        this.models[modelIndex].preSymmetryAtomCount = atomCount;
        return this.models[modelIndex].preSymmetryAtomCount;
    }

    int getPreSymmetryAtomIndex(int modelIndex) {
        return this.models[modelIndex].preSymmetryAtomIndex;
    }

    int getPreSymmetryAtomCount(int modelIndex) {
        return this.models[modelIndex].preSymmetryAtomCount;
    }

    String getModelName(int modelIndex) {
        return this.modelNames[modelIndex];
    }

    int getModelNumber(int modelIndex) {
        return this.modelNumbers[modelIndex];
    }

    Properties getModelProperties(int modelIndex) {
        return this.modelProperties[modelIndex];
    }

    String getModelProperty(int modelIndex, String property) {
        Properties props = this.modelProperties[modelIndex];
        return props == null ? null : props.getProperty(property);
    }

    Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.modelAuxiliaryInfo[modelIndex];
    }

    Object getModelAuxiliaryInfo(int modelIndex, String key) {
        Hashtable info = this.modelAuxiliaryInfo[modelIndex];
        return info == null ? null : info.get(key);
    }

    boolean getModelAuxiliaryInfoBoolean(int modelIndex, String keyName) {
        Hashtable info = this.modelAuxiliaryInfo[modelIndex];
        return info != null && info.containsKey(keyName) && (Boolean)info.get(keyName) != false;
    }

    int getModelAuxiliaryInfoInt(int modelIndex, String keyName) {
        Hashtable info = this.modelAuxiliaryInfo[modelIndex];
        if (info != null && info.containsKey(keyName)) {
            return (Integer)info.get(keyName);
        }
        return Integer.MIN_VALUE;
    }

    Model getModel(int modelIndex) {
        return this.models[modelIndex];
    }

    int getModelNumberIndex(int modelNumber) {
        int i = this.modelCount;
        while (--i >= 0 && this.modelNumbers[i] != modelNumber) {
        }
        return i;
    }

    int getNAltLocs(int modelIndex) {
        return this.models[modelIndex].nAltLocs;
    }

    int getNInsertions(int modelIndex) {
        return this.models[modelIndex].nInsertions;
    }

    void setModelNameNumberProperties(int modelIndex, String modelName, int modelNumber, Properties modelProperties, Hashtable modelAuxiliaryInfo, boolean isPDB) {
        this.modelNames[modelIndex] = modelName;
        this.modelNumbers[modelIndex] = modelNumber;
        this.modelProperties[modelIndex] = modelProperties;
        this.modelAuxiliaryInfo[modelIndex] = modelAuxiliaryInfo;
        this.models[modelIndex] = new Model(this, modelIndex, modelName);
        String codes = (String)this.getModelAuxiliaryInfo(modelIndex, "altLocs");
        this.models[modelIndex].setNAltLocs(codes == null ? 0 : codes.length());
        codes = (String)this.getModelAuxiliaryInfo(modelIndex, "insertionCodes");
        this.models[modelIndex].setNInsertions(codes == null ? 0 : codes.length());
        this.models[modelIndex].isPDB = isPDB;
    }

    int getAltLocCountInModel(int modelIndex) {
        return this.models[modelIndex].nAltLocs;
    }

    private void propogateSecondaryStructure() {
        int i = this.structureCount;
        while (--i >= 0) {
            Structure structure = this.structures[i];
            int j = this.modelCount;
            while (--j >= 0) {
                if (structure.modelIndex != j && structure.modelIndex != -1) continue;
                this.models[j].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
            }
        }
    }

    int getModelCount() {
        return this.modelCount;
    }

    Model[] getModels() {
        return this.models;
    }

    int getChainCount() {
        int chainCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            chainCount += this.models[i].getChainCount();
        }
        return chainCount;
    }

    int getPolymerCount() {
        int polymerCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            polymerCount += this.models[i].getPolymerCount();
        }
        return polymerCount;
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.models[modelIndex].getPolymerCount();
    }

    int getChainCountInModel(int modelIndex) {
        return this.models[modelIndex].getChainCount();
    }

    Polymer getPolymerAt(int modelIndex, int polymerIndex) {
        return this.models[modelIndex].getPolymer(polymerIndex);
    }

    int getGroupCount() {
        int groupCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            groupCount += this.models[i].getGroupCount();
        }
        return groupCount;
    }

    int getGroupCountInModel(int modelIndex) {
        return this.models[modelIndex].getGroupCount();
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedMonomersCount(bsSelected);
        }
    }

    void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcHydrogenBonds(bsA, bsB);
        }
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].selectSeqcodeRange(seqcodeA, seqcodeB, bs);
        }
    }

    Vector getStructureInfo() {
        Vector<Hashtable> info = new Vector<Hashtable>();
        for (int i = 0; i < this.structureCount; ++i) {
            info.add(this.structures[i].toHashtable());
        }
        return info;
    }

    static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;

        Structure(int modelIndex, String typeName, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
            this.modelIndex = modelIndex;
            this.typeName = typeName;
            this.startChainID = startChainID;
            this.startSeqcode = startSeqcode;
            this.endChainID = endChainID;
            this.endSeqcode = endSeqcode;
            this.type = "helix".equals(typeName) ? (byte)3 : ("sheet".equals(typeName) ? (byte)2 : ("turn".equals(typeName) ? (byte)1 : 0));
        }

        Hashtable toHashtable() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("type", this.typeName);
            info.put("startChainID", this.startChainID + "");
            info.put("startSeqcode", new Integer(this.startSeqcode));
            info.put("endChainID", this.endChainID + "");
            info.put("endSeqcode", new Integer(this.endSeqcode));
            return info;
        }
    }
}

