/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.ShapeRenderer;

abstract class MeshRenderer
extends ShapeRenderer {
    boolean iShowTriangles;
    boolean iShowNormals;
    boolean iHideBackground;
    short backgroundColix;
    Point3f[] vertices;
    Point3i[] screens;
    float[] vertexValues;
    final Point3f ptTemp = new Point3f();
    final Point3i ptTempi = new Point3i();

    MeshRenderer() {
    }

    boolean render1(Mesh mesh) {
        if (mesh.visibilityFlags == 0 || !mesh.isValid) {
            return false;
        }
        int vertexCount = mesh.vertexCount;
        if (vertexCount == 0) {
            return false;
        }
        this.vertices = mesh.vertices;
        this.screens = this.viewer.allocTempScreens(vertexCount);
        this.vertexValues = mesh.vertexValues;
        int i = vertexCount;
        while (--i >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[i])) continue;
            this.viewer.transformPoint(this.vertices[i], this.screens[i]);
        }
        this.iShowTriangles = this.viewer.getTestFlag3();
        this.iShowNormals = this.viewer.getTestFlag4();
        boolean bl = this.iHideBackground = mesh.jvxlPlane != null && mesh.hideBackground;
        if (this.iHideBackground) {
            this.backgroundColix = Graphics3D.getColix(this.viewer.getBackgroundArgb());
        }
        if (mesh.showPoints) {
            this.renderPoints(mesh, this.screens, vertexCount);
        }
        if (this.iShowNormals) {
            this.renderNormals(mesh, this.screens, vertexCount);
        }
        if (mesh.drawTriangles) {
            this.renderTriangles(mesh, this.screens, false);
        }
        if (mesh.fillTriangles) {
            this.renderTriangles(mesh, this.screens, true);
        }
        this.viewer.freeTempScreens(this.screens);
        return true;
    }

    void renderPoints(Mesh mesh, Point3i[] screens, int vertexCount) {
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        int iCount = mesh.lastViewableVertex > 0 ? mesh.lastViewableVertex + 1 : vertexCount;
        int iFirst = mesh.firstViewableVertex;
        int i = iCount;
        while (--i >= iFirst) {
            if (this.vertexValues == null || Float.isNaN(this.vertexValues[i])) continue;
            this.g3d.fillSphereCentered(vertexColixes != null ? vertexColixes[i] : colix, 4, screens[i]);
        }
        if (mesh.hasGridPoints) {
            for (i = 0; i < iFirst; ++i) {
                this.g3d.fillSphereCentered((short)12, 2, screens[i]);
            }
        }
        if (mesh.hasGridPoints && !mesh.isContoured) {
            for (i = 1; i < vertexCount; i += 3) {
                this.g3d.fillCylinder((short)12, (byte)3, 1, screens[i], screens[i + 1]);
            }
        }
    }

    void renderNormals(Mesh mesh, Point3i[] screens, int vertexCount) {
        int i = vertexCount;
        while (--i >= 0) {
            if (this.vertexValues == null || Float.isNaN(this.vertexValues[i]) || i % 3 != 0) continue;
            this.ptTemp.set(mesh.vertices[i]);
            short n = mesh.normixes[i];
            if (n <= 0) continue;
            this.ptTemp.add(this.g3d.getNormixVector(n));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.fillCylinder((short)8, (byte)3, 1, screens[i], this.ptTempi);
        }
    }

    void renderTriangles(Mesh mesh, Point3i[] screens, boolean fill) {
        int[][] polygonIndexes = mesh.polygonIndexes;
        short[] normixes = mesh.normixes;
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        short hideColix = 0;
        try {
            hideColix = vertexColixes[mesh.polygonIndexes[0][0]];
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = mesh.polygonCount;
        while (--i >= 0) {
            short colixD;
            short colixC;
            short colixB;
            short colixA;
            int[] vertexIndexes;
            if (!mesh.isPolygonDisplayable(i) || (vertexIndexes = polygonIndexes[i]) == null) continue;
            int iA = vertexIndexes[0];
            int iB = vertexIndexes[1];
            int iC = vertexIndexes[2];
            if (vertexColixes != null) {
                colixA = vertexColixes[iA];
                colixB = vertexColixes[iB];
                colixC = vertexColixes[iC];
            } else {
                colixB = colixC = colix;
                colixA = colixC;
            }
            if (this.iHideBackground) {
                if (colixA == hideColix && colixB == hideColix && colixC == hideColix) continue;
                if (colixA == hideColix) {
                    colixA = this.backgroundColix;
                }
                if (colixB == hideColix) {
                    colixB = this.backgroundColix;
                }
                if (colixC == hideColix) {
                    colixC = this.backgroundColix;
                }
            }
            if (iB == iC) {
                this.g3d.fillCylinder(colixA, (byte)3, iA == iB ? 6 : 3, screens[iA], screens[iB]);
                continue;
            }
            if (vertexIndexes.length == 3) {
                if (fill) {
                    if (this.iShowTriangles) {
                        this.g3d.fillTriangleTest(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC]);
                        continue;
                    }
                    this.g3d.fillTriangle(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC]);
                    continue;
                }
                this.g3d.drawTriangle(colixA, screens[iA], screens[iB], screens[iC]);
                continue;
            }
            if (vertexIndexes.length != 4) continue;
            int iD = vertexIndexes[3];
            short s = colixD = vertexColixes != null ? vertexColixes[iD] : colix;
            if (fill) {
                this.g3d.fillQuadrilateral(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC], screens[iD], colixD, normixes[iD]);
                continue;
            }
            this.g3d.drawQuadrilateral(colixA, screens[iA], screens[iB], screens[iC], screens[iD]);
        }
    }
}

