/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class Mesh {
    Viewer viewer;
    String[] title = null;
    String thisID;
    boolean isValid = true;
    String jvxlFileHeader;
    String jvxlExtraLine;
    int jvxlCompressionRatio;
    String jvxlSurfaceData;
    String jvxlEdgeData;
    String jvxlColorData;
    boolean isJvxlPrecisionColor;
    Point4f jvxlPlane;
    String jvxlDefinitionLine;
    boolean isContoured;
    boolean isBicolorMap;
    float mappedDataMin;
    float mappedDataMax;
    float valueMappedToRed;
    float valueMappedToBlue;
    float cutoff;
    int nBytes;
    int nContours;
    boolean hasGridPoints;
    boolean hideBackground;
    int firstViewableVertex;
    int lastViewableVertex;
    boolean visible = true;
    short colix;
    short[] vertexColixes;
    Graphics3D g3d;
    int vertexCount;
    Point3f[] vertices;
    float[] vertexValues;
    short[] normixes;
    int polygonCount;
    int[][] polygonIndexes = null;
    int drawVertexCount;
    float scale = 1.0f;
    Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    Point3f[] ptCenters;
    Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    Vector3f[] axes;
    String meshType = null;
    String drawType = null;
    int modelIndex = -1;
    int visibilityFlags;
    int[] modelFlags = null;
    boolean showPoints = false;
    boolean drawTriangles = false;
    boolean fillTriangles = true;

    Mesh(Viewer viewer, String thisID, Graphics3D g3d, short colix) {
        this.viewer = viewer;
        this.thisID = thisID;
        this.g3d = g3d;
        this.colix = colix;
    }

    void clear(String meshType) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.vertices = null;
        this.vertexColixes = null;
        this.polygonIndexes = null;
        this.meshType = meshType;
    }

    void initialize() {
        this.initialize(true);
    }

    void initialize(boolean use2Sided) {
        Vector3f[] vectorSums = new Vector3f[this.vertexCount];
        int i = this.vertexCount;
        while (--i >= 0) {
            vectorSums[i] = new Vector3f();
        }
        this.sumVertexNormals(vectorSums);
        this.normixes = new short[this.vertexCount];
        if (use2Sided) {
            i = this.vertexCount;
            while (--i >= 0) {
                this.normixes[i] = this.g3d.get2SidedNormix(vectorSums[i]);
            }
        } else {
            i = this.vertexCount;
            while (--i >= 0) {
                this.normixes[i] = this.g3d.getNormix(vectorSums[i]);
            }
        }
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = this.colix;
            }
        }
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.setTranslucent(this.colix, isTranslucent);
        if (this.vertexColixes != null) {
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = Graphics3D.setTranslucent(this.vertexColixes[i], isTranslucent);
            }
        }
    }

    void sumVertexNormals(Vector3f[] vectorSums) {
        Vector3f vNormalizedNormal = new Vector3f();
        int i = this.polygonCount;
        while (--i >= 0) {
            int[] pi = this.polygonIndexes[i];
            try {
                if (pi == null) continue;
                this.g3d.calcNormalizedNormal(this.vertices[pi[0]], this.vertices[pi[1]], this.vertices[pi[2]], vNormalizedNormal);
                float l = vNormalizedNormal.length();
                if (!((double)l > 0.9) || !((double)l < 1.1)) continue;
                int j = pi.length;
                while (--j >= 0) {
                    int k = pi[j];
                    vectorSums[k].add(vNormalizedNormal);
                }
            }
            catch (Exception e) {
            }
        }
    }

    void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
        this.vertices = new Point3f[vertexCount];
        this.vertexValues = new float[vertexCount];
    }

    void setPolygonCount(int polygonCount) {
        this.polygonCount = polygonCount;
        if (this.polygonIndexes == null || polygonCount > this.polygonIndexes.length) {
            this.polygonIndexes = new int[polygonCount][];
        }
    }

    int addVertexCopy(Point3f vertex, float value) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[256];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = Util.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = value;
        return this.addVertexCopy(vertex);
    }

    int addVertexCopy(Point3f vertex) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[256];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])Util.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(vertex);
        return this.vertexCount++;
    }

    void invalidateVertex(int vertex) {
    }

    void addTriangle(int vertexA, int vertexB, int vertexC) {
        if (this.vertexValues != null && (Float.isNaN(this.vertexValues[vertexA]) || Float.isNaN(this.vertexValues[vertexB]) || Float.isNaN(this.vertexValues[vertexC]))) {
            return;
        }
        if (Float.isNaN(this.vertices[vertexA].x) || Float.isNaN(this.vertices[vertexB].x) || Float.isNaN(this.vertices[vertexC].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[256][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])Util.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC};
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void checkForDuplicatePoints(float cutoff) {
        float cutoff2 = cutoff * cutoff;
        int i = this.vertexCount;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                float dist2 = this.vertices[i].distanceSquared(this.vertices[j]);
                if (!(dist2 < cutoff2)) continue;
                Logger.debug("Mesh.checkForDuplicates " + this.vertices[i] + "<->" + this.vertices[j] + " : " + Math.sqrt(dist2));
            }
        }
    }

    Hashtable getShapeDetail() {
        return null;
    }

    final boolean isPolygonDisplayable(int index) {
        return this.modelFlags == null || this.modelFlags[index] != 0;
    }

    final int setPolygon(Point3f[] ptList, int nVertices, int nPoly, boolean isPlane, boolean isPerpendicular, boolean isRotated45, float length) {
        float dist;
        Point3f pt;
        Point3f center = new Point3f();
        Vector3f normal = new Vector3f();
        if (nVertices == 3 && isPlane && !isPerpendicular) {
            pt = new Point3f(ptList[1]);
            pt.sub(ptList[0]);
            pt.scale(0.5f);
            ptList[3] = new Point3f(ptList[2]);
            ptList[2].add(pt);
            ptList[3].sub(pt);
            nVertices = 4;
        } else if (nVertices >= 3 && !isPlane && isPerpendicular) {
            this.g3d.calcNormalizedNormal(ptList[0], ptList[1], ptList[2], normal);
            center = new Point3f(ptList[0]);
            for (int i = 1; i < nVertices; ++i) {
                center.add(ptList[i]);
            }
            center.scale(1.0f / (float)nVertices);
            dist = length == Float.MAX_VALUE ? ptList[0].distance(center) : length;
            normal.scale(dist);
            ptList[0].set(center);
            ptList[1].set(center);
            ptList[1].add(normal);
            nVertices = 2;
        } else if (nVertices == 2 && isPerpendicular) {
            this.g3d.calcAveragePoint(ptList[0], ptList[1], center);
            float f = dist = length == Float.MAX_VALUE ? ptList[0].distance(center) : length;
            if (isPlane && length != Float.MAX_VALUE) {
                dist /= 2.0f;
            }
            if (isPlane && isRotated45) {
                dist *= 1.4142f;
            }
            this.g3d.calcXYNormalToLine(ptList[0], ptList[1], normal);
            normal.scale(dist);
            if (isPlane) {
                ptList[2] = new Point3f(center);
                ptList[2].sub(normal);
                pt = new Point3f(center);
                pt.add(normal);
                this.g3d.calcNormalizedNormal(ptList[0], ptList[1], ptList[2], normal);
                normal.scale(dist);
                ptList[3] = new Point3f(center);
                ptList[3].add(normal);
                ptList[1].set(center);
                ptList[1].sub(normal);
                ptList[0].set(pt);
                if (isRotated45) {
                    this.g3d.calcAveragePoint(ptList[0], ptList[1], ptList[0]);
                    this.g3d.calcAveragePoint(ptList[1], ptList[2], ptList[1]);
                    this.g3d.calcAveragePoint(ptList[2], ptList[3], ptList[2]);
                    this.g3d.calcAveragePoint(ptList[3], pt, ptList[3]);
                }
                nVertices = 4;
            } else {
                ptList[0].set(center);
                ptList[1].set(center);
                ptList[0].sub(normal);
                ptList[1].add(normal);
            }
        } else if (nVertices == 2 && length != Float.MAX_VALUE) {
            this.g3d.calcAveragePoint(ptList[0], ptList[1], center);
            normal.set(ptList[1]);
            normal.sub(center);
            normal.scale(0.5f / normal.length() * length);
            ptList[0].set(center);
            ptList[1].set(center);
            ptList[0].sub(normal);
            ptList[1].add(normal);
        }
        if (nVertices > 4) {
            nVertices = 4;
        }
        switch (nVertices) {
            case 1: {
                this.drawType = "Point";
                break;
            }
            case 2: {
                this.drawType = "Line";
                break;
            }
            default: {
                this.drawType = "Plane";
            }
        }
        this.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return nPoly;
        }
        int nVertices0 = this.vertexCount;
        for (int i = 0; i < nVertices; ++i) {
            this.addVertexCopy(ptList[i]);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        this.setPolygonCount(nPoly + 1);
        this.polygonIndexes[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.polygonIndexes[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
        return nPoly + 1;
    }

    final void scaleDrawing(float newScale) {
        if (newScale == 0.0f || this.vertexCount == 0 || this.scale == newScale) {
            return;
        }
        Vector3f diff = new Vector3f();
        float f = newScale / this.scale;
        this.scale = newScale;
        int iptlast = -1;
        int ipt = 0;
        int i = this.polygonCount;
        while (--i >= 0) {
            Point3f center = this.ptCenters == null ? this.ptCenter : this.ptCenters[i];
            iptlast = -1;
            int iV = this.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = this.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                diff.sub(this.vertices[ipt], center);
                diff.scale(f);
                diff.add(center);
                this.vertices[ipt].set(diff);
            }
        }
    }

    final void setCenter(int iModel) {
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        int iptlast = -1;
        int ipt = 0;
        int n = 0;
        int i = this.polygonCount;
        while (--i >= 0) {
            if (iModel >= 0 && i != iModel) continue;
            iptlast = -1;
            int iV = this.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = this.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                center.add(this.vertices[ipt]);
                ++n;
            }
            if (i != iModel && i != 0) continue;
            center.scale(1.0f / (float)n);
            break;
        }
        if (iModel < 0) {
            this.ptCenter = center;
        } else {
            this.ptCenters[iModel] = center;
        }
    }

    final Point3f getSpinCenter(int modelIndex) {
        if (this.vertices == null) {
            return null;
        }
        return this.ptCenters == null || modelIndex < 0 ? this.ptCenter : this.ptCenters[modelIndex];
    }

    final Vector3f getSpinAxis(int modelIndex) {
        if (this.vertices == null) {
            return null;
        }
        return this.ptCenters == null || modelIndex < 0 ? this.axis : this.axes[modelIndex];
    }

    final void setAxes() {
        this.axis = new Vector3f(0.0f, 0.0f, 0.0f);
        this.axes = new Vector3f[this.polygonCount];
        if (this.vertices == null) {
            return;
        }
        int i = this.polygonCount;
        while (--i >= 0) {
            this.axes[i] = new Vector3f();
            if (this.drawVertexCount == 2) {
                this.axes[i].sub(this.vertices[this.polygonIndexes[i][0]], this.vertices[this.polygonIndexes[i][1]]);
            } else {
                this.g3d.calcNormalizedNormal(this.vertices[this.polygonIndexes[i][0]], this.vertices[this.polygonIndexes[i][1]], this.vertices[this.polygonIndexes[i][2]], this.axes[i]);
            }
            this.axis.add(this.axes[i]);
        }
    }
}

