/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Viewer;

class Measurement {
    Frame frame;
    int count;
    int[] countPlusIndices;
    String strMeasurement;
    float value;
    boolean isVisible = true;
    boolean isHidden = false;
    short colix;
    AxisAngle4f aa;
    Point3f pointArc;

    Measurement(Frame frame, int[] atomCountPlusIndices, short colix) {
        this.frame = frame;
        this.colix = colix;
        this.setInfo(frame, atomCountPlusIndices, Float.MAX_VALUE);
    }

    Measurement(Frame frame, int[] atomCountPlusIndices, float value, short colix) {
        this.frame = frame;
        this.colix = colix;
        this.setInfo(frame, atomCountPlusIndices, value);
    }

    void setInfo(Frame frame, int[] atomCountPlusIndices, float value) {
        if (atomCountPlusIndices == null) {
            this.count = 0;
        } else {
            this.count = atomCountPlusIndices[0];
            this.countPlusIndices = new int[this.count + 1];
            System.arraycopy(atomCountPlusIndices, 0, this.countPlusIndices, 0, this.count + 1);
        }
        if (this.countPlusIndices != null && value == Float.MAX_VALUE) {
            value = frame.getMeasurement(this.countPlusIndices);
        }
        this.value = value;
        this.formatMeasurement();
    }

    void formatMeasurement() {
        this.strMeasurement = null;
        if (this.value == Float.MAX_VALUE || this.count == 0) {
            this.strMeasurement = null;
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(this.value);
                break;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    Point3f pointA = this.getAtomPoint3f(1);
                    Point3f pointB = this.getAtomPoint3f(2);
                    Point3f pointC = this.getAtomPoint3f(3);
                    Vector3f vectorBA = new Vector3f();
                    Vector3f vectorBC = new Vector3f();
                    vectorBA.sub(pointA, pointB);
                    vectorBC.sub(pointC, pointB);
                    float radians = vectorBA.angle(vectorBC);
                    Vector3f vectorAxis = new Vector3f();
                    vectorAxis.cross(vectorBA, vectorBC);
                    this.aa = new AxisAngle4f(vectorAxis.x, vectorAxis.y, vectorAxis.z, radians);
                    vectorBA.normalize();
                    vectorBA.scale(0.5f);
                    this.pointArc = new Point3f(vectorBA);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                break;
            }
            default: {
                Logger.error("Invalid count to measurement shape:" + this.count);
                throw new IndexOutOfBoundsException();
            }
        }
    }

    void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        Viewer viewer = this.frame.viewer;
        if (viewer.isSelected(this.countPlusIndices[1]) && viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement();
        }
    }

    Point3f getAtomPoint3f(int i) {
        return this.frame.getAtomPoint3f(this.countPlusIndices[i]);
    }

    String formatDistance(float dist) {
        int nDist = (int)(dist * 100.0f + 0.5f);
        String units = this.frame.viewer.getMeasureDistanceUnits();
        if (units == "nanometers") {
            return "" + (double)nDist / 1000.0 + " nm";
        }
        if (units == "picometers") {
            return "" + nDist + " pm";
        }
        return "" + (double)nDist / 100.0 + '\u00c5';
    }

    String formatAngle(float angle) {
        angle = (int)(angle * 10.0f + (angle >= 0.0f ? 0.5f : -0.5f));
        return "" + (angle /= 10.0f) + '\u00b0';
    }

    boolean sameAs(int[] atomCountPlusIndices) {
        if (this.count != atomCountPlusIndices[0]) {
            return false;
        }
        if (this.count == 2) {
            return atomCountPlusIndices[1] == this.countPlusIndices[1] && atomCountPlusIndices[2] == this.countPlusIndices[2] || atomCountPlusIndices[1] == this.countPlusIndices[2] && atomCountPlusIndices[2] == this.countPlusIndices[1];
        }
        if (this.count == 3) {
            return atomCountPlusIndices[2] == this.countPlusIndices[2] && (atomCountPlusIndices[1] == this.countPlusIndices[1] && atomCountPlusIndices[3] == this.countPlusIndices[3] || atomCountPlusIndices[1] == this.countPlusIndices[3] && atomCountPlusIndices[3] == this.countPlusIndices[1]);
        }
        return atomCountPlusIndices[1] == this.countPlusIndices[1] && atomCountPlusIndices[2] == this.countPlusIndices[2] && atomCountPlusIndices[3] == this.countPlusIndices[3] && atomCountPlusIndices[4] == this.countPlusIndices[4] || atomCountPlusIndices[1] == this.countPlusIndices[4] && atomCountPlusIndices[2] == this.countPlusIndices[3] && atomCountPlusIndices[3] == this.countPlusIndices[2] && atomCountPlusIndices[4] == this.countPlusIndices[1];
    }

    static float computeTorsion(Point3f p1, Point3f p2, Point3f p3, Point3f p4) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = Measurement.toDegrees((float)Math.acos(cosang));
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return torsion;
    }

    static float toDegrees(float angrad) {
        return angrad * 180.0f / (float)Math.PI;
    }

    Vector toVector() {
        Vector<Object> V = new Vector<Object>();
        for (int i = 0; i < this.count + 1; ++i) {
            V.add(new Integer(this.countPlusIndices[i]));
        }
        V.add(this.strMeasurement);
        return V;
    }
}

