/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;

class LcaoOrbital
extends Isosurface {
    Integer lcaoColorPos = null;
    Integer lcaoColorNeg = null;
    String thisType;
    Float lcaoScale = null;
    int myColorPt;
    String thisID;
    BitSet atomSet = null;

    LcaoOrbital() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("LcaoOrbital.setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.thisID = null;
            this.atomSet = bs;
            super.setProperty("init", null, null);
            return;
        }
        if ("on" == propertyName) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == propertyName) {
            this.setLcaoOn(false);
            return;
        }
        if ("delete" == propertyName) {
            this.deleteLcaoOrbital();
            return;
        }
        if ("thisID" == propertyName) {
            this.thisID = (String)value;
            return;
        }
        if ("type" == propertyName) {
            this.thisType = (String)value;
            return;
        }
        if ("scale" == propertyName) {
            this.lcaoScale = (Float)value;
            return;
        }
        if ("colorRGB" == propertyName) {
            this.lcaoColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
            return;
        }
        if ("create" == propertyName) {
            this.createLcaoOrbital((String)value);
            return;
        }
    }

    void setLcaoOn(boolean TF) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.atomSet.get(i)) continue;
            this.setLcaoOn(i, TF);
        }
    }

    void setLcaoOn(int iAtom, boolean TF) {
        String id = this.getID(iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.meshes[i].visible = TF;
        }
    }

    void deleteLcaoOrbital() {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.atomSet.get(i)) continue;
            this.deleteLcaoOrbital(i);
        }
    }

    void deleteLcaoOrbital(int iAtom) {
        String id = this.getID(iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
    }

    void createLcaoOrbital(String type) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.atomSet.get(i)) continue;
            this.createLcaoOrbital(type, i);
        }
    }

    void createLcaoOrbital(String type, int iAtom) {
        String id = "lcao_" + (iAtom + 1) + "_" + type;
        super.setProperty("init", null, null);
        super.setProperty("thisID", id, null);
        if (this.lcaoScale != null) {
            super.setProperty("scale", this.lcaoScale, null);
        }
        if (this.lcaoColorNeg != null) {
            super.setProperty("colorRGB", this.lcaoColorNeg, null);
            super.setProperty("colorRGB", this.lcaoColorPos, null);
        }
        super.setProperty("lcaoType", type, null);
        Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.frame.atoms[iAtom].point3f)};
        this.viewer.getPrincipalAxes(iAtom, axes[0], axes[1], type);
        super.setProperty("lcaoCartoon", axes, null);
    }

    String getID(int i) {
        return this.thisID != null ? this.thisID : "lcao_" + (i + 1) + "_" + (this.thisType != null ? this.thisType : "");
    }
}

