/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;

class LcaoCartoon
extends Isosurface {
    Integer lcaoColorPos = null;
    Integer lcaoColorNeg = null;
    String thisType;
    Float lcaoScale = null;
    int myColorPt;
    String lcaoID;
    BitSet thisSet = null;

    LcaoCartoon() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("\nLcaoCartoon.setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bs;
            super.setProperty("init", null, null);
            return;
        }
        if ("on" == propertyName) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == propertyName) {
            this.setLcaoOn(false);
            return;
        }
        if ("delete" == propertyName) {
            this.deleteLcaoCartoon();
            return;
        }
        if ("lcaoID" == propertyName) {
            this.lcaoID = (String)value;
            return;
        }
        if ("select" == propertyName) {
            this.thisType = (String)value;
            return;
        }
        if ("scale" == propertyName) {
            this.lcaoScale = (Float)value;
            return;
        }
        if ("colorRGB" == propertyName) {
            this.lcaoColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
            return;
        }
        if ("create" == propertyName) {
            this.createLcaoCartoon((String)value);
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    void setLcaoOn(boolean TF) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.setLcaoOn(i, TF);
        }
    }

    void setLcaoOn(int iAtom, boolean TF) {
        String id = this.getID(iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.meshes[i].visible = TF;
        }
    }

    void deleteLcaoCartoon() {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.deleteLcaoCartoon(i);
        }
    }

    void deleteLcaoCartoon(int iAtom) {
        String id = this.getID(iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
    }

    void createLcaoCartoon(String type) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.createLcaoCartoon(type, i);
        }
    }

    void createLcaoCartoon(String type, int iAtom) {
        String id = "lcao_" + (iAtom + 1) + "_" + type;
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
        super.setProperty("init", null, null);
        super.setProperty("thisID", id, null);
        if (this.lcaoScale != null) {
            super.setProperty("scale", this.lcaoScale, null);
        }
        if (this.lcaoColorNeg != null) {
            super.setProperty("colorRGB", this.lcaoColorNeg, null);
            super.setProperty("colorRGB", this.lcaoColorPos, null);
        }
        super.setProperty("lcaoType", type, null);
        Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.frame.atoms[iAtom].point3f)};
        if (this.viewer.getPrincipalAxes(iAtom, axes[0], axes[1], type, true)) {
            super.setProperty("lcaoCartoon", axes, null);
        }
    }

    String getID(int i) {
        return this.lcaoID != null ? this.lcaoID : "lcao_" + (i + 1) + "_" + (this.thisType != null ? this.thisType : "");
    }
}

