/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Util;

class Labels
extends Shape {
    String[] strings;
    short[] colixes;
    short[] bgcolixes;
    byte[] fids;
    short[] offsets;
    Font3D defaultFont3D;

    Labels() {
    }

    void initShape() {
        this.defaultFont3D = this.g3d.getFont3D("SansSerif", "Plain", 13);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        int i;
        int i2;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            String palette = null;
            short colix = Graphics3D.getColix(value);
            if (colix == 3) {
                palette = (String)value;
            }
            i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                if (!bsSelected.get(i2)) continue;
                if (this.colixes == null || i2 >= this.colixes.length) {
                    if (colix == 0) continue;
                    this.colixes = Util.ensureLength(this.colixes, i2 + 1);
                }
                this.colixes[i2] = colix != 3 ? colix : this.viewer.getColixAtomPalette(this.frame.getAtomAt(i2), palette);
            }
        }
        if ("bgcolor" == propertyName) {
            short bgcolix = Graphics3D.getColix(value);
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                if (this.bgcolixes == null || i >= this.bgcolixes.length) {
                    if (bgcolix == 0) continue;
                    this.bgcolixes = Util.ensureLength(this.bgcolixes, i + 1);
                }
                this.bgcolixes[i] = bgcolix;
            }
        }
        if ("label" == propertyName) {
            String strLabel = (String)value;
            i = this.frame.atomCount;
            while (--i >= 0) {
                Atom atom;
                if (!bsSelected.get(i)) continue;
                String label = (atom = atoms[i]).formatLabel(strLabel);
                atom.setShapeVisibility(this.myVisibilityFlag, label != null);
                if (this.strings == null || i >= this.strings.length) {
                    this.strings = Util.ensureLength(this.strings, i + 1);
                }
                this.strings[i] = label;
            }
            return;
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize == 13) {
                this.fids = null;
                return;
            }
            byte fid = this.g3d.getFontFid(fontsize);
            this.fids = Util.ensureLength(this.fids, this.frame.atomCount);
            i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                this.fids[i2] = fid;
            }
            return;
        }
        if ("font" == propertyName) {
            byte fid = ((Font3D)value).fid;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                if (this.fids == null || i >= this.fids.length) {
                    if (fid == this.defaultFont3D.fid) continue;
                    this.fids = Util.ensureLength(this.fids, i + 1);
                }
                this.fids[i] = fid;
            }
            return;
        }
        if ("offset" == propertyName) {
            int bsLength;
            int offset = (Integer)value;
            if (offset == 0) {
                offset = Short.MIN_VALUE;
            } else if (offset == 1028) {
                offset = 0;
            }
            i2 = bsLength = bsSelected.size();
            while (--i2 >= 0) {
                if (this.offsets == null || i2 >= this.offsets.length) {
                    if (offset == 0) continue;
                    this.offsets = Util.ensureLength(this.offsets, i2 + 1);
                }
                this.offsets[i2] = (short)offset;
            }
            return;
        }
        if ("pickingLabel" == propertyName) {
            int atomIndex = (Integer)value;
            if (this.strings != null && this.strings.length > atomIndex && this.strings[atomIndex] != null) {
                this.strings[atomIndex] = null;
            } else {
                String strLabel = this.viewer.getStandardLabelFormat();
                Atom atom = atoms[atomIndex];
                this.strings = Util.ensureLength(this.strings, atomIndex + 1);
                this.strings[atomIndex] = atom.formatLabel(strLabel);
            }
            return;
        }
    }

    void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int i = this.strings.length;
        while (--i >= 0) {
            String label = this.strings[i];
            if (label == null || this.frame.atoms.length <= i) continue;
            this.frame.atoms[i].clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

