/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Viewer;

class FrameRenderer {
    Viewer viewer;
    ShapeRenderer[] renderers = new ShapeRenderer[29];

    FrameRenderer(Viewer viewer) {
        this.viewer = viewer;
    }

    void render(Graphics3D g3d, Rectangle rectClip, Frame frame, int displayModelIndex) {
        if (frame == null || frame.atomCount <= 0) {
            return;
        }
        this.viewer.finalizeTransformParameters();
        for (int i = 0; i < 29; ++i) {
            Shape shape = frame.shapes[i];
            if (shape == null) continue;
            this.getRenderer(i, g3d).render(g3d, rectClip, frame, displayModelIndex, shape);
        }
    }

    ShapeRenderer getRenderer(int refShape, Graphics3D g3d) {
        if (this.renderers[refShape] == null) {
            this.renderers[refShape] = this.allocateRenderer(refShape, g3d);
        }
        return this.renderers[refShape];
    }

    ShapeRenderer allocateRenderer(int refShape, Graphics3D g3d) {
        String classBase = JmolConstants.shapeClassBases[refShape] + "Renderer";
        String className = "org.jmol.viewer." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            ShapeRenderer renderer = (ShapeRenderer)shapeClass.newInstance();
            renderer.setViewerFrameRenderer(this.viewer, this, g3d);
            return renderer;
        }
        catch (Exception e) {
            Logger.error("Could not instantiate renderer:" + classBase + "\n" + e);
            e.printStackTrace();
            return null;
        }
    }

    void renderStringOutside(String str, short colix, Font3D font3d, Point3i screen, Graphics3D g3d) {
        this.renderStringOutside(str, colix, font3d, screen.x, screen.y, screen.z, g3d);
    }

    void renderStringOutside(String str, short colix, Font3D font3d, int x, int y, int z, Graphics3D g3d) {
        int yStrCenter;
        int xStrCenter;
        FontMetrics fontMetrics = font3d.fontMetrics;
        int strAscent = fontMetrics.getAscent();
        int strWidth = fontMetrics.stringWidth(str);
        int xCenter = this.viewer.getBoundBoxCenterX();
        int yCenter = this.viewer.getBoundBoxCenterY();
        int dx = x - xCenter;
        int dy = y - yCenter;
        if (dx == 0 && dy == 0) {
            xStrCenter = x;
            yStrCenter = y;
        } else {
            int dist = (int)Math.sqrt(dx * dx + dy * dy);
            xStrCenter = xCenter + (dist + 2 + (strWidth + 1) / 2) * dx / dist;
            yStrCenter = yCenter + (dist + 3 + (strAscent + 1) / 2) * dy / dist;
        }
        int xStrBaseline = xStrCenter - strWidth / 2;
        int yStrBaseline = yStrCenter + strAscent / 2;
        g3d.drawString(str, font3d, colix, xStrBaseline, yStrBaseline, z);
    }
}

