/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Dipole;
import org.jmol.viewer.Dipoles;
import org.jmol.viewer.FrameExportJmolAdapter;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

public final class Frame {
    final Viewer viewer;
    final JmolAdapter adapter;
    final FrameRenderer frameRenderer;
    private String modelSetTypeName;
    final boolean isXYZ;
    final boolean isPDB;
    final boolean isMultiFile;
    final boolean isArrayOfFiles;
    boolean isZeroBased;
    final Mmset mmset;
    final Graphics3D g3d;
    float maxBondingRadius = -2.1474836E9f;
    float maxVanderwaalsRadius = -2.1474836E9f;
    int atomCount;
    public Atom[] atoms;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    String[] atomNames;
    int[] atomSerials;
    byte[] specialAtomIDs;
    int bondCount;
    Bond[] bonds;
    private static final int growthIncrement = 250;
    float[] notionalUnitcell;
    boolean someModelsHaveSymmetry;
    boolean someModelsHaveUnitcells;
    boolean someModelsHaveFractionalCoordinates;
    boolean hasVibrationVectors;
    boolean fileHasHbonds;
    boolean structuresDefined;
    BitSet elementsPresent;
    int groupCount;
    Group[] groups;
    BitSet groupsPresent;
    int moleculeCount;
    Molecule[] molecules = new Molecule[4];
    boolean hasBfactorRange;
    int bfactor100Lo;
    int bfactor100Hi;
    float[] pdbScaleMatrixArray;
    float[] pdbScaleTranslateArray;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    int currentModelIndex;
    Model currentModel;
    char currentChainID;
    Chain currentChain;
    int currentGroupSequenceNumber;
    char currentGroupInsertionCode;
    private final Hashtable htAtomMap = new Hashtable();
    static final int defaultGroupCount = 32;
    Chain[] chains = new Chain[32];
    String[] group3s = new String[32];
    int[] seqcodes = new int[32];
    int[] firstAtomIndexes = new int[32];
    final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    FrameExportJmolAdapter exportJmolAdapter;
    final Shape[] shapes = new Shape[29];
    final Point3f averageAtomPoint = new Point3f();
    final Point3f centerBoundBox = new Point3f();
    final Vector3f boundBoxCornerVector = new Vector3f();
    final Point3f minBoundBox = new Point3f();
    final Point3f maxBoundBox = new Point3f();
    Point3f rotationCenter;
    float rotationRadius;
    Point3f rotationCenterDefault;
    float rotationRadiusDefault;
    static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};
    final Point3f[] bboxVertices = new Point3f[8];
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = null;
    final Closest closest = new Closest();
    static final int minimumPixelSelectionRadius = 6;
    final BitSet bsEmpty = new BitSet();
    final BitSet bsFoundRectangle = new BitSet();
    Bspf bspf;
    private static final boolean MIX_BSPT_ORDER = false;
    private final WithinModelIterator withinModelIterator = new WithinModelIterator();
    private final WithinAnyModelIterator withinAnyModelIterator = new WithinAnyModelIterator();
    static final boolean showRebondTimes = false;
    private float bondTolerance;
    private float minBondDistance;
    private float minBondDistance2;
    float hbondMax = 3.25f;
    float hbondMin = 2.5f;
    float hbondMin2 = this.hbondMin * this.hbondMin;
    boolean hbondsCalculated;
    boolean useRasMolHbondsCalculation = true;
    CellInfo[] cellInfo;
    BitSet selectedMolecules = new BitSet();
    BitSet bsTemp = new BitSet();
    int selectedMoleculeCount;
    Vector3f vectorBA;
    Vector3f vectorBC;
    static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    static final int MAX_NUM_TO_CACHE = 200;
    int[] numCached = new int[5];
    Bond[][][] freeBonds = new Bond[5][][];
    static final float E_ANG_PER_DEBYE = 0.208194f;
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};

    Frame(Viewer viewer, JmolAdapter adapter, Object clientFile) {
        JmolAdapter.StructureIterator iterStructure;
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.viewer = viewer;
        this.adapter = adapter;
        this.modelSetTypeName = adapter.getFileTypeName(clientFile).toLowerCase().intern();
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.isArrayOfFiles = this.modelSetTypeName == "array";
        this.setZeroBased();
        this.mmset = new Mmset(this);
        this.frameRenderer = viewer.getFrameRenderer();
        this.g3d = viewer.getGraphics3D();
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(2);
        this.loadShape(6);
        this.loadShape(18);
        this.initializeBuild(adapter.getEstimatedAtomCount(clientFile));
        this.setModelSetProperties(adapter.getAtomSetCollectionProperties(clientFile));
        this.setModelSetAuxiliaryInfo(adapter.getAtomSetCollectionAuxiliaryInfo(clientFile));
        this.isMultiFile = this.mmset.getModelSetAuxiliaryInfoBoolean("isMultiFile");
        this.isPDB = this.mmset.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.pdbScaleMatrixArray = adapter.getPdbScaleMatrix(clientFile);
        this.pdbScaleTranslateArray = adapter.getPdbScaleTranslate(clientFile);
        this.someModelsHaveSymmetry = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        this.currentModelIndex = -1;
        int modelCount = adapter.getAtomSetCount(clientFile);
        this.setModelCount(modelCount);
        Logger.info("frame: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates);
        if (modelCount > 0) {
            Logger.info(modelCount + " model" + (modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or getProperty \"auxiliaryInfo\" to inspect them.");
        }
        for (int i2 = 0; i2 < modelCount; ++i2) {
            int modelNumber = adapter.getAtomSetNumber(clientFile, i2);
            String modelName = adapter.getAtomSetName(clientFile, i2);
            if (modelName == null) {
                modelName = "" + modelNumber;
            }
            Properties modelProperties = adapter.getAtomSetProperties(clientFile, i2);
            Hashtable modelAuxiliaryInfo = adapter.getAtomSetAuxiliaryInfo(clientFile, i2);
            boolean isPDBModel = this.isPDB || this.mmset.getModelAuxiliaryInfoBoolean(i2, "isPDB");
            this.setModelNameNumberProperties(i2, modelName, modelNumber, modelProperties, modelAuxiliaryInfo, isPDBModel);
        }
        JmolAdapter.AtomIterator iterAtom = adapter.getAtomIterator(clientFile);
        while (iterAtom.hasNext()) {
            byte elementNumber = (byte)iterAtom.getElementNumber();
            if (elementNumber <= 0) {
                elementNumber = JmolConstants.elementNumberFromSymbol(iterAtom.getElementSymbol());
            }
            char alternateLocation = iterAtom.getAlternateLocationID();
            this.addAtom(iterAtom.getAtomSetIndex(), iterAtom.getUniqueID(), elementNumber, iterAtom.getAtomName(), iterAtom.getFormalCharge(), iterAtom.getPartialCharge(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getX(), iterAtom.getY(), iterAtom.getZ(), iterAtom.getIsHetero(), iterAtom.getAtomSerial(), iterAtom.getChainID(), iterAtom.getGroup3(), iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), iterAtom.getVectorX(), iterAtom.getVectorY(), iterAtom.getVectorZ(), alternateLocation, iterAtom.getClientAtomReference());
        }
        this.fileHasHbonds = false;
        JmolAdapter.BondIterator iterBond = adapter.getBondIterator(clientFile);
        if (iterBond != null) {
            while (iterBond.hasNext()) {
                this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), iterBond.getEncodedOrder());
            }
        }
        if ((iterStructure = adapter.getStructureIterator(clientFile)) != null) {
            while (iterStructure.hasNext()) {
                if (iterStructure.getStructureType().equals("turn")) continue;
                this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
        if ((iterStructure = adapter.getStructureIterator(clientFile)) != null) {
            while (iterStructure.hasNext()) {
                if (!iterStructure.getStructureType().equals("turn")) continue;
                this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
        this.doUnitcellStuff();
        this.doAutobond();
        this.finalizeGroupBuild();
        this.buildPolymers();
        this.freeze();
        adapter.finish(clientFile);
        this.finalizeBuild();
        this.dumpAtomSetNameDiagnostics(clientFile);
    }

    void setZeroBased() {
        this.isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
    }

    void dumpAtomSetNameDiagnostics(Object clientFile) {
    }

    void initializeBuild(int atomCountEstimate) {
        this.currentModel = null;
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        if (atomCountEstimate <= 0) {
            atomCountEstimate = 2000;
        }
        this.atoms = new Atom[atomCountEstimate];
        this.bonds = new Bond[2 * atomCountEstimate];
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    void finalizeBuild() {
        this.currentModel = null;
        this.currentChain = null;
        this.htAtomMap.clear();
    }

    void addAtom(int modelIndex, Object atomUid, byte atomicNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode, float vectorX, float vectorY, float vectorZ, char alternateLocationID, Object clientAtomReference) {
        Atom atom;
        if (modelIndex != this.currentModelIndex) {
            this.currentModel = this.mmset.getModel(modelIndex);
            this.currentModelIndex = modelIndex;
            this.currentChainID = (char)65535;
        }
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.currentModel.getOrAllocateChain(chainID);
            this.currentGroupInsertionCode = (char)65535;
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode) {
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.startGroup(this.currentChain, group3, groupSequenceNumber, groupInsertionCode, this.atomCount);
        }
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays();
        }
        this.atoms[this.atomCount] = atom = new Atom(this.viewer, this, this.currentModelIndex, this.atomCount, atomicNumber, atomName, formalCharge, partialCharge, occupancy, bfactor, x, y, z, isHetero, atomSerial, chainID, vectorX, vectorY, vectorZ, alternateLocationID, clientAtomReference);
        ++this.atomCount;
        this.htAtomMap.put(atomUid, atom);
    }

    void bondAtoms(Object atomUid1, Object atomUid2, int order) {
        Atom atom1 = (Atom)this.htAtomMap.get(atomUid1);
        if (atom1 == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + atomUid1);
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(atomUid2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + atomUid2);
            return;
        }
        Bond bond = atom1.bondMutually(atom2, (short)order, this);
        if (bond == null) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 4000);
        }
        this.bonds[this.bondCount++] = bond;
        if ((order & 0x3C0) != 0) {
            this.fileHasHbonds = true;
        }
    }

    boolean bondAtomsByNumber(int iA, int iB, int order, short mad) {
        Atom atom1 = this.atoms[iA];
        Atom atom2 = this.atoms[iB];
        Bond bond = atom1.bondMutually(atom2, (short)order, this);
        if (bond == null) {
            return false;
        }
        if (mad >= 0) {
            bond.mad = mad;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 4000);
        }
        this.bonds[this.bondCount++] = bond;
        if ((order & 0x3C0) != 0) {
            this.fileHasHbonds = true;
        }
        return true;
    }

    void growAtomArrays() {
        int newLength = this.atomCount + 2000;
        this.atoms = (Atom[])Util.setLength(this.atoms, newLength);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, newLength);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])Util.setLength(this.vibrationVectors, newLength);
        }
        if (this.occupancies != null) {
            this.occupancies = Util.setLength(this.occupancies, newLength);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = Util.setLength(this.bfactor100s, newLength);
        }
        if (this.partialCharges != null) {
            this.partialCharges = Util.setLength(this.partialCharges, newLength);
        }
        if (this.atomNames != null) {
            this.atomNames = Util.setLength(this.atomNames, newLength);
        }
        if (this.atomSerials != null) {
            this.atomSerials = Util.setLength(this.atomSerials, newLength);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = Util.setLength(this.specialAtomIDs, newLength);
        }
    }

    void initializeGroupBuild() {
        this.groupCount = 0;
    }

    void finalizeGroupBuild() {
        this.groups = new Group[this.groupCount];
        for (int i = 0; i < this.groupCount; ++i) {
            this.distinguishAndPropogateGroup(i, this.chains[i], this.group3s[i], this.seqcodes[i], this.firstAtomIndexes[i], i == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[i + 1]);
            this.chains[i] = null;
            this.group3s[i] = null;
        }
    }

    void startGroup(Chain chain, String group3, int groupSequenceNumber, char groupInsertionCode, int firstAtomIndex) {
        if (this.groupCount == this.group3s.length) {
            this.chains = (Chain[])Util.doubleLength(this.chains);
            this.group3s = Util.doubleLength(this.group3s);
            this.seqcodes = Util.doubleLength(this.seqcodes);
            this.firstAtomIndexes = Util.doubleLength(this.firstAtomIndexes);
        }
        this.firstAtomIndexes[this.groupCount] = firstAtomIndex;
        this.chains[this.groupCount] = chain;
        this.group3s[this.groupCount] = group3;
        this.seqcodes[this.groupCount] = Group.getSeqcode(groupSequenceNumber, groupInsertionCode);
        ++this.groupCount;
    }

    void distinguishAndPropogateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex) {
        int lastAtomIndex;
        int distinguishingBits = 0;
        int i = JmolConstants.ATOMID_MAX;
        while (--i >= 0) {
            this.specialAtomIndexes[i] = Integer.MIN_VALUE;
        }
        if (this.specialAtomIDs != null) {
            i = maxAtomIndex;
            while (--i >= firstAtomIndex) {
                byte specialAtomID = this.specialAtomIDs[i];
                if (specialAtomID <= 0) continue;
                if (specialAtomID < 32) {
                    distinguishingBits |= 1 << specialAtomID;
                }
                this.specialAtomIndexes[specialAtomID] = i;
            }
        }
        if ((lastAtomIndex = maxAtomIndex - 1) < firstAtomIndex) {
            throw new NullPointerException();
        }
        Group group = null;
        if ((distinguishingBits & 0xE) == 14) {
            group = AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4) {
            group = AlphaMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if ((distinguishingBits & 0xFE0) == 4064) {
            group = NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4096) {
            group = PhosphorusMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        }
        if (group == null) {
            group = new Group(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        }
        chain.addGroup(group);
        this.groups[groupIndex] = group;
        int i2 = maxAtomIndex;
        while (--i2 >= firstAtomIndex) {
            this.atoms[i2].setGroup(group);
        }
    }

    void buildPolymers() {
        for (int i = 0; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            if (!(group instanceof Monomer)) continue;
            Monomer monomer = (Monomer)group;
            if (monomer.polymer != null) continue;
            Polymer.allocatePolymer(this.groups, i);
        }
    }

    JmolAdapter getExportJmolAdapter() {
        if (this.exportJmolAdapter == null) {
            this.exportJmolAdapter = new FrameExportJmolAdapter(this.viewer, this);
        }
        return this.exportJmolAdapter;
    }

    void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.atoms = (Atom[])Util.setLength(this.atoms, this.atomCount);
            if (this.clientAtomReferences != null) {
                this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, this.atomCount);
            }
            if (this.vibrationVectors != null) {
                this.vibrationVectors = (Vector3f[])Util.setLength(this.vibrationVectors, this.atomCount);
            }
            if (this.occupancies != null) {
                this.occupancies = Util.setLength(this.occupancies, this.atomCount);
            }
            if (this.bfactor100s != null) {
                this.bfactor100s = Util.setLength(this.bfactor100s, this.atomCount);
            }
            if (this.partialCharges != null) {
                this.partialCharges = Util.setLength(this.partialCharges, this.atomCount);
            }
            if (this.atomNames != null) {
                this.atomNames = Util.setLength(this.atomNames, this.atomCount);
            }
            if (this.atomSerials != null) {
                this.atomSerials = Util.setLength(this.atomSerials, this.atomCount);
            }
            if (this.specialAtomIDs != null) {
                this.specialAtomIDs = Util.setLength(this.specialAtomIDs, this.atomCount);
            }
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount);
        }
        this.freeBondsCache();
        this.hasVibrationVectors = this.vibrationVectors != null;
        this.hackAtomSerialNumbersForAnimations();
        if (!this.structuresDefined) {
            this.calculateStructures();
        }
        this.findElementsPresent();
        this.findGroupsPresent();
        this.mmset.freeze();
    }

    void calculateStructures() {
        this.mmset.calculateStructures();
    }

    void recalculateStructure(BitSet bsSelected) {
        this.mmset.recalculateStructure(bsSelected);
    }

    void setConformation(int modelIndex, BitSet bsConformation) {
        this.mmset.setConformation(modelIndex, bsConformation);
    }

    void hackAtomSerialNumbersForAnimations() {
        if (this.atomSerials != null) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int modelAtomIndex = 0;
        this.atomSerials = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            short s;
            Atom atom = this.atoms[i];
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                modelAtomIndex = 1;
            }
            this.atomSerials[i] = modelAtomIndex++;
        }
    }

    void defineStructure(int modelIndex, String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        this.structuresDefined = true;
        this.mmset.defineStructure(modelIndex, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].getAtomNumber() != atomNumber) continue;
            return i;
        }
        return -1;
    }

    int getAltLocIndexInModel(int modelIndex, char alternateLocationID) {
        if (alternateLocationID == '\u0000') {
            return 0;
        }
        String altLocList = this.getAltLocListInModel(modelIndex);
        if (altLocList == null) {
            return 0;
        }
        return altLocList.indexOf(alternateLocationID) + 1;
    }

    int getInsertionCodeIndexInModel(int modelIndex, char insertionCode) {
        if (insertionCode == '\u0000') {
            return 0;
        }
        String codeList = this.getInsertionListInModel(modelIndex);
        if (codeList == null) {
            return 0;
        }
        return codeList.indexOf(insertionCode) + 1;
    }

    String getAltLocListInModel(int modelIndex) {
        return (String)this.getModelAuxiliaryInfo(modelIndex, "altLocs");
    }

    String getInsertionListInModel(int modelIndex) {
        return (String)this.getModelAuxiliaryInfo(modelIndex, "insertionCodes");
    }

    int getAltLocCountInModel(int modelIndex) {
        return this.mmset.getNAltLocs(modelIndex);
    }

    int getInsertionCountInModel(int modelIndex) {
        return this.mmset.getNInsertions(modelIndex);
    }

    Properties getModelSetProperties() {
        return this.mmset.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.mmset.getModelSetProperty(propertyName);
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.mmset.getModelSetAuxiliaryInfo();
    }

    Object getModelSetAuxiliaryInfo(String keyName) {
        return this.mmset.getModelSetAuxiliaryInfo(keyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    boolean hasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        if (this.vibrationVectors != null) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (this.atoms[i].modelIndex != modelIndex || this.vibrationVectors[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    int getModelCount() {
        return this.mmset.getModelCount();
    }

    int getModelNumber(int modelIndex) {
        return this.mmset.getModelNumber(modelIndex);
    }

    String getModelName(int modelIndex) {
        return this.mmset.getModelName(modelIndex);
    }

    String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    Properties getModelProperties(int modelIndex) {
        return this.mmset.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.mmset.getModelProperty(modelIndex, propertyName);
    }

    Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.mmset.getModelAuxiliaryInfo(modelIndex);
    }

    Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.mmset.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    Model getModel(int modelIndex) {
        return this.mmset.getModel(modelIndex);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.mmset.getModelNumberIndex(modelNumber);
    }

    void setModelCount(int modelCount) {
        this.mmset.setModelCount(modelCount);
    }

    void setModelSetProperties(Properties modelSetProperties) {
        this.mmset.setModelSetProperties(modelSetProperties);
    }

    void setModelSetAuxiliaryInfo(Hashtable modelSetAuxiliaryInfo) {
        this.mmset.setModelSetAuxiliaryInfo(modelSetAuxiliaryInfo);
    }

    void setModelNameNumberProperties(int modelIndex, String modelName, int modelNumber, Properties modelProperties, Hashtable modelAuxiliaryInfo, boolean isPDB) {
        this.mmset.setModelNameNumberProperties(modelIndex, modelName, modelNumber, modelProperties, modelAuxiliaryInfo, isPDB);
    }

    int getChainCount() {
        return this.mmset.getChainCount();
    }

    int getPolymerCount() {
        return this.mmset.getPolymerCount();
    }

    int getChainCountInModel(int modelIndex) {
        return this.mmset.getChainCountInModel(modelIndex);
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.mmset.getPolymerCountInModel(modelIndex);
    }

    Polymer getPolymerAt(int modelIndex, int polymerIndex) {
        return this.mmset.getPolymerAt(modelIndex, polymerIndex);
    }

    int getGroupCount() {
        return this.mmset.getGroupCount();
    }

    int getGroupCountInModel(int modelIndex) {
        return this.mmset.getGroupCountInModel(modelIndex);
    }

    int getAtomCount() {
        return this.atomCount;
    }

    int getAtomCountInModel(int modelIndex) {
        int n = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    Atom getAtomAt(int atomIndex) {
        return this.atoms[atomIndex];
    }

    Point3f getAtomPoint3f(int atomIndex) {
        return this.atoms[atomIndex].point3f;
    }

    int getBondCount() {
        return this.bondCount;
    }

    int getBondCountInModel(int modelIndex) {
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if (this.bonds[i].atom1.modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    Bond getBondAt(int bondIndex) {
        return this.bonds[bondIndex];
    }

    private void addBond(Bond bond) {
        if (bond == null) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 250);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void bondAtoms(Atom atom1, Atom atom2, short order) {
        this.addBond(atom1.bondMutually(atom2, order, this));
    }

    void bondAtoms(Atom atom1, Atom atom2, short order, BitSet bsA, BitSet bsB) {
        boolean atom2InSetB;
        boolean atom1InSetA = bsA == null || bsA.get(atom1.atomIndex);
        boolean atom1InSetB = bsB == null || bsB.get(atom1.atomIndex);
        boolean atom2InSetA = bsA == null || bsA.get(atom2.atomIndex);
        boolean bl = atom2InSetB = bsB == null || bsB.get(atom2.atomIndex);
        if (atom1InSetA & atom2InSetB || atom1InSetB & atom2InSetA) {
            this.addBond(atom1.bondMutually(atom2, order, this));
        }
    }

    Shape allocateShape(int shapeID) {
        String classBase = JmolConstants.shapeClassBases[shapeID];
        String className = "org.jmol.viewer." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            Shape shape = (Shape)shapeClass.newInstance();
            shape.setViewerG3dFrame(this.viewer, this.g3d, this);
            shape.setVisibilityInfo(shapeID);
            return shape;
        }
        catch (Exception e) {
            Logger.error("Could not instantiate shape:" + classBase + "\n" + e);
            e.printStackTrace();
            return null;
        }
    }

    void loadShape(int shapeID) {
        if (this.shapes[shapeID] == null) {
            this.shapes[shapeID] = this.allocateShape(shapeID);
        }
    }

    void setShapeSize(int shapeID, int size, BitSet bsSelected) {
        if (size != 0) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setSize(size, bsSelected);
        }
    }

    void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bsSelected) {
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setProperty(propertyName, value, bsSelected);
        }
    }

    Object getShapeProperty(int shapeID, String propertyName, int index) {
        return this.shapes[shapeID] == null ? null : this.shapes[shapeID].getProperty(propertyName, index);
    }

    Point3f getBoundBoxCenter() {
        this.findBounds();
        return this.centerBoundBox;
    }

    Point3f getAverageAtomPoint() {
        this.findBounds();
        return this.averageAtomPoint;
    }

    Vector3f getBoundBoxCornerVector() {
        this.findBounds();
        return this.boundBoxCornerVector;
    }

    Point3f getRotationCenter() {
        this.findBounds();
        return this.rotationCenter;
    }

    Point3f getRotationCenterDefault() {
        this.findBounds();
        return this.rotationCenterDefault;
    }

    void increaseRotationRadius(float increaseInAngstroms) {
        if (this.viewer.isWindowCentered()) {
            this.rotationRadius += increaseInAngstroms;
        }
    }

    float getRotationRadius() {
        this.findBounds();
        return this.rotationRadius;
    }

    Point3f setRotationCenterAndRadiusXYZ(Point3f newCenterOfRotation, boolean andRadius) {
        if (newCenterOfRotation != null) {
            this.rotationCenter = newCenterOfRotation;
            if (andRadius && this.viewer.isWindowCentered()) {
                this.rotationRadius = this.calcRotationRadius(this.rotationCenter);
            }
        } else {
            this.rotationCenter = this.rotationCenterDefault;
            this.rotationRadius = this.rotationRadiusDefault;
        }
        return this.rotationCenter;
    }

    Point3f setRotationCenterAndRadiusXYZ(String relativeTo, Point3f pt) {
        Point3f pointT = new Point3f(pt);
        if (relativeTo == "average") {
            pointT.add(this.getAverageAtomPoint());
        } else if (relativeTo == "boundbox") {
            pointT.add(this.getBoundBoxCenter());
        } else if (relativeTo != "absolute") {
            pointT.set(this.getRotationCenterDefault());
        }
        this.setRotationCenterAndRadiusXYZ(pointT, true);
        return pointT;
    }

    void clearBounds() {
        this.rotationCenter = null;
        this.rotationRadius = 0.0f;
    }

    private void findBounds() {
        if (this.rotationCenter != null || this.atomCount <= 0) {
            return;
        }
        this.calcAverageAtomPoint();
        this.calcBoundBoxDimensions();
        this.rotationCenter = this.rotationCenterDefault = this.centerBoundBox;
        this.rotationRadius = this.rotationRadiusDefault = this.calcRotationRadius(this.rotationCenterDefault);
    }

    private void calcAverageAtomPoint() {
        Point3f average = this.averageAtomPoint;
        average.set(0.0f, 0.0f, 0.0f);
        int i = this.atomCount;
        while (--i >= 0) {
            average.add(this.atoms[i].point3f);
        }
        average.scale(1.0f / (float)this.atomCount);
    }

    private void calcBoundBoxDimensions() {
        this.calcAtomsMinMax(this.minBoundBox, this.maxBoundBox);
        this.calcUnitCellMinMax(this.minBoundBox, this.maxBoundBox);
        this.centerBoundBox.add(this.minBoundBox, this.maxBoundBox);
        this.centerBoundBox.scale(0.5f);
        this.boundBoxCornerVector.sub(this.maxBoundBox, this.centerBoundBox);
        int i = 8;
        while (--i >= 0) {
            Point3f bbcagePoint = this.bboxVertices[i] = new Point3f(unitBboxPoints[i]);
            bbcagePoint.x *= this.boundBoxCornerVector.x;
            bbcagePoint.y *= this.boundBoxCornerVector.y;
            bbcagePoint.z *= this.boundBoxCornerVector.z;
            bbcagePoint.add(this.centerBoundBox);
        }
    }

    private float calcRotationRadius(Point3f center) {
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            float radiusVdw;
            Atom atom = this.atoms[i];
            float distAtom = center.distance(atom.point3f);
            float outerVdw = distAtom + (radiusVdw = atom.getVanderwaalsRadiusFloat());
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius;
    }

    boolean frankClicked(int x, int y) {
        Shape frankShape = this.shapes[19];
        if (frankShape == null) {
            return false;
        }
        return frankShape.wasClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest.atom = null;
        this.findNearestAtomIndex(x, y, this.closest);
        for (int i = 0; i < this.shapes.length && this.closest.atom == null; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            shape.findNearestAtomIndex(x, y, this.closest);
        }
        int closestIndex = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return closestIndex;
    }

    void findNearestAtomIndex(int x, int y, Closest closest) {
        Atom champion = null;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom contender = this.atoms[i];
            if (!contender.isCursorOnTopOfClickableAtom(x, y, 6, champion)) continue;
            champion = contender;
        }
        closest.atom = champion;
    }

    BitSet findAtomsInRectangle(Rectangle rect) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if (!rect.contains(atom.getScreenX(), atom.getScreenY())) continue;
            this.bsFoundRectangle.set(i);
        }
        return this.bsFoundRectangle;
    }

    BondIterator getBondIterator(short bondType, BitSet bsSelected) {
        return new SelectedBondIterator(bondType, bsSelected);
    }

    void initializeBspf() {
        if (this.bspf == null) {
            long timeBegin = 0L;
            this.bspf = new Bspf(3);
            Logger.debug("sequential bspt order");
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                if (atom.isDeleted()) continue;
                this.bspf.addTuple(atom.modelIndex, atom);
            }
        }
    }

    private void clearBspf() {
        this.bspf = null;
    }

    int getBsptCount() {
        if (this.bspf == null) {
            this.initializeBspf();
        }
        return this.bspf.getBsptCount();
    }

    AtomIterator getWithinModelIterator(Atom atomCenter, float radius) {
        this.withinModelIterator.initialize(atomCenter.modelIndex, atomCenter, radius);
        return this.withinModelIterator;
    }

    AtomIterator getWithinAnyModelIterator(Atom atomCenter, float radius) {
        this.withinAnyModelIterator.initialize(atomCenter, radius);
        return this.withinAnyModelIterator;
    }

    void doAutobond() {
        if (this.viewer.getAutoBond() && this.getModelSetProperty("noautobond") == null && (this.bondCount == 0 || this.isMultiFile || this.isPDB && this.bondCount < this.atomCount / 2)) {
            this.rebond(false);
        }
    }

    void rebond() {
        this.rebond(true);
    }

    void rebond(boolean deleteFirst) {
        if (deleteFirst) {
            this.deleteAllBonds();
        }
        if (this.maxBondingRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        this.bondTolerance = this.viewer.getBondTolerance();
        this.minBondDistance = this.viewer.getMinBondDistance();
        this.minBondDistance2 = this.minBondDistance * this.minBondDistance;
        this.initializeBspf();
        long timeBegin = 0L;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            float myBondingRadius = atom.getBondingRadiusFloat();
            if (myBondingRadius == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + this.bondTolerance;
            SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, searchRadius);
            while (iter.hasMoreElements()) {
                short order;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2())) <= 0) continue;
                this.checkValencesAndBond(atom, atomNear, order);
            }
            iter.release();
        }
    }

    private short getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + this.bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        if (distance2 < this.minBondDistance2) {
            return 0;
        }
        if (distance2 <= maxAcceptable2) {
            return 1;
        }
        return 0;
    }

    void checkValencesAndBond(Atom atomA, Atom atomB, short order) {
        if (atomA.getCurrentBondCount() > 20 || atomB.getCurrentBondCount() > 20) {
            Logger.warn("maximum auto bond count reached");
            return;
        }
        int formalChargeA = atomA.getFormalCharge();
        if (formalChargeA != 0) {
            int formalChargeB = atomB.getFormalCharge();
            if (formalChargeA < 0 && formalChargeB < 0 || formalChargeA > 0 && formalChargeB > 0) {
                return;
            }
        }
        if (atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != 0 && atomB.alternateLocationID != 0) {
            return;
        }
        this.addBond(atomA.bondMutually(atomB, order, this));
    }

    void autoBond(BitSet bsA, BitSet bsB) {
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float bondTolerance = this.viewer.getBondTolerance();
        float minBondDistance = this.viewer.getMinBondDistance();
        float minBondDistance2 = minBondDistance * minBondDistance;
        this.initializeBspf();
        long timeBegin = 0L;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom;
            float myBondingRadius;
            boolean isAtomInSetB;
            boolean isAtomInSetA = bsA == null || bsA.get(i);
            if (!isAtomInSetA & !(isAtomInSetB = bsB == null || bsB.get(i)) || (myBondingRadius = (atom = this.atoms[i]).getBondingRadiusFloat()) == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + bondTolerance;
            SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, searchRadius);
            while (iter.hasMoreElements()) {
                short order;
                boolean isNearInSetB;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom) continue;
                int atomIndexNear = atomNear.atomIndex;
                boolean isNearInSetA = bsA == null || bsA.get(atomIndexNear);
                if (!isNearInSetA & !(isNearInSetB = bsB == null || bsB.get(atomIndexNear)) || !(isAtomInSetA & isNearInSetB) && !(isAtomInSetB & isNearInSetA) || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2(), minBondDistance2, bondTolerance)) <= 0) continue;
                this.checkValencesAndBond(atom, atomNear, order);
            }
            iter.release();
        }
    }

    private short getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2, float minBondDistance2, float bondTolerance) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        if (distance2 < minBondDistance2) {
            return 0;
        }
        if (distance2 <= maxAcceptable2) {
            return 1;
        }
        return 0;
    }

    void autoHbond(BitSet bsA, BitSet bsB) {
        if (this.useRasMolHbondsCalculation) {
            if (this.mmset != null) {
                this.mmset.calcHydrogenBonds(bsA, bsB);
            }
            return;
        }
        this.initializeBspf();
        long timeBegin = 0L;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            byte elementNumber = atom.elementNumber;
            if (elementNumber != 7 && elementNumber != 8) continue;
            SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, this.hbondMax);
            while (iter.hasMoreElements()) {
                Atom atomNear = (Atom)iter.nextElement();
                byte elementNumberNear = atomNear.elementNumber;
                if (elementNumberNear != 7 && elementNumberNear != 8 || atomNear == atom || iter.foundDistance2() < this.hbondMin2 || atom.isBonded(atomNear)) continue;
                this.addBond(atom.bondMutually(atomNear, (short)64, this));
            }
            iter.release();
        }
    }

    void deleteAllBonds() {
        int i = this.bondCount;
        while (--i >= 0) {
            this.bonds[i].deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = 0;
    }

    void deleteBond(Bond bond) {
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.bonds[i].deleteAtomReferences();
            System.arraycopy(this.bonds, i + 1, this.bonds, i, this.bondCount - i - 1);
            --this.bondCount;
            this.bonds[this.bondCount] = null;
            return;
        }
    }

    void deleteBonds(BitSet bs) {
        int iDst = 0;
        for (int iSrc = 0; iSrc < this.bondCount; ++iSrc) {
            Bond bond = this.bonds[iSrc];
            if (!bs.get(iSrc)) {
                this.bonds[iDst++] = bond;
                continue;
            }
            bond.deleteAtomReferences();
        }
        int i = this.bondCount;
        while (--i >= iDst) {
            this.bonds[i] = null;
        }
        this.bondCount = iDst;
    }

    void deleteCovalentBonds() {
        int indexNoncovalent = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (bond == null) continue;
            if (!bond.isCovalent()) {
                if (i == indexNoncovalent) continue;
                this.bonds[indexNoncovalent++] = bond;
                this.bonds[i] = null;
                continue;
            }
            bond.deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = indexNoncovalent;
    }

    void deleteAtom(int atomIndex) {
        this.clearBspf();
        this.atoms[atomIndex].markDeleted();
    }

    float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    ShapeRenderer getRenderer(int shapeID) {
        return this.frameRenderer.getRenderer(shapeID, this.g3d);
    }

    void doUnitcellStuff() {
        int i;
        int i2;
        int modelCount = this.getModelCount();
        if (this.someModelsHaveUnitcells) {
            boolean doPdbScale = modelCount == 1;
            this.cellInfo = new CellInfo[modelCount];
            for (i2 = 0; i2 < modelCount; ++i2) {
                this.cellInfo[i2] = new CellInfo(i2, doPdbScale);
            }
        }
        if (this.someModelsHaveSymmetry) {
            for (i = 0; i < modelCount; ++i) {
                this.mmset.setSymmetryAtomInfo(i, this.mmset.getModelAuxiliaryInfoInt(i, "presymmetryAtomIndex"), this.mmset.getModelAuxiliaryInfoInt(i, "presymmetryAtomCount"));
            }
        } else {
            int ipt = 0;
            for (i2 = 0; i2 < modelCount; ++i2) {
                ipt = this.mmset.setSymmetryAtomInfo(i2, ipt, this.getAtomCountInModel(i2));
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            i = this.atomCount;
            while (--i >= 0) {
                short modelIndex = this.atoms[i].modelIndex;
                if (!this.cellInfo[modelIndex].coordinatesAreFractional) continue;
                this.cellInfo[modelIndex].transform(this.atoms[i].point3f);
            }
        }
    }

    void calcAtomsMinMax(Point3f pointMin, Point3f pointMax) {
        pointMin.set(this.atoms[0].point3f);
        pointMax.set(this.atoms[0].point3f);
        int i = this.atomCount;
        while (--i > 0) {
            this.checkMinMax(this.atoms[i].point3f, pointMin, pointMax);
        }
    }

    void calcUnitCellMinMax(Point3f pointMin, Point3f pointMax) {
        if (!this.someModelsHaveUnitcells) {
            return;
        }
        int modelCount = this.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            if (!this.cellInfo[i].coordinatesAreFractional) continue;
            for (int j = 0; j < 8; ++j) {
                this.checkMinMax(this.cellInfo[i].vertices[j], pointMin, pointMax);
            }
        }
    }

    void checkMinMax(Point3f pt, Point3f pointMin, Point3f pointMax) {
        float t = pt.x;
        if (t < pointMin.x) {
            pointMin.x = t;
        } else if (t > pointMax.x) {
            pointMax.x = t;
        }
        t = pt.y;
        if (t < pointMin.y) {
            pointMin.y = t;
        } else if (t > pointMax.y) {
            pointMax.y = t;
        }
        t = pt.z;
        if (t < pointMin.z) {
            pointMin.z = t;
        } else if (t > pointMax.z) {
            pointMax.z = t;
        }
    }

    Point3f getAtomSetCenter(BitSet bs) {
        Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
        int nPoints = this.viewer.cardinalityOf(bs);
        if (nPoints == 0) {
            return ptCenter;
        }
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            ptCenter.add(this.atoms[i].point3f);
        }
        ptCenter.scale(1.0f / (float)nPoints);
        return ptCenter;
    }

    int firstAtomOf(BitSet bs) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            return i;
        }
        return -1;
    }

    BitSet getAtomBits(String setType) {
        if (setType.equals("symmetry")) {
            return this.getSymmetrySet();
        }
        if (setType.equals("hetero")) {
            return this.getHeteroSet();
        }
        if (setType.equals("hydrogen")) {
            return this.getHydrogenSet();
        }
        if (setType.equals("protein")) {
            return this.getProteinSet();
        }
        if (setType.equals("nucleic")) {
            return this.getNucleicSet();
        }
        if (setType.equals("dna")) {
            return this.getDnaSet();
        }
        if (setType.equals("rna")) {
            return this.getRnaSet();
        }
        if (setType.equals("purine")) {
            return this.getPurineSet();
        }
        if (setType.equals("pyrimidine")) {
            return this.getPyrimidineSet();
        }
        return null;
    }

    BitSet getAtomBits(String setType, String specInfo) {
        if (setType.equals("SpecAtom")) {
            return this.getSpecAtom(specInfo);
        }
        if (setType.equals("SpecName")) {
            return this.getSpecName(specInfo);
        }
        if (setType.equals("SpecResidueWildcard")) {
            return this.getResidueWildcard(specInfo);
        }
        if (setType.equals("SpecAlternate")) {
            return this.getSpecAlternate(specInfo);
        }
        if (setType.equals("SpecModel")) {
            return this.getSpecModel(specInfo);
        }
        if (setType.equals("PotentialGroupName")) {
            return this.lookupPotentialGroupName(specInfo);
        }
        return null;
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        if (setType.equals("SpecSeqcodeRange")) {
            return this.getSpecSeqcodeRange(specInfo[0], specInfo[1]);
        }
        if (setType.equals("Cell")) {
            return this.getCellSet(specInfo[0], specInfo[1], specInfo[2]);
        }
        return null;
    }

    BitSet getCellSet(int ix, int jy, int kz) {
        BitSet bsCell = new BitSet();
        Point3f cell = new Point3f((float)ix / 1000.0f, (float)jy / 1000.0f, (float)kz / 1000.0f);
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isInLatticeCell(cell)) continue;
            bsCell.set(i);
        }
        return bsCell;
    }

    BitSet getHeteroSet() {
        BitSet bsHetero = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isHetero()) continue;
            bsHetero.set(i);
        }
        return bsHetero;
    }

    BitSet getSymmetrySet() {
        BitSet bs = new BitSet(this.atomCount);
        int i = this.atomCount;
        while (--i >= 0) {
            bs.set(i);
        }
        int modelCount = this.getModelCount();
        for (int i2 = 0; i2 < modelCount; ++i2) {
            int atomIndex = this.mmset.getPreSymmetryAtomIndex(i2);
            int preSymAtomCount = this.mmset.getPreSymmetryAtomCount(i2);
            if (atomIndex < 0) continue;
            int iatom = atomIndex + preSymAtomCount;
            while (--iatom >= atomIndex) {
                bs.clear(iatom);
            }
        }
        return bs;
    }

    BitSet getHydrogenSet() {
        BitSet bsHydrogen = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getElementNumber() != 1) continue;
            bsHydrogen.set(i);
        }
        return bsHydrogen;
    }

    BitSet getProteinSet() {
        BitSet bsProtein = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isProtein()) continue;
            bsProtein.set(i);
        }
        return bsProtein;
    }

    BitSet getNucleicSet() {
        BitSet bsNucleic = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isNucleic()) continue;
            bsNucleic.set(i);
        }
        return bsNucleic;
    }

    BitSet getDnaSet() {
        BitSet bsDna = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isDna()) continue;
            bsDna.set(i);
        }
        return bsDna;
    }

    BitSet getRnaSet() {
        BitSet bsRna = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isRna()) continue;
            bsRna.set(i);
        }
        return bsRna;
    }

    BitSet getPurineSet() {
        BitSet bsPurine = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isPurine()) continue;
            bsPurine.set(i);
        }
        return bsPurine;
    }

    BitSet getPyrimidineSet() {
        BitSet bsPyrimidine = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isPyrimidine()) continue;
            bsPyrimidine.set(i);
        }
        return bsPyrimidine;
    }

    BitSet getAtomBits(String setType, int specInfo) {
        if (setType.equals("SpecResid")) {
            return this.getSpecResid(specInfo);
        }
        if (setType.equals("SpecSeqcode")) {
            return this.getSpecSeqcode(specInfo);
        }
        if (setType.equals("SpecChain")) {
            return this.getSpecChain((char)specInfo);
        }
        if (setType.equals("atomno")) {
            return this.getSpecAtomNumber(specInfo);
        }
        return null;
    }

    BitSet getSpecName(String resNameSpec) {
        BitSet bsRes = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isGroup3Match(resNameSpec)) continue;
            bsRes.set(i);
        }
        return bsRes;
    }

    BitSet getSpecAtomNumber(int atomno) {
        BitSet bsRes = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getAtomNumber() != atomno) continue;
            bsRes.set(i);
        }
        return bsRes;
    }

    BitSet getSpecResid(int resid) {
        BitSet bsRes = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getGroupID() != resid) continue;
            bsRes.set(i);
        }
        return bsRes;
    }

    BitSet getSpecSeqcode(int seqcode) {
        BitSet bsResno = new BitSet();
        int seqNum = seqcode >> 8;
        char insCode = Group.getInsertionCode(seqcode);
        switch (insCode) {
            case '?': {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (seqNum != 0 && seqNum != atomSeqcode >> 8 || (atomSeqcode & 0xFF) == 0) continue;
                    bsResno.set(i);
                }
                break;
            }
            default: {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (seqcode != this.atoms[i].getSeqcode() && (seqNum != 0 || seqcode != (atomSeqcode & 0xFF)) && (insCode != '*' || seqNum != atomSeqcode >> 8)) continue;
                    bsResno.set(i);
                }
                break block0;
            }
        }
        return bsResno;
    }

    BitSet getSpecChain(char chain) {
        boolean caseSensitive = this.viewer.getChainCaseSensitive();
        if (!caseSensitive) {
            chain = Character.toUpperCase(chain);
        }
        BitSet bsChain = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            char ch = this.atoms[i].getChainID();
            if (!caseSensitive) {
                ch = Character.toUpperCase(ch);
            }
            if (chain != ch) continue;
            bsChain.set(i);
        }
        return bsChain;
    }

    BitSet getSpecSeqcodeRange(int seqcodeA, int seqcodeB) {
        BitSet bsResidue = new BitSet();
        this.selectSeqcodeRange(seqcodeA, seqcodeB, bsResidue);
        return bsResidue;
    }

    BitSet getSpecAtom(String atomSpec) {
        BitSet bsAtom = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isAtomNameMatch(atomSpec)) continue;
            bsAtom.set(i);
        }
        return bsAtom;
    }

    BitSet getResidueWildcard(String strWildcard) {
        BitSet bsResidue = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isGroup3Match(strWildcard)) continue;
            bsResidue.set(i);
        }
        return bsResidue;
    }

    BitSet getSpecAlternate(String alternateSpec) {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isAlternateLocationMatch(alternateSpec)) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getSpecModel(String modelTag) {
        int modelNumber = -1;
        try {
            modelNumber = Integer.parseInt(modelTag);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getModelAtomBitSet(this.getModelNumberIndex(modelNumber));
    }

    BitSet lookupPotentialGroupName(String potentialGroupName) {
        BitSet bsResult = null;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isGroup3(potentialGroupName)) continue;
            if (bsResult == null) {
                bsResult = new BitSet(i + 1);
            }
            bsResult.set(i);
        }
        return bsResult;
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        BitSet bs = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getModelBitSet(BitSet atomList) {
        BitSet bs = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!atomList.get(i)) continue;
            bs.set(this.atoms[i].modelIndex);
        }
        return bs;
    }

    void setLabel(String label, int atomIndex) {
    }

    void findElementsPresent() {
        this.elementsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            this.elementsPresent.set(this.atoms[i].elementNumber);
        }
    }

    BitSet getElementsPresentBitSet() {
        return this.elementsPresent;
    }

    void findGroupsPresent() {
        Group groupLast = null;
        this.groupsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (groupLast == this.atoms[i].group) continue;
            groupLast = this.atoms[i].group;
            this.groupsPresent.set(groupLast.getGroupID());
        }
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.mmset.calcSelectedGroupsCount(bsSelected);
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        this.mmset.calcSelectedMonomersCount(bsSelected);
    }

    void calcSelectedMoleculesCount(BitSet bsSelected) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp.clear();
            this.bsTemp.or(bsSelected);
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    void findMaxRadii() {
        int i = this.atomCount;
        while (--i >= 0) {
            float vdwRadius;
            Atom atom = this.atoms[i];
            float bondingRadius = atom.getBondingRadiusFloat();
            if (bondingRadius > this.maxBondingRadius) {
                this.maxBondingRadius = bondingRadius;
            }
            if (!((vdwRadius = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = vdwRadius;
        }
    }

    BitSet getGroupsPresentBitSet() {
        return this.groupsPresent;
    }

    void calcBfactorRange() {
        this.calcBfactorRange(null);
    }

    void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    void calcBfactorRange(BitSet bs) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int i = this.atomCount;
            while (--i > 0) {
                if (bs != null && !bs.get(i)) continue;
                int bf = this.atoms[i].getBfactor100();
                if (bf < this.bfactor100Lo) {
                    this.bfactor100Lo = bf;
                    continue;
                }
                if (bf <= this.bfactor100Hi) continue;
                this.bfactor100Hi = bf;
            }
            this.hasBfactorRange = true;
        }
    }

    int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    BitSet getVisibleSet() {
        BitSet bs = new BitSet();
        int n = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isVisible()) continue;
            bs.set(i);
            ++n;
        }
        return bs;
    }

    float getMeasurement(int[] countPlusIndices) {
        float value = Float.MAX_VALUE;
        if (countPlusIndices == null) {
            return value;
        }
        int count = countPlusIndices[0];
        if (count < 2) {
            return value;
        }
        int i = count;
        while (--i >= 0) {
            if (countPlusIndices[i + 1] >= 0) continue;
            return value;
        }
        switch (count) {
            case 2: {
                value = this.getDistance(countPlusIndices[1], countPlusIndices[2]);
                break;
            }
            case 3: {
                value = this.getAngle(countPlusIndices[1], countPlusIndices[2], countPlusIndices[3]);
                break;
            }
            case 4: {
                value = this.getTorsion(countPlusIndices[1], countPlusIndices[2], countPlusIndices[3], countPlusIndices[4]);
                break;
            }
            default: {
                Logger.error("Invalid count in measurement calculation:" + count);
                throw new IndexOutOfBoundsException();
            }
        }
        return value;
    }

    float getDistance(int atomIndexA, int atomIndexB) {
        return this.atoms[atomIndexA].point3f.distance(this.atoms[atomIndexB].point3f);
    }

    float getAngle(int atomIndexA, int atomIndexB, int atomIndexC) {
        if (this.vectorBA == null) {
            this.vectorBA = new Vector3f();
            this.vectorBC = new Vector3f();
        }
        Point3f pointA = this.atoms[atomIndexA].point3f;
        Point3f pointB = this.atoms[atomIndexB].point3f;
        Point3f pointC = this.atoms[atomIndexC].point3f;
        this.vectorBA.sub(pointA, pointB);
        this.vectorBC.sub(pointC, pointB);
        float angle = this.vectorBA.angle(this.vectorBC);
        float degrees = Frame.toDegrees(angle);
        return degrees;
    }

    float getTorsion(int atomIndexA, int atomIndexB, int atomIndexC, int atomIndexD) {
        return Frame.computeTorsion(this.atoms[atomIndexA].point3f, this.atoms[atomIndexB].point3f, this.atoms[atomIndexC].point3f, this.atoms[atomIndexD].point3f);
    }

    static float toDegrees(float angleRadians) {
        return angleRadians * 180.0f / (float)Math.PI;
    }

    static float computeTorsion(Point3f p1, Point3f p2, Point3f p3, Point3f p4) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = Frame.toDegrees((float)Math.acos(cosang));
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return torsion;
    }

    BitSet getMoleculeBitSet(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    BitSet getMoleculeBitSet(BitSet bs) {
        int iLastBit;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bsResult = (BitSet)bs.clone();
        BitSet bsInitial = (BitSet)bs.clone();
        while ((iLastBit = bsInitial.length()) > 0) {
            this.bsTemp = this.getMoleculeBitSet(iLastBit - 1);
            bsInitial.andNot(this.bsTemp);
            bsResult.or(this.bsTemp);
        }
        return bsResult;
    }

    private void getMolecules() {
        if (this.moleculeCount > 0) {
            return;
        }
        this.moleculeCount = 0;
        int atomCount = this.getAtomCount();
        BitSet atomlist = new BitSet(atomCount);
        BitSet bs = new BitSet(atomCount);
        int thisModelIndex = -1;
        int modelIndex = -1;
        int indexInModel = -1;
        int moleculeCount0 = -1;
        for (int i = 0; i < atomCount; ++i) {
            if (atomlist.get(i) || bs.get(i)) continue;
            modelIndex = this.atoms[i].modelIndex;
            if (modelIndex != thisModelIndex) {
                indexInModel = -1;
                this.mmset.getModel((int)modelIndex).firstMolecule = this.moleculeCount;
                moleculeCount0 = this.moleculeCount - 1;
                thisModelIndex = modelIndex;
            }
            ++indexInModel;
            bs = this.getConnectedBitSet(i);
            atomlist.or(bs);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])Util.setLength(this.molecules, this.moleculeCount * 2);
            }
            this.molecules[this.moleculeCount] = new Molecule(this.moleculeCount, bs, thisModelIndex, indexInModel);
            this.mmset.getModel((int)thisModelIndex).moleculeCount = this.moleculeCount - moleculeCount0;
            ++this.moleculeCount;
        }
    }

    private BitSet getConnectedBitSet(int atomIndex) {
        int atomCount = this.getAtomCount();
        BitSet bs = new BitSet(atomCount);
        BitSet bsToTest = this.getModelAtomBitSet(this.atoms[atomIndex].modelIndex);
        this.getCovalentlyConnectedBitSet(this.atoms[atomIndex], bs, bsToTest);
        return bs;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bs, BitSet bsToTest) {
        int atomIndex = atom.atomIndex;
        if (!bsToTest.get(atomIndex)) {
            return;
        }
        bsToTest.clear(atomIndex);
        bs.set(atomIndex);
        if (atom.bonds == null) {
            return;
        }
        int i = atom.bonds.length;
        while (--i >= 0) {
            Bond bond = atom.bonds[i];
            if ((bond.order & 0x3C0) != 0) continue;
            if (bond.atom1 == atom) {
                this.getCovalentlyConnectedBitSet(bond.atom2, bs, bsToTest);
                continue;
            }
            this.getCovalentlyConnectedBitSet(bond.atom1, bs, bsToTest);
        }
    }

    int getMoleculeCount() {
        return this.moleculeCount;
    }

    Vector getMoleculeInfo(BitSet bsAtoms) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> V = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = (BitSet)bsAtoms.clone();
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            V.add(this.molecules[i].getInfo());
        }
        return V;
    }

    int getMoleculeIndex(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    int getFirstMoleculeIndexInModel(int modelIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        return this.mmset.getModel((int)modelIndex).firstMolecule;
    }

    int getMoleculeCountInModel(int modelIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        return this.mmset.getModel((int)modelIndex).moleculeCount;
    }

    BitSet getGroupBitSet(int atomIndex) {
        BitSet bsGroup = new BitSet();
        this.atoms[atomIndex].group.selectAtoms(bsGroup);
        return bsGroup;
    }

    BitSet getChainBitSet(int atomIndex) {
        BitSet bsChain = new BitSet();
        this.atoms[atomIndex].group.chain.selectAtoms(bsChain);
        return bsChain;
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        this.mmset.selectSeqcodeRange(seqcodeA, seqcodeB, bs);
    }

    Bond[] addToBonds(Bond newBond, Bond[] oldBonds) {
        Bond[] newBonds;
        if (oldBonds == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                newBonds = this.freeBonds[1][this.numCached[1]];
            } else {
                newBonds = new Bond[]{newBond};
            }
        } else {
            int oldLength = oldBonds.length;
            int newLength = oldLength + 1;
            if (newLength < 5 && this.numCached[newLength] > 0) {
                int n = newLength;
                int n2 = this.numCached[n] - 1;
                this.numCached[n] = n2;
                newBonds = this.freeBonds[newLength][n2];
            } else {
                newBonds = new Bond[newLength];
            }
            newBonds[oldLength] = newBond;
            int i = oldLength;
            while (--i >= 0) {
                newBonds[i] = oldBonds[i];
            }
            if (oldLength < 5 && this.numCached[oldLength] < 200) {
                int n = oldLength;
                int n3 = this.numCached[n];
                this.numCached[n] = n3 + 1;
                this.freeBonds[oldLength][n3] = oldBonds;
            }
        }
        return newBonds;
    }

    void freeBondsCache() {
        int i = 5;
        while (--i > 0) {
            this.numCached[i] = 0;
            Bond[][] bondsCache = this.freeBonds[i];
            int j = bondsCache.length;
            while (--j >= 0) {
                bondsCache[j] = null;
            }
        }
    }

    Point3f getAveragePosition(int atomIndex1, int atomIndex2) {
        Atom atom1 = this.atoms[atomIndex1];
        Atom atom2 = this.atoms[atomIndex2];
        return new Point3f((atom1.point3f.x + atom2.point3f.x) / 2.0f, (atom1.point3f.y + atom2.point3f.y) / 2.0f, (atom1.point3f.z + atom2.point3f.z) / 2.0f);
    }

    Vector3f getAtomVector(int atomIndex1, int atomIndex2) {
        Vector3f V = new Vector3f(this.atoms[atomIndex1].point3f);
        V.sub(this.atoms[atomIndex2].point3f);
        return V;
    }

    Vector3f getModelDipole() {
        Vector3f dipole = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("dipole");
        if (dipole == null) {
            dipole = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("DIPOLE_VEC");
        }
        return dipole;
    }

    void getBondDipoles() {
        if (this.partialCharges == null) {
            return;
        }
        this.loadShape(23);
        Dipoles dipoles = (Dipoles)this.shapes[23];
        dipoles.clear(true);
        int i = this.bondCount;
        while (--i >= 0) {
            if (!this.bonds[i].isCovalent()) continue;
            Atom atom1 = this.bonds[i].atom1;
            Atom atom2 = this.bonds[i].atom2;
            float c1 = this.partialCharges[atom1.atomIndex];
            float c2 = this.partialCharges[atom2.atomIndex];
            if (c1 == c2) continue;
            Dipole dipole = dipoles.findDipole(atom1, atom2, true);
            float value = (c1 - c2) / 2.0f * atom1.point3f.distance(atom2.point3f) / 0.208194f;
            if (value < 0.0f) {
                dipole.set(atom2, atom1, -value);
            } else {
                dipole.set(atom1, atom2, value);
            }
            dipole.type = (short)3;
            dipole.modelIndex = atom1.modelIndex;
        }
    }

    String getSymmetryInfoAsString(int modelIndex) {
        return this.cellInfo[modelIndex].symmetryInfoString;
    }

    void convertFractionalCoordinates(int modelIndex, Point3f pt) {
        if (modelIndex < 0) {
            modelIndex = 0;
        }
        if (modelIndex >= this.cellInfo.length || this.cellInfo[modelIndex] == null) {
            return;
        }
        String str = "Frame convertFractional " + pt + "--->";
        this.cellInfo[modelIndex].transform(pt);
        Logger.info(str + pt);
    }

    void setAtomCoord(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        this.atoms[atomIndex].point3f.x = x;
        this.atoms[atomIndex].point3f.y = y;
        this.atoms[atomIndex].point3f.z = z;
    }

    void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        this.atoms[atomIndex].point3f.x += x;
        this.atoms[atomIndex].point3f.y += y;
        this.atoms[atomIndex].point3f.z += z;
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoTypeRaw, boolean hybridizationCompatible) {
        String lcaoType = lcaoTypeRaw.length() > 0 && lcaoTypeRaw.charAt(0) == '-' ? lcaoTypeRaw.substring(1) : lcaoTypeRaw;
        Atom atom = this.atoms[atomIndex];
        z.set(0.0f, 0.0f, 0.0f);
        x.set(0.0f, 0.0f, 0.0f);
        Atom atom1 = atom;
        int nBonds = 0;
        float _180 = 2.984513f;
        Vector3f n = new Vector3f();
        Vector3f x2 = new Vector3f();
        Vector3f x3 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f x4 = new Vector3f();
        Vector3f y1 = new Vector3f();
        Vector3f y2 = new Vector3f();
        if (atom.bonds != null) {
            int i = atom.bonds.length;
            block11: while (--i >= 0) {
                if (!atom.bonds[i].isCovalent()) continue;
                atom1 = atom.bonds[i].getOtherAtom(atom);
                n.sub(atom.point3f, atom1.point3f);
                n.normalize();
                z.add(n);
                switch (++nBonds) {
                    case 1: {
                        x.set(n);
                        continue block11;
                    }
                    case 2: {
                        x2.set(n);
                        continue block11;
                    }
                    case 3: {
                        x3.set(n);
                        x4.set(-z.x, -z.y, -z.z);
                        continue block11;
                    }
                    case 4: {
                        x4.set(n);
                        continue block11;
                    }
                }
                i = -1;
            }
        }
        String hybridization = "";
        switch (nBonds) {
            case 0: {
                z.set(0.0f, 0.0f, 1.0f);
                x.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (lcaoType.indexOf("sp3") == 0) {
                    hybridization = "sp3";
                    x.cross(x3, z);
                    y1.cross(z, x);
                    x.normalize();
                    y1.normalize();
                    y2.set(x);
                    z.normalize();
                    x.scaleAdd(2.828f, x, z);
                    if (!lcaoType.equals("sp3a") && !lcaoType.equals("sp3")) {
                        x.normalize();
                        AxisAngle4f a = new AxisAngle4f(z.x, z.y, z.z, (float)(lcaoType.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f m = new Matrix3f();
                        m.setIdentity();
                        m.set(a);
                        m.transform(x);
                    }
                    z.set(x);
                    x.cross(y1, z);
                    break;
                }
                hybridization = "sp";
                if (atom1.getCovalentBondCount() == 3) {
                    this.getPrincipalAxes(atom1.atomIndex, z, x3, lcaoType, false);
                    x3.set(x);
                    if (lcaoType.indexOf("sp2") == 0) {
                        hybridization = "sp2";
                        z.scale(-1.0f);
                    }
                }
                x.cross(x3, z);
                break;
            }
            case 2: {
                if ((double)z.length() < 0.1) {
                    hybridization = "sp";
                    z.set(x);
                    x.cross(x3, z);
                    break;
                }
                hybridization = lcaoType.indexOf("sp3") == 0 ? "sp3" : "sp2";
                x3.cross(z, x);
                if (lcaoType.indexOf("sp") == 0) {
                    if (lcaoType.equals("sp2a") || lcaoType.equals("sp2b")) {
                        z.set(lcaoType.indexOf("b") >= 0 ? x2 : x);
                        z.scale(-1.0f);
                    }
                    x.cross(z, x3);
                    break;
                }
                if (lcaoType.indexOf("lp") == 0) {
                    hybridization = "lp";
                    x3.normalize();
                    z.normalize();
                    y1.scaleAdd(1.2f, x3, z);
                    y2.scaleAdd(-1.2f, x3, z);
                    z.set(lcaoType.indexOf("b") >= 0 ? y2 : y1);
                    x.cross(z, x3);
                    break;
                }
                hybridization = lcaoType;
                x.cross(z, x3);
                z.set(x3);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
                break;
            }
            default: {
                if (x.angle(x2) < _180) {
                    y1.cross(x, x2);
                } else {
                    y1.cross(x, x3);
                }
                y1.normalize();
                if (x2.angle(x3) < _180) {
                    y2.cross(x2, x3);
                } else {
                    y2.cross(x, x3);
                }
                y2.normalize();
                if (Math.abs(y2.dot(y1)) < 0.95f) {
                    hybridization = "sp3";
                    if (lcaoType.indexOf("sp") == 0) {
                        z.set(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x)));
                        z.scale(-1.0f);
                        x.set(y1);
                        break;
                    }
                    x.cross(z, x);
                    break;
                }
                hybridization = "sp2";
                if (lcaoType.indexOf("sp") == 0) {
                    z.set(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x)));
                    z.scale(-1.0f);
                    x.set(y1);
                    break;
                }
                z.set(y1);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
            }
        }
        x.normalize();
        z.normalize();
        Logger.debug(atom.getIdentity() + " nBonds=" + nBonds + " " + hybridization);
        if (hybridizationCompatible) {
            if (hybridization == "") {
                return false;
            }
            if (lcaoType.indexOf("p") == 0 ? hybridization == "sp3" : lcaoType.indexOf(hybridization) < 0) {
                return false;
            }
        }
        return true;
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        int n = 0;
        Vector3f z = new Vector3f();
        Vector3f x = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!atomSet.get(i) || this.atoms[i].elementNumber != 6) continue;
            Atom atom = this.atoms[i];
            int nBonds = atom.getCovalentBondCount();
            n += nBonds > 0 && nBonds < 4 ? 4 - nBonds : 0;
        }
        Point3f[] hAtoms = new Point3f[n];
        n = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!atomSet.get(i) || this.atoms[i].elementNumber != 6) continue;
            Atom atom = this.atoms[i];
            int nBonds = atom.getCovalentBondCount();
            switch (nBonds) {
                case 1: {
                    this.viewer.getPrincipalAxes(i, z, x, "sp3c", false);
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom.point3f);
                    hAtoms[n++] = pt;
                }
                case 2: {
                    this.viewer.getPrincipalAxes(i, z, x, "sp3b", false);
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom.point3f);
                    hAtoms[n++] = pt;
                }
                case 3: {
                    this.viewer.getPrincipalAxes(i, z, x, "sp3a", false);
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom.point3f);
                    hAtoms[n++] = pt;
                }
            }
        }
        return hAtoms;
    }

    class CellInfo {
        int modelIndex;
        boolean hasUnitcell;
        boolean coordinatesAreFractional;
        String spaceGroup;
        float a;
        float b;
        float c;
        float alpha;
        float beta;
        float gamma;
        int symmetryCount;
        String[] symmetryOperations;
        String symmetryInfoString;
        Matrix3f matrixNotional;
        Matrix3f matrixEuclideanToFractional;
        Matrix3f matrixFractionalToEuclidean;
        Point3f[] vertices;
        Point3f offset = new Point3f();
        Matrix3f pdbScaleMatrix;
        Matrix3f pdbScaleMatrixTranspose;
        Vector3f pdbTranslateVector;

        CellInfo(int modelIndex, boolean doPdbScale) {
            this.modelIndex = modelIndex;
            this.spaceGroup = (String)Frame.this.getModelAuxiliaryInfo(modelIndex, "spaceGroup");
            if (this.spaceGroup == null || this.spaceGroup == "") {
                this.spaceGroup = "spacegroup unspecified";
            }
            this.symmetryCount = Frame.this.mmset.getModelAuxiliaryInfoInt(modelIndex, "symmetryCount");
            this.symmetryOperations = (String[])Frame.this.mmset.getModelAuxiliaryInfo(modelIndex, "symmetryOperations");
            this.symmetryInfoString = "Spacegroup: " + this.spaceGroup;
            if (this.symmetryOperations == null) {
                this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
            } else {
                this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: " + (this.symmetryCount == 0 ? 1 : this.symmetryCount) + "\nSymmetry Operations:";
                for (int i = 0; i < this.symmetryCount; ++i) {
                    this.symmetryInfoString = this.symmetryInfoString + "\n" + this.symmetryOperations[i];
                }
            }
            this.symmetryInfoString = this.symmetryInfoString + "\n";
            this.coordinatesAreFractional = Frame.this.mmset.getModelAuxiliaryInfoBoolean(modelIndex, "coordinatesAreFractional");
            Frame.this.notionalUnitcell = (float[])Frame.this.mmset.getModelAuxiliaryInfo(modelIndex, "notionalUnitcell");
            if (Frame.this.notionalUnitcell == null || Frame.this.notionalUnitcell[0] == 0.0f) {
                return;
            }
            this.a = Frame.this.notionalUnitcell[0];
            this.b = Frame.this.notionalUnitcell[1];
            this.c = Frame.this.notionalUnitcell[2];
            this.alpha = Frame.this.notionalUnitcell[3];
            this.beta = Frame.this.notionalUnitcell[4];
            this.gamma = Frame.this.notionalUnitcell[5];
            this.hasUnitcell = true;
            this.matrixNotional = new Matrix3f();
            this.calcNotionalMatrix();
            if (doPdbScale) {
                this.setPdbScaleMatrix();
                this.setPdbScaleTranslate();
            }
            this.constructFractionalMatrices();
            this.calcUnitcellVertices();
            this.showInfo();
        }

        void setOffset(Point3f pt) {
            if (!this.hasUnitcell) {
                return;
            }
            this.offset.set(pt);
            this.matrixFractionalToEuclidean.transform(this.offset);
        }

        void showInfo() {
            Logger.debug("cellInfo[" + this.modelIndex + "]: a,b,c:" + this.a + "," + this.b + "," + this.c + "; alpha,beta,gamma:" + this.alpha + "," + this.beta + "," + this.gamma);
        }

        final void calcNotionalMatrix() {
            float cosAlpha = (float)Math.cos((float)Math.PI / 180 * this.alpha);
            float cosBeta = (float)Math.cos((float)Math.PI / 180 * this.beta);
            float cosGamma = (float)Math.cos((float)Math.PI / 180 * this.gamma);
            float sinGamma = (float)Math.sin((float)Math.PI / 180 * this.gamma);
            this.matrixNotional.setColumn(0, this.a, 0.0f, 0.0f);
            this.matrixNotional.setColumn(1, this.b * cosGamma, this.b * sinGamma, 0.0f);
            float V = this.a * this.b * this.c * (float)Math.sqrt(1.0 - (double)(cosAlpha * cosAlpha) - (double)(cosBeta * cosBeta) - (double)(cosGamma * cosGamma) + 2.0 * (double)cosAlpha * (double)cosBeta * (double)cosGamma);
            this.matrixNotional.setColumn(2, this.c * cosBeta, this.c * (cosAlpha - cosBeta * cosGamma) / sinGamma, V / (this.a * this.b * sinGamma));
        }

        void setPdbScaleMatrix() {
            if (Frame.this.pdbScaleMatrixArray == null) {
                return;
            }
            if (Frame.this.pdbScaleMatrixArray.length != 9) {
                Logger.warn("pdbScaleMatrix.length != 9 :" + this.pdbScaleMatrix);
                return;
            }
            this.pdbScaleMatrix = new Matrix3f(Frame.this.pdbScaleMatrixArray);
            this.pdbScaleMatrixTranspose = new Matrix3f();
            this.pdbScaleMatrixTranspose.transpose(this.pdbScaleMatrix);
        }

        void setPdbScaleTranslate() {
            if (Frame.this.pdbScaleTranslateArray == null) {
                return;
            }
            if (Frame.this.pdbScaleTranslateArray.length != 3) {
                Logger.warn("pdbScaleTranslateArray.length != 3 :" + Frame.this.pdbScaleTranslateArray);
                return;
            }
            this.pdbTranslateVector = new Vector3f(Frame.this.pdbScaleTranslateArray);
        }

        void constructFractionalMatrices() {
            if (this.pdbScaleMatrix != null) {
                this.matrixEuclideanToFractional = new Matrix3f();
                this.matrixEuclideanToFractional.transpose(this.pdbScaleMatrix);
                this.matrixFractionalToEuclidean = new Matrix3f();
                this.matrixFractionalToEuclidean.invert(this.matrixEuclideanToFractional);
            } else {
                this.matrixFractionalToEuclidean = this.matrixNotional;
                this.matrixEuclideanToFractional = new Matrix3f();
                this.matrixEuclideanToFractional.invert(this.matrixFractionalToEuclidean);
            }
        }

        void calcUnitcellVertices() {
            this.vertices = new Point3f[8];
            int i = 8;
            while (--i >= 0) {
                this.vertices[i] = new Point3f();
                this.matrixFractionalToEuclidean.transform(unitCubePoints[i], this.vertices[i]);
            }
        }

        void transform(Point3f pt) {
            if (this.matrixFractionalToEuclidean == null) {
                return;
            }
            this.matrixFractionalToEuclidean.transform(pt);
        }
    }

    class WithinAnyModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinAnyModelIterator() {
        }

        void initialize(Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = Frame.this.bspf.getBsptCount();
            this.bsptIter = null;
            this.center = center;
            this.radius = radius;
        }

        public boolean hasNext() {
            while (this.bsptIter == null || !this.bsptIter.hasMoreElements()) {
                if (--this.bsptIndex < 0) {
                    this.bsptIter = null;
                    return false;
                }
                this.bsptIter = Frame.this.bspf.getSphereIterator(this.bsptIndex);
                this.bsptIter.initialize(this.center, this.radius);
            }
            return true;
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class WithinModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinModelIterator() {
        }

        void initialize(int bsptIndex, Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = bsptIndex;
            this.bsptIter = Frame.this.bspf.getSphereIterator(bsptIndex);
            this.center = center;
            this.radius = radius;
            this.bsptIter.initialize(center, radius);
        }

        public boolean hasNext() {
            return this.bsptIter.hasMoreElements();
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class SelectedBondIterator
    implements BondIterator {
        short bondType;
        int iBond;
        BitSet bsSelected;
        boolean bondSelectionModeOr;

        SelectedBondIterator(short bondType, BitSet bsSelected) {
            this.bondType = bondType;
            this.bsSelected = bsSelected;
            this.iBond = 0;
            this.bondSelectionModeOr = Frame.this.viewer.getBondSelectionModeOr();
        }

        public boolean hasNext() {
            while (this.iBond < Frame.this.bondCount) {
                Bond bond = Frame.this.bonds[this.iBond];
                if (this.bondType == -1 || (bond.order & this.bondType) != 0) {
                    boolean isSelected2;
                    boolean isSelected1;
                    if (!this.bondSelectionModeOr & (isSelected1 = this.bsSelected.get(bond.atom1.atomIndex)) & (isSelected2 = this.bsSelected.get(bond.atom2.atomIndex)) || this.bondSelectionModeOr & (isSelected1 | isSelected2)) {
                        return true;
                    }
                }
                ++this.iBond;
            }
            return false;
        }

        public int nextIndex() {
            return this.iBond;
        }

        public Bond next() {
            return Frame.this.bonds[this.iBond++];
        }
    }

    class Molecule {
        int moleculeIndex;
        int modelIndex;
        int indexInModel;
        int nAtoms;
        int nElements;
        int[] elementCounts = new int[120];
        String mf;
        BitSet atomList;

        Hashtable getInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("number", new Integer(this.moleculeIndex + 1));
            info.put("modelNumber", new Integer(this.modelIndex + 1));
            info.put("numberInModel", new Integer(this.indexInModel + 1));
            info.put("nAtoms", new Integer(this.nAtoms));
            info.put("nElements", new Integer(this.nElements));
            info.put("mf", this.mf);
            return info;
        }

        Molecule(int moleculeIndex, BitSet atomList, int modelIndex, int indexInModel) {
            this.atomList = atomList;
            this.moleculeIndex = moleculeIndex;
            this.modelIndex = modelIndex;
            this.indexInModel = indexInModel;
            this.nAtoms = this.getElementAndAtomCount(atomList, this.elementCounts, Frame.this.atomCount);
            this.nElements = this.countElements(this.elementCounts, JmolConstants.elementNumberMax);
            this.mf = this.getMolecularFormula(this.elementCounts, JmolConstants.elementNumberMax);
            Logger.info("new Molecule (" + this.mf + ") " + (indexInModel + 1) + "/" + (modelIndex + 1));
        }

        int getElementAndAtomCount(BitSet atomList, int[] elementCounts, int atomMax) {
            int nAtoms = 0;
            for (int i = 0; i < atomMax; ++i) {
                if (!atomList.get(i)) continue;
                ++nAtoms;
                byte by = Frame.this.atoms[i].elementNumber;
                elementCounts[by] = elementCounts[by] + 1;
            }
            return nAtoms;
        }

        int countElements(int[] elementCounts, int eMax) {
            int count = 0;
            for (int i = 1; i < eMax; ++i) {
                if (elementCounts[i] <= 0) continue;
                ++count;
            }
            return count;
        }

        String getMolecularFormula(int[] elementCounts, int eMax) {
            String mf = "";
            String sep = "";
            for (int i = 1; i < eMax; ++i) {
                int nX = elementCounts[i];
                if (nX == 0) continue;
                mf = mf + sep + JmolConstants.elementSymbols[i] + " " + nX;
                sep = " ";
            }
            return mf;
        }
    }
}

