/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Font3D;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.Context;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PatternMatcher;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval
implements Runnable {
    Compiler compiler;
    static final int scriptLevelMax = 10;
    int scriptLevel;
    Context[] stack = new Context[10];
    String filename;
    String script;
    short[] linenumbers;
    short[] lineIndices;
    Token[][] aatoken;
    int pc;
    long timeBeginExecution;
    long timeEndExecution;
    boolean error;
    String errorMessage;
    Token[] statement;
    int statementLength;
    Viewer viewer;
    Thread myThread;
    boolean terminationNotification;
    boolean interruptExecution;
    boolean tQuiet;
    static final boolean logMessages = false;
    final StringBuffer strbufLog = new StringBuffer(80);
    int pcLastExpressionInstruction;
    boolean coordinatesAreFractional;
    Hashtable variables = new Hashtable();
    boolean echoShapeActive = false;
    int lastMoIndex = 0;

    Eval(Viewer viewer) {
        this.compiler = new Compiler();
        this.viewer = viewer;
        this.clearDefinitionsAndLoadPredefined();
    }

    synchronized void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.interruptExecution = false;
            this.myThread.start();
        }
    }

    synchronized void haltExecution() {
        if (this.myThread != null) {
            this.interruptExecution = true;
            this.myThread.interrupt();
        }
    }

    boolean isScriptExecuting() {
        return this.myThread != null;
    }

    synchronized void clearMyThread() {
        this.myThread = null;
    }

    boolean isActive() {
        return this.myThread != null;
    }

    boolean hasTerminationNotification() {
        return this.terminationNotification;
    }

    void resetTerminationNotification() {
        this.terminationNotification = false;
    }

    boolean hadRuntimeError() {
        return this.error;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    void runScript(String script) throws ScriptException {
        this.pushContext();
        if (this.loadScript(null, script)) {
            this.instructionDispatchLoop();
        }
        this.popContext();
    }

    void pushContext() throws ScriptException {
        if (this.scriptLevel == 10) {
            this.evalError("too many script levels");
        }
        Context context = new Context();
        context.filename = this.filename;
        context.script = this.script;
        context.linenumbers = this.linenumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.pc = this.pc;
        this.stack[this.scriptLevel++] = context;
    }

    void popContext() throws ScriptException {
        if (this.scriptLevel == 0) {
            this.evalError("RasMol virtual machine error - stack underflow");
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.script = context.script;
        this.linenumbers = context.linenumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.pc = context.pc;
    }

    boolean loadScript(String filename, String script) {
        this.filename = filename;
        this.script = script;
        if (!this.compiler.compile(filename, script)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            this.viewer.scriptStatus("script compiler ERROR: " + this.errorMessage);
            return false;
        }
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.linenumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        return true;
    }

    void clearState(boolean tQuiet) {
        int i = 10;
        while (--i >= 0) {
            this.stack[i] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.terminationNotification = false;
        this.interruptExecution = false;
        this.tQuiet = tQuiet;
    }

    boolean loadScriptString(String script, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScript(null, script);
    }

    boolean loadScriptFile(String filename, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScriptFileInternal(filename);
    }

    boolean loadScriptFileInternal(String filename) {
        Object t = this.viewer.getInputStreamOrErrorMessageFromName(filename);
        if (!(t instanceof InputStream)) {
            return this.loadError((String)t);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)t));
        StringBuffer script = new StringBuffer();
        try {
            String command;
            while ((command = reader.readLine()) != null) {
                script.append(command);
                script.append("\n");
            }
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.ioError(filename);
        }
        try {
            reader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return this.loadScript(filename, script.toString());
    }

    boolean loadError(String msg) {
        this.error = true;
        this.errorMessage = msg;
        return false;
    }

    boolean fileNotFound(String filename) {
        return this.loadError("file not found:" + filename);
    }

    boolean ioError(String filename) {
        return this.loadError("io error reading:" + filename);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Eval\n pc:");
        str.append(this.pc);
        str.append("\n");
        str.append(this.aatoken.length);
        str.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            str.append(" |");
            Token[] atoken = this.aatoken[i];
            for (int j = 0; j < atoken.length; ++j) {
                str.append(' ');
                str.append(atoken[j]);
            }
            str.append("\n");
        }
        str.append("END\n");
        return str.toString();
    }

    void clearDefinitionsAndLoadPredefined() {
        String definition;
        this.variables.clear();
        int cPredef = JmolConstants.predefinedSets.length;
        for (int iPredef = 0; iPredef < cPredef; ++iPredef) {
            this.predefine(JmolConstants.predefinedSets[iPredef]);
        }
        int i = JmolConstants.elementNames.length;
        while (--i > 1) {
            definition = "@" + JmolConstants.elementNames[i] + " _e=" + i;
            this.predefine(definition);
        }
        int j = JmolConstants.alternateElementNumbers.length;
        while (--j >= 0) {
            definition = "@" + JmolConstants.alternateElementNames[j] + " _e=" + JmolConstants.alternateElementNumbers[j];
            this.predefine(definition);
        }
    }

    void predefineElements() {
        int i = JmolConstants.elementNames.length;
        while (--i > 1) {
            String definition = "@" + JmolConstants.elementNames[i] + " _e=" + i;
            if (!this.compiler.compile("#element", definition)) {
                Logger.error("element definition error:" + definition);
                continue;
            }
            Token[][] aatoken = this.compiler.getAatokenCompiled();
            Token[] statement = aatoken[0];
            String variable = (String)statement[1].value;
            this.variables.put(variable, statement);
        }
    }

    void predefine(String script) {
        if (this.compiler.compile("#predefine", script)) {
            Token[][] aatoken = this.compiler.getAatokenCompiled();
            if (aatoken.length != 1) {
                this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + script);
                return;
            }
            Token[] statement = aatoken[0];
            if (statement.length > 2) {
                int tok = statement[1].tok;
                if (tok == 1 || (tok & 0x48000) == 294912) {
                    String variable = (String)statement[1].value;
                    this.variables.put(variable, statement);
                } else {
                    this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + script);
                }
            } else {
                this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + script);
            }
        } else {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + script + "\ncompile error:" + this.compiler.getErrorMessage());
        }
    }

    public void run() {
        this.runEval();
        this.terminationNotification = true;
        if (this.myThread != null) {
            this.clearMyThread();
        }
    }

    public void runEval() {
        this.refresh();
        this.timeBeginExecution = System.currentTimeMillis();
        this.viewer.pushHoldRepaint();
        try {
            this.instructionDispatchLoop();
        }
        catch (ScriptException e) {
            this.error = true;
            this.errorMessage = "" + e;
            this.viewer.scriptStatus("script ERROR: " + this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.interruptExecution) {
            this.errorMessage = "execution interrupted";
        }
        if (this.errorMessage != null) {
            this.viewer.scriptStatus("script ERROR: " + this.errorMessage);
        } else if (!this.tQuiet) {
            this.viewer.scriptStatus("Script completed");
        }
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint();
    }

    void instructionDispatchLoop() throws ScriptException {
        long timeBegin = 0L;
        block69: while (!this.interruptExecution && this.pc < this.aatoken.length) {
            this.statement = this.aatoken[this.pc++];
            this.statementLength = this.statement.length;
            if (this.viewer.getDebugScript()) {
                this.logDebugScript();
            }
            Token token = this.statement[0];
            System.out.println(token.toString());
            switch (token.tok) {
                case 303360: {
                    this.proteinShape(8);
                    continue block69;
                }
                case 4718849: {
                    this.background();
                    continue block69;
                }
                case 4868: {
                    this.center();
                    continue block69;
                }
                case 526598: {
                    this.color();
                    continue block69;
                }
                case 777: {
                    this.define();
                    continue block69;
                }
                case 1050891: {
                    this.echo();
                    continue block69;
                }
                case 268: 
                case 277: {
                    return;
                }
                case 0x10010F: {
                    this.label();
                    continue block69;
                }
                case 0x100151: {
                    this.hover();
                    continue block69;
                }
                case 0x1000110: {
                    this.load();
                    continue block69;
                }
                case 15634: {
                    this.monitor();
                    continue block69;
                }
                case 278: {
                    this.refresh();
                    continue block69;
                }
                case 280: {
                    this.reset();
                    continue block69;
                }
                case 2106651: {
                    this.rotate(false);
                    continue block69;
                }
                case 0x10011D: {
                    this.script();
                    continue block69;
                }
                case 798: {
                    this.select();
                    continue block69;
                }
                case 2097450: {
                    this.translate();
                    continue block69;
                }
                case 302: {
                    this.zap();
                    continue block69;
                }
                case 12591: {
                    this.zoom();
                    continue block69;
                }
                case 316: {
                    this.delay();
                    continue block69;
                }
                case 317: {
                    this.delay();
                    this.pc = 0;
                    continue block69;
                }
                case 2097470: {
                    this.move();
                    continue block69;
                }
                case 793: {
                    this.restrict();
                    continue block69;
                }
                case 2105631: {
                    this.set();
                    continue block69;
                }
                case 8481: {
                    this.slab();
                    continue block69;
                }
                case 306: {
                    this.depth();
                    continue block69;
                }
                case 307: {
                    this.star();
                    continue block69;
                }
                case 2107683: {
                    this.spacefill();
                    continue block69;
                }
                case 8492: {
                    this.wireframe();
                    continue block69;
                }
                case 2097491: {
                    this.vector();
                    continue block69;
                }
                case 2098529: {
                    this.dipole();
                    continue block69;
                }
                case 323: {
                    this.animation();
                    continue block69;
                }
                case 338: {
                    this.vibration();
                    continue block69;
                }
                case 8458: {
                    this.dots(false);
                    continue block69;
                }
                case 10535: {
                    this.proteinShape(11);
                    continue block69;
                }
                case 340: {
                    this.proteinShape(12);
                    continue block69;
                }
                case 8474: {
                    this.proteinShape(13);
                    continue block69;
                }
                case 8489: {
                    this.proteinShape(9);
                    continue block69;
                }
                case 2307: {
                    this.proteinShape(10);
                    continue block69;
                }
                case 342: {
                    this.proteinShape(14);
                    continue block69;
                }
                case 2112832: {
                    this.rotate(true);
                    continue block69;
                }
                case 10532: {
                    this.ssbond();
                    continue block69;
                }
                case 10509: {
                    this.hbond(true);
                    continue block69;
                }
                case 288: {
                    this.show();
                    continue block69;
                }
                case 324: {
                    this.frame(1, false);
                    continue block69;
                }
                case 102661: {
                    this.frame(1, true);
                    continue block69;
                }
                case 336: {
                    this.font();
                    continue block69;
                }
                case 2097496: {
                    this.moveto();
                    continue block69;
                }
                case 345: {
                    this.bondorder();
                    continue block69;
                }
                case 346: {
                    this.console();
                    continue block69;
                }
                case 347: {
                    this.pmesh();
                    continue block69;
                }
                case 1375: {
                    this.draw();
                    continue block69;
                }
                case 1372: {
                    this.polyhedra();
                    continue block69;
                }
                case 343: {
                    this.dots(true);
                    continue block69;
                }
                case 349: {
                    this.centerAt();
                    continue block69;
                }
                case 2626910: {
                    this.isosurface();
                    continue block69;
                }
                case 524644: {
                    this.lcaoCartoon();
                    continue block69;
                }
                case 2625891: {
                    this.mo();
                    continue block69;
                }
                case 6299942: {
                    this.stereo();
                    continue block69;
                }
                case 1287: {
                    this.connect();
                    continue block69;
                }
                case 352: {
                    this.getProperty();
                    continue block69;
                }
                case 354: {
                    this.conformation();
                    continue block69;
                }
                case 2305: {
                    this.setAxes(1);
                    continue block69;
                }
                case 6405: {
                    this.setBoundbox(1);
                    continue block69;
                }
                case 2324: {
                    this.setUnitcell(1);
                    continue block69;
                }
                case 2336: {
                    this.setFrank(1);
                    continue block69;
                }
                case 261: 
                case 270: 
                case 276: 
                case 284: 
                case 296: 
                case 299: 
                case 319: 
                case 322: 
                case 2349: 
                case 4417: 
                case 10498: 
                case 16659: 
                case 98572: 
                case 2097431: {
                    this.viewer.scriptStatus("script ERROR: command not implemented:" + token.value);
                    continue block69;
                }
            }
            this.unrecognizedCommand(token);
            return;
        }
    }

    int getLinenumber() {
        return this.linenumbers[this.pc];
    }

    String getLine() {
        short ichBegin = this.lineIndices[this.pc];
        int ichEnd = this.script.indexOf(13, (int)ichBegin);
        if (ichEnd == -1 && (ichEnd = this.script.indexOf(10, (int)ichBegin)) == -1) {
            ichEnd = this.script.length();
        }
        return this.script.substring(ichBegin, ichEnd);
    }

    /*
     * Enabled aggressive block sorting
     */
    void logDebugScript() {
        int i;
        this.strbufLog.setLength(0);
        Logger.debug(this.statement[0].toString());
        for (i = 1; i < this.statementLength; ++i) {
            this.strbufLog.append(this.statement[i] + "\n");
            Logger.debug(this.statement[i].toString());
        }
        this.strbufLog.append(this.statement[0].value.toString());
        i = 1;
        while (true) {
            block19: {
                if (i >= this.statementLength) {
                    this.viewer.scriptStatus(this.strbufLog.toString());
                    return;
                }
                this.strbufLog.append(' ');
                Token token = this.statement[i];
                switch (token.tok) {
                    case 2: {
                        this.strbufLog.append(token.intValue);
                        break block19;
                    }
                    case 16407: {
                        this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                        break block19;
                    }
                    case 16409: {
                        this.strbufLog.append(':');
                        this.strbufLog.append((char)token.intValue);
                        break block19;
                    }
                    case 16410: {
                        this.strbufLog.append("%");
                        this.strbufLog.append("" + token.value);
                        break;
                    }
                    case 16411: {
                        this.strbufLog.append("/");
                        this.strbufLog.append("" + token.value);
                        break;
                    }
                    case 16405: {
                        this.strbufLog.append('[');
                        this.strbufLog.append(Group.getGroup3((short)token.intValue));
                        this.strbufLog.append(']');
                        break block19;
                    }
                    case 16406: {
                        this.strbufLog.append('[');
                        this.strbufLog.append(token.value);
                        this.strbufLog.append(']');
                        break block19;
                    }
                    case 16412: {
                        this.strbufLog.append('.');
                        break;
                    }
                    case 16408: {
                        this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                        this.strbufLog.append('-');
                        this.strbufLog.append(Group.getSeqcodeString((Integer)token.value));
                        break;
                    }
                    case 32774: {
                        this.strbufLog.append("within ");
                        break;
                    }
                    case 32788: {
                        this.strbufLog.append("connected ");
                        break;
                    }
                    case 32784: {
                        this.strbufLog.append("substructure ");
                        break;
                    }
                    case 98317: {
                        Point3f pt = (Point3f)token.value;
                        this.strbufLog.append("cell={" + pt.x + " " + pt.y + " " + pt.z + "}");
                        break block19;
                    }
                    case 163840: 
                    case 163841: 
                    case 163842: 
                    case 163843: 
                    case 163844: 
                    case 163845: {
                        this.strbufLog.append(Token.atomPropertyNames[token.intValue & 0xF]);
                        this.strbufLog.append(Token.comparatorNames[token.tok & 0xF]);
                    }
                }
                this.strbufLog.append("" + token.value);
            }
            ++i;
        }
    }

    BitSet expression(Token[] code, int pcStart) throws ScriptException {
        int numberOfAtoms = this.viewer.getAtomCount();
        BitSet[] stack = new BitSet[10];
        int sp = 0;
        boolean refreshed = false;
        this.pcLastExpressionInstruction = 1000;
        int pc = pcStart;
        block27: while (true) {
            Token instruction = code[pc];
            switch (instruction.tok) {
                case 32868: {
                    break;
                }
                case 32869: {
                    this.pcLastExpressionInstruction = pc;
                    break block27;
                }
                case 36875: {
                    int n = sp++;
                    BitSet bitSet = new BitSet(numberOfAtoms);
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    int i = numberOfAtoms;
                    while (--i >= 0) {
                        bs.set(i);
                    }
                    break;
                }
                case 49157: {
                    stack[sp++] = new BitSet();
                    break;
                }
                case 32772: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].or(bs);
                    break;
                }
                case 32771: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].and(bs);
                    break;
                }
                case 32773: {
                    BitSet bs = stack[sp - 1];
                    this.notSet(bs);
                    break;
                }
                case 32774: {
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = this.within(instruction, bs);
                    break;
                }
                case 32788: {
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = this.connected(instruction, bs);
                    break;
                }
                case 32784: {
                    stack[sp++] = this.getSubstructureSet((String)instruction.value);
                    break;
                }
                case 299011: {
                    stack[sp++] = this.copyBitSet(this.viewer.getSelectionSet());
                    break;
                }
                case 294925: {
                    if (!refreshed) {
                        this.viewer.setModelVisibility();
                    }
                    refreshed = true;
                    stack[sp++] = this.copyBitSet(this.viewer.getVisibleSet());
                    break;
                }
                case 299016: {
                    stack[sp++] = this.viewer.getAtomBits((String)instruction.value);
                    break;
                }
                case 294918: 
                case 294919: 
                case 294920: 
                case 294921: 
                case 294922: 
                case 294923: 
                case 296961: 
                case 296962: {
                    stack[sp++] = this.viewer.getAtomBits((String)instruction.value);
                    break;
                }
                case 16406: {
                    stack[sp++] = this.viewer.getAtomBits("SpecName", (String)instruction.value);
                    break;
                }
                case 16405: {
                    stack[sp++] = this.viewer.getAtomBits("SpecResid", instruction.intValue);
                    break;
                }
                case 16407: {
                    stack[sp++] = this.viewer.getAtomBits("SpecSeqcode", instruction.intValue);
                    break;
                }
                case 16408: {
                    int seqcodeA = instruction.intValue;
                    int seqcodeB = (Integer)instruction.value;
                    stack[sp++] = this.viewer.getAtomBits("SpecSeqcodeRange", new int[]{seqcodeA, seqcodeB});
                    break;
                }
                case 16409: {
                    stack[sp++] = this.viewer.getAtomBits("SpecChain", instruction.intValue);
                    break;
                }
                case 16412: {
                    stack[sp++] = this.viewer.getAtomBits("SpecAtom", (String)instruction.value);
                    break;
                }
                case 16410: {
                    stack[sp++] = this.viewer.getAtomBits("SpecAlternate", (String)instruction.value);
                    break;
                }
                case 16411: {
                    stack[sp++] = this.viewer.getAtomBits("SpecModel", (String)instruction.value);
                    break;
                }
                case 98317: {
                    Point3f pt = (Point3f)instruction.value;
                    stack[sp++] = this.viewer.getAtomBits("Cell", new int[]{(int)(pt.x * 1000.0f), (int)(pt.y * 1000.0f), (int)(pt.z * 1000.0f)});
                    break;
                }
                case 1: 
                case 294912: 
                case 294917: 
                case 294924: 
                case 296964: 
                case 303360: {
                    stack[sp++] = this.lookupIdentifierValue((String)instruction.value);
                    break;
                }
                case 163840: 
                case 163841: 
                case 163842: 
                case 163843: 
                case 163844: 
                case 163845: {
                    int n = sp++;
                    BitSet bitSet = new BitSet();
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    this.comparatorInstruction(instruction, bs);
                    break;
                }
                default: {
                    this.unrecognizedExpression();
                }
            }
            ++pc;
        }
        if (sp != 1) {
            this.evalError("atom expression compiler error - stack over/underflow");
        }
        return stack[0];
    }

    void notSet(BitSet bs) {
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (bs.get(i)) {
                bs.clear(i);
                continue;
            }
            bs.set(i);
        }
    }

    BitSet lookupIdentifierValue(String identifier) throws ScriptException {
        int seqcodeEnd;
        String potentialGroupName;
        BitSet bsName;
        int alphaLen;
        BitSet bsDefinedSet = this.lookupValue(identifier, false);
        if (bsDefinedSet != null) {
            return this.copyBitSet(bsDefinedSet);
        }
        int len = identifier.length();
        for (alphaLen = 0; alphaLen < len && Compiler.isAlphabetic(identifier.charAt(alphaLen)); ++alphaLen) {
        }
        if (alphaLen > 3) {
            this.undefinedVariable(identifier);
        }
        if ((bsName = this.viewer.getAtomBits("PotentialGroupName", potentialGroupName = identifier.substring(0, alphaLen))) == null) {
            this.undefinedVariable(identifier);
        }
        if (alphaLen == len) {
            return bsName;
        }
        for (seqcodeEnd = alphaLen; seqcodeEnd < len && Compiler.isDigit(identifier.charAt(seqcodeEnd)); ++seqcodeEnd) {
        }
        int seqNumber = 0;
        try {
            seqNumber = Integer.parseInt(identifier.substring(alphaLen, seqcodeEnd));
        }
        catch (NumberFormatException nfe) {
            this.evalError("identifier parser error #373");
        }
        char insertionCode = ' ';
        if (seqcodeEnd < len && identifier.charAt(seqcodeEnd) == '^') {
            if (++seqcodeEnd == len) {
                this.evalError("invalid insertion code");
            }
            insertionCode = identifier.charAt(seqcodeEnd++);
        }
        int seqcode = Group.getSeqcode(seqNumber, insertionCode);
        BitSet bsSequence = this.viewer.getAtomBits("SpecSeqcode", seqcode);
        BitSet bsNameSequence = bsName;
        bsNameSequence.and(bsSequence);
        if (seqcodeEnd == len) {
            return bsNameSequence;
        }
        char chainID = identifier.charAt(seqcodeEnd);
        if (++seqcodeEnd != len) {
            this.undefinedVariable(identifier);
        }
        BitSet bsChain = this.viewer.getAtomBits("SpecChain", chainID);
        BitSet bsNameSequenceChain = bsNameSequence;
        bsNameSequenceChain.and(bsChain);
        return bsNameSequenceChain;
    }

    BitSet lookupValue(String variable, boolean plurals) throws ScriptException {
        Object value = this.variables.get(variable);
        if (value != null) {
            if (value instanceof Token[]) {
                value = this.expression((Token[])value, 2);
                this.variables.put(variable, value);
            }
            return (BitSet)value;
        }
        if (plurals) {
            return null;
        }
        int len = variable.length();
        if (len < 5) {
            return null;
        }
        if (variable.charAt(len - 1) != 's') {
            return null;
        }
        variable = variable.endsWith("ies") ? variable.substring(0, len - 3) + 'y' : variable.substring(0, len - 1);
        return this.lookupValue(variable, true);
    }

    void comparatorInstruction(Token instruction, BitSet bs) throws ScriptException {
        int comparator = instruction.tok;
        int property = instruction.intValue;
        float propertyValue = 0.0f;
        int comparisonValue = (Integer)instruction.value;
        int numberOfAtoms = this.viewer.getAtomCount();
        Frame frame = this.viewer.getFrame();
        block23: for (int i = 0; i < numberOfAtoms; ++i) {
            Atom atom = frame.getAtomAt(i);
            switch (property) {
                case 98304: {
                    propertyValue = atom.getAtomNumber();
                    break;
                }
                case 98305: {
                    propertyValue = atom.getElementNumber();
                    break;
                }
                case 98572: {
                    propertyValue = atom.getMoleculeNumber();
                    break;
                }
                case 98308: {
                    propertyValue = atom.getBfactor100();
                    if (!(propertyValue < 0.0f)) break;
                    continue block23;
                }
                case 98314: {
                    propertyValue = atom.getOccupancy();
                    break;
                }
                case 98315: {
                    propertyValue = atom.getPolymerLength();
                    break;
                }
                case 98306: {
                    propertyValue = atom.getResno();
                    if (propertyValue != -1.0f) break;
                    continue block23;
                }
                case 98311: {
                    propertyValue = atom.getGroupID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block23;
                }
                case 98312: {
                    propertyValue = atom.getSpecialAtomID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block23;
                }
                case 98313: {
                    propertyValue = this.getProteinStructureType(atom);
                    if (propertyValue != -1.0f) break;
                    continue block23;
                }
                case 100355: {
                    propertyValue = atom.getRasMolRadius();
                    break;
                }
                case 98310: {
                    propertyValue = atom.getCovalentBondCount();
                    break;
                }
                case 102661: {
                    propertyValue = atom.getModelTagNumber();
                    break;
                }
                default: {
                    this.unrecognizedAtomProperty(property);
                }
            }
            boolean match = false;
            switch (comparator) {
                case 163843: {
                    match = propertyValue < (float)comparisonValue;
                    break;
                }
                case 163842: {
                    match = propertyValue <= (float)comparisonValue;
                    break;
                }
                case 163841: {
                    match = propertyValue >= (float)comparisonValue;
                    break;
                }
                case 163840: {
                    match = propertyValue > (float)comparisonValue;
                    break;
                }
                case 163844: {
                    match = propertyValue == (float)comparisonValue;
                    break;
                }
                case 163845: {
                    boolean bl = match = propertyValue != (float)comparisonValue;
                }
            }
            if (!match) continue;
            bs.set(i);
        }
    }

    BitSet within(Token instruction, BitSet bs) throws ScriptException {
        String withinStr;
        Object withinSpec = instruction.value;
        if (withinSpec instanceof Float) {
            return this.viewer.getAtomsWithin(((Float)withinSpec).floatValue(), bs);
        }
        if (withinSpec instanceof String && ((withinStr = (String)withinSpec).equals("group") || withinStr.equals("chain") || withinStr.equals("molecule") || withinStr.equals("model"))) {
            return this.viewer.getAtomsWithin(withinStr, bs);
        }
        this.evalError("Unrecognized within parameter:" + withinSpec);
        return null;
    }

    BitSet connected(Token instruction, BitSet bs) {
        int min = instruction.intValue;
        int max = (Integer)instruction.value;
        return this.viewer.getAtomsConnected(min, max, bs);
    }

    BitSet getSubstructureSet(String smiles) throws ScriptException {
        PatternMatcher matcher = new PatternMatcher(this.viewer);
        try {
            return matcher.getSubstructureSet(smiles);
        }
        catch (InvalidSmilesException e) {
            this.evalError(e.getMessage());
            return null;
        }
    }

    int getProteinStructureType(Atom atom) {
        return atom.getProteinStructureType();
    }

    void checkStatementLength(int length) throws ScriptException {
        if (this.statementLength != length) {
            this.badArgumentCount();
        }
    }

    void checkLength34() throws ScriptException {
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.badArgumentCount();
        }
    }

    void checkLength2() throws ScriptException {
        this.checkStatementLength(2);
    }

    void checkLength3() throws ScriptException {
        this.checkStatementLength(3);
    }

    void checkLength4() throws ScriptException {
        this.checkStatementLength(4);
    }

    int intParameter(int index) throws ScriptException {
        if (index >= this.statementLength || this.statement[index].tok != 2) {
            this.integerExpected();
        }
        return this.statement[index].intValue;
    }

    float floatParameter(int index) throws ScriptException {
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        float floatValue = 0.0f;
        switch (this.statement[index].tok) {
            case 2: {
                floatValue = this.statement[index].intValue;
                break;
            }
            case 3: {
                floatValue = ((Float)this.statement[index].value).floatValue();
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        return floatValue;
    }

    boolean isFloatParameter(int index) {
        if (index >= this.statementLength) {
            return false;
        }
        switch (this.statement[index].tok) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    String stringParameter(int index) throws ScriptException {
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        if (this.statement[index].tok == 4) {
            return (String)this.statement[index].value;
        }
        this.stringExpected();
        return null;
    }

    String objectNameParameter(int index) throws ScriptException {
        if (index >= this.statementLength || this.statement[index].tok != 1) {
            this.objectNameExpected();
        }
        return (String)this.statement[index].value;
    }

    float getRasmolAngstroms(int i) throws ScriptException {
        Token token = this.statement[i];
        switch (token.tok) {
            case 2: {
                return (float)token.intValue / 250.0f;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
        }
        this.numberExpected();
        return -1.0f;
    }

    boolean getSetBoolean() throws ScriptException {
        return this.booleanParameter(2);
    }

    boolean booleanParameter(int i) throws ScriptException {
        if (this.statementLength == i) {
            return true;
        }
        this.checkStatementLength(i + 1);
        switch (this.statement[i].tok) {
            case 8193: {
                return true;
            }
            case 8192: {
                return false;
            }
        }
        this.booleanExpected();
        return false;
    }

    Point4f planeParameter(int i) throws ScriptException {
        if (i < this.statementLength) {
            if (this.statement[i].tok == 32785) {
                return this.getPoint4f(i);
            }
            if (this.statement[i].tok == 4) {
                String str = (String)this.statement[i].value;
                this.pcLastExpressionInstruction = i;
                if (str.equalsIgnoreCase("xy")) {
                    return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                }
                if (str.equalsIgnoreCase("xz")) {
                    return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                }
                if (str.equalsIgnoreCase("yz")) {
                    return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                }
            }
        }
        this.evalError("plane expected -- either {a b c d} or \"xy\" \"xz\" \"yz\"");
        return null;
    }

    short getMadParameter() throws ScriptException {
        int tok = this.statement[1].tok;
        short mad = 1;
        switch (tok) {
            case 8193: {
                break;
            }
            case 8192: {
                mad = 0;
                break;
            }
            case 2: {
                mad = this.getMadInteger(this.statement[1].intValue);
                break;
            }
            case 3: {
                mad = this.getMadFloat(this.floatParameter(1));
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return mad;
    }

    short getMadInteger(int radiusRasMol) throws ScriptException {
        if (radiusRasMol < 0 || radiusRasMol > 750) {
            this.numberOutOfRange(0, 750);
        }
        return (short)(radiusRasMol * 4 * 2);
    }

    short getMadFloat(float angstroms) throws ScriptException {
        if (angstroms < 0.0f || angstroms > 3.0f) {
            this.numberOutOfRange(0.0f, 3.0f);
        }
        return (short)(angstroms * 1000.0f * 2.0f);
    }

    short getSetAxesTypeMad(int cmdPt) throws ScriptException {
        if (cmdPt == 2) {
            this.checkLength3();
        }
        if (cmdPt == 1) {
            this.checkLength2();
        }
        int tok = this.statement[cmdPt].tok;
        short mad = 0;
        switch (tok) {
            case 8193: {
                mad = 1;
            }
            case 8192: {
                break;
            }
            case 2: {
                int diameterPixels = this.statement[cmdPt].intValue;
                if (diameterPixels < 0 || diameterPixels >= 20) {
                    this.numberOutOfRange(0, 19);
                }
                mad = (short)diameterPixels;
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(cmdPt);
                if (angstroms < 0.0f || angstroms >= 2.0f) {
                    this.numberOutOfRange(0.0f, 1.99999f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 16414: {
                mad = -1;
                break;
            }
            default: {
                this.booleanOrNumberExpected("or dotted");
            }
        }
        return mad;
    }

    BitSet copyBitSet(BitSet bitSet) {
        BitSet copy = new BitSet();
        copy.or(bitSet);
        return copy;
    }

    BitSet getAtomBitSet(String atomExpression) throws ScriptException {
        BitSet bs = new BitSet();
        if (!this.loadScript(null, "select (" + atomExpression + ")")) {
            return bs;
        }
        bs = this.expression(this.aatoken[0], 1);
        return bs;
    }

    int getArgbParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok != 540692) {
            this.colorExpected();
        }
        return this.statement[itoken].intValue;
    }

    int getArgbOrNoneParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok == 540692) {
            return this.statement[itoken].intValue;
        }
        if (this.statement[itoken].tok != 49157) {
            this.colorExpected();
        }
        return 0;
    }

    Point3f getCoordinate(int i, boolean allowFractional) throws ScriptException {
        return this.getCoordinate(i, allowFractional, true);
    }

    Point3f getCoordinate(int i, boolean allowFractional, boolean doConvert) throws ScriptException {
        this.coordinatesAreFractional = false;
        if (this.statement[i++].tok != 32785) {
            this.coordinateExpected();
        }
        Point3f pt = new Point3f();
        int j = i;
        while (j + 1 < this.statement.length) {
            switch (this.statement[j].tok) {
                case 32783: {
                    this.coordinatesAreFractional = true;
                }
            }
            ++j;
        }
        if (this.coordinatesAreFractional && !allowFractional) {
            this.evalError("fractional coordinates are not allowed in this context");
        }
        pt.x = this.coordinateValue(i);
        pt.y = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.z = this.coordinateValue(++this.pcLastExpressionInstruction);
        if (this.statement[++this.pcLastExpressionInstruction].tok != 32786) {
            this.coordinateExpected();
        }
        if (this.coordinatesAreFractional && doConvert) {
            this.viewer.convertFractionalCoordinates(pt);
        }
        return pt;
    }

    Point4f getPoint4f(int i) throws ScriptException {
        this.coordinatesAreFractional = false;
        if (this.statement[i++].tok != 32785) {
            this.coordinateExpected();
        }
        Point4f pt = new Point4f();
        int j = i;
        while (j + 1 < this.statement.length) {
            switch (this.statement[j].tok) {
                case 32783: {
                    this.coordinatesAreFractional = true;
                }
            }
            ++j;
        }
        if (this.coordinatesAreFractional) {
            this.evalError("fractional coordinates are not allowed in this context");
        }
        pt.x = this.coordinateValue(i);
        pt.y = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.z = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.w = this.coordinateValue(++this.pcLastExpressionInstruction);
        if (this.statement[++this.pcLastExpressionInstruction].tok != 32786) {
            this.coordinateExpected();
        }
        return pt;
    }

    float coordinateValue(int i) throws ScriptException {
        float val = this.floatParameter(i++);
        Token token = this.statement[i];
        if (token.tok == 32783) {
            token = this.statement[++i];
            if (token.tok == 2 || token.tok == 3) {
                val /= this.floatParameter(i++);
                token = this.statement[i];
            }
        }
        this.pcLastExpressionInstruction = token.tok == 32772 ? i : i - 1;
        return val;
    }

    void moveto() throws ScriptException {
        Point3f pt;
        if (this.statementLength == 2) {
            this.viewer.moveTo(this.floatParameter(1), new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100, 0, 0);
            return;
        }
        if (this.statementLength < 6) {
            this.badArgumentCount();
        }
        float floatSecondsTotal = this.floatParameter(1);
        int zoom = 100;
        int xTrans = 0;
        int yTrans = 0;
        int i = 2;
        if (this.statement[2].tok == 32785) {
            pt = this.getCoordinate(2, true);
            i = this.pcLastExpressionInstruction + 1;
        } else {
            pt = new Point3f(this.floatParameter(i++), this.floatParameter(i++), this.floatParameter(i++));
        }
        float degrees = this.floatParameter(i++);
        if (i != this.statementLength) {
            zoom = this.intParameter(i++);
        }
        if (i != this.statementLength) {
            xTrans = this.intParameter(i++);
        }
        if (i != this.statementLength) {
            yTrans = this.intParameter(i++);
        }
        this.viewer.moveTo(floatSecondsTotal, pt, degrees, zoom, xTrans, yTrans);
    }

    void bondorder() throws ScriptException {
        Token tokenArg = this.statement[1];
        int order = 0;
        switch (tokenArg.tok) {
            case 2: {
                order = (short)tokenArg.intValue;
                if (order >= 0 && order <= 3) break;
                this.invalidArgument();
                break;
            }
            case 10509: {
                order = 64;
                break;
            }
            case 3: {
                float f = ((Float)tokenArg.value).floatValue();
                if (f == (float)((short)f)) {
                    order = (short)f;
                    if (order >= 0 && order <= 3) break;
                    this.invalidArgument();
                    break;
                }
                if (f == 0.5f) {
                    order = 64;
                    break;
                }
                if (f == 1.5f) {
                    order = 5;
                    break;
                }
                this.invalidArgument();
                break;
            }
            case 1: {
                if ("aromatic".equalsIgnoreCase((String)tokenArg.value)) {
                    order = 5;
                    break;
                }
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setShapeProperty(1, "bondOrder", new Short((short)order));
    }

    void console() {
        this.viewer.showConsole(this.statement[1].tok == 8193);
    }

    void centerAt() throws ScriptException {
        if (this.statementLength < 2) {
            this.badArgumentCount();
        }
        String relativeTo = null;
        switch (this.statement[1].tok) {
            case 16431: {
                relativeTo = "absolute";
                break;
            }
            case 16432: {
                relativeTo = "average";
                break;
            }
            case 6405: {
                relativeTo = "boundbox";
                break;
            }
            default: {
                this.unrecognizedSubcommand(this.statement[1].toString());
            }
        }
        Point3f pt = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            pt.x = this.floatParameter(2);
            pt.y = this.floatParameter(3);
            pt.z = this.floatParameter(4);
        } else if (this.statement[2].tok == 32785) {
            pt = this.getCoordinate(2, true);
        }
        this.viewer.setCenter(relativeTo, pt);
    }

    void stereo() throws ScriptException {
        int stereoMode = 1;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.statement[i].tok) {
                case 8193: {
                    stereoMode = 1;
                    continue block6;
                }
                case 8192: {
                    stereoMode = 0;
                    continue block6;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block6;
                }
                case 1: {
                    String id = (String)this.statement[i].value;
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if (id.equalsIgnoreCase("redblue")) {
                        stereoMode = 3;
                        continue block6;
                    }
                    if (id.equalsIgnoreCase("redcyan")) {
                        stereoMode = 2;
                        continue block6;
                    }
                    if (id.equalsIgnoreCase("redgreen")) {
                        stereoMode = 4;
                        continue block6;
                    }
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
        }
        this.viewer.setStereoDegrees(degrees);
        this.viewer.setStereoMode(stereoMode);
    }

    void connect() throws ScriptException {
        boolean haveType = false;
        int nAtomSets = 0;
        int nDistances = 0;
        this.viewer.setShapeProperty(1, "resetConnectParameters", null);
        if (this.statementLength == 1) {
            this.viewer.setShapeProperty(1, "rasmolCompatibleConnect", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            block0 : switch (this.statement[i].tok) {
                case 8192: 
                case 8193: {
                    if (this.statementLength != 2) {
                        this.badArgumentCount();
                    }
                    this.viewer.setShapeProperty(1, "rasmolCompatibleConnect", null);
                    return;
                }
                case 2: 
                case 3: {
                    if (++nDistances > 2) {
                        this.badArgumentCount();
                    }
                    if (nAtomSets > 0 || haveType) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectDistance";
                    propertyValue = new Float(this.floatParameter(i));
                    break;
                }
                case 32868: {
                    if (++nAtomSets > 2) {
                        this.badArgumentCount();
                    }
                    if (haveType) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectSet";
                    propertyValue = this.expression(this.statement, i);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 1: 
                case 10509: {
                    String cmd = (String)this.statement[i].value;
                    int j = JmolConstants.bondOrderNames.length;
                    while (--j >= 0) {
                        if (!cmd.equalsIgnoreCase(JmolConstants.bondOrderNames[j])) continue;
                        if (haveType) {
                            this.incompatibleArguments();
                        }
                        cmd = JmolConstants.bondOrderNames[j];
                        propertyName = "connectBondOrder";
                        propertyValue = cmd;
                        haveType = true;
                        break block0;
                    }
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    if ("modify".equalsIgnoreCase(cmd)) {
                        propertyValue = "modify";
                    } else if ("create".equalsIgnoreCase(cmd)) {
                        propertyValue = "create";
                    } else if ("modifyOrCreate".equalsIgnoreCase(cmd)) {
                        propertyValue = "modifyOrCreate";
                    } else if ("auto".equalsIgnoreCase(cmd)) {
                        propertyValue = "auto";
                    } else {
                        this.unrecognizedSubcommand(cmd);
                    }
                    propertyName = "connectOperation";
                    break;
                }
                case 16426: 
                case 49157: {
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectOperation";
                    propertyValue = "delete";
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(1, propertyName, propertyValue);
        }
        this.viewer.setShapeProperty(1, "applyConnectParameters", null);
    }

    void getProperty() {
        String retValue = "";
        String property = this.statementLength < 2 ? "" : (String)this.statement[1].value;
        String param = this.statementLength < 3 ? "" : (String)this.statement[2].value;
        retValue = (String)this.viewer.getProperty("readable", property, param);
        this.viewer.scriptEcho(retValue);
    }

    void background() throws ScriptException {
        int tok;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
        if ((tok = this.statement[1].tok) == 540692 || tok == 49157) {
            this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(1));
        } else {
            this.viewer.setShapePropertyArgb(this.getShapeType(tok), "bgcolor", this.getArgbOrNoneParam(2));
        }
    }

    void center() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setCenterBitSet(null, true);
            return;
        }
        if (this.statement[1].tok == 8388627) {
            String axisID = this.objectNameParameter(2);
            this.viewer.setNewRotationCenter(axisID);
            return;
        }
        if (this.statement[1].tok == 32785) {
            Point3f pt = this.getCoordinate(1, true);
            this.viewer.setNewRotationCenter(pt);
            return;
        }
        this.viewer.setCenterBitSet(this.expression(this.statement, 1), true);
    }

    void color() throws ScriptException {
        if (this.statementLength > 5 || this.statementLength < 2) {
            this.badArgumentCount();
        }
        int tok = this.statement[1].tok;
        switch (tok) {
            case 8388627: {
                this.colorNamedObject(2);
                return;
            }
            case 296: 
            case 2081: 
            case 2082: 
            case 16385: 
            case 16402: 
            case 16420: 
            case 16422: 
            case 32789: 
            case 32790: 
            case 36868: 
            case 36869: 
            case 49157: 
            case 98308: 
            case 98572: 
            case 294912: 
            case 540692: 
            case 2107683: {
                this.colorObject(4102, 1);
                return;
            }
            case 16421: {
                this.viewer.setRubberbandArgb(this.getArgbParam(2));
                return;
            }
            case 4718849: {
                this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(2));
                return;
            }
            case 1: 
            case 296962: {
                String str = (String)this.statement[1].value;
                if (str.equalsIgnoreCase("unitcell")) {
                    this.colorShape(18, 2, "");
                    return;
                }
                int argb = this.getArgbOrNoneParam(2);
                if (str.equalsIgnoreCase("dotsConvex")) {
                    this.viewer.setShapePropertyArgb(7, "colorConvex", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsConcave")) {
                    this.viewer.setShapePropertyArgb(7, "colorConcave", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsSaddle")) {
                    this.viewer.setShapePropertyArgb(7, "colorSaddle", argb);
                    return;
                }
                if (str.equalsIgnoreCase("selectionHalo")) {
                    this.viewer.setSelectionArgb(argb);
                    return;
                }
                int i = JmolConstants.elementNames.length;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.elementNames[i])) continue;
                    this.viewer.setElementArgb(i, this.getArgbParam(2));
                    return;
                }
                i = JmolConstants.alternateElementNames.length;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.alternateElementNames[i])) continue;
                    this.viewer.setElementArgb(JmolConstants.alternateElementNumbers[i], this.getArgbParam(2));
                    return;
                }
                this.invalidArgument();
            }
        }
        if (tok == 10498) {
            tok = 2052;
        }
        this.colorObject(tok, 2);
    }

    void colorNamedObject(int index) throws ScriptException {
        String objectName = this.objectNameParameter(index);
        int shapeType = this.viewer.getShapeIdFromObjectName(objectName);
        if (shapeType < 0) {
            this.objectNameExpected();
        }
        this.viewer.setShapeProperty(shapeType, "thisID", objectName);
        this.colorShape(shapeType, index + 1, "");
    }

    void colorObject(int tokObject, int itoken) throws ScriptException {
        this.colorShape(this.getShapeType(tokObject), itoken, "");
    }

    void colorShape(int shapeType, int itoken, String modifier) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.badArgumentCount();
        }
        String translucentOrOpaque = null;
        Object colorvalue = null;
        String colorOrBgcolor = "color";
        int tok = this.statement[itoken].tok;
        if (tok == 4718849) {
            colorOrBgcolor = "bgcolor";
            tok = this.statement[++itoken].tok;
        }
        if (tok == 16425 || tok == 16424) {
            translucentOrOpaque = (String)this.statement[itoken].value;
            ++itoken;
        }
        if (itoken < this.statementLength) {
            colorvalue = this.statement[itoken].value;
            tok = this.statement[itoken].tok;
            switch (tok) {
                case 296: 
                case 2081: 
                case 2082: 
                case 16402: 
                case 16419: 
                case 16420: 
                case 32789: 
                case 32790: 
                case 36869: 
                case 49157: 
                case 294912: 
                case 2107683: {
                    break;
                }
                case 98308: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 36868: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 16422: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 98572: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 16385: {
                    this.notImplemented(itoken);
                    return;
                }
                case 540692: {
                    int argb = this.getArgbParam(itoken);
                    colorvalue = argb == 0 ? null : new Integer(argb);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.loadShape(shapeType);
            this.viewer.setShapeProperty(shapeType, colorOrBgcolor + modifier, colorvalue);
        }
        if (translucentOrOpaque != null) {
            this.viewer.setShapeProperty(shapeType, "translucency" + modifier, translucentOrOpaque);
        }
    }

    void define() throws ScriptException {
        if (this.statementLength == 1) {
            this.keywordExpected();
        }
        String variable = (String)this.statement[1].value;
        this.variables.put(variable, this.expression(this.statement, 2));
    }

    void predefine(Token[] statement) {
        String variable = (String)statement[1].value;
        this.variables.put(variable, statement);
    }

    void echo() {
        String text = "";
        if (this.statementLength == 2 && this.statement[1].tok == 4) {
            text = (String)this.statement[1].value;
        }
        if (this.echoShapeActive) {
            this.viewer.setShapeProperty(20, "echo", text);
        }
        this.viewer.scriptEcho(text);
    }

    void label() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = this.viewer.getStandardLabelFormat();
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(strLabel);
    }

    void hover() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = "%U";
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(21);
        this.viewer.setShapeProperty(21, "label", strLabel);
    }

    void load() throws ScriptException {
        String script;
        int[] params = new int[4];
        Point3f unitCells = this.viewer.getDefaultLattice();
        params[1] = (int)unitCells.x;
        params[2] = (int)unitCells.y;
        params[3] = (int)unitCells.z;
        int i = 1;
        String filename = "fileset";
        if (this.statementLength == 1) {
            this.filenameExpected();
        }
        if (this.statement[i].tok == 1) {
            ++i;
        }
        if (this.statement[i].tok != 4) {
            this.filenameExpected();
        }
        if (this.statementLength == i + 1) {
            filename = (String)this.statement[i].value;
            if (filename.length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            this.viewer.openFile(filename, params);
        } else if (this.statement[i + 1].tok == 32785 || this.statement[i + 1].tok == 2) {
            filename = (String)this.statement[i++].value;
            if (filename.length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            if (this.statement[i].tok == 2) {
                params[0] = this.statement[i++].intValue;
            }
            if (i < this.statement.length && this.statement[i].tok == 32785) {
                unitCells = this.getCoordinate(i, false);
                params[1] = (int)unitCells.x;
                params[2] = (int)unitCells.y;
                params[3] = (int)unitCells.z;
            }
            this.viewer.openFile(filename, params);
        } else {
            String modelName = (String)this.statement[i].value;
            String[] filenames = new String[this.statementLength - ++i];
            while (i < this.statementLength) {
                filenames[filenames.length - this.statementLength + i] = (String)this.statement[i].value;
                ++i;
            }
            this.viewer.openFiles(modelName, filenames);
        }
        String errMsg = this.viewer.getOpenFileError();
        if (errMsg != null) {
            this.evalError(errMsg);
        }
        String defaultScript = this.viewer.getDefaultLoadScript();
        String msg = "";
        if (defaultScript.length() > 0) {
            msg = msg + "\nUsing defaultLoadScript: " + defaultScript;
        }
        if ((script = this.viewer.getModelSetProperty("jmolscript")) != null) {
            msg = msg + "\nAdding embedded #jmolscript: " + script;
            defaultScript = defaultScript + ";" + script;
        }
        if (msg.length() > 0) {
            Logger.info(msg);
        }
        if (defaultScript.length() > 0) {
            this.runScript(defaultScript);
        }
    }

    void monitor() throws ScriptException {
        int[] monitorArgs = new int[5];
        float[] rangeMinMax = new float[2];
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        if (this.statementLength == 2) {
            if (this.statement[1].tok == 8193) {
                this.viewer.hideMeasurements(false);
            } else if (this.statement[1].tok == 8192) {
                this.viewer.hideMeasurements(true);
            } else if (this.statement[1].tok == 16426) {
                this.viewer.clearMeasurements();
            } else {
                this.keywordExpected("ON, OFF, or DELETE");
            }
            return;
        }
        monitorArgs[0] = 0;
        int argCount = this.statementLength - 1;
        int expressionCount = 0;
        int atomIndex = -1;
        int atomNumber = 0;
        int ptFloat = -1;
        rangeMinMax[0] = Float.MAX_VALUE;
        rangeMinMax[1] = Float.MAX_VALUE;
        boolean isAll = false;
        boolean isAllConnected = false;
        boolean isExpression = false;
        boolean isDelete = false;
        boolean isRange = true;
        boolean isON = false;
        boolean isOFF = false;
        Vector<BitSet> monitorExpressions = new Vector<BitSet>();
        BitSet bs = new BitSet();
        block11: for (int i = 1; i <= argCount; ++i) {
            Token token = this.statement[i];
            switch (token.tok) {
                case 8193: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isON = true;
                    continue block11;
                }
                case 8192: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isOFF = true;
                    continue block11;
                }
                case 16426: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isDelete = true;
                    continue block11;
                }
                case 16446: {
                    isRange = true;
                    atomIndex = -1;
                    isAll = true;
                    continue block11;
                }
                case 1: {
                    if (((String)token.value).equalsIgnoreCase("ALLCONNECTED")) {
                        isAllConnected = true;
                    } else {
                        this.keywordExpected("ALL, ALLCONNECTED, or DELETE");
                    }
                }
                case 36875: {
                    atomIndex = -1;
                    isAll = true;
                    continue block11;
                }
                case 3: {
                    isAll = true;
                    isRange = true;
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = ((Float)token.value).floatValue();
                    continue block11;
                }
                case 2: {
                    isRange = true;
                    atomNumber = token.intValue;
                    atomIndex = this.viewer.getAtomIndexFromAtomNumber(atomNumber);
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = atomNumber;
                    break;
                }
                case 32868: {
                    isExpression = true;
                    bs = this.expression(this.statement, i);
                    atomIndex = this.viewer.firstAtomOf(bs);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.expressionOrIntegerExpected();
                }
            }
            if (atomIndex == -1) {
                this.badAtomNumber();
            }
            if (isAll) {
                if (bs == null || bs.size() == 0) {
                    this.badAtomNumber();
                }
                if (++expressionCount > 4) {
                    this.badArgumentCount();
                }
                monitorExpressions.add(bs);
                continue;
            }
            if (atomIndex == -1) {
                this.badAtomNumber();
            }
            if ((monitorArgs[0] = monitorArgs[0] + 1) > 4) {
                this.badArgumentCount();
            }
            monitorArgs[monitorArgs[0]] = atomIndex;
        }
        if (isAll) {
            if (!isExpression) {
                this.expressionExpected();
            }
            if (isRange && rangeMinMax[1] < rangeMinMax[0]) {
                rangeMinMax[1] = rangeMinMax[0];
                rangeMinMax[0] = rangeMinMax[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
            }
            this.viewer.defineMeasurement(monitorExpressions, rangeMinMax, isDelete, isAllConnected, isON || isOFF, isOFF);
        } else if (isDelete) {
            this.viewer.deleteMeasurement(monitorArgs);
        } else if (isON) {
            this.viewer.showMeasurement(monitorArgs, true);
        } else if (isOFF) {
            this.viewer.showMeasurement(monitorArgs, false);
        } else {
            this.viewer.toggleMeasurement(monitorArgs);
        }
    }

    void refresh() {
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    void reset() {
        this.viewer.homePosition();
    }

    void restrict() throws ScriptException {
        this.select();
        this.viewer.invertSelection();
        boolean bondmode = this.viewer.getBondSelectionModeOr();
        this.viewer.setBondSelectionModeOr(true);
        this.viewer.setShapeSize(1, 0);
        int shapeType = 16;
        while (--shapeType >= 0) {
            if (shapeType == 6) continue;
            this.viewer.setShapeSize(shapeType, 0);
        }
        this.viewer.setLabel(null);
        this.viewer.setBondSelectionModeOr(bondmode);
        this.viewer.invertSelection();
    }

    void rotate(boolean isSpin) throws ScriptException {
        int i;
        if (this.statement.length == 2) {
            switch (this.statement[1].tok) {
                case 8193: {
                    this.viewer.setSpinOn(true);
                    return;
                }
                case 8192: {
                    this.viewer.setSpinOn(false);
                    return;
                }
            }
        }
        float degrees = Float.MIN_VALUE;
        int nPoints = 0;
        float endDegrees = Float.MAX_VALUE;
        boolean isAxisAngle = false;
        boolean isInternal = false;
        Point3f[] points = new Point3f[3];
        Point3f rotCenter = null;
        Vector3f rotAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        int direction = 1;
        boolean axesOrientationRasmol = this.viewer.getAxesOrientationRasmol();
        for (i = 0; i < 3; ++i) {
            points[i] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        for (i = 1; i < this.statementLength; ++i) {
            Token token = this.statement[i];
            switch (token.tok) {
                case 32770: {
                    direction = -1;
                    break;
                }
                case 4109: {
                    isAxisAngle = true;
                    break;
                }
                case 1: {
                    String str = (String)this.statement[i].value;
                    if (str.equalsIgnoreCase("x")) {
                        rotAxis.set(direction, 0.0f, 0.0f);
                        break;
                    }
                    if (str.equalsIgnoreCase("y")) {
                        if (axesOrientationRasmol) {
                            direction = -direction;
                        }
                        rotAxis.set(0.0f, direction, 0.0f);
                        break;
                    }
                    if (str.equalsIgnoreCase("z")) {
                        rotAxis.set(0.0f, 0.0f, direction);
                        break;
                    }
                    if (!str.equalsIgnoreCase("internal") && !str.equalsIgnoreCase("molecular")) break;
                    isInternal = true;
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    if (isAxisAngle) {
                        if (axesOrientationRasmol) {
                            pt.y = -pt.y;
                        }
                        rotAxis.set(pt);
                        isAxisAngle = false;
                        break;
                    }
                    points[nPoints++].set(pt);
                    break;
                }
                case 8388627: {
                    isInternal = true;
                    String axisID = this.objectNameParameter(++i);
                    rotCenter = this.viewer.getDrawObjectCenter(axisID);
                    rotAxis = this.viewer.getDrawObjectAxis(axisID);
                    if (rotCenter == null) {
                        this.drawObjectNotDefined(axisID);
                    }
                    points[nPoints++].set(rotCenter);
                    break;
                }
                case 32772: {
                    break;
                }
                case 2: {
                    this.statement[i].value = new Float(token.intValue);
                }
                case 3: {
                    if (degrees == Float.MIN_VALUE) {
                        degrees = this.floatParameter(i);
                        break;
                    }
                    endDegrees = degrees;
                    degrees = this.floatParameter(i);
                    isSpin = true;
                    break;
                }
                case 32868: {
                    BitSet bs = this.expression(this.statement, i + 1);
                    rotCenter = this.viewer.getAtomSetCenter(bs);
                    points[nPoints++].set(rotCenter);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (nPoints < 3) continue;
            this.tooManyRotationPoints();
        }
        if (nPoints < 2 && !isInternal) {
            if (nPoints == 1) {
                rotCenter = new Point3f(points[0]);
            }
            if (degrees == Float.MIN_VALUE) {
                degrees = 10.0f;
            }
            this.viewer.rotateAxisAngleAtCenter(rotCenter, rotAxis, degrees, endDegrees, isSpin);
            return;
        }
        if (nPoints < 2) {
            points[1].set(points[0]);
            points[1].sub(rotAxis);
        }
        if (points[0].distance(points[1]) == 0.0f) {
            this.rotationPointsIdentical();
        }
        if (degrees == Float.MIN_VALUE) {
            degrees = 10.0f;
        }
        this.viewer.rotateAboutPointsInternal(points[0], points[1], degrees, endDegrees, isSpin);
    }

    void script() throws ScriptException {
        if (this.statement[1].tok != 4) {
            this.filenameExpected();
        }
        this.pushContext();
        String filename = (String)this.statement[1].value;
        if (!this.loadScriptFileInternal(filename)) {
            this.errorLoadingScript(this.errorMessage);
        }
        this.instructionDispatchLoop();
        this.popContext();
    }

    void select() throws ScriptException {
        this.viewer.select(this.statementLength == 1 ? null : this.expression(this.statement, 1));
    }

    void translate() throws ScriptException {
        int percent;
        if (this.statementLength < 3) {
            this.badArgumentCount();
        }
        if (this.statement[2].tok != 2) {
            this.integerExpected();
        }
        if ((percent = this.statement[2].intValue) > 100 || percent < -100) {
            this.numberOutOfRange(-100, 100);
        }
        if (this.statement[1].tok == 1) {
            String str = (String)this.statement[1].value;
            if (str.equalsIgnoreCase("x")) {
                this.viewer.translateToXPercent(percent);
                return;
            }
            if (str.equalsIgnoreCase("y")) {
                this.viewer.translateToYPercent(percent);
                return;
            }
            if (str.equalsIgnoreCase("z")) {
                this.viewer.translateToZPercent(percent);
                return;
            }
        }
        this.axisExpected();
    }

    void zap() {
        this.viewer.clear();
    }

    void zoom() throws ScriptException {
        if (this.statement[1].tok == 2) {
            int percent = this.statement[1].intValue;
            if (percent < 5 || percent > 200000) {
                this.numberOutOfRange(5, 200000);
            }
            this.viewer.zoomToPercent(percent);
            return;
        }
        switch (this.statement[1].tok) {
            case 8193: {
                this.viewer.setZoomEnabled(true);
                break;
            }
            case 8192: {
                this.viewer.setZoomEnabled(false);
                break;
            }
            default: {
                this.booleanOrPercentExpected();
            }
        }
    }

    void delay() throws ScriptException {
        long timeBegin = System.currentTimeMillis();
        long millis = 0L;
        Token token = this.statement[1];
        switch (token.tok) {
            case 2: 
            case 8193: {
                millis = token.intValue * 1000;
                break;
            }
            case 3: {
                millis = (long)(((Float)token.value).floatValue() * 1000.0f);
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.refresh();
        if ((millis -= System.currentTimeMillis() - timeBegin) > 0L) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    void move() throws ScriptException {
        if (this.statementLength < 10 || this.statementLength > 12) {
            this.badArgumentCount();
        }
        Vector3f dRot = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        int dZoom = this.intParameter(4);
        Vector3f dTrans = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        int dSlab = this.intParameter(8);
        float floatSecondsTotal = this.floatParameter(9);
        int fps = 30;
        if (this.statementLength > 10) {
            fps = this.statement[10].intValue;
            if (this.statementLength > 11) {
                // empty if block
            }
        }
        this.viewer.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
    }

    void slab() throws ScriptException {
        if (this.statement[1].tok == 2) {
            int percent = this.statement[1].intValue;
            if (percent < 0 || percent > 100) {
                this.numberOutOfRange(0, 100);
            }
            this.viewer.slabToPercent(percent);
            return;
        }
        switch (this.statement[1].tok) {
            case 8193: {
                this.viewer.setSlabEnabled(true);
                break;
            }
            case 8192: {
                this.viewer.setSlabEnabled(false);
                break;
            }
            default: {
                this.booleanOrPercentExpected();
            }
        }
    }

    void depth() throws ScriptException {
        this.viewer.depthToPercent(this.intParameter(1));
    }

    void star() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 100) {
                    this.numberOutOfRange(0, 100);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(15, mad);
    }

    void spacefill() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -200) {
                        this.numberOutOfRange(-200, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 200) {
                    this.numberOutOfRange(0, 200);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(0, mad);
    }

    void wireframe() throws ScriptException {
        this.viewer.setShapeSize(1, this.getMadParameter());
    }

    void ssbond() throws ScriptException {
        this.viewer.loadShape(3);
        this.viewer.setShapeSize(3, this.getMadParameter());
    }

    void hbond(boolean isCommand) throws ScriptException {
        if (this.statementLength == 2 && this.statement[1].tok == 1 && ((String)this.statement[1].value).equalsIgnoreCase("calculate")) {
            this.viewer.autoHbond();
            return;
        }
        this.viewer.setShapeSize(2, this.getMadParameter());
    }

    void conformation() throws ScriptException {
        BitSet bsConformations;
        if (this.statementLength == 1) {
            bsConformations = this.viewer.setConformation();
        } else {
            this.checkLength2();
            bsConformations = this.viewer.setConformation(this.intParameter(1) - 1);
        }
        boolean addHbonds = this.viewer.hbondsAreVisible();
        this.viewer.setShapeSize(2, 0, bsConformations);
        if (addHbonds) {
            this.viewer.autoHbond(bsConformations, bsConformations);
        }
        this.viewer.setSelectionSet(bsConformations);
    }

    void vector() throws ScriptException {
        int mad = 1;
        if (this.statementLength > 1) {
            switch (this.statement[1].tok) {
                case 8193: {
                    break;
                }
                case 8192: {
                    mad = 0;
                    break;
                }
                case 2: {
                    int diameterPixels = this.statement[1].intValue;
                    if (diameterPixels < 0 || diameterPixels >= 20) {
                        this.numberOutOfRange(0, 19);
                    }
                    mad = (short)diameterPixels;
                    break;
                }
                case 3: {
                    float angstroms = this.floatParameter(1);
                    if (angstroms > 3.0f) {
                        this.numberOutOfRange(0.0f, 3.0f);
                    }
                    mad = (short)(angstroms * 1000.0f * 2.0f);
                    break;
                }
                case 1: {
                    String cmd = (String)this.statement[1].value;
                    if (cmd.equalsIgnoreCase("scale")) {
                        this.checkLength3();
                        float scale = this.floatParameter(2);
                        if (scale < -10.0f || scale > 10.0f) {
                            this.numberOutOfRange(-10.0f, 10.0f);
                        }
                        this.viewer.setVectorScale(scale);
                        return;
                    }
                    this.unrecognizedSubcommand(cmd);
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
            this.checkLength2();
        }
        this.viewer.setShapeSize(5, mad);
    }

    void dipole() throws ScriptException {
        String propertyName = null;
        Object propertyValue = null;
        boolean iHaveAtoms = false;
        boolean iHaveCoord = false;
        this.viewer.loadShape(23);
        this.viewer.setShapeProperty(23, "init", null);
        if (this.statementLength == 1) {
            this.viewer.setShapeProperty(23, "thisID", null);
            return;
        }
        block10: for (int i = 1; i < this.statementLength; ++i) {
            propertyName = null;
            propertyValue = null;
            Token token = this.statement[i];
            switch (token.tok) {
                case 8193: {
                    propertyName = "on";
                    break;
                }
                case 8192: {
                    propertyName = "off";
                    break;
                }
                case 16426: {
                    propertyName = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    propertyName = "dipoleValue";
                    propertyValue = new Float(this.floatParameter(i));
                    break;
                }
                case 32868: {
                    propertyValue = this.expression(this.statement, i);
                    i = this.pcLastExpressionInstruction;
                    propertyName = iHaveAtoms || iHaveCoord ? "endSet" : "startSet";
                    iHaveAtoms = true;
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    propertyName = iHaveAtoms || iHaveCoord ? "endCoord" : "startCoord";
                    propertyValue = pt;
                    iHaveCoord = true;
                    break;
                }
                case 2052: 
                case 10498: {
                    propertyName = "bonds";
                    break;
                }
                case 1: {
                    String cmd = (String)token.value;
                    if (cmd.equalsIgnoreCase("cross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("noCross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("calculate")) continue block10;
                    if (cmd.equalsIgnoreCase("offset")) {
                        float v = this.floatParameter(++i);
                        if (this.statement[i].tok == 2) {
                            propertyName = "dipoleOffsetPercent";
                            propertyValue = new Integer((int)v);
                            break;
                        }
                        propertyName = "dipoleOffset";
                        propertyValue = new Float(v);
                        break;
                    }
                    if (cmd.equalsIgnoreCase("value")) {
                        propertyName = "dipoleValue";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("offsetSide")) {
                        propertyName = "offsetSide";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("width")) {
                        propertyName = "dipoleWidth";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    propertyName = "thisID";
                    propertyValue = ((String)token.value).toLowerCase();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(23, propertyName, propertyValue);
        }
        if (iHaveCoord || iHaveAtoms) {
            this.viewer.setShapeProperty(23, "set", null);
        }
    }

    void animationMode() throws ScriptException {
        float startDelay = 1.0f;
        float endDelay = 1.0f;
        if (this.statementLength < 3 || this.statementLength > 5) {
            this.badArgumentCount();
        }
        int animationMode = 0;
        switch (this.statement[2].tok) {
            case 317: {
                ++animationMode;
                break;
            }
            case 1: {
                String cmd = (String)this.statement[2].value;
                if (cmd.equalsIgnoreCase("once")) {
                    endDelay = 0.0f;
                    startDelay = 0.0f;
                    break;
                }
                if (cmd.equalsIgnoreCase("palindrome")) {
                    animationMode = 2;
                    break;
                }
                this.unrecognizedSubcommand(cmd);
            }
        }
        if (this.statementLength >= 4) {
            startDelay = endDelay = this.floatParameter(3);
            if (this.statementLength == 5) {
                endDelay = this.floatParameter(4);
            }
        }
        this.viewer.setAnimationReplayMode(animationMode, startDelay, endDelay);
    }

    void vibration() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        Token token = this.statement[1];
        float period = 0.0f;
        switch (token.tok) {
            case 2: 
            case 8192: 
            case 8193: {
                period = token.intValue;
                break;
            }
            case 3: {
                period = this.floatParameter(1);
                break;
            }
            case 1: {
                String cmd = (String)this.statement[1].value;
                if (cmd.equalsIgnoreCase("scale")) {
                    this.vibrationScale();
                    return;
                }
            }
            default: {
                this.unrecognizedSubcommand(token.toString());
            }
        }
        this.viewer.setVibrationPeriod(period);
    }

    void vibrationScale() throws ScriptException {
        this.checkLength3();
        float scale = this.floatParameter(2);
        if (scale < -10.0f || scale > 10.0f) {
            this.numberOutOfRange(-10.0f, 10.0f);
        }
        this.viewer.setVibrationScale(scale);
    }

    void animationDirection() throws ScriptException {
        int direction;
        this.checkStatementLength(4);
        boolean negative = false;
        if (this.statement[2].tok == 32770) {
            negative = true;
        } else if (this.statement[2].tok != 32775) {
            this.invalidArgument();
        }
        if (this.statement[3].tok != 2) {
            this.invalidArgument();
        }
        if ((direction = this.statement[3].intValue) != 1) {
            this.numberMustBe(-1, 1);
        }
        if (negative) {
            direction = -direction;
        }
        this.viewer.setAnimationDirection(direction);
    }

    void dots(boolean isSurface) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setShapeSize(7, 1);
            if (isSurface) {
                this.viewer.setShapeSize(7, -2);
            }
            return;
        }
        int mad = 0;
        switch (this.statement[1].tok) {
            case 8193: 
            case 16438: {
                mad = 1;
                break;
            }
            case 16439: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 32775: {
                float radius = this.floatParameter(2);
                if (radius < 0.0f || radius > 10.0f) {
                    this.numberOutOfRange(0.0f, 2.0f);
                }
                mad = (short)(radius == 0.0f ? 0.0f : radius * 1000.0f + 11002.0f);
                break;
            }
            case 3: {
                float radius = this.floatParameter(1);
                if (radius < 0.0f || radius > 10.0f) {
                    this.numberOutOfRange(0.0f, 10.0f);
                }
                mad = (short)(radius == 0.0f ? 0.0f : radius * 1000.0f + 1002.0f);
                break;
            }
            case 2: {
                int dotsParam = this.intParameter(1);
                if (dotsParam < 0 || dotsParam > 1000) {
                    this.numberOutOfRange(0, 1000);
                }
                mad = (short)(dotsParam == 0 ? 0 : dotsParam + 1);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(7, mad);
        if (isSurface && mad != 0) {
            this.viewer.setShapeSize(7, -2);
        }
    }

    void proteinShape(int shapeType) throws ScriptException {
        int mad = 0;
        int tok = this.statement[1].tok;
        switch (tok) {
            case 8193: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 296: {
                mad = -2;
                break;
            }
            case 16418: 
            case 98308: {
                mad = -4;
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (radiusRasMol >= 500) {
                    this.numberOutOfRange(0, 499);
                }
                mad = (short)(radiusRasMol * 4 * 2);
                break;
            }
            case 3: {
                float angstroms = ((Float)this.statement[1].value).floatValue();
                if (angstroms > 4.0f) {
                    this.numberOutOfRange(0.0f, 4.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(shapeType, mad);
    }

    void animation() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        int tok = this.statement[1].tok;
        boolean animate = false;
        switch (tok) {
            case 8193: {
                animate = true;
            }
            case 8192: {
                this.viewer.setAnimationOn(animate);
                break;
            }
            case 4096: {
                this.showAnimation();
                break;
            }
            case 324: {
                this.frame(2, false);
                break;
            }
            case 16415: {
                this.animationMode();
                break;
            }
            case 16416: {
                this.animationDirection();
                break;
            }
            case 1: {
                String str = (String)this.statement[1].value;
                if (str.equalsIgnoreCase("fps")) {
                    this.checkLength3();
                    this.viewer.setAnimationFps(this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(this.statement[1], true);
            }
        }
    }

    void frame(int offset, boolean useModelNumber) throws ScriptException {
        useModelNumber = true;
        if (this.statementLength <= offset) {
            this.badArgumentCount();
        }
        if (this.statement[offset].tok == 32770) {
            this.checkStatementLength(++offset + 1);
            if (this.statement[offset].tok != 2 || this.statement[offset].intValue != 1) {
                this.invalidArgument();
            }
            this.viewer.setAnimationPrevious();
            return;
        }
        int frameNumber = -1;
        int frameNumber2 = -1;
        boolean isPlay = false;
        boolean isRange = false;
        boolean isAll = false;
        while (offset < this.statementLength) {
            Token cmd = this.statement[offset];
            int tok = cmd.tok;
            switch (tok) {
                case 36875: {
                    isAll = true;
                }
                case 32777: {
                    break;
                }
                case 49157: {
                    break;
                }
                case 2: {
                    if (frameNumber == -1) {
                        frameNumber = cmd.intValue;
                        break;
                    }
                    frameNumber2 = cmd.intValue;
                    break;
                }
                case 16441: {
                    isPlay = true;
                    break;
                }
                case 16446: {
                    isRange = true;
                    break;
                }
                default: {
                    this.frameControl(cmd, false);
                    return;
                }
            }
            if (offset == this.statementLength - 1) {
                int modelIndex;
                if (isAll) {
                    this.viewer.setAnimationRange(-1, -1);
                    this.viewer.setDisplayModelIndex(-1);
                    return;
                }
                int n = modelIndex = useModelNumber ? this.viewer.getModelNumberIndex(frameNumber) : frameNumber - 1;
                if (!isPlay && !isRange || modelIndex >= 0) {
                    this.viewer.setDisplayModelIndex(modelIndex);
                }
                if (isPlay || isRange) {
                    if (isRange || frameNumber2 >= 0) {
                        int modelIndex2 = useModelNumber ? this.viewer.getModelNumberIndex(frameNumber2) : frameNumber2 - 1;
                        this.viewer.setAnimationDirection(1);
                        this.viewer.setAnimationRange(modelIndex, modelIndex2);
                    }
                    if (isPlay) {
                        this.viewer.resumeAnimation();
                    }
                }
            }
            ++offset;
        }
    }

    void frameControl(Token token, boolean isSubCmd) throws ScriptException {
        switch (token.tok) {
            case 16445: {
                this.viewer.setAnimationDirection(-this.viewer.getAnimationDirection());
            }
            case 16440: 
            case 16441: {
                this.viewer.resumeAnimation();
                return;
            }
            case 16659: {
                this.viewer.pauseAnimation();
                return;
            }
            case 16442: {
                this.viewer.setAnimationNext();
                return;
            }
            case 16443: {
                this.viewer.setAnimationPrevious();
                return;
            }
            case 16444: {
                this.viewer.rewindAnimation();
                return;
            }
        }
        this.evalError("invalid frame control keyword: " + token.toString());
    }

    int getShapeType(int tok) throws ScriptException {
        int iShape;
        if (tok == 343) {
            tok = 8458;
        }
        if ((iShape = JmolConstants.shapeTokenIndex(tok)) < 0) {
            this.unrecognizedColorObject();
        }
        return iShape;
    }

    void font() throws ScriptException {
        int shapeType = 0;
        int fontsize = 0;
        String fontface = "SansSerif";
        String fontstyle = "Plain";
        switch (this.statementLength) {
            case 5: {
                if (this.statement[4].tok != 1) {
                    this.keywordExpected();
                }
                fontstyle = (String)this.statement[4].value;
            }
            case 4: {
                if (this.statement[3].tok != 1) {
                    this.keywordExpected();
                }
                fontface = (String)this.statement[3].value;
            }
            case 3: {
                if (this.statement[2].tok != 2) {
                    this.integerExpected();
                }
                fontsize = this.statement[2].intValue;
                shapeType = this.getShapeType(this.statement[1].tok);
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        Font3D font3d = this.viewer.getFont3D(fontface, fontstyle, fontsize);
        this.viewer.setShapeProperty(shapeType, "font", font3d);
    }

    void set() throws ScriptException {
        switch (this.statement[1].tok) {
            case 2305: {
                this.setAxes(2);
                break;
            }
            case 2051: {
                this.setBondmode();
                break;
            }
            case 2052: {
                this.setBonds();
                break;
            }
            case 6405: {
                this.setBoundbox(2);
                break;
            }
            case 526598: {
                Logger.warn("WARNING! use 'set defaultColors' not 'set color'");
            }
            case 18471: {
                this.setDefaultColors();
                break;
            }
            case 2075: {
                this.setDebugScript();
                break;
            }
            case 2055: {
                this.setDisplay();
                break;
            }
            case 1050891: {
                this.setEcho();
                break;
            }
            case 2056: {
                this.setFontsize();
                break;
            }
            case 2336: {
                this.setFrank(2);
                break;
            }
            case 296961: {
                this.setHetero();
                break;
            }
            case 296962: {
                this.setHydrogen();
                break;
            }
            case 2079: {
                this.setLabelOffset();
                break;
            }
            case 15634: {
                this.setMonitor(2);
                break;
            }
            case 2077: {
                this.setProperty();
                break;
            }
            case 296964: {
                this.setSolvent();
                break;
            }
            case 100355: {
                this.setRadius();
                break;
            }
            case 10535: {
                this.setStrands();
                break;
            }
            case 2065: {
                this.setSpecular();
                break;
            }
            case 2066: {
                this.setSpecPower();
                break;
            }
            case 2048: {
                this.setAmbient();
                break;
            }
            case 2078: {
                this.setDiffuse();
                break;
            }
            case 2112832: {
                this.setSpin();
                break;
            }
            case 10532: {
                this.setSsbond();
                break;
            }
            case 10509: {
                this.setHbond();
                break;
            }
            case 2076: {
                this.setScale3d();
                break;
            }
            case 2324: {
                this.setUnitcell(2);
                break;
            }
            case 2062: {
                this.setPicking();
                break;
            }
            case 2083: {
                this.setPickingStyle();
                break;
            }
            case 2050: 
            case 2058: 
            case 2059: 
            case 2060: 
            case 2061: 
            case 2063: 
            case 2064: 
            case 2067: 
            case 2069: 
            case 2081: 
            case 2307: 
            case 2349: {
                this.notImplemented(1);
                break;
            }
            case 1: {
                String str = (String)this.statement[1].value;
                if (str.equalsIgnoreCase("measurementNumbers")) {
                    this.setMonitor(2);
                    break;
                }
                if (str.equalsIgnoreCase("defaultLattice")) {
                    Point3f pt;
                    if (this.statement.length < 3) {
                        this.badArgumentCount();
                    }
                    if (this.statement[2].tok == 2) {
                        int i = this.statement[2].intValue;
                        pt = new Point3f(i, i, i);
                    } else {
                        pt = this.getCoordinate(2, false);
                    }
                    this.viewer.setDefaultLattice(pt);
                    break;
                }
                if (str.equalsIgnoreCase("defaultLoadScript")) {
                    this.checkLength3();
                    this.viewer.setDefaultLoadScript(this.stringParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("dipoleScale")) {
                    this.checkLength3();
                    float scale = this.floatParameter(2);
                    if (scale < -10.0f || scale > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.viewer.setDipoleScale(scale);
                    break;
                }
                if (str.equalsIgnoreCase("logLevel")) {
                    int ilevel = this.intParameter(2);
                    int i = 5;
                    while (--i >= 0) {
                        Logger.setActiveLevel(i, 5 - i <= ilevel);
                    }
                    Logger.info("logging level set to " + ilevel);
                    break;
                }
                this.viewer.setBooleanProperty((String)this.statement[1].value, this.getSetBoolean());
                break;
            }
            case 4718849: 
            case 6299942: {
                this.setspecialShouldNotBeHere();
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setAxes(int cmdPt) throws ScriptException {
        if (this.statement.length == 1) {
            this.viewer.setShapeSize(16, 1);
            return;
        }
        if (this.statement.length == cmdPt + 2 && this.statement[cmdPt].tok == 1 && ((String)this.statement[cmdPt].value).equalsIgnoreCase("scale")) {
            this.viewer.setShapeProperty(16, "scale", new Float(this.floatParameter(cmdPt + 1)));
            return;
        }
        this.viewer.setShapeSize(16, this.getSetAxesTypeMad(cmdPt));
    }

    void setBoundbox(int cmdPt) throws ScriptException {
        this.viewer.setShapeSize(17, this.getSetAxesTypeMad(cmdPt));
    }

    void setUnitcell(int cmdPt) throws ScriptException {
        if (this.statement.length == cmdPt + 1) {
            this.viewer.setShapeSize(18, this.getSetAxesTypeMad(cmdPt));
        } else {
            this.viewer.setShapeProperty(18, "offset", this.getCoordinate(cmdPt, true, false));
        }
    }

    void setFrank(int cmdPt) throws ScriptException {
        this.viewer.setShapeSize(19, this.getSetAxesTypeMad(cmdPt));
    }

    void setDefaultColors() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 16392: 
            case 16430: {
                this.viewer.setDefaultColors((String)this.statement[2].value);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setBondmode() throws ScriptException {
        this.checkLength3();
        boolean bondmodeOr = false;
        switch (this.statement[2].tok) {
            case 32771: {
                break;
            }
            case 32772: {
                bondmodeOr = true;
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setBondSelectionModeOr(bondmodeOr);
    }

    void setBonds() throws ScriptException {
        this.viewer.setShowMultipleBonds(this.getSetBoolean());
    }

    void setDisplay() throws ScriptException {
        boolean showHalo = false;
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 299011: {
                showHalo = true;
            }
            case 16391: {
                this.viewer.setSelectionHaloEnabled(showHalo);
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
    }

    void setEcho() throws ScriptException {
        String propertyName = "target";
        String propertyValue = null;
        this.checkLength34();
        this.echoShapeActive = true;
        switch (this.statement[2].tok) {
            case 8192: {
                this.echoShapeActive = false;
                propertyName = "off";
                break;
            }
            case 49157: {
                this.echoShapeActive = false;
            }
            case 1: {
                propertyValue = (String)this.statement[2].value;
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
        this.viewer.loadShape(20);
        this.viewer.setShapeProperty(20, propertyName, propertyValue);
        if (this.statementLength == 4) {
            int tok = this.statement[3].tok;
            if (tok != 1 && tok != 4868) {
                this.keywordExpected();
            }
            this.viewer.setShapeProperty(20, "align", (String)this.statement[3].value);
        }
    }

    void setFontsize() throws ScriptException {
        int rasmolSize = 8;
        if (this.statementLength == 3) {
            rasmolSize = this.intParameter(2);
            if ((rasmolSize += 5) < 6 || rasmolSize > 63) {
                this.numberOutOfRange(6, 6);
            }
        }
        this.viewer.loadShape(4);
        this.viewer.setShapeProperty(4, "fontsize", new Integer(rasmolSize));
    }

    void setLabelOffset() throws ScriptException {
        this.checkLength4();
        int xOffset = this.intParameter(2);
        int yOffset = this.intParameter(3);
        int offset = (xOffset & 0xFF) << 8 | yOffset & 0xFF;
        this.viewer.loadShape(4);
        this.viewer.setShapeProperty(4, "offset", new Integer(offset));
    }

    void setHetero() throws ScriptException {
        this.viewer.setRasmolHeteroSetting(this.getSetBoolean());
    }

    void setHydrogen() throws ScriptException {
        this.viewer.setRasmolHydrogenSetting(this.getSetBoolean());
    }

    void setMonitor(int cmdPt) throws ScriptException {
        boolean showMeasurementNumbers = false;
        this.checkLength3();
        switch (this.statement[cmdPt].tok) {
            case 8193: {
                showMeasurementNumbers = true;
            }
            case 8192: {
                this.viewer.setShapeProperty(6, "showMeasurementNumbers", showMeasurementNumbers ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                if (!this.viewer.setMeasureDistanceUnits((String)this.statement[cmdPt].value)) {
                    this.unrecognizedSetParameter();
                }
                return;
            }
        }
        this.viewer.setShapeSize(6, this.getSetAxesTypeMad(cmdPt));
    }

    void setDebugScript() throws ScriptException {
        this.viewer.setDebugScript(this.getSetBoolean());
    }

    void setProperty() throws ScriptException {
        this.checkLength4();
        if (this.statement[2].tok != 1) {
            this.propertyNameExpected();
        }
        String propertyName = (String)this.statement[2].value;
        switch (this.statement[3].tok) {
            case 8193: {
                this.viewer.setBooleanProperty(propertyName, true);
                break;
            }
            case 8192: {
                this.viewer.setBooleanProperty(propertyName, false);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.notImplemented(3);
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setSolvent() throws ScriptException {
        this.viewer.setSolventOn(this.getSetBoolean());
    }

    void setRadius() throws ScriptException {
        this.checkLength3();
        this.viewer.setSolventProbeRadius(this.getRasmolAngstroms(2));
    }

    void setStrands() throws ScriptException {
        int strandCount = 5;
        if (this.statementLength == 3) {
            if (this.statement[2].tok != 2) {
                this.integerExpected();
            }
            if ((strandCount = this.statement[2].intValue) < 0 || strandCount > 20) {
                this.numberOutOfRange(0, 20);
            }
        }
        this.viewer.setShapeProperty(11, "strandCount", new Integer(strandCount));
    }

    void setSpecular() throws ScriptException {
        this.checkLength3();
        if (this.statement[2].tok == 2) {
            this.viewer.setSpecularPercent(this.intParameter(2));
        } else {
            this.viewer.setSpecular(this.getSetBoolean());
        }
    }

    void setSpecPower() throws ScriptException {
        this.checkLength3();
        this.viewer.setSpecularPower(this.intParameter(2));
    }

    void setAmbient() throws ScriptException {
        this.checkLength3();
        this.viewer.setAmbientPercent(this.intParameter(2));
    }

    void setDiffuse() throws ScriptException {
        this.checkLength3();
        this.viewer.setDiffusePercent(this.intParameter(2));
    }

    void setSpin() throws ScriptException {
        this.checkLength4();
        int value = this.intParameter(3);
        if (this.statement[2].tok == 1) {
            String str = (String)this.statement[2].value;
            if (str.equalsIgnoreCase("x")) {
                this.viewer.setSpinX(value);
                return;
            }
            if (str.equalsIgnoreCase("y")) {
                this.viewer.setSpinY(value);
                return;
            }
            if (str.equalsIgnoreCase("z")) {
                this.viewer.setSpinZ(value);
                return;
            }
            if (str.equalsIgnoreCase("fps")) {
                this.viewer.setSpinFps(value);
                return;
            }
        }
        this.unrecognizedSetParameter();
    }

    void setSsbond() throws ScriptException {
        this.checkLength3();
        boolean ssbondsBackbone = false;
        this.viewer.loadShape(3);
        switch (this.statement[2].tok) {
            case 303360: {
                ssbondsBackbone = true;
                break;
            }
            case 294917: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setSsbondsBackbone(ssbondsBackbone);
    }

    void setHbond() throws ScriptException {
        this.checkLength3();
        boolean bool = false;
        switch (this.statement[2].tok) {
            case 303360: {
                bool = true;
            }
            case 294917: {
                this.viewer.setHbondsBackbone(bool);
                break;
            }
            case 16429: {
                bool = true;
            }
            case 16414: {
                this.viewer.setHbondsSolid(bool);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setScale3d() throws ScriptException {
        this.checkLength3();
        float angstromsPerInch = 0.0f;
        switch (this.statement[2].tok) {
            case 3: {
                angstromsPerInch = ((Float)this.statement[2].value).floatValue();
                break;
            }
            case 2: {
                angstromsPerInch = this.statement[2].intValue;
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.viewer.setScaleAngstromsPerInch(angstromsPerInch);
    }

    void setPicking() throws ScriptException {
        int pickingMode = 1;
        if (this.statementLength >= 3) {
            block0 : switch (this.statement[2].tok) {
                case 8192: 
                case 49157: {
                    pickingMode = 0;
                }
                case 8193: {
                    break;
                }
                case 16395: {
                    pickingMode = 1;
                    break;
                }
                case 16396: {
                    pickingMode = 2;
                    break;
                }
                case 15634: {
                    pickingMode = 3;
                    break;
                }
                case 16397: {
                    pickingMode = 4;
                    break;
                }
                case 16398: {
                    pickingMode = 5;
                    break;
                }
                case 0x10010F: {
                    pickingMode = 6;
                    break;
                }
                case 4868: {
                    pickingMode = 7;
                    break;
                }
                case 16399: {
                    pickingMode = 8;
                    break;
                }
                case 2052: 
                case 10498: {
                    pickingMode = 9;
                    break;
                }
                case 4102: {
                    pickingMode = 10;
                    break;
                }
                case 36868: {
                    pickingMode = 11;
                    break;
                }
                case 36869: {
                    pickingMode = 12;
                    break;
                }
                case 98572: {
                    pickingMode = 14;
                    break;
                }
                case 2112832: {
                    pickingMode = 13;
                    int rate = 10;
                    if (this.statementLength == 4) {
                        rate = this.intParameter(3);
                    }
                    this.viewer.setPickingSpinRate(rate);
                    break;
                }
                case 798: {
                    pickingMode = 10;
                    if (this.statementLength != 4) break;
                    switch (this.statement[3].tok) {
                        case 36869: {
                            pickingMode = 12;
                        }
                        case 4102: {
                            break block0;
                        }
                        case 36868: {
                            pickingMode = 11;
                            break block0;
                        }
                    }
                    this.invalidArgument();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        this.viewer.setPickingMode(pickingMode);
    }

    void setPickingStyle() throws ScriptException {
        String style = "";
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 1: {
                style = (String)this.statement[2].value;
            }
            case 49157: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        if (!this.viewer.setPickingStyle(style)) {
            this.invalidArgument();
        }
    }

    void show() throws ScriptException {
        switch (this.statement[1].tok) {
            case 36876: {
                this.showPdbHeader();
                break;
            }
            case 102661: {
                this.showModel();
                break;
            }
            case 323: {
                this.showAnimation();
                break;
            }
            case 4111: {
                this.showOrientation();
                break;
            }
            case 4110: {
                this.showTransform();
                break;
            }
            case 4868: {
                this.showCenter();
                break;
            }
            case 4112: {
                this.showFile();
                break;
            }
            case 6405: {
                this.showBoundbox();
                break;
            }
            case 12591: {
                this.showZoom();
                break;
            }
            case 15634: {
                this.showMeasurements();
                break;
            }
            case 299016: {
                this.showSymmetry();
                break;
            }
            case 2626910: {
                this.showIsosurface();
                break;
            }
            case 4107: {
                this.showUrl();
                break;
            }
            case 4096: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4102: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4417: 
            case 6169: 
            case 36868: 
            case 36869: 
            case 36875: 
            case 299011: 
            case 2112832: {
                this.notImplemented(1);
                break;
            }
            default: {
                this.evalError("unrecognized SHOW parameter");
            }
        }
    }

    void showString(String str) {
        Logger.info("show:" + str);
        this.viewer.scriptStatus("" + str);
    }

    void showPdbHeader() {
        this.showString(this.viewer.getPDBHeader());
    }

    void showModel() {
        this.showString(this.viewer.getModelInfoAsString());
    }

    void showMeasurements() {
        this.showString(this.viewer.getMeasurementInfoAsString());
    }

    void showSymmetry() {
        this.showString(this.viewer.getSymmetryInfoAsString());
    }

    void showIsosurface() {
        this.showString((String)this.viewer.getShapeProperty(26, "jvxlFileData"));
    }

    void showFile() throws ScriptException {
        if (this.statementLength == 2) {
            this.showString(this.viewer.getCurrentFileAsString());
            return;
        }
        if (this.statementLength == 3 && this.statement[2].tok == 4) {
            String fileName = (String)this.statement[2].value;
            this.showString(this.viewer.getFileAsString(fileName));
            return;
        }
        this.invalidArgument();
    }

    void showUrl() throws ScriptException {
        if (this.statementLength == 2) {
            this.viewer.showUrl(this.viewer.getFullPathName());
            return;
        }
        if (this.statementLength == 3 && this.statement[2].tok == 4) {
            String fileName = (String)this.statement[2].value;
            this.viewer.showUrl(fileName);
            return;
        }
        this.invalidArgument();
    }

    void showAnimation() {
        this.showString("show animation information goes here");
    }

    void showOrientation() {
        this.showString(this.viewer.getOrientationText());
    }

    void showTransform() {
        this.showString("transform:\n" + this.viewer.getTransformText());
    }

    void showCenter() {
        this.showString("center: " + this.viewer.getCenter());
    }

    void showZoom() {
        this.showString("zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomPercentSetting() : "off"));
    }

    void showBoundbox() {
        this.showString("boundbox: " + this.viewer.getBoundBoxCenter() + " " + this.viewer.getBoundBoxCornerVector());
    }

    /*
     * Unable to fully structure code
     */
    void pmesh() throws ScriptException {
        this.viewer.loadShape(24);
        this.viewer.setShapeProperty(24, "init", null);
        block4: for (i = 1; i < this.statementLength; ++i) {
            propertyName = null;
            propertyValue = null;
            tok = this.statement[i].tok;
            switch (tok) {
                case 1: {
                    propertyValue = this.statement[i].value;
                    str = (String)propertyValue;
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    propertyName = "thisID";
                    break;
                }
                case 4: {
                    filename = (String)this.statement[i].value;
                    propertyName = "bufferedReader";
                    if (!filename.equalsIgnoreCase("inline")) ** GOTO lbl39
                    if (i + 1 < this.statementLength && this.statement[i + 1].tok == 4) {
                        data = (String)this.statement[++i].value;
                        if (data.indexOf("|") < 0 && data.indexOf("\n") < 0) {
                            data = this.viewer.simpleReplace(data, " ", "\n");
                            propertyName = "bufferedReaderOnePerLine";
                        }
                        data = this.viewer.simpleReplace(data, "{", " ");
                        data = this.viewer.simpleReplace(data, ",", " ");
                        data = this.viewer.simpleReplace(data, "}", " ");
                        data = this.viewer.simpleReplace(data, "|", "\n");
                        data = this.viewer.simpleReplace(data, "\n\n", "\n");
                        t = this.viewer.getBufferedReaderForString(data);
                    } else {
                        this.stringOrIdentifierExpected();
                        break;
lbl39:
                        // 1 sources

                        t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename);
                        if (t instanceof String) {
                            this.fileNotFoundException(filename + ":" + t);
                        }
                    }
                    propertyValue = t;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(24, tok)) continue block4;
                    this.invalidArgument(i, this.statement[i] + " not recognized");
                    continue block4;
                }
            }
            this.viewer.setShapeProperty(24, propertyName, propertyValue);
        }
    }

    void draw() throws ScriptException {
        this.viewer.loadShape(28);
        this.viewer.setShapeProperty(28, "init", null);
        boolean havePoints = false;
        boolean isInitialized = false;
        int intScale = 0;
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            int tok = this.statement[i].tok;
            block0 : switch (tok) {
                case 1: {
                    propertyName = "thisID";
                    propertyValue = this.statement[i].value;
                    String str = (String)propertyValue;
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("PLANE")) {
                        propertyName = "plane";
                        break;
                    }
                    if (str.equalsIgnoreCase("CROSSED")) {
                        propertyName = "crossed";
                        break;
                    }
                    if (str.equalsIgnoreCase("VERTICES")) {
                        propertyName = "vertices";
                        break;
                    }
                    if (str.equalsIgnoreCase("REVERSE")) {
                        propertyName = "reverse";
                        break;
                    }
                    if (str.equalsIgnoreCase("ROTATE45")) {
                        propertyName = "rotate45";
                        break;
                    }
                    if (str.equalsIgnoreCase("PERP") || str.equalsIgnoreCase("PERPENDICULAR")) {
                        propertyName = "perp";
                        break;
                    }
                    if (str.equalsIgnoreCase("SCALE")) {
                        this.checkStatementLength(++i + 1);
                        switch (this.statement[i].tok) {
                            case 2: {
                                intScale = this.intParameter(i);
                                break block0;
                            }
                            case 3: {
                                intScale = (int)(this.floatParameter(i) * 100.0f);
                                break block0;
                            }
                        }
                        this.numberExpected();
                        break;
                    }
                    if (!str.equalsIgnoreCase("LENGTH")) break;
                    propertyValue = new Float(this.floatParameter(++i));
                    propertyName = "length";
                    break;
                }
                case 8388627: {
                    propertyValue = this.objectNameParameter(++i);
                    propertyName = "identifier";
                    havePoints = true;
                    break;
                }
                case 3: {
                    propertyValue = new Float(this.floatParameter(i));
                    propertyName = "length";
                    break;
                }
                case 2: {
                    intScale = this.intParameter(i);
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    propertyName = "coord";
                    propertyValue = pt;
                    havePoints = true;
                    break;
                }
                case 32868: {
                    propertyName = "atomSet";
                    propertyValue = this.expression(this.statement, i + 1);
                    i = this.pcLastExpressionInstruction;
                    havePoints = true;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(28, tok)) break;
                    this.invalidArgument();
                }
            }
            if (havePoints && !isInitialized) {
                this.viewer.setShapeProperty(28, "points", new Integer(intScale));
                isInitialized = true;
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(28, propertyName, propertyValue);
        }
        if (havePoints) {
            this.viewer.setShapeProperty(28, "set", null);
        } else if (intScale != 0) {
            this.viewer.setShapeProperty(28, "scale", new Integer(intScale));
        }
    }

    void polyhedra() throws ScriptException {
        boolean isChange = false;
        boolean iHaveVertexExpression = false;
        boolean iHaveCenterExpression = false;
        this.viewer.loadShape(22);
        this.viewer.setShapeProperty(22, "init", null);
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            Token token = this.statement[i];
            switch (token.tok) {
                case 2052: {
                    isChange = true;
                }
                case 1: {
                    propertyName = (String)token.value;
                    if (propertyName.equalsIgnoreCase("collapsed")) {
                        isChange = true;
                        break;
                    }
                    if (propertyName.equalsIgnoreCase("maxFactor") || propertyName.equalsIgnoreCase("faceCenterOffset")) {
                        isChange = true;
                        if (++i == this.statementLength) {
                            this.numberExpected();
                        }
                        if (this.statement[i].tok == 2) {
                            propertyValue = new Float(this.statement[i].intValue);
                            break;
                        }
                        if (this.statement[i].tok != 3) break;
                        propertyValue = this.statement[i].value;
                        break;
                    }
                    if (!propertyName.equalsIgnoreCase("to")) break;
                    isChange = true;
                    iHaveVertexExpression = true;
                    if (++i == this.statementLength || this.statement[i].tok != 32868) {
                        this.expressionExpected();
                    }
                    propertyValue = this.expression(this.statement, ++i);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 2: {
                    propertyName = "nBonds";
                    propertyValue = new Integer(token.intValue);
                    isChange = true;
                    break;
                }
                case 3: {
                    propertyName = "radius";
                    propertyValue = token.value;
                    isChange = true;
                    break;
                }
                case 16429: {
                    isChange = true;
                }
                case 8192: 
                case 8193: 
                case 16426: {
                    propertyName = (String)token.value;
                    break;
                }
                case 32868: {
                    if (iHaveVertexExpression || !iHaveCenterExpression) {
                        propertyName = "centers";
                        iHaveCenterExpression = true;
                    } else {
                        propertyName = "to";
                        iHaveVertexExpression = true;
                    }
                    propertyValue = this.expression(this.statement, ++i);
                    i = this.pcLastExpressionInstruction;
                    isChange = true;
                    break;
                }
                default: {
                    this.invalidArgument(i, "polyhedra command");
                }
            }
            this.viewer.setShapeProperty(22, propertyName, propertyValue);
        }
        if (isChange) {
            this.viewer.setShapeProperty(22, "generate", null);
        }
    }

    /*
     * Unable to fully structure code
     */
    void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(27);
        this.viewer.setShapeProperty(27, "init", null);
        if (this.statementLength == 1) {
            this.endOfStatementUnexpected();
        }
        block11: for (i = 1; i < this.statementLength; ++i) {
            token = this.statement[i];
            tok = token.tok;
            propertyName = null;
            propertyValue = null;
            switch (tok) {
                case 8193: {
                    propertyName = "on";
                    ** GOTO lbl51
                }
                case 8192: {
                    propertyName = "off";
                    ** GOTO lbl51
                }
                case 16426: {
                    propertyName = "delete";
                    ** GOTO lbl51
                }
                case 2: 
                case 3: {
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(++i));
                    ** GOTO lbl51
                }
                case 526598: {
                    if (++i < this.statement.length && this.statement[i].tok == 540692) {
                        this.viewer.setShapeProperty(27, "colorRGB", new Integer(this.getArgbParam(i)));
                        this.viewer.setShapeProperty(27, "colorRGB", new Integer(this.getArgbParam(i + 1 < this.statement.length && this.statement[i + 1].tok == 540692 ? ++i : i)));
                        continue block11;
                    }
                    this.invalidArgument();
                }
                case 4: {
                    propertyName = "create";
                    propertyValue = this.stringParameter(i);
                    ** GOTO lbl51
                }
                case 798: {
                    propertyName = "select";
                    propertyValue = this.stringParameter(++i);
                    ** GOTO lbl51
                }
                case 1: {
                    str = (String)token.value;
                    if (!str.equalsIgnoreCase("SCALE")) ** GOTO lbl44
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(++i));
                    ** GOTO lbl51
lbl44:
                    // 1 sources

                    if (!str.equalsIgnoreCase("CREATE")) ** GOTO lbl48
                    propertyName = "create";
                    propertyValue = this.stringParameter(++i);
                    ** GOTO lbl51
lbl48:
                    // 1 sources

                    propertyValue = str;
                }
                case 36875: {
                    propertyName = "lcaoID";
                }
lbl51:
                // 10 sources

                default: {
                    if (propertyName == null) {
                        this.invalidArgument(i, token.toString());
                    }
                    this.viewer.setShapeProperty(27, propertyName, propertyValue);
                }
            }
        }
    }

    void mo() throws ScriptException {
        int moIndex;
        this.viewer.loadShape(25);
        this.viewer.setShapeProperty(25, "init", null);
        Integer index = null;
        try {
            index = (Integer)this.viewer.getShapeProperty(25, "moIndex");
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = moIndex = index == null ? Integer.MAX_VALUE : index;
        if (moIndex == Integer.MAX_VALUE) {
            this.lastMoIndex = 0;
        }
        if (this.statementLength == 1) {
            this.endOfStatementUnexpected();
        }
        Token token = this.statement[1];
        int tok = token.tok;
        String propertyName = null;
        Serializable propertyValue = null;
        switch (tok) {
            case 2: {
                moIndex = this.intParameter(1);
                break;
            }
            case 16442: {
                moIndex = this.lastMoIndex + 1;
                break;
            }
            case 16443: {
                moIndex = this.lastMoIndex - 1;
                break;
            }
            case 526598: {
                if (2 < this.statement.length && this.statement[2].tok == 540692) {
                    this.viewer.setShapeProperty(25, "colorRGB", new Integer(this.getArgbParam(2)));
                    if (3 >= this.statement.length || this.statement[3].tok != 540692) break;
                    this.viewer.setShapeProperty(25, "colorRGB", new Integer(this.getArgbParam(3)));
                    break;
                }
                this.invalidArgument();
            }
            case 1: {
                String str = (String)token.value;
                if (str.equalsIgnoreCase("CUTOFF")) {
                    propertyName = "cutoff";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("RESOLUTION")) {
                    propertyName = "resolution";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("plane")) {
                    propertyName = "plane";
                    propertyValue = this.planeParameter(2);
                    break;
                }
                if (str.equalsIgnoreCase("noplane")) {
                    propertyName = "plane";
                    propertyValue = null;
                    break;
                }
                this.invalidArgument(1, str);
            }
            default: {
                if (!this.setMeshDisplayProperty(25, tok)) {
                    this.invalidArgument(1, this.statement[1] + " not recognized");
                }
                return;
            }
        }
        if (propertyName != null) {
            this.viewer.setShapeProperty(25, propertyName, propertyValue);
        }
        if (moIndex != Integer.MAX_VALUE) {
            this.setMoData(25, moIndex);
        }
    }

    void setMoData(int shape, int moIndex) throws ScriptException {
        Vector mos;
        int nOrb;
        Hashtable moData;
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            this.evalError("MO isosurfaces require that only one model be displayed");
        }
        if ((moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "moData")) == null) {
            this.evalError("no MO basis/coefficient data available for this frame");
        }
        int n = nOrb = (mos = (Vector)moData.get("mos")) == null ? 0 : mos.size();
        if (nOrb == 0) {
            this.evalError("no MO coefficient data available");
        }
        if (nOrb == 1 && moIndex > 1) {
            this.evalError("Only one molecular orbital is available in this file");
        }
        if (moIndex < 1 || moIndex > nOrb) {
            this.evalError("An MO index from 1 to " + nOrb + " is required");
        }
        this.lastMoIndex = moIndex;
        Hashtable mo = (Hashtable)mos.get(moIndex - 1);
        int occ = mo.containsKey("occupancy") ? (Integer)mo.get("occupancy") : -1;
        String[] title = new String[]{"Model " + (modelIndex + 1) + "  MO " + moIndex + "/" + mos.size(), mo.containsKey("symmetry") ? "Symmetry = " + mo.get("symmetry") : "", "Energy = " + mo.get("energy") + " " + moData.get("energyUnits"), occ < 0 ? "" : "Occupancy = " + occ};
        this.viewer.setShapeProperty(shape, "title", title);
        this.viewer.setShapeProperty(shape, "molecularOrbital", new Integer(moIndex));
        this.viewer.setShapeProperty(shape, "moData", moData);
    }

    void isosurface() throws ScriptException {
        this.viewer.loadShape(26);
        this.viewer.setShapeProperty(26, "init", null);
        int colorRangeStage = 0;
        int signPt = 0;
        boolean surfaceObjectSeen = false;
        float[] nlmZ = new float[5];
        block25: for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            Token token = this.statement[i];
            block0 : switch (token.tok) {
                case 798: {
                    propertyName = "select";
                    propertyValue = this.expression(this.statement, ++i + 1);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 4868: {
                    propertyName = "center";
                    switch (this.statement[++i].tok) {
                        case 8388627: {
                            String id = this.objectNameParameter(++i);
                            propertyValue = this.viewer.getDrawObjectCenter(id);
                            if (propertyValue != null) break block0;
                            this.drawObjectNotDefined(id);
                            break;
                        }
                        case 32868: {
                            propertyValue = this.viewer.getAtomSetCenter(this.expression(this.statement, ++i));
                            i = this.pcLastExpressionInstruction;
                            break;
                        }
                        case 32785: {
                            propertyValue = this.getCoordinate(i, true);
                            i = this.pcLastExpressionInstruction;
                            break;
                        }
                        default: {
                            this.coordinateOrNameOrExpressionRequired();
                            break;
                        }
                    }
                    break;
                }
                case 526598: {
                    if (i + 1 == this.statement.length) {
                        this.invalidArgument(i, " COLOR keyword not in context");
                    }
                    colorRangeStage = 0;
                    switch (this.statement[i + 1].tok) {
                        case 16431: {
                            ++i;
                            colorRangeStage = 1;
                            break;
                        }
                        case 540692: {
                            signPt = i + 1;
                        }
                    }
                    continue block25;
                }
                case 2: 
                case 3: {
                    propertyName = colorRangeStage == 1 ? "red" : (colorRangeStage == 2 ? "blue" : "cutoff");
                    propertyValue = new Float(this.floatParameter(i));
                    if (colorRangeStage <= 0) break;
                    ++colorRangeStage;
                    break;
                }
                case 540692: {
                    if (i != signPt && i != signPt + 1) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "colorRGB";
                    propertyValue = new Integer(this.getArgbParam(i));
                    break;
                }
                case 1: {
                    String str = (String)token.value;
                    if (str.equalsIgnoreCase("REMAPPABLE")) {
                        propertyName = "remappable";
                        break;
                    }
                    if (str.equalsIgnoreCase("CUTOFF")) {
                        propertyName = "cutoff";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("SCALE")) {
                        propertyName = "scale";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("RESOLUTION")) {
                        propertyName = "resolution";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ANISOTROPY")) {
                        propertyName = "anisotropy";
                        propertyValue = this.getCoordinate(i + 1, false);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("ECCENTRICITY")) {
                        propertyName = "eccentricity";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("SIGN")) {
                        signPt = i + 1;
                        propertyName = "sign";
                        propertyValue = Boolean.TRUE;
                        colorRangeStage = 1;
                        break;
                    }
                    if (str.equalsIgnoreCase("INSIDEOUT")) {
                        propertyName = "insideOut";
                        break;
                    }
                    if (str.equalsIgnoreCase("REVERSECOLOR")) {
                        propertyName = "reverseColor";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("ADDHYDROGENS")) {
                        propertyName = "addHydrogens";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("COLORSCHEME")) {
                        propertyName = "setColorScheme";
                        propertyValue = this.stringParameter(++i);
                        break;
                    }
                    if (str.equalsIgnoreCase("DEBUG") || str.equalsIgnoreCase("NODEBUG")) {
                        propertyName = "debug";
                        propertyValue = str.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("GRIDPOINTS")) {
                        propertyName = "gridPoints";
                        break;
                    }
                    if (str.equalsIgnoreCase("CONTOUR")) {
                        propertyName = "contour";
                        propertyValue = new Integer(i + 1 < this.statement.length && this.statement[i + 1].tok == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (str.equalsIgnoreCase("PHASE")) {
                        propertyName = "phase";
                        propertyValue = i + 1 < this.statement.length && this.statement[i + 1].tok == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (str.equalsIgnoreCase("MAP")) {
                        surfaceObjectSeen = true;
                        propertyName = "map";
                        break;
                    }
                    if (str.equalsIgnoreCase("plane")) {
                        surfaceObjectSeen = true;
                        propertyName = "plane";
                        propertyValue = this.planeParameter(++i);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("sphere")) {
                        surfaceObjectSeen = true;
                        propertyName = "sphere";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ellipsoid")) {
                        surfaceObjectSeen = true;
                        propertyName = "ellipsoid";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("lobe")) {
                        surfaceObjectSeen = true;
                        propertyName = "lobe";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("AtomicOrbital") || str.equalsIgnoreCase("orbital")) {
                        surfaceObjectSeen = true;
                        nlmZ[0] = this.intParameter(++i);
                        nlmZ[1] = this.intParameter(++i);
                        nlmZ[2] = this.intParameter(++i);
                        nlmZ[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        propertyName = "hydrogenOrbital";
                        propertyValue = nlmZ;
                        break;
                    }
                    if (str.equalsIgnoreCase("functionXY")) {
                        surfaceObjectSeen = true;
                        Vector<Object> v = new Vector<Object>();
                        if (++i == this.statement.length) {
                            this.badArgumentCount();
                        }
                        if (this.statement[i].tok != 4) {
                            this.invalidArgument(i, "function name in quotation marks expected");
                        }
                        v.add(this.statement[i++].value);
                        v.add(this.getCoordinate(i, false));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        i = this.pcLastExpressionInstruction;
                        propertyName = "functionXY";
                        propertyValue = v;
                        break;
                    }
                    propertyValue = token.value;
                }
                case 36875: {
                    propertyName = "thisID";
                    break;
                }
                case 524644: {
                    surfaceObjectSeen = true;
                    String lcaoType = this.stringParameter(++i);
                    this.viewer.setShapeProperty(26, "lcaoType", lcaoType);
                    switch (this.statement[++i].tok) {
                        case 32868: {
                            propertyName = "lcaoCartoon";
                            int atomIndex = this.viewer.firstAtomOf(this.expression(this.statement, ++i));
                            if (atomIndex < 0) {
                                this.expressionExpected();
                            }
                            Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.viewer.getAtomPoint3f(atomIndex))};
                            this.viewer.getPrincipalAxes(atomIndex, axes[0], axes[1], lcaoType, false);
                            i = this.pcLastExpressionInstruction;
                            propertyValue = axes;
                            break block0;
                        }
                    }
                    this.expressionExpected();
                    break;
                }
                case 2625891: {
                    if (++i == this.statement.length) {
                        this.badArgumentCount();
                    }
                    int moIndex = this.intParameter(i);
                    this.setMoData(26, moIndex);
                    surfaceObjectSeen = true;
                    continue block25;
                }
                case 16448: 
                case 296964: {
                    surfaceObjectSeen = true;
                    propertyName = token.tok == 296964 ? "solvent" : "sasurface";
                    float radius = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    propertyValue = new Float(radius);
                    break;
                }
                case 4: {
                    Object t;
                    String filename = (String)token.value;
                    if (filename.length() == 0) {
                        filename = this.viewer.getFullPathName();
                    }
                    if (i + 1 < this.statement.length && this.statement[i + 1].tok == 2) {
                        this.viewer.setShapeProperty(26, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    if ((t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename)) instanceof String) {
                        this.fileNotFoundException(filename + ":" + t);
                    }
                    Logger.info("reading isosurface data from " + filename);
                    propertyName = surfaceObjectSeen ? "mapColor" : "getSurface";
                    propertyValue = t;
                    surfaceObjectSeen = true;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(26, token.tok)) break;
                    this.invalidArgument(i, this.statement[i] + " not recognized");
                }
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(26, propertyName, propertyValue);
        }
    }

    boolean setMeshDisplayProperty(int shape, int tok) {
        String propertyName = null;
        Object propertyValue = null;
        switch (tok) {
            case 8193: {
                propertyName = "on";
                break;
            }
            case 8192: {
                propertyName = "off";
                break;
            }
            case 16426: {
                propertyName = "delete";
                break;
            }
            case 8458: {
                propertyValue = Boolean.TRUE;
            }
            case 16433: {
                propertyName = "dots";
                break;
            }
            case 16434: {
                propertyValue = Boolean.TRUE;
            }
            case 16435: {
                propertyName = "mesh";
                break;
            }
            case 16436: {
                propertyValue = Boolean.TRUE;
            }
            case 16437: {
                propertyName = "fill";
                break;
            }
            case 16425: {
                propertyName = "translucency";
                propertyValue = "translucent";
                break;
            }
            case 16424: {
                propertyName = "translucency";
                propertyValue = "opaque";
            }
        }
        if (propertyName == null) {
            return false;
        }
        this.viewer.setShapeProperty(shape, propertyName, propertyValue);
        return true;
    }

    void evalError(String message) throws ScriptException {
        throw new ScriptException(message, this.getLine(), this.filename, this.getLinenumber());
    }

    void unrecognizedCommand(Token token) throws ScriptException {
        this.evalError("unrecognized command:" + token.value);
    }

    void unrecognizedAtomProperty(int propnum) throws ScriptException {
        this.evalError("unrecognized atom property:" + propnum);
    }

    void filenameExpected() throws ScriptException {
        this.evalError("filename expected");
    }

    void booleanExpected() throws ScriptException {
        this.evalError("boolean expected");
    }

    void booleanOrPercentExpected() throws ScriptException {
        this.evalError("boolean or percent expected");
    }

    void booleanOrNumberExpected() throws ScriptException {
        this.evalError("boolean or number expected");
    }

    void booleanOrNumberExpected(String orWhat) throws ScriptException {
        this.evalError("boolean, number, or \"" + orWhat + "\" expected");
    }

    void expressionOrDecimalExpected() throws ScriptException {
        this.evalError("(atom expression) or decimal number expected");
    }

    void expressionOrIntegerExpected() throws ScriptException {
        this.evalError("(atom expression) or integer expected");
    }

    void expressionExpected() throws ScriptException {
        this.evalError("valid (atom expression) expected");
    }

    void rotationPointsIdentical() throws ScriptException {
        this.evalError("rotation points cannot be identical");
    }

    void integerExpected() throws ScriptException {
        this.evalError("integer expected");
    }

    void numberExpected() throws ScriptException {
        this.evalError("number expected");
    }

    void stringExpected() throws ScriptException {
        this.evalError("quoted string expected");
    }

    void stringOrIdentifierExpected() throws ScriptException {
        this.evalError("quoted string or identifier expected");
    }

    void propertyNameExpected() throws ScriptException {
        this.evalError("property name expected");
    }

    void axisExpected() throws ScriptException {
        this.evalError("x y z axis expected");
    }

    void colorExpected() throws ScriptException {
        this.evalError("color expected");
    }

    void keywordExpected() throws ScriptException {
        this.evalError("keyword expected");
    }

    void unrecognizedColorObject() throws ScriptException {
        this.evalError("unrecognized color object");
    }

    void unrecognizedExpression() throws ScriptException {
        this.evalError("runtime unrecognized expression");
    }

    void undefinedVariable(String varName) throws ScriptException {
        this.evalError("variable undefined:" + varName);
    }

    void endOfStatementUnexpected() throws ScriptException {
        this.evalError("unexpected end of script command");
    }

    void badArgumentCount() throws ScriptException {
        this.evalError("bad argument count");
    }

    void invalidArgument() throws ScriptException {
        String str = "invalid argument";
        for (int i = 0; i < this.statementLength; ++i) {
            str = str + "\n" + this.statement[i].toString();
        }
        this.evalError(str);
    }

    void invalidArgument(int ipt, String info) throws ScriptException {
        String str = "invalid argument - " + info;
        for (int i = 0; i <= ipt; ++i) {
            str = str + "\n" + this.statement[i].toString();
        }
        this.evalError(str);
    }

    void unrecognizedSetParameter() throws ScriptException {
        this.evalError("unrecognized SET parameter");
    }

    void unrecognizedSubcommand(String cmd) throws ScriptException {
        this.evalError("unrecognized subcommand: " + cmd);
    }

    void subcommandExpected() throws ScriptException {
        this.evalError("subcommand expected");
    }

    void setspecialShouldNotBeHere() throws ScriptException {
        this.evalError("interpreter error - setspecial should not be here");
    }

    void numberOutOfRange() throws ScriptException {
        this.evalError("number out of range");
    }

    void numberOutOfRange(int min, int max) throws ScriptException {
        this.evalError("integer out of range (" + min + " - " + max + ")");
    }

    void numberOutOfRange(float min, float max) throws ScriptException {
        this.evalError("decimal number out of range (" + min + " - " + max + ")");
    }

    void numberMustBe(int a, int b) throws ScriptException {
        this.evalError("number must be (" + a + " or " + b + ")");
    }

    void badAtomNumber() throws ScriptException {
        this.evalError("bad atom number");
    }

    void errorLoadingScript(String msg) throws ScriptException {
        this.evalError("error loading script -> " + msg);
    }

    void fileNotFoundException(String filename) throws ScriptException {
        this.evalError("file not found : " + filename);
    }

    void drawObjectNotDefined(String drawID) throws ScriptException {
        this.evalError("draw object not defined:" + drawID);
    }

    void objectNameExpected() throws ScriptException {
        this.evalError("object name expected after '$'");
    }

    void coordinateExpected() throws ScriptException {
        this.evalError("{ number number number } expected");
    }

    void coordinateOrNameOrExpressionRequired() throws ScriptException {
        this.evalError(" {x y z} or $name or (atom expression) required");
    }

    void tooManyRotationPoints() throws ScriptException {
        this.evalError("too many rotation points were specified");
    }

    void keywordExpected(String what) throws ScriptException {
        this.evalError("keyword expected: " + what);
    }

    void notImplemented(int itoken) {
        this.notImplemented(this.statement[itoken]);
    }

    void notImplemented(Token token) {
        this.viewer.scriptStatus("script ERROR: " + token.value + " not implemented in command:" + this.statement[0].value);
    }

    void invalidParameterOrder() throws ScriptException {
        this.evalError("invalid parameter order");
    }

    void incompatibleArguments() throws ScriptException {
        this.evalError("incompatible arguments");
    }

    void insufficientArguments() throws ScriptException {
        this.evalError("insufficient arguments");
    }

    class ScriptException
    extends Exception {
        String message;
        String line;
        String fileName;
        int linenumber;

        ScriptException(String message, String line, String filename, int linenumber) {
            this.message = message;
            this.line = line;
            this.fileName = filename;
            this.linenumber = linenumber;
            Logger.error(this.toString());
        }

        public String toString() {
            String str = "ScriptException:" + this.message;
            if (this.line != null) {
                str = str + "\n    Script line:" + this.line;
            }
            if (this.fileName != null) {
                str = str + "\n           File:" + this.fileName + " Line number:" + this.linenumber;
            }
            return str;
        }
    }
}

