/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.util.Logger;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshCollection;

class Draw
extends MeshCollection {
    static final int MAX_POINTS = 256;
    Point3f[] ptList = new Point3f[256];
    int[] ptIdentifiers = new int[256];
    boolean[] reversePoints = new boolean[256];
    boolean[] useVertices = new boolean[256];
    BitSet[] ptBitSets = new BitSet[256];
    BitSet bsAllAtoms = new BitSet();
    Point3f xyz = new Point3f();
    int ipt;
    int nPoints;
    int nbitsets;
    int ncoord;
    int nidentifiers;
    float newScale;
    float length;
    boolean isFixed;
    boolean isVisible;
    boolean isPerpendicular;
    boolean isVertices;
    boolean isPlane;
    boolean isReversed;
    boolean isRotated45;
    boolean isCrossed;
    boolean isValid;
    static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 25;

    Draw() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("draw " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.nPoints = -1;
            this.nidentifiers = 0;
            this.nbitsets = 0;
            this.ncoord = 0;
            this.ipt = 0;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isPlane = false;
            this.isValid = true;
            this.isVisible = true;
            this.length = Float.MAX_VALUE;
            super.setProperty("thisID", null, null);
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Float)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.nPoints = 0;
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.currentMesh != null) {
                this.currentMesh.scaleDrawing(this.newScale);
                this.currentMesh.initialize();
            }
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.reversePoints[this.nidentifiers] = this.isReversed;
                this.useVertices[this.nidentifiers] = this.isVertices;
                this.ptIdentifiers[this.nidentifiers] = meshIndex;
                ++this.nidentifiers;
                ++this.nPoints;
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error("draw identifier " + value + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("coord" == propertyName) {
            this.ptList[this.ncoord++] = new Point3f((Point3f)value);
            ++this.nPoints;
            return;
        }
        if ("atomSet" == propertyName) {
            if (this.viewer.cardinalityOf((BitSet)value) == 0) {
                return;
            }
            this.ptBitSets[this.nbitsets++] = (BitSet)value;
            this.bsAllAtoms.or((BitSet)value);
            ++this.nPoints;
            return;
        }
        if ("set" == propertyName) {
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            boolean bl = this.currentMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.currentMesh.isValid) {
                this.currentMesh.scaleDrawing(this.newScale);
                this.currentMesh.initialize();
                this.currentMesh.setAxes();
                this.currentMesh.visible = this.isVisible;
            }
            this.nPoints = -1;
            return;
        }
        if ("off" == propertyName) {
            this.isVisible = false;
        }
        super.setProperty(propertyName, value, bs);
    }

    boolean setDrawing() {
        if (this.currentMesh == null) {
            this.allocMesh(null);
        }
        this.currentMesh.clear("draw");
        if (this.nPoints == 0) {
            return false;
        }
        int nPoly = 0;
        int modelCount = this.viewer.getModelCount();
        if (this.isFixed) {
            this.currentMesh.setPolygonCount(1);
            this.currentMesh.ptCenters = null;
            this.currentMesh.modelFlags = null;
            this.addFixedPoints();
            nPoly = this.setPolygons(nPoly);
        } else {
            BitSet bsAllModels = new BitSet();
            bsAllModels = this.nbitsets > 0 ? this.viewer.getModelBitSet(this.bsAllAtoms) : this.viewer.getVisibleFramesBitSet();
            this.currentMesh.setPolygonCount(modelCount);
            this.currentMesh.ptCenters = new Point3f[modelCount];
            this.currentMesh.modelFlags = new int[modelCount];
            for (int iModel = 0; iModel < modelCount; ++iModel) {
                if (!bsAllModels.get(iModel)) continue;
                this.addModelPoints(iModel);
                nPoly = this.setPolygons(nPoly);
                this.currentMesh.setCenter(iModel);
            }
        }
        this.currentMesh.setCenter(-1);
        return true;
    }

    private void addFixedPoints() {
        int i;
        this.nPoints = this.ncoord;
        for (i = 0; i < this.nidentifiers; ++i) {
            Mesh m = this.meshes[this.ptIdentifiers[i]];
            if (this.isPlane || this.isPerpendicular || this.useVertices[i]) {
                if (this.reversePoints[i]) {
                    this.ipt = m.drawVertexCount;
                    while (--this.ipt >= 0) {
                        this.addPoint(m.vertices[this.ipt]);
                    }
                    continue;
                }
                this.ipt = 0;
                while (this.ipt < m.drawVertexCount) {
                    this.addPoint(m.vertices[this.ipt]);
                    ++this.ipt;
                }
                continue;
            }
            this.addPoint(m.ptCenter);
        }
        for (i = 0; i < this.nbitsets; ++i) {
            this.addPoint(this.viewer.getAtomSetCenter(this.ptBitSets[i]));
        }
    }

    void addPoint(Point3f newPt) {
        this.ptList[this.nPoints++] = new Point3f(newPt);
        if (this.nPoints > 256) {
            this.nPoints = 256;
        }
    }

    private void addModelPoints(int iModel) {
        this.nPoints = this.ncoord;
        for (int i = 0; i < this.nidentifiers; ++i) {
            if (this.meshes[this.ptIdentifiers[i]].ptCenters == null || this.meshes[this.ptIdentifiers[i]].ptCenters[iModel] == null) {
                this.addPoint(this.meshes[this.ptIdentifiers[i]].ptCenter);
                continue;
            }
            this.addPoint(this.meshes[this.ptIdentifiers[i]].ptCenters[iModel]);
        }
        BitSet bsModel = this.viewer.getModelAtomBitSet(iModel);
        for (int i = 0; i < this.nbitsets; ++i) {
            BitSet bs = (BitSet)this.ptBitSets[i].clone();
            bs.and(bsModel);
            if (this.viewer.cardinalityOf(bs) <= 0) continue;
            this.addPoint(this.viewer.getAtomSetCenter(bs));
        }
    }

    private int setPolygons(int nPoly) {
        if (this.nPoints == 4 && this.isCrossed) {
            Point3f pt = new Point3f(this.ptList[1]);
            this.ptList[1].set(this.ptList[2]);
            this.ptList[2].set(pt);
        }
        return this.currentMesh.setPolygon(this.ptList, this.nPoints, nPoly, this.isPlane, this.isPerpendicular, this.isRotated45, this.length);
    }

    void setVisibilityFlags(BitSet bs) {
        int modelCount = this.viewer.getModelCount();
        int i = this.meshCount;
        while (--i >= 0) {
            Mesh m = this.meshes[i];
            int n = m.visibilityFlags = m.isValid ? this.myVisibilityFlag : 0;
            if (m.modelFlags == null) continue;
            int iModel = modelCount;
            while (--iModel >= 0) {
                m.modelFlags[iModel] = bs.get(iModel) ? 1 : 0;
            }
        }
    }

    void checkObjectClicked(int x, int y, boolean isShiftDown) {
        int modelCount = this.viewer.getModelCount();
        int dmin2 = 25;
        int nearestModel = 0;
        int nearestVertex = 0;
        Mesh pickedMesh = null;
        int i = this.meshCount;
        while (--i >= 0) {
            int mCount;
            Mesh m = this.meshes[i];
            if (m.drawVertexCount != 2 || m.visibilityFlags == 0) continue;
            int iModel = mCount = m.modelFlags == null ? 1 : modelCount;
            while (--iModel >= 0) {
                if (m.modelFlags != null && m.modelFlags[iModel] == 0) continue;
                int iVertex = m.polygonIndexes[iModel].length;
                while (--iVertex >= 0) {
                    int d2 = this.coordinateInRange(x, y, m.vertices[m.polygonIndexes[iModel][iVertex]], dmin2);
                    if (d2 < 0) continue;
                    pickedMesh = m;
                    dmin2 = d2;
                    nearestModel = iModel;
                    nearestVertex = iVertex;
                }
            }
        }
        if (pickedMesh != null) {
            if (nearestVertex == 0) {
                this.viewer.startSpinningAxis(pickedMesh.vertices[pickedMesh.polygonIndexes[nearestModel][0]], pickedMesh.vertices[pickedMesh.polygonIndexes[nearestModel][1]], isShiftDown);
            } else {
                this.viewer.startSpinningAxis(pickedMesh.vertices[pickedMesh.polygonIndexes[nearestModel][1]], pickedMesh.vertices[pickedMesh.polygonIndexes[nearestModel][0]], isShiftDown);
            }
            return;
        }
    }

    int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        int d2 = dmin2;
        Point3i ptXY = this.viewer.transformPoint(vertex);
        d2 = (x - ptXY.x) * (x - ptXY.x) + (y - ptXY.y) * (y - ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }
}

