/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Dots;
import org.jmol.viewer.ShapeRenderer;

class DotsRenderer
extends ShapeRenderer {
    boolean perspectiveDepth;
    int scalePixelsPerAngstrom;
    boolean bondSelectionModeOr;
    Geodesic geodesic;
    Geodesic geodesicSolvent;
    Geodesic g1;
    Geodesic g2;
    static final int[] mapNull = Dots.mapNull;
    final Point3f[] vertexTest = new Point3f[12];
    final Vector3f[] vectorTest = new Vector3f[12];
    int[] mapAtoms = null;
    Point3i facePt1 = new Point3i();
    Point3i facePt2 = new Point3i();
    Point3i facePt3 = new Point3i();
    static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    static final float oneFifth = 1.2566371f;
    static final float oneTenth = 0.62831855f;
    static final int[] power4 = new int[]{1, 4, 16, 64, 256};
    static final short[] faceIndicesInitial = new short[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 7, 3, 3, 8, 4, 4, 9, 5, 5, 10, 1, 6, 1, 10, 7, 2, 6, 8, 3, 7, 9, 4, 8, 10, 5, 9, 11, 6, 10, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9};

    DotsRenderer() {
    }

    void initRenderer() {
        int i;
        this.geodesic = new Geodesic();
        this.geodesic.quadruple();
        this.geodesic.quadruple();
        this.geodesic.quadruple();
        this.geodesicSolvent = new Geodesic();
        this.geodesicSolvent.quadruple();
        this.geodesicSolvent.quadruple();
        this.geodesicSolvent.quadruple();
        this.g1 = new Geodesic();
        this.g1.quadruple();
        this.g2 = new Geodesic();
        this.g2.quadruple();
        this.g2.quadruple();
        for (i = 0; i < 12; ++i) {
            this.vertexTest[i] = new Point3f();
        }
        for (i = 0; i < 12; ++i) {
            this.vectorTest[i] = new Vector3f();
        }
    }

    void render() {
        this.perspectiveDepth = this.viewer.getPerspectiveDepth();
        this.scalePixelsPerAngstrom = (int)this.viewer.getScalePixelsPerAngstrom();
        this.bondSelectionModeOr = this.viewer.getBondSelectionModeOr();
        this.geodesic.transform();
        Dots dots = (Dots)this.shape;
        if (dots == null) {
            return;
        }
        dots.timeBeginExecution = System.currentTimeMillis();
        Atom[] atoms = this.frame.atoms;
        int[][] dotsConvexMaps = dots.dotsConvexMaps;
        short[] colixesConvex = dots.colixesConvex;
        int myVisibilityFlag = dots.myVisibilityFlag;
        boolean isInMotion = this.viewer.getInMotion() && dots.dotsConvexMax > 100;
        boolean iShowSolid = dots.showSurface;
        int i = dots.dotsConvexMax;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(myVisibilityFlag)) continue;
            this.renderConvex(dots, atom, colixesConvex[i], dotsConvexMaps[i], iShowSolid, isInMotion);
        }
        dots.timeEndExecution = System.currentTimeMillis();
    }

    void renderConvex(Dots dots, Atom atom, short colix, int[] visibilityMap, boolean iShowSolid, boolean isInMotion) {
        colix = Graphics3D.inheritColix(colix, atom.colixAtom);
        if (this.mapAtoms == null) {
            this.mapAtoms = new int[this.geodesic.vertices.length];
        }
        this.geodesic.calcScreenPoints(visibilityMap, dots.getAppropriateRadius(atom), atom.getScreenX(), atom.getScreenY(), atom.getScreenZ(), this.mapAtoms);
        if (this.geodesic.screenCoordinateCount == 0) {
            return;
        }
        if (iShowSolid && !isInMotion) {
            colix = dots.surfaceColix;
            this.renderGeodesicFragment(colix, this.geodesic, visibilityMap, this.mapAtoms, this.geodesic.screenDotCount);
        } else {
            this.g3d.plotPoints(colix, this.geodesic.screenCoordinateCount, this.geodesic.screenCoordinates);
        }
    }

    void renderGeodesicFragment(short colix, Geodesic g, int[] points, int[] map, int dotCount) {
        short[] faces = g.screenLevel == 1 ? this.g1.faceIndices : (g.screenLevel == 2 ? this.g2.faceIndices : g.faceIndices);
        int[] coords = g.screenCoordinates;
        int mapMax = points.length << 5;
        if (dotCount < mapMax) {
            mapMax = dotCount;
        }
        int f = 0;
        while (f < faces.length) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            if (p1 >= mapMax || p2 >= mapMax || p3 >= mapMax || !Dots.getBit(points, p1) || !Dots.getBit(points, p2) || !Dots.getBit(points, p3)) continue;
            this.facePt1.set(coords[map[p1]], coords[map[p1] + 1], coords[map[p1] + 2]);
            this.facePt2.set(coords[map[p2]], coords[map[p2] + 1], coords[map[p2] + 2]);
            this.facePt3.set(coords[map[p3]], coords[map[p3] + 1], coords[map[p3] + 2]);
            this.g3d.fillTriangle(colix, this.facePt1, this.facePt2, this.facePt3);
        }
    }

    static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    class Geodesic {
        Vector3f[] vertices = new Vector3f[12];
        Vector3f[] verticesTransformed;
        int screenCoordinateCount;
        int[] screenCoordinates;
        short[] faceIndices;
        int level = 0;
        float scaledRadius;
        int screenLevel;
        int screenDotCount;
        int screenCenterX;
        int screenCenterY;
        int screenCenterZ;
        short iVertexNew;
        Hashtable htVertex;

        Geodesic() {
            int i;
            this.vertices[0] = new Vector3f(0.0f, 0.0f, halfRoot5);
            for (i = 0; i < 5; ++i) {
                this.vertices[i + 1] = new Vector3f((float)Math.cos((float)i * 1.2566371f), (float)Math.sin((float)i * 1.2566371f), 0.5f);
                this.vertices[i + 6] = new Vector3f((float)Math.cos((float)i * 1.2566371f + 0.62831855f), (float)Math.sin((float)i * 1.2566371f + 0.62831855f), -0.5f);
            }
            this.vertices[11] = new Vector3f(0.0f, 0.0f, -halfRoot5);
            i = 12;
            while (--i >= 0) {
                this.vertices[i].normalize();
            }
            this.faceIndices = faceIndicesInitial;
            this.verticesTransformed = new Vector3f[12];
            i = 12;
            while (--i >= 0) {
                this.verticesTransformed[i] = new Vector3f();
            }
            this.screenCoordinates = new int[36];
        }

        void transform() {
            int i = this.vertices.length;
            while (--i >= 0) {
                Vector3f t = this.verticesTransformed[i];
                DotsRenderer.this.viewer.transformVector(this.vertices[i], t);
            }
        }

        void calcScreenPoints(int[] visibilityMap, float radius, int x, int y, int z, int[] coordMap) {
            int dotCount = 12;
            this.screenLevel = 3;
            if (DotsRenderer.this.scalePixelsPerAngstrom > 5) {
                dotCount = 42;
                this.screenLevel = 1;
                if (DotsRenderer.this.scalePixelsPerAngstrom > 10) {
                    dotCount = 162;
                    this.screenLevel = 2;
                    if (DotsRenderer.this.scalePixelsPerAngstrom > 20) {
                        dotCount = 642;
                        this.screenLevel = 3;
                    }
                }
            }
            this.screenDotCount = dotCount;
            this.screenCenterX = x;
            this.screenCenterY = y;
            this.screenCenterZ = z;
            this.scaledRadius = DotsRenderer.this.viewer.scaleToPerspective(z, radius);
            int icoordinates = 0;
            int iDot = visibilityMap.length << 5;
            this.screenCoordinateCount = 0;
            if (iDot > dotCount) {
                iDot = dotCount;
            }
            while (--iDot >= 0) {
                if (!DotsRenderer.getBit(visibilityMap, iDot)) continue;
                Vector3f vertex = this.verticesTransformed[iDot];
                if (coordMap != null) {
                    coordMap[iDot] = icoordinates;
                }
                this.screenCoordinates[icoordinates++] = x + (int)((double)(this.scaledRadius * vertex.x) + (vertex.x < 0.0f ? -0.5 : 0.5));
                this.screenCoordinates[icoordinates++] = y + (int)((double)(this.scaledRadius * vertex.y) + (vertex.y < 0.0f ? -0.5 : 0.5));
                this.screenCoordinates[icoordinates++] = z + (int)((double)(this.scaledRadius * vertex.z) + (vertex.z < 0.0f ? -0.5 : 0.5));
                ++this.screenCoordinateCount;
            }
        }

        void calcScreenPoint(short iDot, Point3i pt) {
            Vector3f vertex = this.verticesTransformed[iDot];
            pt.x = this.screenCenterX + (int)((double)(this.scaledRadius * vertex.x) + (vertex.x < 0.0f ? -0.5 : 0.5));
            pt.y = this.screenCenterY + (int)((double)(this.scaledRadius * vertex.y) + (vertex.y < 0.0f ? -0.5 : 0.5));
            pt.z = this.screenCenterZ + (int)((double)(this.scaledRadius * vertex.z) + (vertex.z < 0.0f ? -0.5 : 0.5));
        }

        void quadruple() {
            ++this.level;
            this.htVertex = new Hashtable();
            int nVerticesOld = this.vertices.length;
            short[] faceIndicesOld = this.faceIndices;
            int nFaceIndicesOld = faceIndicesOld.length;
            int nEdgesOld = nVerticesOld + nFaceIndicesOld / 3 - 2;
            int nVerticesNew = nVerticesOld + nEdgesOld;
            Vector3f[] verticesNew = new Vector3f[nVerticesNew];
            System.arraycopy(this.vertices, 0, verticesNew, 0, nVerticesOld);
            this.vertices = verticesNew;
            this.verticesTransformed = new Vector3f[nVerticesNew];
            int i = nVerticesNew;
            while (--i >= 0) {
                this.verticesTransformed[i] = new Vector3f();
            }
            this.screenCoordinates = new int[3 * nVerticesNew];
            short[] faceIndicesNew = new short[4 * nFaceIndicesOld];
            this.faceIndices = faceIndicesNew;
            this.iVertexNew = (short)nVerticesOld;
            int iFaceNew = 0;
            int i2 = 0;
            while (i2 < nFaceIndicesOld) {
                short iA = faceIndicesOld[i2++];
                short iB = faceIndicesOld[i2++];
                short iC = faceIndicesOld[i2++];
                short iAB = this.getVertex(iA, iB);
                short iBC = this.getVertex(iB, iC);
                short iCA = this.getVertex(iC, iA);
                faceIndicesNew[iFaceNew++] = iA;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iB;
                faceIndicesNew[iFaceNew++] = iBC;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iC;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iBC;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iBC;
            }
            if (iFaceNew != faceIndicesNew.length) {
                Logger.debug("que?");
                throw new NullPointerException();
            }
            if (this.iVertexNew != nVerticesNew) {
                Logger.debug("huh?  iVertexNew=" + this.iVertexNew + "nVerticesNew=" + nVerticesNew);
                throw new NullPointerException();
            }
            this.htVertex = null;
        }

        private short getVertex(short i1, short i2) {
            Integer hashKey;
            Short iv;
            if (i1 > i2) {
                short t = i1;
                i1 = i2;
                i2 = t;
            }
            if ((iv = (Short)this.htVertex.get(hashKey = new Integer((i1 << 16) + i2))) != null) {
                return iv;
            }
            Vector3f vertexNew = new Vector3f(this.vertices[i1]);
            vertexNew.add(this.vertices[i2]);
            vertexNew.scale(0.5f);
            vertexNew.normalize();
            this.htVertex.put(hashKey, new Short(this.iVertexNew));
            this.vertices[this.iVertexNew] = vertexNew;
            short s = this.iVertexNew;
            this.iVertexNew = (short)(s + 1);
            return s;
        }

        String showMap(int[] map) {
            String s = "showMap";
            int n = 0;
            int iDot = map.length << 5;
            while (--iDot >= 0) {
                if (!DotsRenderer.getBit(map, iDot)) continue;
                s = s + " " + iDot;
            }
            s = n + " points:" + s;
            return s;
        }
    }
}

