/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.DotsRenderer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Util;

class Dots
extends Shape {
    DotsRenderer dotsRenderer;
    short mad = 0;
    short lastMad = 0;
    float lastSolventRadius = 0.0f;
    float maxRadius = 0.0f;
    float scale = 1.0f;
    float setRadius = Float.MAX_VALUE;
    float addRadius = Float.MAX_VALUE;
    short surfaceColix = (short)12;
    int dotsConvexMax;
    int[][] dotsConvexMaps;
    final int nArcPoints = 9;
    short[] colixesConvex;
    Vector3f[] geodesicVertices;
    int geodesicCount;
    int[] geodesicMap;
    Vector3f[] geodesicSolventVertices;
    int geodesicSolventCount;
    int[] geodesicSolventMap;
    int[] mapT;
    static final int[] mapNull = new int[0];
    boolean useVanderwaalsRadius;
    int indexI;
    int indexJ;
    int indexK;
    Atom atomI;
    Atom atomJ;
    Atom atomK;
    Point3f centerI;
    Point3f centerJ;
    Point3f centerK;
    float radiusI;
    float radiusJ;
    float radiusK;
    float radiusP;
    float diameterP;
    float radiiIP2;
    float radiiJP2;
    float radiiKP2;
    float distanceIJ2;
    final Point3f pointT = new Point3f();
    boolean TIMINGS = true;
    long timeBeginExecution;
    long timeEndExecution;
    boolean showSurface;
    Point3f centerT;
    int neighborCount;
    Atom[] neighbors = new Atom[16];
    int[] neighborIndices = new int[16];
    Point3f[] neighborCenters = new Point3f[16];
    float[] neighborPlusProbeRadii2 = new float[16];
    float[] neighborRadii2 = new float[16];

    Dots() {
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    void initShape() {
        Logger.debug("init dots");
        this.dotsRenderer = (DotsRenderer)this.frame.getRenderer(7);
        this.geodesicVertices = this.dotsRenderer.geodesic.vertices;
        this.geodesicCount = this.geodesicVertices.length;
        this.geodesicMap = Dots.allocateBitmap(this.geodesicCount);
        this.geodesicSolventVertices = this.dotsRenderer.geodesicSolvent.vertices;
        this.geodesicSolventCount = this.geodesicSolventVertices.length;
        this.geodesicSolventMap = Dots.allocateBitmap(this.geodesicSolventCount);
        this.mapT = Dots.allocateBitmap(this.geodesicSolventCount);
    }

    void setSize(int size, BitSet bsSelected) {
        int atomCount;
        Logger.debug("Dots.setSize " + size);
        short mad = (short)size;
        boolean isVisible = true;
        this.showSurface = false;
        if (mad == -2) {
            this.showSurface = true;
        } else if (mad < 0) {
            this.useVanderwaalsRadius = false;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        } else if (mad == 0) {
            isVisible = false;
        } else if (mad == 1) {
            this.useVanderwaalsRadius = true;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        } else if (mad <= 1001) {
            this.useVanderwaalsRadius = true;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = (float)(mad - 1) / 100.0f;
        } else if (mad <= 11002) {
            this.useVanderwaalsRadius = false;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = (float)(mad - 1002) / 1000.0f;
            this.scale = 1.0f;
        } else if (mad <= 13002) {
            this.useVanderwaalsRadius = true;
            this.addRadius = (float)(mad - 11002) / 1000.0f;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        }
        this.maxRadius = this.frame.getMaxVanderwaalsRadius();
        float solventRadius = this.viewer.getCurrentSolventProbeRadius();
        if (this.addRadius == Float.MAX_VALUE) {
            float f = this.addRadius = solventRadius != 0.0f ? solventRadius : 0.0f;
        }
        if (this.showSurface) {
            return;
        }
        this.mad = mad;
        this.timeBeginExecution = System.currentTimeMillis();
        int i = atomCount = this.frame.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            this.frame.atoms[i].setShapeVisibility(this.myVisibilityFlag, isVisible);
        }
        if (this.lastSolventRadius != this.addRadius || mad != this.lastMad) {
            this.dotsConvexMax = 0;
            this.dotsConvexMaps = null;
            this.radiusP = 0.0f;
            this.diameterP = 2.0f * this.radiusP;
            this.lastSolventRadius = this.addRadius;
        }
        if (this.dotsConvexMaps != null) {
            i = atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.dotsConvexMaps[i] = null;
            }
        }
        if (isVisible) {
            this.lastMad = mad;
            if (this.dotsConvexMaps == null) {
                this.dotsConvexMaps = new int[atomCount][];
                this.colixesConvex = new short[atomCount];
            }
            i = atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setAtomI(i);
                this.getNeighbors(bsSelected);
                this.calcConvexMap();
            }
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            i = atomCount;
            while (--i >= 0 && this.dotsConvexMaps[i] == null) {
            }
            this.dotsConvexMax = i + 1;
        }
        this.timeEndExecution = System.currentTimeMillis();
        Logger.debug("dots generation time = " + this.getExecutionWalltime());
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("Dots.setProperty: " + propertyName + " " + value + " " + bs);
        if ("color" == propertyName) {
            this.surfaceColix = Graphics3D.getColix(value);
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            this.surfaceColix = Graphics3D.setTranslucent(this.surfaceColix, isTranslucent);
            return;
        }
    }

    float getAppropriateRadius(Atom atom) {
        float v = this.addRadius + (this.setRadius != Float.MAX_VALUE ? this.setRadius : (this.useVanderwaalsRadius ? atom.getVanderwaalsRadiusFloat() : atom.getBondingRadiusFloat()) * this.scale);
        return v;
    }

    void setAtomI(int indexI) {
        this.indexI = indexI;
        this.atomI = this.frame.atoms[indexI];
        this.centerI = this.atomI.point3f;
        this.radiusI = this.getAppropriateRadius(this.atomI);
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    void setNeighborJ(int indexNeighbor) {
        this.indexJ = this.neighborIndices[indexNeighbor];
        this.atomJ = this.neighbors[indexNeighbor];
        this.radiusJ = this.getAppropriateRadius(this.atomJ);
        this.radiiJP2 = this.neighborPlusProbeRadii2[indexNeighbor];
        this.centerJ = this.neighborCenters[indexNeighbor];
        this.distanceIJ2 = this.centerI.distanceSquared(this.centerJ);
    }

    void setNeighborK(int indexNeighbor) {
        this.indexK = this.neighborIndices[indexNeighbor];
        this.centerK = this.neighborCenters[indexNeighbor];
        this.atomK = this.neighbors[indexNeighbor];
        this.radiusK = this.getAppropriateRadius(this.atomK);
        this.radiiKP2 = this.neighborPlusProbeRadii2[indexNeighbor];
    }

    void calcConvexMap() {
        this.calcConvexBits();
        int[] map = mapNull;
        int count = this.getMapStorageCount(this.geodesicMap);
        if (count > 0) {
            this.addIncompleteFaces(this.geodesicMap, this.dotsRenderer.geodesic);
            this.addIncompleteFaces(this.geodesicMap, this.dotsRenderer.geodesic);
            count = this.getMapStorageCount(this.geodesicMap);
            map = new int[count];
            System.arraycopy(this.geodesicMap, 0, map, 0, count);
        }
        this.dotsConvexMaps[this.indexI] = map;
    }

    int getMapStorageCount(int[] map) {
        int indexLast = map.length;
        while (--indexLast >= 0 && map[indexLast] == 0) {
        }
        return indexLast + 1;
    }

    void addIncompleteFaces(int[] points, DotsRenderer.Geodesic g) {
        Dots.clearBitmap(this.mapT);
        short[] faces = g.faceIndices;
        int len = faces.length;
        short maxPt = -1;
        int f = 0;
        while (f < len) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            boolean ok1 = Dots.getBit(points, p1);
            boolean ok2 = Dots.getBit(points, p2);
            boolean ok3 = Dots.getBit(points, p3);
            if (!ok1 && !ok2 && !ok3 || ok1 && ok2 && ok3) continue;
            if (!ok1) {
                Dots.setBit(this.mapT, p1);
                if (maxPt < p1) {
                    maxPt = p1;
                }
            }
            if (!ok2) {
                Dots.setBit(this.mapT, p2);
                if (maxPt < p2) {
                    maxPt = p2;
                }
            }
            if (ok3) continue;
            Dots.setBit(this.mapT, p3);
            if (maxPt >= p3) continue;
            maxPt = p3;
        }
        for (short i = 0; i <= maxPt; ++i) {
            if (!Dots.getBit(this.mapT, i)) continue;
            Dots.setBit(points, i);
        }
    }

    void calcConvexBits() {
        Dots.setAllBits(this.geodesicMap, this.geodesicCount);
        if (this.neighborCount == 0) {
            return;
        }
        float combinedRadii = this.radiusI + this.radiusP;
        short[] faces = this.dotsRenderer.geodesic.faceIndices;
        int p4 = DotsRenderer.power4[this.dotsRenderer.geodesic.level - 1];
        Dots.clearBitmap(this.mapT);
        Point3f[] vertexTest = this.dotsRenderer.vertexTest;
        for (int i = 0; i < 12; ++i) {
            vertexTest[i].set(this.geodesicVertices[i]);
            vertexTest[i].scaleAdd(combinedRadii, this.centerI);
        }
        for (int f = 0; f < 20; ++f) {
            int faceTest = 0;
            short p1 = faces[3 * p4 * (4 * f + 0)];
            short p2 = faces[3 * p4 * (4 * f + 1)];
            short p3 = faces[3 * p4 * (4 * f + 2)];
            for (int j = 0; j < this.neighborCount; ++j) {
                boolean ok3;
                float maxDist = this.neighborPlusProbeRadii2[j];
                this.centerT = this.neighborCenters[j];
                boolean ok1 = vertexTest[p1].distanceSquared(this.centerT) >= maxDist;
                boolean ok2 = vertexTest[p2].distanceSquared(this.centerT) >= maxDist;
                boolean bl = ok3 = vertexTest[p3].distanceSquared(this.centerT) >= maxDist;
                if (!ok1) {
                    Dots.clearBit(this.geodesicMap, p1);
                }
                if (!ok2) {
                    Dots.clearBit(this.geodesicMap, p2);
                }
                if (!ok3) {
                    Dots.clearBit(this.geodesicMap, p3);
                }
                if (ok1 || ok2 || ok3) continue;
                faceTest = -1;
                break;
            }
            int kFirst = f * 12 * p4;
            int kLast = kFirst + 12 * p4;
            for (int k = kFirst; k < kLast; ++k) {
                short vect = faces[k];
                if (Dots.getBit(this.mapT, vect) || !Dots.getBit(this.geodesicMap, vect)) continue;
                switch (faceTest) {
                    case -1: {
                        Dots.clearBit(this.geodesicMap, vect);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float maxDist = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.set(this.geodesicVertices[vect]);
                            this.pointT.scaleAdd(combinedRadii, this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < maxDist)) continue;
                            Dots.clearBit(this.geodesicMap, vect);
                        }
                        break;
                    }
                }
                Dots.setBit(this.mapT, vect);
            }
        }
    }

    void getNeighbors(BitSet bsSelected) {
        AtomIterator iter = this.frame.getWithinModelIterator(this.atomI, this.radiusI + this.diameterP + this.maxRadius);
        this.neighborCount = 0;
        while (iter.hasNext()) {
            Atom neighbor = iter.next();
            if (neighbor == this.atomI || !bsSelected.get(neighbor.atomIndex)) continue;
            float neighborRadius = this.getAppropriateRadius(neighbor);
            if (this.centerI.distance(neighbor.point3f) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighbors.length) {
                this.neighbors = (Atom[])Util.doubleLength(this.neighbors);
                this.neighborIndices = Util.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])Util.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = Util.doubleLength(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = Util.doubleLength(this.neighborRadii2);
            }
            this.neighbors[this.neighborCount] = neighbor;
            this.neighborCenters[this.neighborCount] = neighbor.point3f;
            this.neighborIndices[this.neighborCount] = neighbor.atomIndex;
            float neighborPlusProbeRadii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = neighborPlusProbeRadii * neighborPlusProbeRadii;
            this.neighborRadii2[this.neighborCount] = neighborRadius * neighborRadius;
            ++this.neighborCount;
        }
    }

    static final int[] allocateBitmap(int count) {
        return new int[count + 31 >> 5];
    }

    static final void setBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] | 1 << (~i & 0x1F);
    }

    static final void clearBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] & ~(1 << (~i & 0x1F));
    }

    static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    static final void setAllBits(int[] bitmap, int count) {
        int i = count >> 5;
        if ((count & 0x1F) != 0) {
            bitmap[i] = Integer.MIN_VALUE >> count - 1;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
    }

    static final void clearBitmap(int[] bitmap) {
        int i = bitmap.length;
        while (--i >= 0) {
            bitmap[i] = 0;
        }
    }

    void setModelClickability() {
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = this.frame.atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

