/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.Dipole;
import org.jmol.viewer.SelectionIndependentShape;
import org.jmol.viewer.Util;

class Dipoles
extends SelectionIndependentShape {
    static final short DEFAULT_MAD = 5;
    static final float DEFAULT_OFFSETSIDE = 0.4f;
    float dipoleVectorScale = 1.0f;
    int dipoleCount = 0;
    Dipole[] dipoles = new Dipole[4];
    Dipole currentDipole;
    Dipole tempDipole;
    Point3f startCoord = new Point3f();
    Point3f endCoord = new Point3f();
    float dipoleValue;
    boolean isBond;
    boolean iHaveTwoEnds;
    int atomIndex1;

    Dipoles() {
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("dipoles setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.tempDipole = new Dipole();
            this.tempDipole.dipoleValue = 1.0f;
            this.tempDipole.mad = (short)5;
            this.atomIndex1 = -1;
            this.tempDipole.modelIndex = -1;
            this.dipoleValue = 0.0f;
            this.isBond = false;
            this.iHaveTwoEnds = false;
            if (this.currentDipole != null) {
                Logger.debug("current dipole: " + this.currentDipole.thisID);
            }
            return;
        }
        if ("thisID" == propertyName) {
            if (value == null) {
                this.currentDipole = null;
                return;
            }
            String thisID = "" + (String)value;
            this.currentDipole = this.findDipole(thisID);
            if (this.currentDipole == null) {
                this.currentDipole = this.allocDipole(thisID, "");
            }
            Logger.debug("current dipole now " + this.currentDipole.thisID);
            this.tempDipole = this.currentDipole;
            if (thisID.equals("molecular")) {
                Vector3f v = this.viewer.getModelDipole();
                Logger.info("file molecular dipole = " + v);
                if (v == null) {
                    Logger.warn("No molecular dipole found in file; setting to {0 0 0}");
                    v = new Vector3f();
                }
                this.tempDipole.set(new Point3f(0.0f, 0.0f, 0.0f), new Vector3f(-v.x, -v.y, -v.z));
                this.tempDipole.type = (short)4;
                this.tempDipole.thisID = "molecular";
                this.setDipole();
            }
            return;
        }
        if ("dipoleVectorScale" == propertyName) {
            this.dipoleVectorScale = ((Float)value).floatValue();
            return;
        }
        if ("bonds" == propertyName) {
            this.isBond = true;
            this.currentDipole = null;
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isBondDipole(i)) continue;
                return;
            }
            this.viewer.getBondDipoles();
            return;
        }
        if ("on" == propertyName) {
            if (this.currentDipole != null) {
                this.currentDipole.visible = true;
            } else {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].visible = true;
                }
            }
            return;
        }
        if ("off" == propertyName) {
            if (this.currentDipole != null) {
                this.currentDipole.visible = false;
            } else {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].visible = false;
                }
            }
            return;
        }
        if ("delete" == propertyName) {
            if (this.currentDipole != null) {
                this.deleteDipole(this.currentDipole);
            } else {
                this.clear(false);
            }
            return;
        }
        if ("clear" == propertyName) {
            this.currentDipole = null;
            this.clear(false);
        }
        if ("dipoleWidth" == propertyName) {
            short mad = this.tempDipole.mad = (short)(((Float)value).floatValue() * 1000.0f);
            if (this.currentDipole == null) {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    this.dipoles[i].mad = mad;
                }
            }
            return;
        }
        if ("dipoleOffset" == propertyName) {
            this.tempDipole.offsetAngstroms = ((Float)value).floatValue();
            if (this.currentDipole == null) {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].offsetAngstroms = this.tempDipole.offsetAngstroms;
                }
            }
            return;
        }
        if ("dipoleOffsetPercent" == propertyName) {
            this.tempDipole.offsetPercent = (Integer)value;
            if (this.tempDipole.dipoleValue != 0.0f) {
                this.tempDipole.offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            if (this.currentDipole == null) {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.dipoles[i].dipoleValue;
                }
            }
            return;
        }
        if ("offsetSide" == propertyName) {
            float offsetSide = ((Float)value).floatValue();
            if (this.currentDipole != null) {
                this.currentDipole.offsetSide = offsetSide;
            } else {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].offsetSide = offsetSide;
                }
            }
            return;
        }
        if ("cross" == propertyName) {
            boolean isOFF;
            boolean bl = isOFF = (Boolean)value == false;
            if (this.currentDipole != null) {
                this.currentDipole.noCross = isOFF;
            } else {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].noCross = isOFF;
                }
            }
            return;
        }
        if ("color" == propertyName) {
            this.colix = Graphics3D.getColix(value);
            if (this.isBond) {
                this.setColixDipole(this.colix, this.colix != 3 ? null : (String)value, (short)3, bs);
            } else if (value != null) {
                if (this.currentDipole != null) {
                    this.currentDipole.colix = this.colix;
                } else {
                    int i = this.dipoleCount;
                    while (--i >= 0) {
                        this.dipoles[i].colix = this.colix;
                    }
                }
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent;
            boolean bl = isTranslucent = "translucent" == value;
            if (this.currentDipole != null) {
                this.currentDipole.setTranslucent(isTranslucent);
            } else {
                int i = this.dipoleCount;
                while (--i >= 0) {
                    if (this.isBond && !this.isBondDipole(i)) continue;
                    this.dipoles[i].setTranslucent(isTranslucent);
                }
            }
            return;
        }
        if ("startSet" == propertyName) {
            BitSet atomset = (BitSet)value;
            this.startCoord = this.viewer.getAtomSetCenter(atomset);
            this.tempDipole.set(this.startCoord, new Point3f(0.0f, 0.0f, 0.0f), this.dipoleValue);
            if (this.viewer.cardinalityOf(atomset) == 1) {
                this.atomIndex1 = this.viewer.firstAtomOf(atomset);
            }
            return;
        }
        if ("endSet" == propertyName) {
            this.iHaveTwoEnds = true;
            BitSet atomset = (BitSet)value;
            if (this.atomIndex1 >= 0 && this.viewer.cardinalityOf(atomset) == 1) {
                this.tempDipole.set(this.frame.atoms[this.atomIndex1], this.frame.atoms[this.viewer.firstAtomOf(atomset)], 1.0f);
                this.currentDipole = this.findDipole(this.tempDipole.thisID, this.tempDipole.dipoleInfo);
                this.tempDipole.thisID = this.currentDipole.thisID;
                if (this.isSameAtoms(this.currentDipole, this.tempDipole.dipoleInfo)) {
                    this.tempDipole = this.currentDipole;
                    if (this.dipoleValue > 0.0f) {
                        this.tempDipole.dipoleValue = this.dipoleValue;
                    }
                }
            } else {
                this.tempDipole.set(this.startCoord, this.viewer.getAtomSetCenter(atomset), this.dipoleValue);
            }
            return;
        }
        if ("startCoord" == propertyName) {
            this.startCoord.set((Point3f)value);
            this.tempDipole.set(this.startCoord, new Point3f(0.0f, 0.0f, 0.0f), this.dipoleValue);
            return;
        }
        if ("endCoord" == propertyName) {
            this.iHaveTwoEnds = true;
            this.endCoord.set((Point3f)value);
            this.tempDipole.set(this.startCoord, this.endCoord, this.dipoleValue);
            this.dumpDipoles("endCoord");
            return;
        }
        if ("dipoleValue" == propertyName) {
            this.dipoleValue = ((Float)value).floatValue();
            this.tempDipole.set(this.dipoleValue);
            if (this.tempDipole.offsetPercent != 0) {
                this.tempDipole.offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            return;
        }
        if ("set" == propertyName) {
            if (this.isBond || !this.iHaveTwoEnds) {
                return;
            }
            this.setDipole();
            this.setModelIndex();
            return;
        }
    }

    private boolean isBondDipole(int i) {
        if (i >= this.dipoles.length || this.dipoles[i] == null) {
            return false;
        }
        return this.dipoles[i].isBondType();
    }

    private void setColixDipole(short colix, String palette, short bondTypeMask, BitSet bs) {
        if (colix != 3) {
            BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
            while (iter.hasNext()) {
                Dipole d = this.findBondDipole(iter.next());
                if (d == null) continue;
                d.colix = colix;
            }
        } else {
            Logger.debug("setColixDipole called with palette:" + palette);
        }
    }

    private void setDipole() {
        if (this.currentDipole == null) {
            this.currentDipole = this.allocDipole("", "");
        }
        this.currentDipole.set(this.tempDipole.thisID, this.tempDipole.dipoleInfo, this.tempDipole.atoms, this.tempDipole.dipoleValue, this.tempDipole.mad, this.tempDipole.offsetAngstroms, this.tempDipole.offsetSide, this.tempDipole.origin, this.tempDipole.vector);
    }

    private int getDipoleIndex(String dipoleInfo, String thisID) {
        if (dipoleInfo != null && dipoleInfo.length() > 0) {
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isSameAtoms(this.dipoles[i], dipoleInfo)) continue;
                return i;
            }
        }
        return this.getIndexFromName(thisID);
    }

    private boolean isSameAtoms(Dipole dipole, String dipoleInfo) {
        return dipole != null && dipole.isBondType() && (dipole.dipoleInfo + dipole.dipoleInfo).indexOf(dipoleInfo) >= 0;
    }

    private int getDipoleIndex(int atomIndex1, int atomIndex2) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.dipoles[i] == null || this.dipoles[i].atoms[0] == null || this.dipoles[i].atoms[1] == null || (this.dipoles[i].atoms[0].atomIndex != atomIndex1 || this.dipoles[i].atoms[1].atomIndex != atomIndex2) && (this.dipoles[i].atoms[1].atomIndex != atomIndex1 || this.dipoles[i].atoms[0].atomIndex != atomIndex2)) continue;
            return i;
        }
        return -1;
    }

    private void deleteDipole(Dipole dipole) {
        if (dipole == null) {
            return;
        }
        if (this.currentDipole == dipole) {
            this.currentDipole = null;
        }
        int i = this.dipoleCount;
        while (this.dipoles[--i] != dipole) {
        }
        if (i < 0) {
            return;
        }
        for (int j = i + 1; j < this.dipoleCount; ++j) {
            this.dipoles[j - 1] = this.dipoles[j];
        }
        this.dipoles[--this.dipoleCount] = null;
    }

    private Dipole findDipole(String thisID) {
        int dipoleIndex = this.getIndexFromName(thisID);
        if (dipoleIndex >= 0) {
            return this.dipoles[dipoleIndex];
        }
        return null;
    }

    Dipole findDipole(Atom atom1, Atom atom2, boolean doAllocate) {
        int dipoleIndex = this.getDipoleIndex(atom1.atomIndex, atom2.atomIndex);
        if (dipoleIndex >= 0) {
            return this.dipoles[dipoleIndex];
        }
        return doAllocate ? this.allocDipole("", "") : null;
    }

    private Dipole findBondDipole(Bond bond) {
        Dipole d = this.findDipole(bond.atom1, bond.atom2, false);
        return d == null || d.atoms[0] == null ? null : d;
    }

    private Dipole findDipole(String thisID, String dipoleInfo) {
        int dipoleIndex = this.getDipoleIndex(dipoleInfo, thisID);
        if (dipoleIndex >= 0) {
            if (thisID.length() > 0) {
                this.dipoles[dipoleIndex].thisID = thisID;
            }
            return this.dipoles[dipoleIndex];
        }
        return this.allocDipole(thisID, dipoleInfo);
    }

    private Dipole allocDipole(String thisID, String dipoleInfo) {
        this.dipoles = (Dipole[])Util.ensureLength(this.dipoles, this.dipoleCount + 1);
        if (thisID == null || thisID.length() == 0) {
            thisID = "dipole" + (this.dipoleCount + 1);
        }
        Dipole dipole = new Dipole(this.viewer, thisID, dipoleInfo, this.g3d, this.colix, 5, true);
        this.dipoles[this.dipoleCount++] = dipole;
        Dipole d = dipole;
        return d;
    }

    private void dumpDipoles(String msg) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = this.dipoles[i];
            Logger.info("\n\n" + msg + " dump dipole " + i + " " + dipole + " " + dipole.thisID + " " + dipole.dipoleInfo + " " + dipole.visibilityFlags + " mad=" + dipole.mad + " vis=" + dipole.visible + "\n orig" + dipole.origin + " " + " vect" + dipole.vector + " val=" + dipole.dipoleValue);
        }
        if (this.currentDipole != null) {
            Logger.info(" current = " + this.currentDipole + this.currentDipole.origin);
        }
        if (this.tempDipole != null) {
            Logger.info(" temp = " + this.tempDipole + " " + this.tempDipole.origin);
        }
    }

    void clear(boolean clearBondDipolesOnly) {
        if (clearBondDipolesOnly) {
            int i = this.dipoleCount;
            while (--i >= 0) {
                if (!this.isBondDipole(i)) continue;
                this.deleteDipole(this.dipoles[i]);
            }
            return;
        }
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.isBond && !this.isBondDipole(i)) continue;
            this.deleteDipole(this.dipoles[i]);
        }
    }

    int getIndexFromName(String thisID) {
        if (thisID == null) {
            return -1;
        }
        int i = this.dipoleCount;
        while (--i >= 0) {
            if (this.dipoles[i] == null || !thisID.equals(this.dipoles[i].thisID)) continue;
            return i;
        }
        return -1;
    }

    Vector getShapeDetail() {
        Vector V = new Vector();
        for (int i = 0; i < this.dipoleCount; ++i) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            Dipole dipole = this.dipoles[i];
            info.put("ID", dipole.thisID);
            info.put("vector", dipole.vector);
            info.put("origin", dipole.origin);
            if (dipole.atoms[0] != null) {
                Hashtable atomInfo = new Hashtable();
                this.viewer.getAtomIdentityInfo(dipole.atoms[0].atomIndex, atomInfo);
                Vector atoms = new Vector();
                atoms.add(atomInfo);
                atomInfo = new Hashtable();
                this.viewer.getAtomIdentityInfo(dipole.atoms[1].atomIndex, atomInfo);
                atoms.add(atomInfo);
                info.put("atoms", atoms);
                info.put("magnitude", new Float(dipole.vector.length()));
            }
            V.add(info);
        }
        return V;
    }

    void setModelIndex() {
        if (this.currentDipole == null) {
            return;
        }
        this.currentDipole.visible = true;
        this.currentDipole.modelIndex = this.viewer.getDisplayModelIndex();
    }

    void setVisibilityFlags(BitSet bs) {
        int i = this.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = this.dipoles[i];
            dipole.visibilityFlags = (dipole.modelIndex < 0 || bs.get(dipole.modelIndex)) && dipole.mad != 0 && dipole.visible && dipole.origin != null && dipole.vector != null && dipole.vector.length() != 0.0f && dipole.dipoleValue != 0.0f ? this.myVisibilityFlag : 0;
        }
        this.dumpDipoles("setVis");
    }
}

