/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import org.jmol.util.Logger;

class CompoundDocument {
    DataInputStream stream;
    CmpDocHeader header = new CmpDocHeader();
    Vector directory = new Vector();
    CmpDocDirectoryEntry rootEntry;
    int[] SAT;
    int[] SSAT;
    int sectorSize;
    int shortSectorSize;
    int nShortSectorsPerStandardSector;
    int nIntPerSector;
    int nDirEntriesperSector;
    boolean isRandom = false;
    boolean isBigEndian = true;

    CompoundDocument(String fileName, BufferedInputStream bis) {
        if (!this.isRandom) {
            this.stream = new DataInputStream(bis);
        }
        this.stream.mark(Integer.MAX_VALUE);
        if (!this.readHeader()) {
            return;
        }
        this.getSectorAllocationTable();
        this.getShortSectorAllocationTable();
        this.getDirectoryTable();
    }

    public Vector getDirectory() {
        return this.directory;
    }

    public String getDirectoryListing(String separator) {
        String str = "";
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry thisEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (thisEntry.isEmpty) continue;
            str = str + separator + thisEntry.entryName + "\tlen=" + thisEntry.lenStream + "\tSID=" + thisEntry.SIDfirstSector + (thisEntry.isStandard ? "\tfileOffset=" + this.getOffset(thisEntry.SIDfirstSector) : "");
        }
        return str;
    }

    public StringBuffer getAllData() {
        StringBuffer data = new StringBuffer();
        data.append("Compound Document File Directory: ");
        data.append(this.getDirectoryListing("|"));
        data.append("\n");
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry thisEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (thisEntry.isEmpty || thisEntry.entryType == 5) continue;
            data.append("BEGIN Compound Document Entry: " + thisEntry.entryName + "\n");
            data.append(this.getFileAsString(thisEntry));
            data.append("\n");
            data.append("END Compound Document Entry: " + thisEntry.entryName + "\n");
        }
        return data;
    }

    public StringBuffer getFileAsString(String entryName) {
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry thisEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (!thisEntry.entryName.equals(entryName)) continue;
            return this.getFileAsString(thisEntry);
        }
        return new StringBuffer();
    }

    private long getOffset(int SID) {
        return 512 + SID * this.sectorSize;
    }

    private void gotoSector(int SID) {
        this.seek(this.getOffset(SID));
    }

    private boolean readHeader() {
        if (!this.header.readData()) {
            return false;
        }
        this.sectorSize = 1 << this.header.sectorPower;
        this.shortSectorSize = 1 << this.header.shortSectorPower;
        this.nShortSectorsPerStandardSector = this.sectorSize / this.shortSectorSize;
        this.nIntPerSector = this.sectorSize / 4;
        this.nDirEntriesperSector = this.sectorSize / 128;
        Logger.debug("compound document: revNum=" + this.header.revNumber + " verNum=" + this.header.verNumber + " isBigEndian=" + this.isBigEndian + " bytes per standard/short sector=" + this.sectorSize + "/" + this.shortSectorSize);
        return true;
    }

    private void getSectorAllocationTable() {
        block9: {
            int nSID = 0;
            this.SAT = new int[this.header.nSATsectors * this.nIntPerSector + 109];
            try {
                int thisSID;
                for (int i = 0; i < 109 && (thisSID = this.header.MSAT0[i]) >= 0; ++i) {
                    this.gotoSector(thisSID);
                    for (int j = 0; j < this.nIntPerSector; ++j) {
                        this.SAT[nSID++] = this.readInt();
                    }
                }
                int nMaster = this.header.nAdditionalMATsectors;
                thisSID = this.header.SID_MSAT_next;
                int[] MSAT = new int[this.nIntPerSector];
                while (nMaster-- > 0 && thisSID >= 0) {
                    int i;
                    this.gotoSector(thisSID);
                    for (i = 0; i < this.nIntPerSector; ++i) {
                        MSAT[i] = this.readInt();
                    }
                    for (i = 0; i < this.nIntPerSector - 1; ++i) {
                        thisSID = MSAT[i];
                        if (thisSID >= 0) {
                            this.gotoSector(thisSID);
                            int j = this.nIntPerSector;
                            while (--j >= 0) {
                                this.SAT[nSID++] = this.readInt();
                            }
                            continue;
                        }
                        break block9;
                    }
                    thisSID = MSAT[this.nIntPerSector - 1];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void getShortSectorAllocationTable() {
        int nSSID = 0;
        int thisSID = this.header.SID_SSAT_start;
        this.SSAT = new int[this.header.nSATsectors * this.nIntPerSector];
        try {
            while (thisSID > 0) {
                this.gotoSector(thisSID);
                for (int j = 0; j < this.nIntPerSector; ++j) {
                    this.SSAT[nSSID++] = this.readInt();
                }
                thisSID = this.SAT[thisSID];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getDirectoryTable() {
        int thisSID = this.header.SID_DIR_start;
        this.rootEntry = null;
        try {
            while (thisSID > 0) {
                this.gotoSector(thisSID);
                int j = this.nDirEntriesperSector;
                while (--j >= 0) {
                    CmpDocDirectoryEntry thisEntry = new CmpDocDirectoryEntry();
                    thisEntry.readData();
                    if (thisEntry.lenStream > 0) {
                        this.directory.add(thisEntry);
                    }
                    if (thisEntry.entryType != 5) continue;
                    this.rootEntry = thisEntry;
                }
                thisSID = this.SAT[thisSID];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private StringBuffer getFileAsString(CmpDocDirectoryEntry thisEntry) {
        if (thisEntry.isEmpty) {
            return new StringBuffer();
        }
        return thisEntry.isStandard ? this.getStandardStringData(thisEntry.SIDfirstSector, thisEntry.lenStream) : this.getShortStringData(thisEntry.SIDfirstSector, thisEntry.lenStream);
    }

    private StringBuffer getStandardStringData(int thisSID, int nBytes) {
        StringBuffer data = new StringBuffer();
        byte[] byteBuf = new byte[this.sectorSize];
        try {
            while (thisSID > 0 && nBytes > 0) {
                this.gotoSector(thisSID);
                this.readByteArray(byteBuf);
                for (int i = 0; i < this.sectorSize; ++i) {
                    if (byteBuf[i] == 0) {
                        return new StringBuffer();
                    }
                    data.append((char)byteBuf[i]);
                    if (--nBytes == 0) break;
                }
                thisSID = this.SAT[thisSID];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private StringBuffer getShortStringData(int shortSID, int nBytes) {
        StringBuffer data = new StringBuffer();
        byte[] byteBuf = new byte[this.shortSectorSize];
        int ptShort = 0;
        if (this.rootEntry == null) {
            return data;
        }
        try {
            int thisSID = this.rootEntry.SIDfirstSector;
            while (thisSID >= 0 && shortSID >= 0 && nBytes > 0) {
                while (shortSID - ptShort >= this.nShortSectorsPerStandardSector) {
                    ptShort += this.nShortSectorsPerStandardSector;
                    thisSID = this.SAT[thisSID];
                }
                this.seek(this.getOffset(thisSID) + (long)((shortSID - ptShort) * this.shortSectorSize));
                this.readByteArray(byteBuf);
                for (int i = 0; i < this.shortSectorSize; ++i) {
                    if (byteBuf[i] == 0) {
                        return new StringBuffer();
                    }
                    data.append((char)byteBuf[i]);
                    if (--nBytes == 0) break;
                }
                shortSID = this.SSAT[shortSID];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    byte readByte() throws Exception {
        return this.stream.readByte();
    }

    void readByteArray(byte[] b) throws Exception {
        this.stream.read(b);
    }

    void readByteArray(byte[] b, int off, int len) throws Exception {
        this.stream.read(b, off, len);
    }

    short readShort() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readShort();
        }
        return (short)(this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8);
    }

    int readInt() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readInt();
        }
        return this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8 | (this.stream.readByte() & 0xFF) << 16 | (this.stream.readByte() & 0xFF) << 24;
    }

    long readLong() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readLong();
        }
        return (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 54;
    }

    private void seek(long offset) {
        try {
            this.stream.reset();
            this.stream.skipBytes((int)offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CmpDocDirectoryEntry {
        byte[] unicodeName = new byte[64];
        short nBytesUnicodeName;
        byte entryType;
        byte entryColor;
        int DIDchildLeft;
        int DIDchildRight;
        int DIDstorageRoot;
        byte[] uniqueID = new byte[16];
        byte[] userflags = new byte[4];
        long timeStamp1;
        long timeStamp2;
        int SIDfirstSector;
        int lenStream;
        byte[] unused = new byte[4];
        String entryName;
        boolean isStandard;
        boolean isEmpty;

        private CmpDocDirectoryEntry() {
        }

        final boolean readData() {
            try {
                CompoundDocument.this.readByteArray(this.unicodeName);
                this.nBytesUnicodeName = CompoundDocument.this.readShort();
                this.entryType = CompoundDocument.this.readByte();
                this.entryColor = CompoundDocument.this.readByte();
                this.DIDchildLeft = CompoundDocument.this.readInt();
                this.DIDchildRight = CompoundDocument.this.readInt();
                this.DIDstorageRoot = CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.uniqueID);
                CompoundDocument.this.readByteArray(this.userflags);
                this.timeStamp1 = CompoundDocument.this.readLong();
                this.timeStamp2 = CompoundDocument.this.readLong();
                this.SIDfirstSector = CompoundDocument.this.readInt();
                this.lenStream = CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.unused);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            this.entryName = "";
            for (int i = 0; i < this.nBytesUnicodeName - 2; i += 2) {
                this.entryName = this.entryName + (char)this.unicodeName[i];
            }
            this.isStandard = this.entryType == 5 || this.lenStream >= CompoundDocument.this.header.minBytesStandardStream;
            this.isEmpty = this.entryType == 0 || this.lenStream <= 0;
            return true;
        }
    }

    private class CmpDocHeader {
        byte[] magicNumbers = new byte[8];
        byte[] uniqueID = new byte[16];
        byte revNumber;
        byte unusedb1;
        byte verNumber;
        byte unusedb2;
        short byteOrder;
        short sectorPower;
        short shortSectorPower;
        byte[] unused = new byte[10];
        int nSATsectors;
        int SID_DIR_start;
        byte[] unused2 = new byte[4];
        int minBytesStandardStream;
        int SID_SSAT_start;
        int nSSATsectors;
        int SID_MSAT_next;
        int nAdditionalMATsectors;
        int[] MSAT0 = new int[109];

        private CmpDocHeader() {
        }

        final boolean readData() {
            try {
                CompoundDocument.this.readByteArray(this.magicNumbers, 0, 8);
                if (this.magicNumbers[0] != -48 || this.magicNumbers[1] != -49 || this.magicNumbers[2] != 17 || this.magicNumbers[3] != -32 || this.magicNumbers[4] != -95 || this.magicNumbers[5] != -79 || this.magicNumbers[6] != 26 || this.magicNumbers[7] != -31) {
                    return false;
                }
                CompoundDocument.this.readByteArray(this.uniqueID);
                this.revNumber = CompoundDocument.this.readByte();
                CompoundDocument.this.readByte();
                this.verNumber = CompoundDocument.this.readByte();
                CompoundDocument.this.readByte();
                byte b1 = CompoundDocument.this.readByte();
                byte b2 = CompoundDocument.this.readByte();
                CompoundDocument.this.isBigEndian = b1 == -1 && b2 == -2;
                this.sectorPower = CompoundDocument.this.readShort();
                this.shortSectorPower = CompoundDocument.this.readShort();
                CompoundDocument.this.readByteArray(this.unused);
                this.nSATsectors = CompoundDocument.this.readInt();
                this.SID_DIR_start = CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.unused2);
                this.minBytesStandardStream = CompoundDocument.this.readInt();
                this.SID_SSAT_start = CompoundDocument.this.readInt();
                this.nSSATsectors = CompoundDocument.this.readInt();
                this.SID_MSAT_next = CompoundDocument.this.readInt();
                this.nAdditionalMATsectors = CompoundDocument.this.readInt();
                for (int i = 0; i < 109; ++i) {
                    this.MSAT0[i] = CompoundDocument.this.readInt();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

