/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Cartoon;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.NucleicPolymer;

class CartoonRenderer
extends MpsRenderer {
    final Point3f pointT = new Point3f();
    boolean isNucleicPolymer;
    boolean ribbonBorder = false;
    int monomerCount;
    Monomer[] monomers;
    Point3f[] leadMidpoints;
    Vector3f[] wingVectors;
    short[] mads;
    short[] colixes;
    boolean[] isSpecials;
    Point3i[] leadMidpointScreens;
    Point3i[] ribbonTopScreens;
    Point3i[] ribbonBottomScreens;
    int myVisibilityFlag;
    final Point3i screenArrowTop = new Point3i();
    final Point3i screenArrowTopPrev = new Point3i();
    final Point3i screenArrowBot = new Point3i();
    final Point3i screenArrowBotPrev = new Point3i();
    final Point3f[] ring6Points = new Point3f[6];
    final Point3i[] ring6Screens = new Point3i[6];
    final Point3f[] ring5Points = new Point3f[5];
    final Point3i[] ring5Screens = new Point3i[5];

    CartoonRenderer() {
        this.ring6Screens[5] = new Point3i();
        int i = 5;
        while (--i >= 0) {
            this.ring5Screens[i] = new Point3i();
            this.ring6Screens[i] = new Point3i();
        }
    }

    void calc1Screen(Point3f center, Vector3f vector, short mad, float offsetFraction, Point3i screen) {
        this.pointT.set(vector);
        float scale = (float)mad * offsetFraction;
        this.pointT.scaleAdd(scale, center);
        this.viewer.transformPoint(this.pointT, screen);
    }

    Point3i[] calcScreens(Point3f[] centers, Vector3f[] vectors, short[] mads, float offsetFraction) {
        int count = centers.length;
        Point3i[] screens = this.viewer.allocTempScreens(count);
        if (offsetFraction == 0.0f) {
            int i = count;
            while (--i >= 0) {
                this.viewer.transformPoint(centers[i], screens[i]);
            }
        } else {
            int i = count;
            while (--i >= 0) {
                this.pointT.set(vectors[i]);
                short mad = mads[i];
                float scale = (float)mad * offsetFraction;
                this.pointT.scaleAdd(scale, centers[i]);
                this.viewer.transformPoint(this.pointT, screens[i]);
            }
        }
        return screens;
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer, int myVisibilityFlag) {
        Cartoon.Cchain strandsChain = (Cartoon.Cchain)mpspolymer;
        this.myVisibilityFlag = myVisibilityFlag;
        if (strandsChain.wingVectors != null) {
            this.monomerCount = strandsChain.monomerCount;
            this.monomers = strandsChain.monomers;
            this.isNucleicPolymer = strandsChain.polymer instanceof NucleicPolymer;
            this.leadMidpoints = strandsChain.leadMidpoints;
            this.wingVectors = strandsChain.wingVectors;
            this.mads = strandsChain.mads;
            this.colixes = strandsChain.colixes;
            this.ribbonBorder = this.viewer.getRibbonBorder();
            this.render1Chain();
        }
    }

    void render1Chain() {
        this.isSpecials = this.calcIsSpecials(this.monomerCount, this.monomers);
        this.leadMidpointScreens = this.calcScreenLeadMidpoints(this.monomerCount, this.leadMidpoints);
        this.ribbonTopScreens = this.calcScreens(this.leadMidpoints, this.wingVectors, this.mads, this.isNucleicPolymer ? 0.001f : 5.0E-4f);
        this.ribbonBottomScreens = this.calcScreens(this.leadMidpoints, this.wingVectors, this.mads, this.isNucleicPolymer ? 0.0f : -5.0E-4f);
        boolean lastWasSpecial = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            Monomer group = this.monomers[i];
            if ((group.shapeVisibilityFlags & this.myVisibilityFlag) != 0) {
                short colix = Graphics3D.inheritColix(this.colixes[i], group.getLeadAtom().colixAtom);
                boolean isSpecial = this.isSpecials[i];
                if (isSpecial) {
                    if (lastWasSpecial) {
                        this.render2StrandSegment(this.monomerCount, group, colix, this.mads, i);
                    } else {
                        this.render2StrandArrowhead(this.monomerCount, group, colix, this.mads, i);
                    }
                } else {
                    this.renderRopeSegment(colix, this.mads, i, this.monomerCount, this.monomers, this.leadMidpointScreens, this.isSpecials);
                    if (this.isNucleicPolymer) {
                        this.renderNucleicBaseStep((NucleicMonomer)group, colix, this.mads[i], this.leadMidpointScreens[i + 1]);
                    }
                }
                lastWasSpecial = isSpecial;
                continue;
            }
            lastWasSpecial = false;
        }
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
        this.viewer.freeTempScreens(this.leadMidpointScreens);
        this.viewer.freeTempBooleans(this.isSpecials);
    }

    void render2StrandSegment(int monomerCount, Monomer group, short colix, short[] mads, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleicPolymer ? 4 : 7, this.ribbonTopScreens[iPrev], this.ribbonTopScreens[i], this.ribbonTopScreens[iNext], this.ribbonTopScreens[iNext2], this.ribbonBottomScreens[iPrev], this.ribbonBottomScreens[i], this.ribbonBottomScreens[iNext], this.ribbonBottomScreens[iNext2]);
    }

    void render2StrandArrowhead(int monomerCount, Monomer group, short colix, short[] mads, int i) {
        int iNext2;
        int iNext;
        int iLast = monomerCount;
        int iPrev = i - 1;
        if (iPrev < 0) {
            iPrev = 0;
        }
        if ((iNext = i + 1) > iLast) {
            iNext = iLast;
        }
        if ((iNext2 = i + 2) > iLast) {
            iNext2 = iLast;
        }
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.leadMidpoints[iPrev], this.wingVectors[iPrev], mads[iPrev], 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.leadMidpoints[i], this.wingVectors[i], mads[i], -0.001f, this.screenArrowBotPrev);
        if (this.ribbonBorder) {
            this.g3d.fillCylinder(colix, colix, (byte)3, 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleicPolymer ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.leadMidpointScreens[iNext], this.leadMidpointScreens[iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.leadMidpointScreens[iNext], this.leadMidpointScreens[iNext2]);
    }

    void renderNucleicBaseStep(NucleicMonomer nucleotide, short colix, short mad, Point3i backboneScreen) {
        Point3i stepScreen;
        nucleotide.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6(colix);
        boolean hasRing5 = nucleotide.maybeGetBaseRing5Points(this.ring5Points);
        if (hasRing5) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            stepScreen = this.ring5Screens[2];
        } else {
            stepScreen = this.ring6Screens[1];
        }
        this.g3d.fillCylinder(colix, (byte)3, this.viewer.scaleToScreen(backboneScreen.z, mad > 1 ? mad / 2 : mad), backboneScreen, stepScreen);
        --this.ring6Screens[5].z;
        int i = 5;
        while (--i > 0) {
            --this.ring6Screens[i].z;
            if (!hasRing5) continue;
            --this.ring5Screens[i].z;
        }
        i = 6;
        while (--i > 0) {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[i], this.ring6Screens[i - 1]);
        }
        if (hasRing5) {
            i = 5;
            while (--i > 0) {
                this.g3d.fillCylinder(colix, (byte)3, 3, this.ring5Screens[i], this.ring5Screens[i - 1]);
            }
        } else {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[5], this.ring6Screens[0]);
        }
    }

    void renderRing6(short colix) {
        this.g3d.calcSurfaceShade(colix, this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    void renderRing5() {
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4]);
    }
}

