/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;

class BallsRenderer
extends ShapeRenderer {
    int minX;
    int maxX;
    int minY;
    int maxY;
    short colixSelection;
    int ballVisibilityFlag;
    int haloVisibilityFlag;

    BallsRenderer() {
    }

    void initRenderer() {
        this.ballVisibilityFlag = this.viewer.getShapeVisibilityFlag(0);
        this.haloVisibilityFlag = this.viewer.getShapeVisibilityFlag(29);
    }

    void render() {
        this.minX = this.rectClip.x;
        this.maxX = this.minX + this.rectClip.width;
        this.minY = this.rectClip.y;
        this.maxY = this.minY + this.rectClip.height;
        this.colixSelection = this.viewer.getColixSelection();
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & 1) == 0) continue;
            atom.transform(this.viewer);
            if ((atom.shapeVisibilityFlags & this.ballVisibilityFlag) != 0) {
                this.renderBall(atom);
            }
            if ((atom.shapeVisibilityFlags & this.haloVisibilityFlag) == 0) continue;
            this.renderHalo(atom);
        }
    }

    void renderBall(Atom atom) {
        this.g3d.fillSphereCentered(atom.colixAtom, atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }

    void renderHalo(Atom atom) {
        int halowidth;
        short diameter = atom.screenDiameter;
        if (diameter == 0) {
            diameter = this.viewer.scaleToScreen(atom.screenZ, 500);
        }
        if ((halowidth = diameter / 4) < 4) {
            halowidth = 4;
        }
        if (halowidth > 10) {
            halowidth = 10;
        }
        int haloDiameter = diameter + 2 * halowidth;
        this.g3d.fillScreenedCircleCentered(this.colixSelection, haloDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }
}

