/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;

class Balls
extends Shape {
    Balls() {
    }

    void setSize(int size, BitSet bsSelected) {
        int bsLength;
        short mad = (short)size;
        Atom[] atoms = this.frame.atoms;
        int i = bsLength = bsSelected.length();
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            Atom atom = atoms[i];
            atom.setMadAtom(mad);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                Atom atom = atoms[i];
                atom.setColixAtom(colix != 3 ? colix : this.viewer.getColixAtomPalette(atom, (String)value));
            }
            return;
        }
        if ("translucency" == propertyName) {
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                atoms[i].setTranslucent(value == "translucent");
            }
            return;
        }
    }

    void setModelClickability() {
        Atom[] atoms = this.frame.atoms;
        int haloVisibilityFlag = this.viewer.getShapeVisibilityFlag(29);
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            atom.clickabilityFlags = 0;
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) != 0) {
                atom.clickabilityFlags |= this.myVisibilityFlag;
            }
            if ((atom.shapeVisibilityFlags & haloVisibilityFlag) == 0) continue;
            atom.clickabilityFlags |= haloVisibilityFlag;
        }
    }
}

