/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Mps;
import org.jmol.viewer.Polymer;

class Backbone
extends Mps {
    Backbone() {
    }

    Mps.Mpspolymer allocateMpspolymer(Polymer polymer) {
        return new Bbpolymer(polymer);
    }

    class Bbpolymer
    extends Mps.Mpspolymer {
        Bbpolymer(Polymer polymer) {
            super(Backbone.this, polymer, 1, 1500, 500, 2000);
        }

        void setMad(short mad, BitSet bsSelected) {
            boolean bondSelectionModeOr = Backbone.this.viewer.getBondSelectionModeOr();
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            boolean isVisible = mad != 0;
            int i = this.monomerCount - 1;
            while (--i >= 0) {
                boolean wasVisible;
                int index1 = atomIndices[i];
                int index2 = atomIndices[i + 1];
                boolean isAtom1 = bsSelected.get(index1);
                boolean isAtom2 = bsSelected.get(index2);
                if ((!isAtom1 || !isAtom2) && (!bondSelectionModeOr || !isAtom1 && !isAtom2)) continue;
                this.monomers[i].setShapeVisibility(Backbone.this.myVisibilityFlag, isVisible);
                Atom atomA = Backbone.this.frame.getAtomAt(index1);
                Atom atomB = Backbone.this.frame.getAtomAt(index2);
                boolean bl = wasVisible = this.mads[i] != 0;
                if (wasVisible != isVisible) {
                    atomA.addDisplayedBackbone(Backbone.this.myVisibilityFlag, isVisible);
                    atomB.addDisplayedBackbone(Backbone.this.myVisibilityFlag, isVisible);
                }
                this.mads[i] = mad;
            }
        }

        void setModelClickability() {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                Atom atom = Backbone.this.frame.getAtomAt(atomIndices[i]);
                if (atom.nBackbonesDisplayed <= 0) continue;
                atom.clickabilityFlags |= Backbone.this.myVisibilityFlag;
            }
        }
    }
}

