/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.DefaultLogger;
import org.jmol.util.LoggerInterface;

public final class Logger {
    private static LoggerInterface _logger = new DefaultLogger();
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int NB_LEVELS = 5;
    private static final boolean[] _activeLevels = new boolean[5];

    private static boolean getProperty(String level, boolean defaultValue) {
        try {
            String property = System.getProperty("jmol.logger." + level);
            if (property != null) {
                return Boolean.TRUE.equals(Boolean.valueOf(property));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static void setLogger(LoggerInterface logger) {
        _logger = logger;
    }

    public static boolean isActiveLevel(int level) {
        if (_logger == null) {
            return false;
        }
        if (level >= 0 && level < _activeLevels.length) {
            return _activeLevels[level];
        }
        return false;
    }

    public static void setActiveLevel(int level, boolean active) {
        if (level >= 0 && level < _activeLevels.length) {
            Logger._activeLevels[level] = active;
        }
    }

    public static void debug(String txt) {
        try {
            if (Logger.isActiveLevel(0)) {
                _logger.debug(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String txt) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.info(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.warn(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String txt) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.error(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(String txt) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.fatal(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Logger._activeLevels[0] = Logger.getProperty("debug", false);
        Logger._activeLevels[1] = Logger.getProperty("info", true);
        Logger._activeLevels[2] = Logger.getProperty("warn", true);
        Logger._activeLevels[3] = Logger.getProperty("error", true);
        Logger._activeLevels[4] = Logger.getProperty("fatal", true);
    }
}

