/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;

public class QuantumCalculation {
    public static int MAX_GRID = 80;
    static final float bohr_per_angstrom = 1.8897161f;
    float[][] xyzBohr = new float[MAX_GRID][3];
    float[] X = new float[MAX_GRID];
    float[] Y = new float[MAX_GRID];
    float[] Z = new float[MAX_GRID];
    float[] X2 = new float[MAX_GRID];
    float[] Y2 = new float[MAX_GRID];
    float[] Z2 = new float[MAX_GRID];
    float[] CX = new float[MAX_GRID];
    float[] CY = new float[MAX_GRID];
    float[] CZ = new float[MAX_GRID];
    float[] DXY = new float[MAX_GRID];
    float[] DXZ = new float[MAX_GRID];
    float[] DYZ = new float[MAX_GRID];
    float[] EX = new float[MAX_GRID];
    float[] EY = new float[MAX_GRID];
    float[] EZ = new float[MAX_GRID];
    String calculationType;
    Point3f[] atomCoordBohr;
    Atom[] atoms;
    Vector shells;
    float[][] gaussians;
    Hashtable aoOrdersDF;
    int[][] slaterInfo;
    float[][] slaterData;
    float[] moCoefficients;
    float[][][] voxelData;
    float[] originBohr = new float[3];
    float[] stepBohr = new float[3];
    int[] countsXYZ;
    int moCoeff;
    int atomIndex;
    int gaussianPtr;
    boolean doDebug = false;
    int xMin;
    int xMax;
    int yMin;
    int yMax;
    int zMin;
    int zMax;
    static final float ROOT3 = 1.7320508f;

    public QuantumCalculation() {
    }

    public QuantumCalculation(String calculationType, Atom[] atoms, Vector shells, float[][] gaussians, Hashtable aoOrdersDF, int[][] slaterInfo, float[][] slaterData, float[] moCoefficients) {
        this.calculationType = calculationType;
        this.atoms = atoms;
        this.shells = shells;
        this.gaussians = gaussians;
        this.aoOrdersDF = aoOrdersDF;
        this.slaterInfo = slaterInfo;
        this.slaterData = slaterData;
        this.moCoefficients = moCoefficients;
    }

    public void createSlaterCube(float[][][] voxelData, int[] countsXYZ, float[] originXYZ, float[] stepsXYZ) {
        this.voxelData = voxelData;
        this.countsXYZ = countsXYZ;
        this.setupCoordinates(originXYZ, stepsXYZ);
        this.atomIndex = -1;
        this.moCoeff = 0;
        int nSlaters = this.slaterInfo.length;
        for (int i = 0; i < nSlaters; ++i) {
            this.processSlater(i);
        }
    }

    public void createGaussianCube(float[][][] voxelData, int[] countsXYZ, float[] originXYZ, float[] stepsXYZ) {
        if (!this.checkCalculationType()) {
            return;
        }
        this.voxelData = voxelData;
        this.countsXYZ = countsXYZ;
        this.setupCoordinates(originXYZ, stepsXYZ);
        this.atomIndex = -1;
        this.moCoeff = 0;
        this.doDebug = Logger.isActiveLevel(0);
        if (this.doDebug) {
            for (int i = 0; i < this.moCoefficients.length; ++i) {
                Logger.debug("MO coeffs:" + i + " " + this.moCoefficients[i]);
            }
        }
        int nShells = this.shells.size();
        for (int i = 0; i < nShells; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length);
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType.indexOf("5D") >= 0) {
            Logger.error("QuantumCalculation.checkCalculationType: can't read 5D basis sets yet: " + this.calculationType + " -- exit");
            return false;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void setupCoordinates(float[] originXYZ, float[] stepsXYZ) {
        int i = 3;
        while (--i >= 0) {
            this.originBohr[i] = originXYZ[i] * 1.8897161f;
            this.stepBohr[i] = stepsXYZ[i] * 1.8897161f;
        }
        i = 3;
        while (--i >= 0) {
            this.xyzBohr[0][i] = this.originBohr[i];
            int n = this.countsXYZ[i];
            float inc = this.stepBohr[i];
            int j = 0;
            while (++j < n) {
                this.xyzBohr[j][i] = this.xyzBohr[j - 1][i] + inc;
            }
        }
        this.atomCoordBohr = new Point3f[this.atoms.length];
        for (i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i] == null) continue;
            this.atomCoordBohr[i] = new Point3f(this.atoms[i].point3f);
            this.atomCoordBohr[i].scale(1.8897161f);
        }
        if (this.doDebug) {
            Logger.debug("QuantumCalculation:\n origin(Bohr)= " + this.originBohr[0] + " " + this.originBohr[1] + " " + this.originBohr[2] + "\n steps(Bohr)= " + this.stepBohr[0] + " " + this.stepBohr[1] + " " + this.stepBohr[2] + "\n counts= " + this.countsXYZ[0] + " " + this.countsXYZ[1] + " " + this.countsXYZ[2]);
        }
    }

    private void processShell(int iShell) {
        int lastAtom = this.atomIndex;
        Hashtable shell = (Hashtable)this.shells.get(iShell);
        this.gaussianPtr = (Integer)shell.get("gaussianPtr");
        int nGaussians = (Integer)shell.get("nGaussians");
        this.atomIndex = (Integer)shell.get("atomIndex");
        String basisType = (String)shell.get("basisType");
        if (this.doDebug) {
            Logger.debug("processShell: " + basisType + " nGaussians=" + nGaussians + " atom=" + this.atomIndex);
        }
        if (this.atomIndex != lastAtom && this.atomCoordBohr[this.atomIndex] != null) {
            int i = this.countsXYZ[0];
            while (--i >= 0) {
                this.X2[i] = this.X[i] = this.xyzBohr[i][0] - this.atomCoordBohr[this.atomIndex].x;
                int n = i;
                this.X2[n] = this.X2[n] * this.X[i];
            }
            i = this.countsXYZ[1];
            while (--i >= 0) {
                this.Y2[i] = this.Y[i] = this.xyzBohr[i][1] - this.atomCoordBohr[this.atomIndex].y;
                int n = i;
                this.Y2[n] = this.Y2[n] * this.Y[i];
            }
            i = this.countsXYZ[2];
            while (--i >= 0) {
                this.Z2[i] = this.Z[i] = this.xyzBohr[i][2] - this.atomCoordBohr[this.atomIndex].z;
                int n = i;
                this.Z2[n] = this.Z2[n] * this.Z[i];
            }
        }
        if (basisType.equals("S")) {
            this.addDataS(nGaussians);
        } else if (basisType.equals("SP") || basisType.equals("L")) {
            this.addDataSP(nGaussians);
        } else if (basisType.equals("P")) {
            this.addDataP(nGaussians);
        } else if (basisType.equals("D")) {
            this.addDataD(nGaussians);
        } else {
            Logger.warn(" Unsupported basis type: " + basisType);
        }
    }

    private void addDataS(int nGaussians) {
        if (this.atomCoordBohr[this.atomIndex] == null) {
            ++this.moCoeff;
            return;
        }
        this.setMinMax(nGaussians);
        int moCoeff0 = this.moCoeff;
        for (int ig = 0; ig < nGaussians; ++ig) {
            this.moCoeff = moCoeff0;
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 0.75) * 0.7127055f;
            a *= this.moCoefficients[this.moCoeff++];
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.EX[i] = a * this.gExp(-this.X2[i] * alpha);
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.EY[i] = this.gExp(-this.Y2[i] * alpha);
            }
            i = this.zMax;
            while (--i >= this.zMin) {
                this.EZ[i] = this.gExp(-this.Z2[i] * alpha);
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + this.EX[ix] * this.EY[iy] * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void addDataP(int nGaussians) {
        if (this.atomCoordBohr[this.atomIndex] == null) {
            this.moCoeff += 3;
            return;
        }
        this.setMinMax(nGaussians);
        int moCoeff0 = this.moCoeff;
        for (int ig = 0; ig < nGaussians; ++ig) {
            this.moCoeff = moCoeff0;
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 1.25) * 1.425411f;
            float ax = a * this.moCoefficients[this.moCoeff++];
            float ay = a * this.moCoefficients[this.moCoeff++];
            float az = a * this.moCoefficients[this.moCoeff++];
            this.calcSP(alpha, 0.0f, ax, ay, az);
        }
    }

    private void addDataSP(int nGaussians) {
        if (this.atomCoordBohr[this.atomIndex] == null) {
            this.moCoeff += 4;
            return;
        }
        this.setMinMax(nGaussians);
        int moCoeff0 = this.moCoeff;
        for (int ig = 0; ig < nGaussians; ++ig) {
            this.moCoeff = moCoeff0;
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float c2 = this.gaussians[this.gaussianPtr + ig][2];
            float a1 = c1 * (float)Math.pow(alpha, 0.75) * 0.7127055f;
            float a2 = c2 * (float)Math.pow(alpha, 1.25) * 1.425411f;
            float as = c1 == 0.0f ? 0.0f : a1 * this.moCoefficients[this.moCoeff++];
            float ax = a2 * this.moCoefficients[this.moCoeff++];
            float ay = a2 * this.moCoefficients[this.moCoeff++];
            float az = a2 * this.moCoefficients[this.moCoeff++];
            this.calcSP(alpha, as, ax, ay, az);
        }
    }

    private void setCE(float alpha, float as, float ax, float ay, float az) {
        int i = this.xMax;
        while (--i >= this.xMin) {
            this.CX[i] = as + ax * this.X[i];
            this.EX[i] = this.gExp(-this.X2[i] * alpha);
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.CY[i] = ay * this.Y[i];
            this.EY[i] = this.gExp(-this.Y2[i] * alpha);
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.CZ[i] = az * this.Z[i];
            this.EZ[i] = this.gExp(-this.Z2[i] * alpha);
        }
    }

    private void calcSP(float alpha, float as, float ax, float ay, float az) {
        this.setCE(alpha, as, ax, ay, az);
        int ix = this.xMax;
        while (--ix >= this.xMin) {
            int iy = this.yMax;
            while (--iy >= this.yMin) {
                int iz = this.zMax;
                while (--iz >= this.zMin) {
                    float[] fArray = this.voxelData[ix][iy];
                    int n = iz;
                    fArray[n] = fArray[n] + (this.CX[ix] + this.CY[iy] + this.CZ[iz]) * this.EX[ix] * this.EY[iy] * this.EZ[iz];
                }
            }
        }
    }

    private void addDataD(int nGaussians) {
        if (this.atomCoordBohr[this.atomIndex] == null) {
            this.moCoeff += 6;
            return;
        }
        this.setMinMax(nGaussians);
        int moCoeff0 = this.moCoeff;
        for (int ig = 0; ig < nGaussians; ++ig) {
            this.moCoeff = moCoeff0;
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 1.75) * 1.6459228f;
            float axx = a / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float ayy = a / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float azz = a / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float axy = a * this.moCoefficients[this.moCoeff++];
            float axz = a * this.moCoefficients[this.moCoeff++];
            float ayz = a * this.moCoefficients[this.moCoeff++];
            this.setCE(alpha, 0.0f, axx, ayy, azz);
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.DXY[i] = axy * this.X[i];
                this.DXZ[i] = axz * this.X[i];
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.DYZ[i] = ayz * this.Y[i];
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float axx_x2 = this.CX[ix] * this.X[ix];
                float axy_x = this.DXY[ix];
                float axz_x = this.DXZ[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float axx_x2__ayy_y2__axy_xy = axx_x2 + (this.CY[iy] + axy_x) * this.Y[iy];
                    float axz_x__ayz_y = axz_x + this.DYZ[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (axx_x2__ayy_y2__axy_xy + (this.CZ[iz] + axz_x__ayz_y) * this.Z[iz]) * this.EX[ix] * this.EY[iy] * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void setMinMax(int nGaussians) {
        this.xMin = 0;
        this.yMin = 0;
        this.zMin = 0;
        this.xMax = this.countsXYZ[0];
        this.yMax = this.countsXYZ[1];
        this.zMax = this.countsXYZ[2];
    }

    private void setMinMax(int a, int b, int c, int d, float minuszeta, float coef) {
        this.xMin = 0;
        this.yMin = 0;
        this.zMin = 0;
        this.xMax = this.countsXYZ[0];
        this.yMax = this.countsXYZ[1];
        this.zMax = this.countsXYZ[2];
    }

    private float gExp(float x) {
        return (float)Math.exp(x);
    }

    private void processSlater(int slaterIndex) {
        int ix;
        this.atomIndex = this.slaterInfo[slaterIndex][0];
        if (this.atomCoordBohr[this.atomIndex] == null) {
            ++this.moCoeff;
            return;
        }
        int a = this.slaterInfo[slaterIndex][1];
        int b = this.slaterInfo[slaterIndex][2];
        int c = this.slaterInfo[slaterIndex][3];
        int d = this.slaterInfo[slaterIndex][4];
        float minuszeta = -this.slaterData[slaterIndex][0];
        float coef = this.slaterData[slaterIndex][1] * this.moCoefficients[this.moCoeff++];
        this.setMinMax(a, b, c, d, minuszeta, coef);
        int i = this.xMax;
        while (--i >= this.xMin) {
            this.X[i] = this.xyzBohr[i][0] - this.atomCoordBohr[this.atomIndex].x;
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.Y[i] = this.xyzBohr[i][1] - this.atomCoordBohr[this.atomIndex].y;
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.Z[i] = this.xyzBohr[i][2] - this.atomCoordBohr[this.atomIndex].z;
        }
        if (a == -2 || b == -2) {
            ix = this.xMax;
            while (--ix >= this.xMin) {
                float dx2 = this.X[ix] * this.X[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dy2 = this.Y[iy] * this.Y[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float dz2 = this.Z[iz] * this.Z[iz];
                        float r = (float)Math.sqrt(dx2 + dy2 + dz2);
                        float value = coef * (float)Math.exp(minuszeta * r) * ((a == -2 ? 2.0f * dz2 - dx2 : dx2) - dy2);
                        int i2 = d;
                        while (--i2 >= 0) {
                            value *= r;
                        }
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + value;
                    }
                }
            }
        } else {
            ix = this.xMax;
            while (--ix >= this.xMin) {
                float dx = this.X[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dy = this.Y[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float dz = this.Z[iz];
                        float r = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        float value = coef * (float)Math.exp(minuszeta * r);
                        int i3 = a;
                        while (--i3 >= 0) {
                            value *= dx;
                        }
                        i3 = b;
                        while (--i3 >= 0) {
                            value *= dy;
                        }
                        i3 = c;
                        while (--i3 >= 0) {
                            value *= dz;
                        }
                        i3 = d;
                        while (--i3 >= 0) {
                            value *= r;
                        }
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + value;
                    }
                }
            }
        }
    }
}

