/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jmol.util.Logger;

public class GT {
    private static GT getTextWrapper = new GT();
    private ResourceBundle translationResources;
    private ResourceBundle appletTranslationResources;

    private GT() {
        String language;
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null && ((language = locale.getLanguage()).equals("") || language.equals(Locale.ENGLISH.getLanguage()))) {
            Logger.debug("English: no need for gettext wrapper");
            return;
        }
        Logger.debug("Instantiating gettext wrapper...");
        try {
            this.translationResources = ResourceBundle.getBundle("org.jmol.translation.Jmol.Messages");
        }
        catch (MissingResourceException mre) {
            Logger.warn("Translations do not seem to have been installed!");
            Logger.warn(mre.getMessage());
            this.translationResources = null;
        }
        catch (Exception exception) {
            Logger.error("Some exception occured!");
            Logger.error(exception.getMessage());
            exception.printStackTrace();
            this.translationResources = null;
        }
        try {
            this.appletTranslationResources = ResourceBundle.getBundle("org.jmol.translation.JmolApplet.Messages");
        }
        catch (MissingResourceException mre) {
            Logger.warn("Applet translations do not seem to have been installed!");
            Logger.warn(mre.getMessage());
            this.appletTranslationResources = null;
        }
        catch (Exception exception) {
            Logger.error("Some exception occured!");
            Logger.error(exception.getMessage());
            exception.printStackTrace();
            this.appletTranslationResources = null;
        }
    }

    public static String _(String string) {
        return getTextWrapper.getString(string);
    }

    public static String _(String string, Object[] objects) {
        return getTextWrapper.getString(string, objects);
    }

    private String getString(String string) {
        if (this.translationResources != null) {
            try {
                String trans = this.translationResources.getString(string);
                return trans;
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (this.appletTranslationResources != null) {
            try {
                String trans = this.appletTranslationResources.getString(string);
                return trans;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (this.translationResources != null || this.appletTranslationResources != null) {
            Logger.debug("No trans, using default: " + string);
        }
        return string;
    }

    private String getString(String string, Object[] objects) {
        String trans = string;
        if (this.translationResources != null) {
            try {
                trans = MessageFormat.format(this.translationResources.getString(string), objects);
                return trans;
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (this.appletTranslationResources != null) {
            try {
                trans = MessageFormat.format(this.appletTranslationResources.getString(string), objects);
                return trans;
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        trans = MessageFormat.format(string, objects);
        if (this.translationResources != null || this.appletTranslationResources != null) {
            Logger.debug("No trans, using default: " + trans);
        }
        return trans;
    }
}

