/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.appletwrapper;

import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.TickerThread;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.util.Logger;

class WrappedAppletLoader
extends Thread {
    AppletWrapper appletWrapper;
    String wrappedAppletClassName;
    private static final int minimumLoadSeconds = 0;

    WrappedAppletLoader(AppletWrapper appletWrapper, String wrappedAppletClassName) {
        this.appletWrapper = appletWrapper;
        this.wrappedAppletClassName = wrappedAppletClassName;
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        Logger.debug("WrappedAppletLoader.run(" + this.wrappedAppletClassName + ")");
        TickerThread tickerThread = new TickerThread(this.appletWrapper);
        tickerThread.start();
        WrappedApplet wrappedApplet = null;
        try {
            Class<?> wrappedAppletClass = Class.forName(this.wrappedAppletClassName);
            wrappedApplet = (WrappedApplet)wrappedAppletClass.newInstance();
            wrappedApplet.setAppletWrapper(this.appletWrapper);
            wrappedApplet.init();
        }
        catch (Exception e) {
            Logger.error("Could not instantiate wrappedApplet class" + this.wrappedAppletClassName);
            e.printStackTrace();
        }
        long loadTimeSeconds = (System.currentTimeMillis() - startTime + 500L) / 1000L;
        Logger.debug(this.wrappedAppletClassName + " load time = " + loadTimeSeconds + " seconds");
        tickerThread.keepRunning = false;
        tickerThread.interrupt();
        this.appletWrapper.wrappedApplet = wrappedApplet;
        this.appletWrapper.repaint();
    }
}

