/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.appletwrapper;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import org.jmol.appletwrapper.ClassPreloader;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.appletwrapper.WrappedAppletLoader;
import org.jmol.util.Logger;

public class AppletWrapper
extends Applet {
    private String wrappedAppletClassName;
    private String preloadImageName;
    private String preloadTextMessage;
    private int preloadThreadCount;
    private String[] preloadClassNames;
    private int preloadClassIndex;
    private String previousClassName;
    private boolean needToCompleteInitialization;
    private boolean preloadImageReadyForDisplay;
    private boolean preloadImagePainted;
    private Image preloadImage;
    private MediaTracker mediaTracker;
    private Color bgcolor;
    private Color textColor;
    public WrappedApplet wrappedApplet;
    private long startTime;
    private int clockX;
    private int clockBaseline;
    private int clockWidth;
    private static int MINIMUM_ELAPSED_SECONDS = 1;
    private static String fontFace = "sansserif";
    private static int fontSizeDivisor = 18;
    private int fontSize;
    private Font font;
    private FontMetrics fontMetrics;
    private int fontAscent;
    private int fontHeight;
    private static final String[] colorNames = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    private static final Color[] colors = new Color[]{Color.cyan, Color.black, Color.blue, Color.magenta, Color.gray, new Color(0, 128, 0), Color.green, new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), Color.red, Color.lightGray, new Color(0, 128, 128), Color.white, Color.yellow};

    public AppletWrapper(String wrappedAppletClassName, String preloadImageName, String preloadTextMessage, int preloadThreadCount, String[] preloadClassNames) {
        this.wrappedAppletClassName = wrappedAppletClassName;
        this.preloadImageName = preloadImageName;
        this.preloadTextMessage = preloadTextMessage;
        this.preloadThreadCount = preloadThreadCount;
        this.preloadClassNames = preloadClassNames;
        this.needToCompleteInitialization = true;
    }

    public String getAppletInfo() {
        return this.wrappedApplet != null ? this.wrappedApplet.getAppletInfo() : null;
    }

    public void init() {
        this.startTime = System.currentTimeMillis();
        new WrappedAppletLoader(this, this.wrappedAppletClassName).start();
        int i = this.preloadThreadCount;
        while (--i >= 0) {
            new ClassPreloader(this).start();
        }
    }

    public void update(Graphics g) {
        long elapsedTime;
        int imageHeight;
        if (this.wrappedApplet != null) {
            this.mediaTracker = null;
            this.preloadImage = null;
            this.fontMetrics = null;
            this.wrappedApplet.update(g);
            return;
        }
        Dimension dim = this.size();
        if (this.needToCompleteInitialization) {
            this.completeInitialization(g, dim);
        }
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(this.textColor);
        int imageBottom = 0;
        if (!this.preloadImageReadyForDisplay && this.mediaTracker != null) {
            this.preloadImageReadyForDisplay = this.mediaTracker.checkID(0, true);
        }
        if (this.preloadImageReadyForDisplay && (imageHeight = this.preloadImage.getHeight(null)) > 0 && 10 + imageHeight + this.fontHeight <= dim.height) {
            g.drawImage(this.preloadImage, 10, 10, null);
            this.preloadImagePainted = true;
            imageBottom = 10 + imageHeight;
        }
        if ((elapsedTime = (System.currentTimeMillis() - this.startTime) / 1000L) >= (long)MINIMUM_ELAPSED_SECONDS) {
            int messageBaseline = imageBottom + this.fontAscent;
            if (messageBaseline < dim.height / 2) {
                messageBaseline = dim.height / 2;
            } else if (messageBaseline >= dim.height) {
                messageBaseline = dim.height - 1;
            }
            g.setFont(this.font);
            g.drawString(this.preloadTextMessage, 10, messageBaseline);
            String clockText = "  " + elapsedTime + " seconds";
            this.clockWidth = this.fontMetrics.stringWidth(clockText);
            this.clockX = dim.width - this.clockWidth - 5;
            if (this.clockX < 0) {
                this.clockX = 0;
            }
            this.clockBaseline = dim.height - 5;
            Logger.debug(clockText);
            g.drawString(clockText, this.clockX, this.clockBaseline);
        }
    }

    public void paint(Graphics g) {
        if (this.wrappedApplet != null) {
            this.wrappedApplet.paint(g);
            return;
        }
        this.update(g);
    }

    void repaintClock() {
        if (!this.preloadImagePainted || this.clockBaseline == 0) {
            this.repaint();
        } else {
            this.repaint(this.clockX, this.clockBaseline - this.fontAscent, this.clockWidth, this.fontHeight);
        }
    }

    private void completeInitialization(Graphics g, Dimension dim) {
        String bgcolorName;
        this.needToCompleteInitialization = false;
        if (this.preloadImageName != null) {
            try {
                Logger.debug("loadImage:" + this.preloadImageName);
                URL urlImage = this.getClass().getClassLoader().getResource(this.preloadImageName);
                Logger.info("urlImage=" + urlImage);
                if (urlImage != null) {
                    this.preloadImage = Toolkit.getDefaultToolkit().getImage(urlImage);
                    Logger.debug("successfully loaded " + this.preloadImageName);
                    Logger.debug("preloadImage=" + this.preloadImage);
                    this.mediaTracker = new MediaTracker(this);
                    this.mediaTracker.addImage(this.preloadImage, 0);
                    this.mediaTracker.checkID(0, true);
                }
            }
            catch (Exception e) {
                Logger.error("getImage failed: " + e);
            }
        }
        if ((bgcolorName = this.getParameter("boxbgcolor")) == null) {
            bgcolorName = this.getParameter("bgcolor");
        }
        this.bgcolor = this.getColorFromName(bgcolorName);
        this.textColor = this.getContrastingBlackOrWhite(this.bgcolor);
        this.fontSize = dim.height / fontSizeDivisor;
        if (this.fontSize < 7) {
            this.fontSize = 7;
        }
        if (this.fontSize > 30) {
            this.fontSize = 30;
        }
        while (true) {
            this.font = new Font(fontFace, 0, this.fontSize);
            this.fontMetrics = g.getFontMetrics(this.font);
            if (this.fontMetrics.stringWidth(this.preloadTextMessage) + 10 < dim.width || this.fontSize < 8) break;
            this.fontSize -= 2;
        }
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
    }

    private Color getColorFromName(String strColor) {
        if (strColor != null) {
            if (strColor.length() == 7 && strColor.charAt(0) == '#') {
                try {
                    int red = Integer.parseInt(strColor.substring(1, 3), 16);
                    int grn = Integer.parseInt(strColor.substring(3, 5), 16);
                    int blu = Integer.parseInt(strColor.substring(5, 7), 16);
                    return new Color(red, grn, blu);
                }
                catch (NumberFormatException e) {}
            } else {
                strColor = strColor.toLowerCase().intern();
                int i = colorNames.length;
                while (--i >= 0) {
                    if (strColor != colorNames[i]) continue;
                    return colors[i];
                }
            }
        }
        return Color.black;
    }

    private Color getContrastingBlackOrWhite(Color color) {
        int argb = color.getRGB();
        int grayscale = ((2989 * (argb >> 16) & 0xFF) + (5870 * (argb >> 8) & 0xFF) + 1140 * (argb & 0xFF) + 500) / 1000;
        return grayscale < 128 ? Color.white : Color.black;
    }

    public boolean handleEvent(Event e) {
        if (this.wrappedApplet != null) {
            return this.wrappedApplet.handleEvent(e);
        }
        return false;
    }

    synchronized String getNextPreloadClassName() {
        String className;
        if (this.preloadClassNames == null || this.preloadClassIndex == this.preloadClassNames.length) {
            return null;
        }
        if ((className = this.preloadClassNames[this.preloadClassIndex++]).charAt(0) == '.') {
            int lastDot = this.previousClassName.lastIndexOf(46);
            String previousPackageName = this.previousClassName.substring(0, lastDot);
            className = previousPackageName + className;
        }
        this.previousClassName = className;
        return this.previousClassName;
    }
}

